/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns.compiler;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ElementPatternCondition;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.compiler.PatternCompiler;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.StringInterner;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PatternCompilerImpl<T>
implements PatternCompiler<T> {
    private static final Logger LOG = Logger.getInstance(PatternCompilerImpl.class.getName());
    private final Set<Method> myStaticMethods;
    private final Interner<String> myStringInterner = new StringInterner();
    private static final Node ERROR_NODE = new Node(null, null, null);
    private static final ElementPattern<?> ALWAYS_FALSE = new FalsePattern();

    public PatternCompilerImpl(List<Class<?>> patternClasses) {
        this.myStaticMethods = PatternCompilerImpl.getStaticMethods(patternClasses);
    }

    @Override
    public ElementPattern<T> createElementPattern(String text2, String displayName) {
        try {
            return this.compileElementPattern(text2);
        }
        catch (Exception ex) {
            PatternCompilerImpl.onCompilationFailed(displayName, text2, ex);
            return new LazyPresentablePattern(new Node(ERROR_NODE, text2, null), Collections.emptySet());
        }
    }

    static void onCompilationFailed(String displayName, String text2, @NotNull Throwable ex) {
        if (ex == null) {
            PatternCompilerImpl.$$$reportNull$$$0(0);
        }
        Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
        String message = displayName == null ? text2 : displayName + ": " + text2;
        Application app = ApplicationManager.getApplication();
        if (app != null && app.isUnitTestMode()) {
            LOG.error(message, cause);
        } else {
            LOG.warn(message, cause);
        }
    }

    @Override
    public synchronized ElementPattern<T> compileElementPattern(String text2) {
        Node node = (Node)PatternCompilerImpl.processElementPatternText(text2, frame -> {
            Object[] args = frame.params.toArray();
            int argsLength = args.length;
            for (int i = 0; i < argsLength; ++i) {
                args[i] = args[i] instanceof String ? this.myStringInterner.intern((String)args[i]) : args[i];
            }
            return new Node((Node)frame.target, this.myStringInterner.intern(frame.methodName), args.length == 0 ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : args);
        });
        if (node == null) {
            node = new Node(ERROR_NODE, text2, null);
        }
        return new LazyPresentablePattern(node, this.myStaticMethods);
    }

    private static Set<Method> getStaticMethods(List<Class<?>> patternClasses) {
        return new THashSet<Method>(ContainerUtil.concat(patternClasses, aClass -> ContainerUtil.findAll(aClass.getMethods(), method2 -> Modifier.isStatic(method2.getModifiers()) && Modifier.isPublic(method2.getModifiers()) && !Modifier.isAbstract(method2.getModifiers()) && ElementPattern.class.isAssignableFrom(method2.getReturnType()))));
    }

    @Nullable
    private static <T> T processElementPatternText(String text2, Function<? super Frame, Object> executor) {
        Stack<Frame> stack = new Stack<Frame>();
        int curPos = 0;
        Frame curFrame = new Frame();
        Object curResult = null;
        StringBuilder curString = new StringBuilder();
        while (curPos <= text2.length()) {
            char ch = curPos++ < text2.length() ? text2.charAt(curPos - 1) : (char)'\u0000';
            switch (curFrame.state) {
                case init: {
                    if (Character.isWhitespace(ch)) break;
                    if (Character.isJavaIdentifierStart(ch)) {
                        curString.append(ch);
                        curFrame.state = State.name;
                        break;
                    }
                    PatternCompilerImpl.throwError(curPos, ch, "method call expected");
                    break;
                }
                case name: {
                    if (Character.isJavaIdentifierPart(ch)) {
                        curString.append(ch);
                        break;
                    }
                    if (ch == '(' || Character.isWhitespace(ch)) {
                        curFrame.methodName = curString.toString();
                        curString.setLength(0);
                        curFrame.state = ch == '(' ? State.param_start : State.name_end;
                        break;
                    }
                    PatternCompilerImpl.throwError(curPos, ch, "'" + curString + ch + "' method name start is invalid, '(' expected");
                    break;
                }
                case name_end: {
                    if (ch == '(') {
                        curFrame.state = State.param_start;
                        break;
                    }
                    if (Character.isWhitespace(ch)) break;
                    PatternCompilerImpl.throwError(curPos, ch, "'(' expected after '" + curFrame.methodName + "'");
                    break;
                }
                case param_start: {
                    if (Character.isWhitespace(ch)) break;
                    if (Character.isDigit(ch) || ch == '-' || ch == '\"') {
                        curFrame.state = State.literal;
                        curString.append(ch);
                        break;
                    }
                    if (ch == ')') {
                        curFrame.state = State.invoke;
                        break;
                    }
                    if (Character.isJavaIdentifierStart(ch)) {
                        curString.append(ch);
                        stack.push(curFrame);
                        curFrame = new Frame();
                        curFrame.state = State.name;
                        break;
                    }
                    PatternCompilerImpl.throwError(curPos, ch, "expression expected in '" + curFrame.methodName + "' call");
                    break;
                }
                case param_end: {
                    if (ch == ')') {
                        curFrame.state = State.invoke;
                        break;
                    }
                    if (ch == ',') {
                        curFrame.state = State.param_start;
                        break;
                    }
                    if (Character.isWhitespace(ch)) break;
                    PatternCompilerImpl.throwError(curPos, ch, "')' or ',' expected in '" + curFrame.methodName + "' call");
                    break;
                }
                case literal: {
                    if (curString.charAt(0) == '\"') {
                        curString.append(ch);
                        if (ch == '\\') {
                            curFrame.state = State.escape;
                            break;
                        }
                        if (ch != '\"') break;
                        curFrame.params.add(PatternCompilerImpl.makeParam(curString.toString()));
                        curString.setLength(0);
                        curFrame.state = State.param_end;
                        break;
                    }
                    if (Character.isWhitespace(ch) || ch == ',' || ch == ')') {
                        curFrame.params.add(PatternCompilerImpl.makeParam(curString.toString()));
                        curString.setLength(0);
                        curFrame.state = ch == ')' ? State.invoke : (ch == ',' ? State.param_start : State.param_end);
                        break;
                    }
                    curString.append(ch);
                    break;
                }
                case escape: {
                    if (ch != '\u0000') {
                        curString.append(ch);
                        curFrame.state = State.literal;
                        break;
                    }
                    PatternCompilerImpl.throwError(curPos, ch, "unclosed escape sequence");
                    break;
                }
                case invoke: {
                    curResult = executor.fun(curFrame);
                    if (ch == '\u0000' && stack.isEmpty()) {
                        return (T)curResult;
                    }
                    if (ch == '.') {
                        curFrame = new Frame();
                        curFrame.target = curResult;
                        curFrame.state = State.init;
                        curResult = null;
                        break;
                    }
                    if (ch == ',' || ch == ')') {
                        curFrame = (Frame)stack.pop();
                        curFrame.params.add(curResult);
                        curResult = null;
                        curFrame.state = ch == ')' ? State.invoke : State.param_start;
                        break;
                    }
                    if (Character.isWhitespace(ch)) {
                        curFrame.state = State.invoke_end;
                        break;
                    }
                    PatternCompilerImpl.throwError(curPos, ch, (stack.isEmpty() ? "'.' or <eof>" : "'.' or ')'") + "expected after '" + curFrame.methodName + "' call");
                    break;
                }
                case invoke_end: {
                    if (ch == '\u0000' && stack.isEmpty()) {
                        return (T)curResult;
                    }
                    if (ch == ')') {
                        curFrame.state = State.invoke;
                        break;
                    }
                    if (ch == ',') {
                        curFrame.state = State.param_start;
                        break;
                    }
                    if (ch == '.') {
                        curFrame = new Frame();
                        curFrame.target = curResult;
                        curFrame.state = State.init;
                        curResult = null;
                        break;
                    }
                    if (Character.isWhitespace(ch)) break;
                    PatternCompilerImpl.throwError(curPos, ch, (stack.isEmpty() ? "'.' or <eof>" : "'.' or ')'") + "expected after '" + curFrame.methodName + "' call");
                }
            }
        }
        return null;
    }

    private static void throwError(int offset, char ch, String message) {
        throw new IllegalStateException(offset + "(" + ch + "): " + message);
    }

    private static Object makeParam(String s) {
        if (s.length() >= 2 && s.startsWith("\"") && s.endsWith("\"")) {
            return StringUtil.unescapeStringCharacters(s.substring(1, s.length() - 1));
        }
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException numberFormatException) {
            return s;
        }
    }

    private static Object invokeMethod(@Nullable Object target2, String methodName, Object[] arguments, Collection<Method> staticMethods) throws Throwable {
        Ref<Boolean> convertVarArgs;
        Collection<Method> methods = target2 == null ? staticMethods : Arrays.asList(target2.getClass().getMethods());
        Method method2 = PatternCompilerImpl.findMethod(methodName, arguments, methods, convertVarArgs = Ref.create(Boolean.FALSE));
        if (method2 != null) {
            try {
                Object[] newArgs;
                if (!convertVarArgs.get().booleanValue()) {
                    newArgs = arguments;
                } else {
                    Class<?>[] parameterTypes = method2.getParameterTypes();
                    newArgs = new Object[parameterTypes.length];
                    System.arraycopy(arguments, 0, newArgs, 0, parameterTypes.length - 1);
                    ?[] varArgs = ArrayUtil.newArray(parameterTypes[parameterTypes.length - 1].getComponentType(), arguments.length - parameterTypes.length + 1);
                    System.arraycopy(arguments, parameterTypes.length - 1, varArgs, 0, varArgs.length);
                    newArgs[parameterTypes.length - 1] = varArgs;
                }
                return method2.invoke(target2, newArgs);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        throw new NoSuchMethodException("unknown symbol: " + methodName + "(" + StringUtil.join(arguments, o -> String.valueOf(o), ", ") + ")");
    }

    @Nullable
    private static Method findMethod(String methodName, Object[] arguments, Collection<Method> methods, Ref<? super Boolean> convertVarArgs) {
        block0: for (Method method2 : methods) {
            if (!methodName.equals(method2.getName()) || method2.getParameterCount() != arguments.length && !method2.isVarArgs()) continue;
            Class<?>[] parameterTypes = method2.getParameterTypes();
            convertVarArgs.set((Boolean)false);
            int parameterTypesLength = parameterTypes.length;
            for (int i = 0; i < arguments.length; ++i) {
                Class<?> componentType;
                Class<?> type = ReflectionUtil.boxType(i < parameterTypesLength ? parameterTypes[i] : parameterTypes[parameterTypesLength - 1]);
                Object argument = arguments[i];
                Class<?> clazz = componentType = method2.isVarArgs() && i < parameterTypesLength - 1 ? null : parameterTypes[parameterTypesLength - 1].getComponentType();
                if (argument == null || type.isInstance(argument)) continue;
                if (componentType == null || !componentType.isInstance(argument)) continue block0;
                convertVarArgs.set((Boolean)true);
            }
            if (parameterTypes.length > arguments.length) {
                convertVarArgs.set((Boolean)true);
            }
            return method2;
        }
        return null;
    }

    @Override
    public String dumpContextDeclarations() {
        StringBuilder sb = new StringBuilder();
        THashMap classes = new THashMap();
        THashSet missingClasses = new THashSet();
        classes.put(Object.class, missingClasses);
        for (Method method2 : this.myStaticMethods) {
            for (Class<?> type = method2.getReturnType(); type != null && ElementPattern.class.isAssignableFrom(type); type = type.getSuperclass()) {
                Class<?> enclosingClass = type.getEnclosingClass();
                if (enclosingClass != null) {
                    THashSet list2 = (THashSet)classes.get(enclosingClass);
                    if (list2 == null) {
                        list2 = new THashSet();
                        classes.put(enclosingClass, list2);
                    }
                    list2.add(type);
                    continue;
                }
                if (classes.containsKey(type)) continue;
                classes.put(type, null);
            }
        }
        for (Class aClass : classes.keySet()) {
            if (aClass == Object.class) continue;
            PatternCompilerImpl.printClass(aClass, classes, sb);
        }
        for (Method method2 : this.myStaticMethods) {
            PatternCompilerImpl.printMethodDeclaration(method2, sb, classes);
        }
        for (Class aClass : missingClasses) {
            sb.append("class ").append(aClass.getSimpleName());
            Class superclass = aClass.getSuperclass();
            if (missingClasses.contains(superclass)) {
                sb.append(" extends ").append(superclass.getSimpleName());
            }
            sb.append("{}\n");
        }
        return sb.toString();
    }

    private static void printClass(Class<?> aClass, Map<Class<?>, Collection<Class<?>>> classes, StringBuilder sb) {
        boolean isInterface = aClass.isInterface();
        sb.append(isInterface ? "interface " : "class ");
        PatternCompilerImpl.dumpType(aClass, aClass, sb, classes);
        Type superClass = aClass.getGenericSuperclass();
        Class rawSuperClass = (Class)(superClass instanceof ParameterizedType ? ((ParameterizedType)superClass).getRawType() : superClass);
        if (superClass != null && classes.containsKey(rawSuperClass)) {
            sb.append(" extends ");
            PatternCompilerImpl.dumpType(null, superClass, sb, classes);
        }
        int implementsIdx = 1;
        for (Type superInterface : aClass.getGenericInterfaces()) {
            Class rawSuperInterface = (Class)(superInterface instanceof ParameterizedType ? ((ParameterizedType)superInterface).getRawType() : superInterface);
            if (!classes.containsKey(rawSuperInterface)) continue;
            if (implementsIdx++ == 1) {
                sb.append(isInterface ? " extends " : " implements ");
            } else {
                sb.append(", ");
            }
            PatternCompilerImpl.dumpType(null, superInterface, sb, classes);
        }
        sb.append(" {\n");
        for (Method method2 : aClass.getDeclaredMethods()) {
            if (Modifier.isStatic(method2.getModifiers()) || !Modifier.isPublic(method2.getModifiers()) || Modifier.isVolatile(method2.getModifiers())) continue;
            PatternCompilerImpl.printMethodDeclaration(method2, sb.append("  "), classes);
        }
        Collection<Class<?>> innerClasses = classes.get(aClass);
        sb.append("}\n");
        if (innerClasses != null) {
            for (Class<?> innerClass : innerClasses) {
                PatternCompilerImpl.printClass(innerClass, classes, sb);
            }
        }
    }

    private static void dumpType(GenericDeclaration owner, Type type, StringBuilder sb, Map<Class<?>, Collection<Class<?>>> classes) {
        if (type instanceof Class) {
            Class aClass = (Class)type;
            Class<?> enclosingClass = aClass.getEnclosingClass();
            if (enclosingClass != null) {
                sb.append(enclosingClass.getSimpleName()).append("_");
            } else if (!(aClass.isArray() || aClass.isPrimitive() || aClass.getName().startsWith("java.") || classes.containsKey(aClass))) {
                classes.get(Object.class).add(aClass);
            }
            sb.append(aClass.getSimpleName());
            if (owner == aClass) {
                PatternCompilerImpl.dumpTypeParametersArray(owner, aClass.getTypeParameters(), sb, "<", ">", classes);
            }
        } else if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            sb.append(typeVariable.getName());
            if (typeVariable.getGenericDeclaration() == owner) {
                PatternCompilerImpl.dumpTypeParametersArray(null, typeVariable.getBounds(), sb, " extends ", "", classes);
            }
        } else if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            sb.append("?");
            PatternCompilerImpl.dumpTypeParametersArray(owner, wildcardType.getUpperBounds(), sb, " extends ", "", classes);
            PatternCompilerImpl.dumpTypeParametersArray(owner, wildcardType.getLowerBounds(), sb, " super ", "", classes);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type raw = parameterizedType.getRawType();
            PatternCompilerImpl.dumpType(null, raw, sb, classes);
            PatternCompilerImpl.dumpTypeParametersArray(owner, parameterizedType.getActualTypeArguments(), sb, "<", ">", classes);
        } else if (type instanceof GenericArrayType) {
            PatternCompilerImpl.dumpType(owner, ((GenericArrayType)type).getGenericComponentType(), sb, classes);
            sb.append("[]");
        }
    }

    private static void dumpTypeParametersArray(GenericDeclaration owner, Type[] typeVariables, StringBuilder sb, String prefix, String suffix, Map<Class<?>, Collection<Class<?>>> classes) {
        int typeVarIdx = 1;
        for (Type typeVariable : typeVariables) {
            if (typeVariable == Object.class) continue;
            if (typeVarIdx++ == 1) {
                sb.append(prefix);
            } else {
                sb.append(", ");
            }
            PatternCompilerImpl.dumpType(owner, typeVariable, sb, classes);
        }
        if (typeVarIdx > 1) {
            sb.append(suffix);
        }
    }

    private static void printMethodDeclaration(Method method2, StringBuilder sb, Map<Class<?>, Collection<Class<?>>> classes) {
        if (Modifier.isStatic(method2.getModifiers())) {
            sb.append("static ");
        }
        PatternCompilerImpl.dumpTypeParametersArray(method2, method2.getTypeParameters(), sb, "<", "> ", classes);
        PatternCompilerImpl.dumpType(null, method2.getGenericReturnType(), sb, classes);
        sb.append(" ").append(method2.getName()).append("(");
        int paramIdx = 1;
        for (Type parameter : method2.getGenericParameterTypes()) {
            if (paramIdx != 1) {
                sb.append(", ");
            }
            PatternCompilerImpl.dumpType(null, parameter, sb, classes);
            sb.append(" ").append("p").append(paramIdx++);
        }
        sb.append(")");
        if (!method2.getDeclaringClass().isInterface()) {
            sb.append("{}");
        }
        sb.append("\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ex", "com/intellij/patterns/compiler/PatternCompilerImpl", "onCompilationFailed"));
    }

    public static class LazyPresentablePattern<T>
    implements ElementPattern<T> {
        private final Node myNode;
        private final Set<Method> myStaticMethods;
        private final long myHashCode;
        private ElementPattern<T> myCompiledPattern;

        public LazyPresentablePattern(@NotNull Node node, @NotNull Set<Method> staticMethods) {
            if (node == null) {
                LazyPresentablePattern.$$$reportNull$$$0(0);
            }
            if (staticMethods == null) {
                LazyPresentablePattern.$$$reportNull$$$0(1);
            }
            this.myNode = node;
            this.myStaticMethods = staticMethods;
            this.myHashCode = StringHash.calc(this.toString());
        }

        @Override
        public boolean accepts(@Nullable Object o) {
            return this.getCompiledPattern().accepts(o, new ProcessingContext());
        }

        @Override
        public boolean accepts(@Nullable Object o, ProcessingContext context) {
            return this.getCompiledPattern().accepts(o, context);
        }

        @Override
        public ElementPatternCondition<T> getCondition() {
            return this.getCompiledPattern().getCondition();
        }

        public ElementPattern<T> getCompiledPattern() {
            if (this.myCompiledPattern == null) {
                ElementPattern result2;
                try {
                    result2 = this.compile();
                }
                catch (Throwable throwable) {
                    PatternCompilerImpl.onCompilationFailed(null, this.toString(), throwable);
                    result2 = ALWAYS_FALSE;
                }
                this.myCompiledPattern = result2;
            }
            return this.myCompiledPattern;
        }

        public ElementPattern<?> compile() throws Throwable {
            return this.myNode.target == ERROR_NODE ? ALWAYS_FALSE : (ElementPattern)this.execute(this.myNode);
        }

        public String toString() {
            if (this.myNode.target == ERROR_NODE && this.myNode.args == null) {
                return this.myNode.method;
            }
            StringBuilder sb = new StringBuilder();
            LazyPresentablePattern.appendNode(this.myNode, sb);
            return sb.toString();
        }

        private static void appendNode(Node node, StringBuilder sb) {
            if (node.target == ERROR_NODE) {
                sb.append(node.method);
                return;
            }
            if (node.target != null) {
                LazyPresentablePattern.appendNode(node.target, sb);
                sb.append('.');
            }
            sb.append(node.method).append('(');
            boolean first = true;
            for (Object arg : node.args == null ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : node.args) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',').append(' ');
                }
                if (arg instanceof Node) {
                    LazyPresentablePattern.appendNode((Node)arg, sb);
                    continue;
                }
                if (arg instanceof String) {
                    sb.append('\"').append(StringUtil.escapeStringCharacters((String)arg)).append('\"');
                    continue;
                }
                if (!(arg instanceof Number)) continue;
                sb.append(arg);
            }
            sb.append(')');
        }

        private Object execute(Node node) throws Throwable {
            Object[] args;
            Object target2 = node.target != null ? this.execute(node.target) : null;
            String methodName = node.method;
            if (node.args.length == 0) {
                args = node.args;
            } else {
                args = new Object[node.args.length];
                int len = node.args.length;
                for (int i = 0; i < len; ++i) {
                    args[i] = node.args[i] instanceof Node ? this.execute((Node)node.args[i]) : node.args[i];
                }
            }
            return PatternCompilerImpl.invokeMethod(target2, methodName, args, this.myStaticMethods);
        }

        public int hashCode() {
            return (int)this.myHashCode;
        }

        public boolean equals(Object obj) {
            return obj instanceof LazyPresentablePattern && ((LazyPresentablePattern)obj).myHashCode == this.myHashCode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "staticMethods";
                    break;
                }
            }
            objectArray[1] = "com/intellij/patterns/compiler/PatternCompilerImpl$LazyPresentablePattern";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class FalsePattern
    extends InitialPatternCondition<Object>
    implements ElementPattern<Object> {
        private final ElementPatternCondition<Object> myCondition = new ElementPatternCondition<Object>(this);

        protected FalsePattern() {
            super(Object.class);
        }

        @Override
        public boolean accepts(@Nullable Object o) {
            return false;
        }

        @Override
        public boolean accepts(@Nullable Object o, ProcessingContext context) {
            return false;
        }

        @Override
        public ElementPatternCondition<Object> getCondition() {
            return this.myCondition;
        }
    }

    private static class Node {
        final Node target;
        final String method;
        final Object[] args;

        Node(@Nullable Node target2, @Nullable String method2, Object @Nullable [] args) {
            this.target = target2;
            this.method = method2;
            this.args = args;
        }
    }

    private static class Frame {
        State state = State.init;
        Object target;
        String methodName;
        ArrayList<Object> params = new ArrayList();

        private Frame() {
        }
    }

    private static enum State {
        init,
        name,
        name_end,
        param_start,
        param_end,
        literal,
        escape,
        invoke,
        invoke_end;

    }
}

