/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.CommonBundle;
import com.intellij.configurationStore.StoreUtil;
import com.intellij.featureStatistics.fusCollectors.LifecycleUsageTriggerCollector;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ModuleAttachProcessorKt;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.projectImport.ProjectOpenedCallback;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/platform/ModuleAttachProcessor;", "Lcom/intellij/projectImport/ProjectAttachProcessor;", "()V", "attachToProject", "", "project", "Lcom/intellij/openapi/project/Project;", "projectDir", "Ljava/nio/file/Path;", "callback", "Lcom/intellij/projectImport/ProjectOpenedCallback;", "beforeDetach", "", "module", "Lcom/intellij/openapi/module/Module;", "Companion", "intellij.platform.lang.impl"})
public final class ModuleAttachProcessor
extends ProjectAttachProcessor {
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean attachToProject(@NotNull Project project2, @NotNull Path projectDir, @Nullable ProjectOpenedCallback callback2) {
        Module module2;
        Path dotIdeaDir;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)projectDir, (String)"projectDir");
        Path path2 = dotIdeaDir = projectDir.resolve(".idea");
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"dotIdeaDir");
        if (!PathKt.exists((Path)path2)) {
            OpenProjectTask options = new OpenProjectTask(false, null, true, true, null, null, false, false, false, null, null, null, 0, 0, 16371, null);
            Project project3 = ProjectManagerEx.getInstanceEx().newProject(projectDir, null, options);
            if (project3 == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"ProjectManagerEx.getInst\u2026 options) ?: return false");
            Project newProject = project3;
            PlatformProjectOpenProcessor.Companion.runDirectoryProjectConfigurators(projectDir, newProject, true);
            StoreUtil.Companion.saveSettings$default(StoreUtil.Companion, newProject, false, 2, null);
            boolean $i$f$runWriteAction = false;
            ApplicationManager.getApplication().runWriteAction(new Computable<T>(newProject){
                final /* synthetic */ Project $newProject$inlined;
                {
                    this.$newProject$inlined = project2;
                }

                public final T compute() {
                    boolean bl = false;
                    Disposer.dispose(this.$newProject$inlined);
                    return (T)Unit.INSTANCE;
                }
            });
        }
        try {
            Module module3 = ModuleAttachProcessorKt.access$findMainModule(project2, dotIdeaDir);
            if (module3 == null) {
                module3 = ModuleAttachProcessorKt.access$findMainModule(project2, projectDir);
            }
            module2 = module3;
        }
        catch (Exception e) {
            ModuleAttachProcessorKt.access$getLOG$p().info(e);
            Messages.showErrorDialog(project2, "Cannot attach project: " + e.getMessage(), CommonBundle.getErrorTitle());
            return false;
        }
        Module newModule = module2;
        LifecycleUsageTriggerCollector.onProjectModuleAttached(project2);
        if (newModule != null) {
            ProjectOpenedCallback projectOpenedCallback = callback2;
            if (projectOpenedCallback != null) {
                projectOpenedCallback.projectOpened(project2, newModule);
            }
            return true;
        }
        return Messages.showYesNoDialog(project2, "The project at " + projectDir + " uses a non-standard layout and cannot be attached to this project. Would you like to open it in a new window?", "Open Project", Messages.getQuestionIcon()) != 0;
    }

    @Override
    public void beforeDetach(@NotNull Module module2) {
        Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
        ModuleAttachProcessorKt.access$removeVcsMapping(module2);
    }

    @JvmStatic
    @Nullable
    public static final Module findModuleInBaseDir(@NotNull Project project2) {
        return Companion.findModuleInBaseDir(project2);
    }

    @JvmStatic
    @Nullable
    public static final Module getPrimaryModule(@NotNull Project project2) {
        return Companion.getPrimaryModule(project2);
    }

    @JvmStatic
    @NotNull
    public static final List<Module> getSortedModules(@NotNull Project project2) {
        return Companion.getSortedModules(project2);
    }

    @JvmStatic
    @Nullable
    public static final String getMultiProjectDisplayName(@NotNull Project project2) {
        return Companion.getMultiProjectDisplayName(project2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/platform/ModuleAttachProcessor$Companion;", "", "()V", "findModuleInBaseDir", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "getMultiProjectDisplayName", "", "getPrimaryModule", "getSortedModules", "", "intellij.platform.lang.impl"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final Module findModuleInBaseDir(@NotNull Project project2) {
            Module module2;
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
                VirtualFile baseDir = project2.getBaseDir();
                ModuleManager moduleManager = ModuleManager.getInstance(project2);
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                Module[] moduleArray = moduleManager.getModules();
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
                Module[] $this$firstOrNull$iv = moduleArray;
                boolean $i$f$firstOrNull = false;
                Module[] moduleArray2 = $this$firstOrNull$iv;
                int n = moduleArray2.length;
                for (int i = 0; i < n; ++i) {
                    boolean bl;
                    Module element$iv;
                    block2: {
                        VirtualFile[] $this$any$iv;
                        Module module3 = element$iv = moduleArray2[i];
                        boolean bl2 = false;
                        Module module4 = module3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)module4, (String)"module");
                        Intrinsics.checkExpressionValueIsNotNull((Object)ProjectUtil.getRootManager(module4).getContentRoots(), (String)"module.rootManager.contentRoots");
                        boolean $i$f$any = false;
                        VirtualFile[] virtualFileArray = $this$any$iv;
                        int n2 = virtualFileArray.length;
                        for (int j = 0; j < n2; ++j) {
                            VirtualFile element$iv2;
                            VirtualFile it = element$iv2 = virtualFileArray[j];
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it, (Object)baseDir)) continue;
                            bl = true;
                            break block2;
                        }
                        bl = false;
                    }
                    if (!bl) continue;
                    module2 = element$iv;
                    break block3;
                }
                module2 = null;
            }
            return module2;
        }

        @JvmStatic
        @Nullable
        public final Module getPrimaryModule(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            return ProjectAttachProcessor.canAttachToProject() ? this.findModuleInBaseDir(project2) : null;
        }

        @JvmStatic
        @NotNull
        public final List<Module> getSortedModules(@NotNull Project project2) {
            ArrayList<Module> result2;
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
                Module primaryModule = this.getPrimaryModule(project2);
                result2 = new ArrayList<Module>();
                ModuleManager moduleManager = ModuleManager.getInstance(project2);
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                Module[] moduleArray = moduleManager.getModules();
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
                Module[] $this$filterTo$iv = moduleArray;
                boolean $i$f$filterTo = false;
                Object object = $this$filterTo$iv;
                int n = ((Module[])object).length;
                for (int i = 0; i < n; ++i) {
                    Module element$iv;
                    Module it = element$iv = object[i];
                    boolean bl = false;
                    if (!(it != primaryModule)) continue;
                    ((Collection)result2).add(element$iv);
                }
                List $this$sortBy$iv = result2;
                boolean $i$f$sortBy = false;
                if ($this$sortBy$iv.size() > 1) {
                    object = $this$sortBy$iv;
                    n = 0;
                    Comparator comparator2 = new Comparator<T>(){

                        public final int compare(T a, T b) {
                            boolean bl = false;
                            Module p1 = (Module)a;
                            boolean bl2 = false;
                            Comparable comparable = (Comparable)((Object)p1.getName());
                            p1 = (Module)b;
                            Comparable comparable2 = comparable;
                            bl2 = false;
                            String string = p1.getName();
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                        }
                    };
                    CollectionsKt.sortWith((List)object, (Comparator)comparator2);
                }
                Module module2 = primaryModule;
                if (module2 == null) break block2;
                Module module3 = module2;
                boolean bl = false;
                boolean bl2 = false;
                Module it = module3;
                boolean bl3 = false;
                result2.add(0, it);
            }
            return result2;
        }

        @JvmStatic
        @Nullable
        public final String getMultiProjectDisplayName(@NotNull Project project2) {
            Module primaryModule;
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            if (!ProjectAttachProcessor.canAttachToProject()) {
                return null;
            }
            ModuleManager moduleManager = ModuleManager.getInstance(project2);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
            Object[] modules = moduleManager.getModules();
            if (modules.length <= 1) {
                return null;
            }
            Module module2 = this.getPrimaryModule(project2);
            if (module2 == null) {
                Intrinsics.checkExpressionValueIsNotNull((Object)modules, (String)"modules");
                module2 = (Module)ArraysKt.first((Object[])modules);
            }
            Module module3 = primaryModule = module2;
            Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"primaryModule");
            StringBuilder result2 = new StringBuilder(module3.getName());
            result2.append(", ");
            for (Object module4 : modules) {
                if (module4 == primaryModule) continue;
                Object object = module4;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"module");
                result2.append(object.getName());
                break;
            }
            if (modules.length > 2) {
                result2.append("...");
            }
            return result2.toString();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

