/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.ide.lightEdit.LightEditUtil;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.platform.CommandLineProjectOpenProcessor;
import com.intellij.platform.DirectoryProjectConfigurator;
import com.intellij.platform.PlatformProjectOpenProcessorKt;
import com.intellij.platform.PrepareProjectResult;
import com.intellij.platform.ProjectFrameAllocator;
import com.intellij.platform.ProjectUiFrameAllocator;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.projectImport.ProjectOpenedCallback;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.function.Consumer;
import java.util.function.Predicate;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0002\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J$\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J*\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0005H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/PlatformProjectOpenProcessor;", "Lcom/intellij/projectImport/ProjectOpenProcessor;", "Lcom/intellij/platform/CommandLineProjectOpenProcessor;", "()V", "canOpenProject", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "doOpenProject", "Lcom/intellij/openapi/project/Project;", "virtualFile", "projectToClose", "forceOpenInNewFrame", "getName", "", "isProjectFile", "lookForProjectsInDirectory", "openProjectAndFile", "line", "", "column", "tempProject", "Companion", "Option", "intellij.platform.ide.impl"})
public final class PlatformProjectOpenProcessor
extends ProjectOpenProcessor
implements CommandLineProjectOpenProcessor {
    @JvmField
    @NotNull
    public static final Key<Boolean> PROJECT_OPENED_BY_PLATFORM_PROCESSOR;
    public static final Companion Companion;

    @Override
    public boolean canOpenProject(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return file2.isDirectory();
    }

    @Override
    public boolean isProjectFile(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return false;
    }

    @Override
    public boolean lookForProjectsInDirectory() {
        return false;
    }

    @Override
    @Nullable
    public Project doOpenProject(@NotNull VirtualFile virtualFile2, @Nullable Project projectToClose, boolean forceOpenInNewFrame) {
        Path baseDir;
        Intrinsics.checkParameterIsNotNull((Object)virtualFile2, (String)"virtualFile");
        OpenProjectTask options = new OpenProjectTask(forceOpenInNewFrame, projectToClose);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            options.useDefaultProjectAsTemplate = false;
        }
        options.isNewProject = !ProjectUtil.isValidProjectPath(baseDir = Paths.get(virtualFile2.getPath(), new String[0]));
        Path path2 = baseDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"baseDir");
        return Companion.doOpenProject(path2, options);
    }

    @Override
    @Nullable
    public Project openProjectAndFile(@NotNull VirtualFile virtualFile2, int line, int column, boolean tempProject) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile2, (String)"virtualFile");
        Path file2 = Paths.get(virtualFile2.getPath(), new String[0]);
        if (tempProject) {
            Path path2 = file2;
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"file");
            return Companion.createTempProjectAndOpenFile(path2, new OpenProjectTask(true, null, false, false, null, null, false, false, false, null, null, null, line, column, 4094, null));
        }
        Path path3 = file2;
        Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"file");
        return Companion.doOpenProject(path3, new OpenProjectTask(false, null, false, false, null, null, false, false, false, null, null, null, line, column, 4095, null));
    }

    @Override
    @NotNull
    public String getName() {
        return "text editor";
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create("PROJECT_OPENED_BY_PLATFORM_PROCESSOR");
        Intrinsics.checkExpressionValueIsNotNull(key, (String)"Key.create<Boolean>(\"PRO\u2026D_BY_PLATFORM_PROCESSOR\")");
        PROJECT_OPENED_BY_PLATFORM_PROCESSOR = key;
    }

    @JvmStatic
    @NotNull
    public static final PlatformProjectOpenProcessor getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @Nullable
    public static final PlatformProjectOpenProcessor getInstanceIfItExists() {
        return Companion.getInstanceIfItExists();
    }

    @JvmStatic
    @Deprecated(message="Use {@link #doOpenProject(Path, OpenProjectTask)} ")
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    public static final Project doOpenProject(@NotNull VirtualFile virtualFile2, @Nullable Project projectToClose, boolean forceOpenInNewFrame, int line, @Nullable ProjectOpenedCallback callback2, boolean isReopen) {
        return Companion.doOpenProject(virtualFile2, projectToClose, forceOpenInNewFrame, line, callback2, isReopen);
    }

    @JvmStatic
    @Deprecated(message="Use {@link #doOpenProject(Path, OpenProjectTask)} ")
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    @Nullable
    public static final Project doOpenProject(@NotNull VirtualFile virtualFile2, @Nullable Project projectToClose, int line, @Nullable ProjectOpenedCallback callback2, @NotNull EnumSet<Option> options) {
        return Companion.doOpenProject(virtualFile2, projectToClose, line, callback2, options);
    }

    @JvmStatic
    @ApiStatus.Internal
    @Nullable
    public static final Project createTempProjectAndOpenFile(@NotNull Path file2, @NotNull OpenProjectTask options) {
        return Companion.createTempProjectAndOpenFile(file2, options);
    }

    @JvmStatic
    @ApiStatus.Internal
    @Nullable
    public static final Project doOpenProject(@NotNull Path file2, @NotNull OpenProjectTask options) {
        return Companion.doOpenProject(file2, options);
    }

    @JvmStatic
    @ApiStatus.Internal
    @Nullable
    public static final Project openExistingProject(@NotNull Path file2, @Nullable Path projectDir, @NotNull OpenProjectTask options) {
        return Companion.openExistingProject(file2, projectDir, options);
    }

    @JvmStatic
    @Deprecated(message="Use {@link #runDirectoryProjectConfigurators(Path, Project, boolean)}")
    @NotNull
    public static final Module runDirectoryProjectConfigurators(@NotNull VirtualFile baseDir, @NotNull Project project2) {
        return Companion.runDirectoryProjectConfigurators(baseDir, project2);
    }

    @JvmStatic
    @NotNull
    public static final Module runDirectoryProjectConfigurators(@NotNull Path baseDir, @NotNull Project project2, boolean newProject) {
        return Companion.runDirectoryProjectConfigurators(baseDir, project2, newProject);
    }

    @JvmStatic
    public static final boolean attachToProject(@NotNull Project project2, @NotNull Path projectDir, @Nullable ProjectOpenedCallback callback2) {
        return Companion.attachToProject(project2, projectDir, callback2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/platform/PlatformProjectOpenProcessor$Option;", "", "(Ljava/lang/String;I)V", "FORCE_NEW_FRAME", "TEMP_PROJECT", "intellij.platform.ide.impl"})
    public static final class Option
    extends Enum<Option> {
        public static final /* enum */ Option FORCE_NEW_FRAME;
        public static final /* enum */ Option TEMP_PROJECT;
        private static final /* synthetic */ Option[] $VALUES;

        static {
            Option[] optionArray = new Option[2];
            Option[] optionArray2 = optionArray;
            optionArray[0] = FORCE_NEW_FRAME = new Option();
            optionArray[1] = TEMP_PROJECT = new Option();
            $VALUES = optionArray;
        }

        public static Option[] values() {
            return (Option[])$VALUES.clone();
        }

        public static Option valueOf(String string) {
            return Enum.valueOf(Option.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J>\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001a\u001a\u00020\u0005H\u0007J<\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0007J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\b\u0010\u001d\u001a\u00020\u001eH\u0007J\n\u0010\u001f\u001a\u0004\u0018\u00010\u001eH\u0007J$\u0010 \u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0007J \u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u0005H\u0007R#\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/platform/PlatformProjectOpenProcessor$Companion;", "", "()V", "PROJECT_OPENED_BY_PLATFORM_PROCESSOR", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "attachToProject", "project", "Lcom/intellij/openapi/project/Project;", "projectDir", "Ljava/nio/file/Path;", "callback", "Lcom/intellij/projectImport/ProjectOpenedCallback;", "createTempProjectAndOpenFile", "file", "options", "Lcom/intellij/ide/impl/OpenProjectTask;", "doOpenProject", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "projectToClose", "forceOpenInNewFrame", "line", "", "isReopen", "Ljava/util/EnumSet;", "Lcom/intellij/platform/PlatformProjectOpenProcessor$Option;", "getInstance", "Lcom/intellij/platform/PlatformProjectOpenProcessor;", "getInstanceIfItExists", "openExistingProject", "runDirectoryProjectConfigurators", "Lcom/intellij/openapi/module/Module;", "baseDir", "newProject", "intellij.platform.ide.impl"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final PlatformProjectOpenProcessor getInstance() {
            PlatformProjectOpenProcessor platformProjectOpenProcessor = this.getInstanceIfItExists();
            if (platformProjectOpenProcessor == null) {
                Intrinsics.throwNpe();
            }
            return platformProjectOpenProcessor;
        }

        @JvmStatic
        @Nullable
        public final PlatformProjectOpenProcessor getInstanceIfItExists() {
            ExtensionPointName<ProjectOpenProcessor> extensionPointName = ProjectOpenProcessor.EXTENSION_POINT_NAME;
            Intrinsics.checkExpressionValueIsNotNull(extensionPointName, (String)"EXTENSION_POINT_NAME");
            for (ProjectOpenProcessor processor2 : extensionPointName.getExtensionList()) {
                if (!(processor2 instanceof PlatformProjectOpenProcessor)) continue;
                return (PlatformProjectOpenProcessor)processor2;
            }
            return null;
        }

        @JvmStatic
        @Deprecated(message="Use {@link #doOpenProject(Path, OpenProjectTask)} ")
        @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
        @Nullable
        public final Project doOpenProject(@NotNull VirtualFile virtualFile2, @Nullable Project projectToClose, boolean forceOpenInNewFrame, int line, @Nullable ProjectOpenedCallback callback2, boolean isReopen) {
            Intrinsics.checkParameterIsNotNull((Object)virtualFile2, (String)"virtualFile");
            OpenProjectTask options = new OpenProjectTask(forceOpenInNewFrame, projectToClose, false, false, null, null, false, false, false, null, null, null, line, 0, 12284, null);
            Path path2 = Paths.get(virtualFile2.getPath(), new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(virtualFile.path)");
            return this.doOpenProject(path2, options);
        }

        @JvmStatic
        @Deprecated(message="Use {@link #doOpenProject(Path, OpenProjectTask)} ")
        @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
        @Nullable
        public final Project doOpenProject(@NotNull VirtualFile virtualFile2, @Nullable Project projectToClose, int line, @Nullable ProjectOpenedCallback callback2, @NotNull EnumSet<Option> options) {
            Intrinsics.checkParameterIsNotNull((Object)virtualFile2, (String)"virtualFile");
            Intrinsics.checkParameterIsNotNull(options, (String)"options");
            OpenProjectTask openProjectOptions = new OpenProjectTask(options.contains((Object)Option.FORCE_NEW_FRAME), projectToClose, false, false, null, null, false, false, false, callback2, null, null, line, 0, 11772, null);
            Path path2 = Paths.get(virtualFile2.getPath(), new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(virtualFile.path)");
            return this.doOpenProject(path2, openProjectOptions);
        }

        @JvmStatic
        @ApiStatus.Internal
        @Nullable
        public final Project createTempProjectAndOpenFile(@NotNull Path file2, @NotNull OpenProjectTask options) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            String dummyProjectName = ((Object)file2.getFileName()).toString();
            Path baseDir = FileUtil.createTempDirectory(dummyProjectName, null, true).toPath();
            OpenProjectTask copy2 = OpenProjectTask.copy$default(options, false, null, false, true, null, dummyProjectName, true, false, false, null, null, null, 0, 0, 16279, null);
            Project project2 = this.openExistingProject(file2, baseDir, copy2);
            if (project2 == null) {
                return null;
            }
            Project project3 = project2;
            PlatformProjectOpenProcessorKt.access$openFileFromCommandLine(project3, file2, copy2.getLine(), copy2.getColumn());
            return project3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @ApiStatus.Internal
        @Nullable
        public final Project doOpenProject(@NotNull Path file2, @NotNull OpenProjectTask options) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            PlatformProjectOpenProcessorKt.access$getLOG$p().info("Opening " + file2);
            Path baseDir = file2;
            if (!Files.isDirectory(file2, new LinkOption[0])) {
                Path baseDirCandidate;
                if (LightEditUtil.openFile(file2)) {
                    return LightEditUtil.getProject();
                }
                for (baseDirCandidate = file2.getParent(); baseDirCandidate != null && !Files.exists(baseDirCandidate.resolve(".idea"), new LinkOption[0]); baseDirCandidate = baseDirCandidate.getParent()) {
                }
                if (baseDirCandidate == null) {
                    PlatformProjectOpenProcessorKt.access$getLOG$p().info("No project directory found");
                    if (Registry.is("ide.open.file.in.temp.project.dir")) {
                        return this.createTempProjectAndOpenFile(file2, options);
                    }
                    Path path2 = file2.getParent();
                    Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"file.parent");
                    baseDir = path2;
                    options.isNewProject = !Files.isDirectory(baseDir.resolve(".idea"), new LinkOption[0]);
                } else {
                    baseDir = baseDirCandidate;
                    PlatformProjectOpenProcessorKt.access$getLOG$p().info("Project directory found: " + baseDir);
                }
            }
            AutoCloseable autoCloseable = SaveAndSyncHandler.Companion.getInstance().disableAutoSave();
            boolean bl = false;
            Throwable throwable = null;
            try {
                AccessToken it = (AccessToken)autoCloseable;
                boolean bl2 = false;
                Project project2 = Companion.openExistingProject(file2, baseDir, options);
                if (project2 != null && file2 != baseDir && !Files.isDirectory(file2, new LinkOption[0])) {
                    PlatformProjectOpenProcessorKt.access$openFileFromCommandLine(project2, file2, options.getLine(), options.getColumn());
                }
                Project project3 = project2;
                return project3;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @JvmStatic
        @ApiStatus.Internal
        @Nullable
        public final Project openExistingProject(@NotNull Path file2, @Nullable Path projectDir, @NotNull OpenProjectTask options) {
            Project project2;
            void result2;
            Ref.ObjectRef openProjects;
            ProjectManagerEx projectManager;
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
            if (options.getProject() != null && (projectManager = ProjectManagerEx.getInstanceExIfCreated()) != null && projectManager.isProjectOpened(options.getProject())) {
                return null;
            }
            Activity activity = StartUpMeasurer.startMainActivity("project opening preparation");
            Intrinsics.checkExpressionValueIsNotNull((Object)activity, (String)"StartUpMeasurer.startMai\u2026ect opening preparation\")");
            Activity activity2 = activity;
            if (!options.forceOpenInNewFrame) {
                Ref.ObjectRef objectRef = openProjects = ProjectUtil.getOpenProjects();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectRef, (String)"openProjects");
                Ref.ObjectRef objectRef2 = objectRef;
                boolean bl = false;
                Ref.ObjectRef objectRef3 = objectRef2;
                boolean bl2 = false;
                if (!(((Ref.ObjectRef)objectRef3).length == 0)) {
                    Project projectToClose = options.projectToClose;
                    if (projectToClose == null) {
                        IdeFrame lastFocusedFrame;
                        IdeFocusManager ideFocusManager = IdeFocusManager.getGlobalInstance();
                        Intrinsics.checkExpressionValueIsNotNull((Object)ideFocusManager, (String)"IdeFocusManager.getGlobalInstance()");
                        IdeFrame ideFrame = lastFocusedFrame = ideFocusManager.getLastFocusedFrame();
                        Project project3 = projectToClose = ideFrame != null ? ideFrame.getProject() : null;
                        if (projectToClose == null || projectToClose instanceof LightEditCompatible) {
                            projectToClose = openProjects[((Ref.ObjectRef)openProjects).length - 1];
                        }
                    }
                    Project project4 = projectToClose;
                    if (project4 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (PlatformProjectOpenProcessorKt.access$checkExistingProjectOnOpen(project4, options.getCallback(), projectDir)) {
                        return null;
                    }
                }
            }
            openProjects = new Ref.ObjectRef();
            openProjects.element = null;
            boolean $i$f$runInAutoSaveDisabledMode = false;
            AutoCloseable lastFocusedFrame = SaveAndSyncHandler.Companion.getInstance().disableAutoSave();
            boolean bl = false;
            Throwable throwable = null;
            try {
                AccessToken it$iv = (AccessToken)lastFocusedFrame;
                boolean bl3 = false;
                boolean bl4 = false;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                ProjectFrameAllocator frameAllocator = application.isHeadlessEnvironment() ? new ProjectFrameAllocator() : (ProjectFrameAllocator)new ProjectUiFrameAllocator(options, file2);
                boolean isCompleted = frameAllocator.run((Function0<Unit>)((Function0)new Function0<Unit>(frameAllocator, options, file2, activity2, (Ref.ObjectRef)result2, projectDir){
                    final /* synthetic */ ProjectFrameAllocator $frameAllocator;
                    final /* synthetic */ OpenProjectTask $options$inlined;
                    final /* synthetic */ Path $file$inlined;
                    final /* synthetic */ Activity $activity$inlined;
                    final /* synthetic */ Ref.ObjectRef $result$inlined;
                    final /* synthetic */ Path $projectDir$inlined;
                    {
                        this.$frameAllocator = projectFrameAllocator;
                        this.$options$inlined = openProjectTask;
                        this.$file$inlined = path2;
                        this.$activity$inlined = activity;
                        this.$result$inlined = objectRef;
                        this.$projectDir$inlined = path3;
                        super(0);
                    }

                    public final void invoke() {
                        this.$activity$inlined.end();
                        if (this.$options$inlined.getProject() == null) {
                            Path path2 = this.$projectDir$inlined;
                            if (path2 == null) {
                                Intrinsics.throwNpe();
                            }
                            this.$result$inlined.element = PlatformProjectOpenProcessorKt.access$prepareProject(this.$file$inlined, this.$options$inlined, path2);
                            PrepareProjectResult prepareProjectResult = (PrepareProjectResult)this.$result$inlined.element;
                            if ((prepareProjectResult != null ? prepareProjectResult.getProject() : null) == null) {
                                this.$frameAllocator.projectNotLoaded(null);
                                return;
                            }
                        } else {
                            this.$result$inlined.element = new PrepareProjectResult(this.$options$inlined.getProject(), null);
                        }
                        PrepareProjectResult prepareProjectResult = (PrepareProjectResult)this.$result$inlined.element;
                        if (prepareProjectResult == null) {
                            Intrinsics.throwNpe();
                        }
                        Project project2 = prepareProjectResult.getProject();
                        this.$frameAllocator.projectLoaded(project2);
                        if (ProjectManagerEx.getInstanceEx().openProject(project2)) {
                            this.$frameAllocator.projectOpened(project2);
                        } else {
                            this.$frameAllocator.projectNotLoaded(null);
                            this.$result$inlined.element = null;
                        }
                    }
                }));
                if (!isCompleted) {
                    result2.element = null;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)lastFocusedFrame, (Throwable)throwable);
            }
            PrepareProjectResult prepareProjectResult = (PrepareProjectResult)result2.element;
            Project project5 = project2 = prepareProjectResult != null ? prepareProjectResult.getProject() : null;
            if (project2 == null) {
                if (options.getShowWelcomeScreen()) {
                    WelcomeFrame.showIfNoProjectOpened();
                }
                return null;
            }
            if (options.getCallback() != null) {
                Module module2;
                PrepareProjectResult prepareProjectResult2 = (PrepareProjectResult)result2.element;
                Module module3 = module2 = prepareProjectResult2 != null ? prepareProjectResult2.getModule() : null;
                if (module2 == null) {
                    ModuleManager moduleManager = ModuleManager.getInstance(project2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                    module2 = moduleManager.getModules()[0];
                }
                ProjectOpenedCallback projectOpenedCallback = options.getCallback();
                if (projectOpenedCallback == null) {
                    Intrinsics.throwNpe();
                }
                projectOpenedCallback.projectOpened(project2, module2);
            }
            return project2;
        }

        @JvmStatic
        @Deprecated(message="Use {@link #runDirectoryProjectConfigurators(Path, Project, boolean)}")
        @NotNull
        public final Module runDirectoryProjectConfigurators(@NotNull VirtualFile baseDir, @NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)baseDir, (String)"baseDir");
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Path path2 = Paths.get(baseDir.getPath(), new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"Paths.get(baseDir.path)");
            return this.runDirectoryProjectConfigurators(path2, project2, false);
        }

        @JvmStatic
        @NotNull
        public final Module runDirectoryProjectConfigurators(@NotNull Path baseDir, @NotNull Project project2, boolean newProject) {
            Intrinsics.checkParameterIsNotNull((Object)baseDir, (String)"baseDir");
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Ref moduleRef = new Ref();
            VirtualFile virtualFile2 = ProjectUtil.getFileAndRefresh(baseDir);
            PlatformProjectOpenProcessorKt.access$getLOG$p().assertTrue(virtualFile2 != null);
            DirectoryProjectConfigurator.EP_NAME.forEachExtensionSafe(new Consumer<DirectoryProjectConfigurator>(project2, virtualFile2, moduleRef, newProject){
                final /* synthetic */ Project $project;
                final /* synthetic */ VirtualFile $virtualFile;
                final /* synthetic */ Ref $moduleRef;
                final /* synthetic */ boolean $newProject;

                public final void accept(@NotNull DirectoryProjectConfigurator configurator) {
                    Intrinsics.checkParameterIsNotNull((Object)configurator, (String)"configurator");
                    VirtualFile virtualFile2 = this.$virtualFile;
                    if (virtualFile2 == null) {
                        Intrinsics.throwNpe();
                    }
                    configurator.configureProject(this.$project, virtualFile2, this.$moduleRef, this.$newProject);
                }
                {
                    this.$project = project2;
                    this.$virtualFile = virtualFile2;
                    this.$moduleRef = ref;
                    this.$newProject = bl;
                }
            });
            Object t = moduleRef.get();
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"moduleRef.get()");
            return (Module)t;
        }

        @JvmStatic
        public final boolean attachToProject(@NotNull Project project2, @NotNull Path projectDir, @Nullable ProjectOpenedCallback callback2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)projectDir, (String)"projectDir");
            return ProjectAttachProcessor.EP_NAME.findFirstSafe(new Predicate<ProjectAttachProcessor>(project2, projectDir, callback2){
                final /* synthetic */ Project $project;
                final /* synthetic */ Path $projectDir;
                final /* synthetic */ ProjectOpenedCallback $callback;

                public final boolean test(ProjectAttachProcessor processor2) {
                    return processor2.attachToProject(this.$project, this.$projectDir, this.$callback);
                }
                {
                    this.$project = project2;
                    this.$projectDir = path2;
                    this.$callback = projectOpenedCallback;
                }
            }) != null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

