/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform;

import com.intellij.conversion.ConversionResult;
import com.intellij.conversion.ConversionService;
import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurerKt;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.platform.PlatformProjectOpenProcessorKt;
import com.intellij.platform.PrepareProjectResult;
import com.intellij.pom.Navigatable;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.projectImport.ProjectOpenedCallback;
import com.intellij.ui.IdeUICustomization;
import com.intellij.util.Consumer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002\u001a2\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0002\u001a\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002\u001a\"\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\nH\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "checkExistingProjectOnOpen", "", "projectToClose", "Lcom/intellij/openapi/project/Project;", "callback", "Lcom/intellij/projectImport/ProjectOpenedCallback;", "projectDir", "Ljava/nio/file/Path;", "configureNewProject", "Lcom/intellij/openapi/module/Module;", "project", "baseDir", "dummyFileContentRoot", "dummyProject", "newProject", "convertAndLoadProject", "path", "options", "Lcom/intellij/ide/impl/OpenProjectTask;", "openFileFromCommandLine", "", "file", "line", "", "column", "prepareProject", "Lcom/intellij/platform/PrepareProjectResult;", "intellij.platform.ide.impl"})
public final class PlatformProjectOpenProcessorKt {
    private static final Logger LOG;

    private static final PrepareProjectResult prepareProject(Path file2, OpenProjectTask options, Path baseDir) {
        Project project2 = null;
        boolean isNewProject = options.isNewProject;
        if (isNewProject) {
            String string = options.getProjectName();
            if (string == null) {
                string = ((Object)baseDir.getFileName()).toString();
            }
            String projectName = string;
            project2 = ProjectManagerEx.getInstanceEx().newProject(baseDir, projectName, options);
        } else {
            ProgressIndicator indicator;
            ProgressManager progressManager = ProgressManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
            ProgressIndicator progressIndicator2 = indicator = progressManager.getProgressIndicator();
            if (progressIndicator2 != null) {
                progressIndicator2.setText(IdeUICustomization.getInstance().projectMessage("progress.text.project.checking.configuration", new Object[0]));
            }
            project2 = PlatformProjectOpenProcessorKt.convertAndLoadProject(baseDir, options);
            ProgressIndicator progressIndicator3 = indicator;
            if (progressIndicator3 != null) {
                progressIndicator3.setText("");
            }
        }
        if (project2 == null) {
            return null;
        }
        Module module2 = PlatformProjectOpenProcessorKt.configureNewProject(project2, baseDir, file2, options.isDummyProject(), isNewProject);
        if (isNewProject) {
            project2.save();
        }
        return new PrepareProjectResult(project2, module2);
    }

    /*
     * Unable to fully structure code
     */
    private static final Module configureNewProject(Project project, Path baseDir, Path dummyFileContentRoot, boolean dummyProject, boolean newProject) {
        if (newProject) ** GOTO lbl-1000
        v0 = ModuleManager.getInstance(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"ModuleManager.getInstance(project)");
        v1 = v0.getModules();
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"ModuleManager.getInstance(project).modules");
        var6_5 = v1;
        var7_6 = false;
        if (var6_5.length == 0) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        runConfigurators = v2;
        var6_5 = new Ref.ObjectRef();
        var6_5.element = null;
        if (runConfigurators) {
            ApplicationManager.getApplication().invokeAndWait(new Runnable((Ref.ObjectRef)module, baseDir, project, newProject){
                final /* synthetic */ Ref.ObjectRef $module;
                final /* synthetic */ Path $baseDir;
                final /* synthetic */ Project $project;
                final /* synthetic */ boolean $newProject;

                public final void run() {
                    this.$module.element = PlatformProjectOpenProcessor.Companion.runDirectoryProjectConfigurators(this.$baseDir, this.$project, this.$newProject);
                }
                {
                    this.$module = objectRef;
                    this.$baseDir = path2;
                    this.$project = project2;
                    this.$newProject = bl;
                }
            });
        }
        if (runConfigurators && dummyProject) {
            v3 = (Module)module.element;
            if (v3 == null) {
                Intrinsics.throwNpe();
            }
            ModuleRootModificationUtil.updateModel(v3, (Consumer<? super ModifiableRootModel>)new Consumer<ModifiableRootModel>(dummyFileContentRoot){
                final /* synthetic */ Path $dummyFileContentRoot;

                public final void consume(ModifiableRootModel model) {
                    ModifiableRootModel modifiableRootModel = model;
                    Intrinsics.checkExpressionValueIsNotNull((Object)modifiableRootModel, (String)"model");
                    ContentEntry[] entries = modifiableRootModel.getContentEntries();
                    if (entries.length == 1) {
                        model.removeContentEntry(entries[0]);
                    }
                    model.addContentEntry(VfsUtilCore.pathToUrl(((Object)this.$dummyFileContentRoot).toString()));
                }
                {
                    this.$dummyFileContentRoot = path2;
                }
            });
        }
        return (Module)module.element;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final boolean checkExistingProjectOnOpen(Project projectToClose, ProjectOpenedCallback callback2, Path projectDir) {
        int exitCode;
        block6: {
            int exitCode2;
            block7: {
                boolean isValidProject;
                GeneralSettings settings = GeneralSettings.getInstance();
                boolean bl = isValidProject = projectDir != null && ProjectUtil.isValidProjectPath(projectDir);
                if (projectDir == null || !ProjectAttachProcessor.canAttachToProject()) break block6;
                if (!isValidProject) break block7;
                GeneralSettings generalSettings = settings;
                Intrinsics.checkExpressionValueIsNotNull((Object)generalSettings, (String)"settings");
                if (generalSettings.getConfirmOpenNewProject() != -1) break block6;
            }
            if ((exitCode2 = ProjectUtil.confirmOpenOrAttachProject()) == -1) {
                return true;
            }
            if (exitCode2 == 1 ? !ProjectManagerEx.getInstanceEx().closeAndDispose(projectToClose) : exitCode2 == 2 && PlatformProjectOpenProcessor.Companion.attachToProject(projectToClose, projectDir, callback2)) {
                return true;
            }
            IdeEventQueue.getInstance().flushQueue();
            return false;
        }
        if ((exitCode = ProjectUtil.confirmOpenNewProject(false)) == 1) {
            if (ProjectManagerEx.getInstanceEx().closeAndDispose(projectToClose)) return false;
            return true;
        }
        if (exitCode == 0) return false;
        return true;
    }

    private static final void openFileFromCommandLine(Project project2, Path file2, int line, int column) {
        StartupManager.getInstance(project2).registerPostStartupDumbAwareActivity(new Runnable(project2, file2, line, column){
            final /* synthetic */ Project $project;
            final /* synthetic */ Path $file;
            final /* synthetic */ int $line;
            final /* synthetic */ int $column;

            public final void run() {
                ApplicationManager.getApplication().invokeLater(new Runnable(this){
                    final /* synthetic */ openFileFromCommandLine.1 this$0;

                    public final void run() {
                        Navigatable navigatable;
                        if (this.this$0.$project.isDisposed() || !Files.exists(this.this$0.$file, new LinkOption[0])) {
                            return;
                        }
                        VirtualFile virtualFile2 = ProjectUtil.getFileAndRefresh(this.this$0.$file);
                        if (virtualFile2 == null) {
                            return;
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"ProjectUtil.getFileAndRe\u2026(file) ?: return@Runnable");
                        VirtualFile virtualFile3 = virtualFile2;
                        if (this.this$0.$line > 0) {
                            navigatable = new OpenFileDescriptor(this.this$0.$project, virtualFile3, this.this$0.$line - 1, RangesKt.coerceAtLeast((int)this.this$0.$column, (int)0));
                        } else {
                            Navigatable navigatable2 = PsiNavigationSupport.getInstance().createNavigatable(this.this$0.$project, virtualFile3, -1);
                            navigatable = navigatable2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)navigatable2, (String)"PsiNavigationSupport.get\u2026project, virtualFile, -1)");
                        }
                        Navigatable navigatable3 = navigatable;
                        navigatable3.navigate(true);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }, ModalityState.NON_MODAL, this.$project.getDisposed());
            }
            {
                this.$project = project2;
                this.$file = path2;
                this.$line = n;
                this.$column = n2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final Project convertAndLoadProject(Path path2, OpenProjectTask options) {
        void name$iv;
        String string = "project conversion";
        ActivityCategory category$iv = ActivityCategory.MAIN;
        boolean $i$f$runActivity = false;
        Activity activity$iv = StartUpMeasurerKt.createActivity((String)name$iv, (ActivityCategory)category$iv);
        boolean bl = false;
        ConversionResult result$iv = ConversionService.getInstance().convert(path2);
        activity$iv.end();
        ConversionResult conversionResult = result$iv;
        Intrinsics.checkExpressionValueIsNotNull((Object)conversionResult, (String)"runActivity(\"project con\u2026tance().convert(path)\n  }");
        ConversionResult conversionResult2 = conversionResult;
        if (conversionResult2.openingIsCanceled()) {
            return null;
        }
        ProjectImpl projectImpl = ProjectManagerImpl.doCreateProject(options.getProjectName(), path2);
        Intrinsics.checkExpressionValueIsNotNull((Object)projectImpl, (String)"ProjectManagerImpl.doCre\u2026ptions.projectName, path)");
        ProjectImpl project2 = projectImpl;
        try {
            ProgressManager progressManager = ProgressManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)progressManager, (String)"ProgressManager.getInstance()");
            ProjectManagerImpl.initProject(path2, project2, true, null, progressManager.getProgressIndicator());
        }
        catch (ProcessCanceledException e) {
            return null;
        }
        if (!conversionResult2.conversionNotNeeded()) {
            StartupManager.getInstance(project2).registerPostStartupActivity(new Runnable(conversionResult2, project2){
                final /* synthetic */ ConversionResult $conversionResult;
                final /* synthetic */ ProjectImpl $project;

                public final void run() {
                    this.$conversionResult.postStartupActivity(this.$project);
                }
                {
                    this.$conversionResult = conversionResult;
                    this.$project = projectImpl;
                }
            });
        }
        return project2;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PlatformProjectOpenProcessor.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ void access$openFileFromCommandLine(Project project2, Path file2, int line, int column) {
        PlatformProjectOpenProcessorKt.openFileFromCommandLine(project2, file2, line, column);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ boolean access$checkExistingProjectOnOpen(Project projectToClose, ProjectOpenedCallback callback2, Path projectDir) {
        return PlatformProjectOpenProcessorKt.checkExistingProjectOnOpen(projectToClose, callback2, projectDir);
    }

    public static final /* synthetic */ PrepareProjectResult access$prepareProject(Path file2, OpenProjectTask options, Path baseDir) {
        return PlatformProjectOpenProcessorKt.prepareProject(file2, options, baseDir);
    }
}

