/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.renameProject;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.platform.ModuleAttachProcessor;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.RenameHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameProjectHandler
implements RenameHandler,
TitledHandler {
    private static final Logger LOG = Logger.getInstance(RenameProjectHandler.class);

    @Override
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            RenameProjectHandler.$$$reportNull$$$0(0);
        }
        return RenameProjectHandler.isAvailable(dataContext);
    }

    static boolean isAvailable(DataContext dataContext) {
        Module module2 = LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        return module2 != null;
    }

    @Override
    public String getActionTitle() {
        return RefactoringBundle.message("rename.project.handler.title");
    }

    @Override
    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, DataContext dataContext) {
        if (project2 == null) {
            RenameProjectHandler.$$$reportNull$$$0(1);
        }
        LOG.error("Project renaming should be never invoked from file");
    }

    @Override
    public void invoke(@NotNull Project project2, PsiElement @NotNull [] elements2, DataContext dataContext) {
        if (project2 == null) {
            RenameProjectHandler.$$$reportNull$$$0(2);
        }
        if (elements2 == null) {
            RenameProjectHandler.$$$reportNull$$$0(3);
        }
        LOG.assertTrue(project2 instanceof ProjectEx);
        Module module2 = LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        LOG.assertTrue(module2 != null);
        Messages.showInputDialog(project2, RefactoringBundle.message("enter.new.project.name"), RefactoringBundle.message("rename.project"), Messages.getQuestionIcon(), module2.getName(), (InputValidator)new MyInputValidator((ProjectEx)project2, module2));
    }

    public static boolean renameProject(@NotNull ProjectEx project2, @Nullable Module module2, String newName) {
        if (project2 == null) {
            RenameProjectHandler.$$$reportNull$$$0(4);
        }
        if (RenameProjectHandler.shouldRenameProject(project2, module2, newName)) {
            project2.setProjectName(newName);
            project2.save();
        }
        if (module2 != null && !newName.equals(module2.getName())) {
            ModifiableModuleModel modifiableModel = ModuleManager.getInstance(project2).getModifiableModel();
            try {
                modifiableModel.renameModule(module2, newName);
            }
            catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
                Messages.showErrorDialog(project2, IdeBundle.message("error.module.already.exists", newName), IdeBundle.message("title.rename.module", new Object[0]));
                return false;
            }
            Ref<Boolean> success = Ref.create(Boolean.TRUE);
            CommandProcessor.getInstance().executeCommand(project2, () -> ApplicationManager.getApplication().runWriteAction(() -> modifiableModel.commit()), IdeBundle.message("command.renaming.module", module2.getName()), null);
            return success.get();
        }
        return true;
    }

    private static boolean shouldRenameProject(@NotNull Project project2, @Nullable Module module2, String inputString) {
        if (project2 == null) {
            RenameProjectHandler.$$$reportNull$$$0(5);
        }
        if (inputString.equals(project2.getName())) {
            return false;
        }
        if (module2 == null) {
            return true;
        }
        if (ProjectAttachProcessor.canAttachToProject()) {
            return module2 == ModuleAttachProcessor.getPrimaryModule(project2);
        }
        return module2 == ModuleAttachProcessor.findModuleInBaseDir(project2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/platform/renameProject/RenameProjectHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "renameProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldRenameProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class MyInputValidator
    implements InputValidator {
        private final ProjectEx myProject;
        @Nullable
        private final Module myModule;

        public MyInputValidator(ProjectEx project2, @Nullable Module module2) {
            this.myProject = project2;
            this.myModule = module2;
        }

        @Override
        public boolean checkInput(String inputString) {
            return inputString != null && inputString.length() > 0;
        }

        @Override
        public boolean canClose(String inputString) {
            return RenameProjectHandler.renameProject(this.myProject, this.myModule, inputString);
        }
    }
}

