/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.facet.frameworks.beans.Artifact;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ProjectTemplateParameterFactory;
import com.intellij.ide.util.projectWizard.WizardInputField;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.templates.TemplateModuleBuilder;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipInputStream;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="template")
public abstract class ArchivedProjectTemplate
implements ProjectTemplate {
    public static final String INPUT_FIELD = "input-field";
    public static final String TEMPLATE = "template";
    public static final String INPUT_DEFAULT = "default";
    protected final String myDisplayName;
    @Nullable
    private final String myCategory;
    private List<WizardInputField<?>> myInputFields;
    private List<String> myFrameworks;
    private List<Artifact> myArtifacts;

    public ArchivedProjectTemplate(@NotNull String displayName, @Nullable String category) {
        if (displayName == null) {
            ArchivedProjectTemplate.$$$reportNull$$$0(0);
        }
        this.myInputFields = Collections.emptyList();
        this.myFrameworks = new ArrayList<String>();
        this.myArtifacts = new ArrayList<Artifact>();
        this.myDisplayName = displayName;
        this.myCategory = category;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myDisplayName;
        if (string == null) {
            ArchivedProjectTemplate.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public Icon getIcon() {
        return this.getModuleType().getIcon();
    }

    protected abstract ModuleType<?> getModuleType();

    @Override
    @NotNull
    public ModuleBuilder createModuleBuilder() {
        return new TemplateModuleBuilder(this, this.getModuleType(), this.getInputFields());
    }

    @NotNull
    public List<WizardInputField<?>> getInputFields() {
        List<WizardInputField<?>> list2 = this.myInputFields;
        if (list2 == null) {
            ArchivedProjectTemplate.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Property(surroundWithTag=false)
    @XCollection(elementName="artifact")
    public List<Artifact> getArtifacts() {
        return this.myArtifacts;
    }

    public void setArtifacts(List<Artifact> artifacts) {
        this.myArtifacts = artifacts;
    }

    @Property(surroundWithTag=false)
    @XCollection(elementName="framework", valueAttributeName="")
    @NotNull
    public List<String> getFrameworks() {
        List<String> list2 = this.myFrameworks;
        if (list2 == null) {
            ArchivedProjectTemplate.$$$reportNull$$$0(3);
        }
        return list2;
    }

    public void setFrameworks(List<String> frameworks) {
        this.myFrameworks = frameworks;
    }

    @Override
    @Nullable
    public ValidationInfo validateSettings() {
        return null;
    }

    public void handleUnzippedDirectories(@NotNull File dir, @NotNull List<? super File> filesToRefresh) throws IOException {
        if (dir == null) {
            ArchivedProjectTemplate.$$$reportNull$$$0(4);
        }
        if (filesToRefresh == null) {
            ArchivedProjectTemplate.$$$reportNull$$$0(5);
        }
        filesToRefresh.add(dir);
    }

    public abstract <T> T processStream(@NotNull StreamProcessor<T> var1) throws IOException;

    @Nullable
    public String getCategory() {
        return this.myCategory;
    }

    public void populateFromElement(@NotNull Element element2) {
        if (element2 == null) {
            ArchivedProjectTemplate.$$$reportNull$$$0(6);
        }
        XmlSerializer.deserializeInto(this, element2);
        this.myInputFields = ArchivedProjectTemplate.getFields(element2);
    }

    private static List<WizardInputField<?>> getFields(Element templateElement) {
        return ContainerUtil.mapNotNull(templateElement.getChildren(INPUT_FIELD), element2 -> {
            ProjectTemplateParameterFactory factory = WizardInputField.getFactoryById(element2.getText());
            return factory == null ? null : factory.createField(element2.getAttributeValue(INPUT_DEFAULT));
        });
    }

    protected static <T> T consumeZipStream(@NotNull StreamProcessor<T> consumer, @NotNull ZipInputStream stream) throws IOException {
        if (consumer == null) {
            ArchivedProjectTemplate.$$$reportNull$$$0(7);
        }
        if (stream == null) {
            ArchivedProjectTemplate.$$$reportNull$$$0(8);
        }
        try {
            T t = consumer.consume(stream);
            return t;
        }
        finally {
            StreamUtil.closeStream(stream);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/templates/ArchivedProjectTemplate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToRefresh";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/templates/ArchivedProjectTemplate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFields";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleUnzippedDirectories";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "populateFromElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "consumeZipStream";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class StreamProcessor<T> {
        public abstract T consume(@NotNull ZipInputStream var1) throws IOException;
    }
}

