/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.CommonBundle;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.templates.ArchivedTemplatesFactory;
import com.intellij.platform.templates.LocalArchivedTemplate;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Arrays;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ManageProjectTemplatesDialog
extends DialogWrapper {
    private final JPanel myPanel;
    private final JBList<ProjectTemplate> myTemplatesList;
    private final JTextPane myDescriptionPane;

    ManageProjectTemplatesDialog() {
        super(false);
        this.setTitle("Manage Project Templates");
        ProjectTemplate[] templates = new ArchivedTemplatesFactory().createTemplates("User-defined", new WizardContext(null, this.getDisposable()));
        this.myTemplatesList = new JBList<ProjectTemplate>((ListModel<ProjectTemplate>)new CollectionListModel<ProjectTemplate>(Arrays.asList(templates)){

            @Override
            public void remove(int index) {
                ProjectTemplate template = (ProjectTemplate)this.getElementAt(index);
                super.remove(index);
                if (template instanceof LocalArchivedTemplate) {
                    FileUtil.delete(new File(((LocalArchivedTemplate)template).getArchivePath().getPath()));
                }
            }
        });
        this.myTemplatesList.setEmptyText("No user-defined project templates");
        this.myTemplatesList.setCellRenderer(SimpleListCellRenderer.create("", ProjectTemplate::getName));
        this.myTemplatesList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ProjectTemplate template = ManageProjectTemplatesDialog.this.getSelectedTemplate();
                ManageProjectTemplatesDialog.this.myDescriptionPane.setText(template == null ? null : template.getDescription());
            }
        });
        this.myPanel = new JPanel(new BorderLayout(0, 5));
        JPanel panel2 = ToolbarDecorator.createDecorator(this.myTemplatesList).disableUpDownActions().createPanel();
        panel2.setPreferredSize(JBUI.size(300, 200));
        this.myPanel.add(panel2);
        this.myDescriptionPane = new JTextPane();
        this.myDescriptionPane.setPreferredSize(JBUI.size(300, 50));
        Messages.installHyperlinkSupport(this.myDescriptionPane);
        this.myPanel.add((Component)ScrollPaneFactory.createScrollPane(this.myDescriptionPane, 22, 30), "South");
        if (templates.length > 0) {
            this.myTemplatesList.setSelectedValue(templates[0], true);
        }
        this.init();
    }

    @Nullable
    private ProjectTemplate getSelectedTemplate() {
        return (ProjectTemplate)this.myTemplatesList.getSelectedValue();
    }

    @Override
    protected Action @NotNull [] createActions() {
        Action[] actionArray = new Action[]{new DialogWrapper.DialogWrapperAction(CommonBundle.getCloseButtonText()){

            @Override
            protected void doAction(ActionEvent e) {
                ManageProjectTemplatesDialog.this.doCancelAction();
            }
        }};
        if (actionArray == null) {
            ManageProjectTemplatesDialog.$$$reportNull$$$0(0);
        }
        return actionArray;
    }

    @Override
    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Override
    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTemplatesList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/platform/templates/ManageProjectTemplatesDialog", "createActions"));
    }
}

