/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.DynamicBundle;
import com.intellij.ide.util.projectWizard.ProjectTemplateParameterFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.templates.ArchivedTemplatesFactory;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SaveProjectAsTemplateDialog
extends DialogWrapper {
    private static final String WHOLE_PROJECT = "<whole project>";
    @NotNull
    private final Project myProject;
    private JPanel myPanel;
    private JTextField myName;
    private EditorTextField myDescription;
    private JComboBox myModuleCombo;
    private JLabel myModuleLabel;
    private JBCheckBox myReplaceParameters;
    private static final Logger LOG = Logger.getInstance(SaveProjectAsTemplateDialog.class);

    protected SaveProjectAsTemplateDialog(@NotNull Project project2, @Nullable VirtualFile descriptionFile) {
        if (project2 == null) {
            SaveProjectAsTemplateDialog.$$$reportNull$$$0(0);
        }
        super(project2);
        this.myProject = project2;
        this.$$$setupUI$$$();
        this.setTitle("Save Project As Template");
        this.myName.setText(project2.getName());
        Module[] modules = ModuleManager.getInstance(project2).getModules();
        if (modules.length < 2) {
            this.myModuleLabel.setVisible(false);
            this.myModuleCombo.setVisible(false);
        } else {
            ArrayList<String> items = new ArrayList<String>(ContainerUtil.map(modules, module2 -> module2.getName()));
            items.add(WHOLE_PROJECT);
            this.myModuleCombo.setModel(new CollectionComboBoxModel<String>((List<String>)items, WHOLE_PROJECT));
        }
        this.myDescription.setFileType(FileTypeManager.getInstance().getFileTypeByExtension("html"));
        if (descriptionFile != null) {
            try {
                String s = VfsUtilCore.loadText(descriptionFile);
                this.myDescription.setText(s);
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
        boolean showReplaceParameters = ProjectTemplateParameterFactory.EP_NAME.getExtensionList().size() > 0;
        this.myReplaceParameters.setVisible(showReplaceParameters);
        this.myReplaceParameters.setSelected(showReplaceParameters);
        this.init();
    }

    @Override
    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Override
    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myName;
    }

    @Override
    @Nullable
    protected String getDimensionServiceKey() {
        return "save.project.as.template.dialog";
    }

    @Override
    @Nullable
    protected ValidationInfo doValidate() {
        if (StringUtil.isEmpty(this.myName.getText())) {
            return new ValidationInfo("Template name should not be empty");
        }
        return null;
    }

    @Override
    protected void doOKAction() {
        Path file2 = this.getTemplateFile();
        if (PathKt.exists((Path)file2)) {
            if (Messages.showYesNoDialog(this.myPanel, FileUtilRt.getNameWithoutExtension(file2.getFileName().toString()) + " exists already.\nDo you want to replace it with the new one?", "Template Already Exists", Messages.getWarningIcon()) == 1) {
                return;
            }
            PathKt.delete((Path)file2);
        }
        super.doOKAction();
    }

    Path getTemplateFile() {
        String name = this.myName.getText();
        return ArchivedTemplatesFactory.getTemplateFile(name);
    }

    String getDescription() {
        return this.myDescription.getText();
    }

    boolean isReplaceParameters() {
        return this.myReplaceParameters.isSelected();
    }

    @Nullable
    Module getModuleToSave() {
        String item = (String)this.myModuleCombo.getSelectedItem();
        if (item == null || item.equals(WHOLE_PROJECT)) {
            return null;
        }
        return ModuleManager.getInstance(this.myProject).findModuleByName(item);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JLabel jLabel;
        JComboBox jComboBox;
        EditorTextField editorTextField;
        JTextField jTextField;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$(jBLabel, DynamicBundle.getBundle("messages/LangBundle", SaveProjectAsTemplateDialog.class).getString("label.project.as.template.name"));
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myName = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$(jBLabel2, DynamicBundle.getBundle("messages/LangBundle", SaveProjectAsTemplateDialog.class).getString("label.project.as.template.description"));
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 10, 0, 0, 0, null, null, null));
        this.myDescription = editorTextField = new EditorTextField();
        jPanel.add((Component)editorTextField, new GridConstraints(2, 1, 2, 1, 0, 3, 3, 3, null, new Dimension(-1, 60), null));
        this.myModuleCombo = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myModuleLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle("messages/LangBundle", SaveProjectAsTemplateDialog.class).getString("label.project.as.template.save"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myReplaceParameters = jBCheckBox = new JBCheckBox();
        jBCheckBox.setSelected(true);
        this.$$$loadButtonText$$$(jBCheckBox, DynamicBundle.getBundle("messages/LangBundle", SaveProjectAsTemplateDialog.class).getString("checkbox.replace.parameters.with.placeholders"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(4, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        jBLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/platform/templates/SaveProjectAsTemplateDialog", "<init>"));
    }
}

