/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.configurationStore.JbXmlOutputter;
import com.intellij.configurationStore.StoreUtilKt;
import com.intellij.ide.util.projectWizard.ProjectTemplateFileProcessor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.NamedComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.XmlSerializer;
import java.io.IOException;
import java.util.ArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

final class SystemFileProcessor
extends ProjectTemplateFileProcessor {
    private static final String[] COMPONENT_NAMES = new String[]{FileEditorManager.class.getName(), "org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent"};
    private static final Logger LOG = Logger.getInstance(SystemFileProcessor.class);

    SystemFileProcessor() {
    }

    @Override
    @Nullable
    protected String encodeFileText(String content2, VirtualFile file2, Project project2) throws IOException {
        String fileName = file2.getName();
        if (!file2.getParent().getName().equals(".idea") || !fileName.equals("workspace.xml")) {
            return null;
        }
        ArrayList componentList = new ArrayList();
        for (String componentName : COMPONENT_NAMES) {
            Object component2;
            Object object = component2 = componentName.equals("org.jetbrains.idea.maven.project.MavenWorkspaceSettingsComponent") ? project2.getPicoContainer().getComponentInstance(componentName) : project2.getComponent(componentName);
            if (component2 == null) {
                try {
                    Class<?> aClass = Class.forName(componentName);
                    component2 = project2.getComponent(aClass);
                    if (component2 == null) {
                        component2 = project2.getService(aClass);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            ContainerUtil.addIfNotNull(componentList, component2);
        }
        if (componentList.isEmpty()) {
            return null;
        }
        Element root = new Element("project");
        for (Object component3 : componentList) {
            Element element2 = new Element("component");
            element2.setAttribute("name", component3 instanceof NamedComponent ? ((NamedComponent)component3).getComponentName() : component3.getClass().getName());
            root.addContent(element2);
            ApplicationManager.getApplication().invokeAndWait(() -> {
                if (component3 instanceof JDOMExternalizable) {
                    try {
                        ((JDOMExternalizable)component3).writeExternal(element2);
                    }
                    catch (WriteExternalException ignore) {
                        LOG.error(ignore);
                    }
                } else if (component3 instanceof PersistentStateComponent) {
                    Object state = WriteAction.compute(() -> ((PersistentStateComponent)component3).getState());
                    if (state == null) {
                        return;
                    }
                    Element element1 = state instanceof Element ? (Element)state : XmlSerializer.serialize(state);
                    element2.addContent(element1.cloneContent());
                    element2.setAttribute("name", StoreUtilKt.getStateSpec((PersistentStateComponent)component3).name());
                }
            }, ModalityState.defaultModalityState());
        }
        return JbXmlOutputter.collapseMacrosAndWrite(root, project2);
    }
}

