/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.tree.events.impl;

import com.intellij.pom.tree.events.ChangeInfo;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeInfoImpl
implements ChangeInfo {
    @Nullable
    private final TreeElement myOldChild;
    @Nullable
    private final TreeElement myNewChild;
    private final int myOffset;
    private final int myOldLength;
    private final int myNewLength;

    ChangeInfoImpl(@Nullable TreeElement oldChild, @Nullable TreeElement newChild, int offset, int oldLength) {
        this.myOldChild = oldChild;
        this.myNewChild = newChild;
        this.myOffset = offset;
        this.myOldLength = oldLength;
        this.myNewLength = newChild != null ? newChild.getTextLength() : 0;
    }

    @Nullable
    public TreeElement getOldChild() {
        return this.myOldChild;
    }

    @Nullable
    public TreeElement getNewChild() {
        return this.myNewChild;
    }

    @Override
    public int getChangeType() {
        if (this.myOldChild == this.myNewChild) {
            return 3;
        }
        if (this.myOldChild != null) {
            return this.myNewChild == null ? 1 : 2;
        }
        return 0;
    }

    public String toString() {
        return this.myOldChild + "(" + this.myOldLength + ")->" + this.myNewChild + "(" + this.myNewLength + ") at " + this.myOffset;
    }

    int getLengthDelta() {
        return this.myNewLength - this.myOldLength;
    }

    TreeElement getAffectedChild() {
        return this.myNewChild != null ? this.myNewChild : this.myOldChild;
    }

    void fireEvent(int parentStart, PsiFile file2, CompositeElement parent) {
        PsiTreeChangeEventImpl e = ChangeInfoImpl.createEvent(file2, this.myOffset + parentStart);
        if (this.myOldChild == this.myNewChild && this.myNewChild != null) {
            ChangeInfoImpl.childrenChanged(e, this.myNewChild, this.myOldLength);
        } else if (this.myOldChild != null && this.myNewChild != null) {
            this.childReplaced(e, this.myOldChild, this.myNewChild, parent);
        } else if (this.myOldChild != null) {
            this.childRemoved(e, this.myOldChild, parent);
        } else if (this.myNewChild != null) {
            ChangeInfoImpl.childAdded(e, this.myNewChild, parent);
        }
    }

    @NotNull
    static PsiTreeChangeEventImpl createEvent(PsiFile file2, int offset) {
        PsiTreeChangeEventImpl e = new PsiTreeChangeEventImpl(file2.getManager());
        e.setFile(file2);
        e.setOffset(offset);
        PsiTreeChangeEventImpl psiTreeChangeEventImpl = e;
        if (psiTreeChangeEventImpl == null) {
            ChangeInfoImpl.$$$reportNull$$$0(0);
        }
        return psiTreeChangeEventImpl;
    }

    boolean hasNoPsi() {
        return this.myOldChild != null && this.myOldChild.getPsi() == null || this.myNewChild != null && this.myNewChild.getPsi() == null;
    }

    private static void childAdded(PsiTreeChangeEventImpl e, TreeElement child2, CompositeElement parent) {
        e.setParent(parent.getPsi());
        e.setChild(child2.getPsi());
        ChangeInfoImpl.getPsiManagerImpl(e).childAdded(e);
    }

    private void childRemoved(PsiTreeChangeEventImpl e, TreeElement child2, CompositeElement parent) {
        e.setParent(parent.getPsi());
        e.setChild(child2.getPsi());
        e.setOldLength(this.myOldLength);
        ChangeInfoImpl.getPsiManagerImpl(e).childRemoved(e);
    }

    private void childReplaced(PsiTreeChangeEventImpl e, TreeElement oldChild, TreeElement newChild, CompositeElement parent) {
        e.setParent(parent.getPsi());
        e.setOldChild(oldChild.getPsi());
        e.setChild(newChild.getPsi());
        e.setNewChild(newChild.getPsi());
        e.setOldLength(this.myOldLength);
        ChangeInfoImpl.getPsiManagerImpl(e).childReplaced(e);
    }

    static void childrenChanged(PsiTreeChangeEventImpl e, TreeElement parent, int oldLength) {
        e.setParent(parent.getPsi());
        e.setOldLength(oldLength);
        ChangeInfoImpl.getPsiManagerImpl(e).childrenChanged(e);
    }

    private static PsiManagerImpl getPsiManagerImpl(PsiTreeChangeEventImpl e) {
        return (PsiManagerImpl)e.getSource();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/pom/tree/events/impl/ChangeInfoImpl", "createEvent"));
    }
}

