/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.profile.codeInspection.ui.inspectionsTree.InspectionConfigTreeNode;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Queue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.TreePath;

public class InspectionsAggregationUtil {
    public static List<HighlightDisplayKey> getInspectionsKeys(InspectionConfigTreeNode node) {
        return ContainerUtil.map(InspectionsAggregationUtil.getInspectionsNodes(node), node1 -> node1.getKey());
    }

    public static List<InspectionConfigTreeNode.Tool> getInspectionsNodes(InspectionConfigTreeNode node) {
        Queue<InspectionConfigTreeNode> q = new Queue<InspectionConfigTreeNode>(1);
        q.addLast(node);
        return InspectionsAggregationUtil.getInspectionsNodes(q);
    }

    public static List<InspectionConfigTreeNode.Tool> getInspectionsNodes(TreePath[] paths) {
        if (paths == null) {
            return Collections.emptyList();
        }
        Queue<InspectionConfigTreeNode> q = new Queue<InspectionConfigTreeNode>(paths.length);
        for (TreePath path2 : paths) {
            if (path2 == null) continue;
            q.addLast((InspectionConfigTreeNode)path2.getLastPathComponent());
        }
        return InspectionsAggregationUtil.getInspectionsNodes(q);
    }

    private static List<InspectionConfigTreeNode.Tool> getInspectionsNodes(Queue<InspectionConfigTreeNode> queue) {
        ArrayList<InspectionConfigTreeNode.Tool> nodes = new ArrayList<InspectionConfigTreeNode.Tool>();
        while (!queue.isEmpty()) {
            InspectionConfigTreeNode node = queue.pullFirst();
            if (node instanceof InspectionConfigTreeNode.Group) {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    InspectionConfigTreeNode childNode = (InspectionConfigTreeNode)node.getChildAt(i);
                    queue.addLast(childNode);
                }
                continue;
            }
            nodes.add((InspectionConfigTreeNode.Tool)node);
        }
        return new ArrayList<InspectionConfigTreeNode.Tool>(nodes);
    }
}

