/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.scopeChooser.ScopeChooserConfigurable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.profile.codeInspection.ui.ScopeOrderComparator;
import com.intellij.psi.search.scope.NonProjectFilesScope;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopesOrderDialog
extends DialogWrapper {
    private final JList<String> myOptionsList;
    private final InspectionProfileImpl myInspectionProfile;
    @NotNull
    private final Project myProject;
    private final JPanel myPanel;
    private final MyModel myModel;

    ScopesOrderDialog(@NotNull Component parent, @NotNull InspectionProfileImpl inspectionProfile, final @NotNull Project project2) {
        if (parent == null) {
            ScopesOrderDialog.$$$reportNull$$$0(0);
        }
        if (inspectionProfile == null) {
            ScopesOrderDialog.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            ScopesOrderDialog.$$$reportNull$$$0(2);
        }
        super(parent, true);
        this.myOptionsList = new JBList<String>();
        this.myInspectionProfile = inspectionProfile;
        this.myProject = project2;
        this.myModel = new MyModel();
        this.reloadScopeList();
        this.myOptionsList.setModel(this.myModel);
        this.myOptionsList.setSelectedIndex(0);
        JPanel listPanel = ToolbarDecorator.createDecorator(this.myOptionsList).setMoveDownAction(new AnActionButtonRunnable(){

            @Override
            public void run(AnActionButton anActionButton) {
                ListUtil.moveSelectedItemsDown(ScopesOrderDialog.this.myOptionsList);
            }
        }).setMoveUpAction(new AnActionButtonRunnable(){

            @Override
            public void run(AnActionButton anActionButton) {
                ListUtil.moveSelectedItemsUp(ScopesOrderDialog.this.myOptionsList);
            }
        }).addExtraAction(new AnActionButton(CodeInsightBundle.messagePointer("action.AnActionButton.text.edit.scopes", new Object[0]), AllIcons.Actions.Edit){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ShowSettingsUtil.getInstance().editConfigurable(project2, (Configurable)new ScopeChooserConfigurable(project2));
                ScopesOrderDialog.this.reloadScopeList();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/profile/codeInspection/ui/ScopesOrderDialog$1", "actionPerformed"));
            }
        }).disableRemoveAction().disableAddAction().createPanel();
        JLabel descr = new JLabel(AnalysisBundle.message("inspections.settings.scopes.order.help.label", new Object[0]));
        UIUtil.applyStyle(UIUtil.ComponentStyle.SMALL, descr);
        this.myPanel = new JPanel();
        this.myPanel.setLayout(new BorderLayout());
        this.myPanel.add((Component)listPanel, "Center");
        this.myPanel.add((Component)descr, "South");
        this.init();
        this.setTitle(AnalysisBundle.message("inspections.settings.scopes.order.title", new Object[0]));
    }

    private void reloadScopeList() {
        this.myModel.removeAllElements();
        ArrayList<String> scopes = new ArrayList<String>();
        for (NamedScopesHolder holder : NamedScopesHolder.getAllNamedScopeHolders(this.myProject)) {
            for (NamedScope scope : holder.getScopes()) {
                if (scope instanceof NonProjectFilesScope) continue;
                scopes.add(scope.getName());
            }
        }
        scopes.remove(CustomScopesProviderEx.getAllScope().getName());
        Collections.sort(scopes, new ScopeOrderComparator(this.myInspectionProfile));
        for (String scopeName : scopes) {
            this.myModel.addElement(scopeName);
        }
    }

    @Override
    @Nullable
    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Override
    protected void doOKAction() {
        int size = this.myOptionsList.getModel().getSize();
        Object[] newScopeOrder = new String[size];
        for (int i = 0; i < size; ++i) {
            String scopeName = this.myOptionsList.getModel().getElementAt(i);
            newScopeOrder[i] = scopeName;
        }
        if (!Arrays.equals(newScopeOrder, this.myInspectionProfile.getScopesOrder())) {
            this.myInspectionProfile.setScopesOrder((String[])newScopeOrder);
        }
        super.doOKAction();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "inspectionProfile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/intellij/profile/codeInspection/ui/ScopesOrderDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyModel
    extends DefaultListModel<String>
    implements EditableModel {
        private MyModel() {
        }

        @Override
        public void addRow() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void exchangeRows(int oldIndex, int newIndex) {
            String scope1 = (String)this.getElementAt(newIndex);
            this.set(newIndex, this.getElementAt(oldIndex));
            this.set(oldIndex, scope1);
        }

        @Override
        public boolean canExchangeRows(int oldIndex, int newIndex) {
            return true;
        }

        @Override
        public void removeRow(int idx) {
            throw new UnsupportedOperationException();
        }
    }
}

