/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.inspectionsTree;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class ScopesAndSeveritiesHintTable
extends JBTable {
    private static final int SCOPE_COLUMN = 0;
    private static final int SEVERITY_COLUMN = 1;

    public ScopesAndSeveritiesHintTable(LinkedHashMap<String, HighlightDisplayLevel> scopeToAverageSeverityMap, String defaultScopeName) {
        super(new MyModel(scopeToAverageSeverityMap, defaultScopeName));
        this.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
                this.setOpaque(false);
                UIUtil.applyStyle(UIUtil.ComponentStyle.SMALL, this);
                return this;
            }
        });
        this.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value2, isSelected, hasFocus, row, column);
                HighlightDisplayLevel level = (HighlightDisplayLevel)value2;
                this.setIcon(level.getIcon());
                this.setText(SingleInspectionProfilePanel.renderSeverity(level.getSeverity()));
                this.setOpaque(false);
                UIUtil.applyStyle(UIUtil.ComponentStyle.SMALL, this);
                return this;
            }
        });
        this.setShowGrid(false);
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.setOpaque(false);
        for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
            int w = 0;
            TableColumn column = this.getColumnModel().getColumn(i);
            for (int j = 0; j < this.getModel().getRowCount(); ++j) {
                Component component2 = this.prepareRenderer(column.getCellRenderer(), j, i);
                w = Math.max(component2.getPreferredSize().width, w);
            }
            column.setPreferredWidth(w + 1);
        }
    }

    private static final class MyModel
    extends AbstractTableModel {
        private final LinkedHashMap<String, HighlightDisplayLevel> myScopeToAverageSeverityMap;
        private final String myDefaultScopeName;
        private final List<String> myScopes;

        MyModel(LinkedHashMap<String, HighlightDisplayLevel> scopeToAverageSeverityMap, String defaultScopeName) {
            this.myScopeToAverageSeverityMap = scopeToAverageSeverityMap;
            this.myDefaultScopeName = defaultScopeName;
            this.myScopes = new ArrayList<String>(this.myScopeToAverageSeverityMap.keySet());
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return HighlightDisplayLevel.class;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public int getRowCount() {
            return this.myScopes.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String scopeName = this.myScopes.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return this.myDefaultScopeName.equals(scopeName) ? "Everywhere else" : scopeName;
                }
                case 1: {
                    return this.myScopeToAverageSeverityMap.get(scopeName);
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

