/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.projectImport;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectOpenProcessor {
    public static final ExtensionPointName<ProjectOpenProcessor> EXTENSION_POINT_NAME = new ExtensionPointName("com.intellij.projectOpenProcessor");

    @NotNull
    @Nls
    public abstract String getName();

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @Nullable
    public Icon getIcon(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectOpenProcessor.$$$reportNull$$$0(0);
        }
        return this.getIcon();
    }

    public abstract boolean canOpenProject(@NotNull VirtualFile var1);

    public boolean isProjectFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectOpenProcessor.$$$reportNull$$$0(1);
        }
        return this.canOpenProject(file2);
    }

    @Nullable
    public abstract Project doOpenProject(@NotNull VirtualFile var1, @Nullable Project var2, boolean var3);

    public boolean lookForProjectsInDirectory() {
        return true;
    }

    public boolean canImportProjectAfterwards() {
        return false;
    }

    public void importProjectAfterwards(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            ProjectOpenProcessor.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            ProjectOpenProcessor.$$$reportNull$$$0(3);
        }
    }

    @Nullable
    public static ProjectOpenProcessor getImportProvider(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectOpenProcessor.$$$reportNull$$$0(4);
        }
        return ProjectOpenProcessor.getImportProvider(file2, false);
    }

    @Nullable
    public static ProjectOpenProcessor getImportProvider(@NotNull VirtualFile file2, boolean onlyIfExistingProjectFile) {
        if (file2 == null) {
            ProjectOpenProcessor.$$$reportNull$$$0(5);
        }
        return EXTENSION_POINT_NAME.findFirstSafe(provider -> provider.canOpenProject(file2) && (!onlyIfExistingProjectFile || provider.isProjectFile(file2)));
    }

    @NotNull
    public static List<ProjectOpenProcessor> getOpenProcessors(@NotNull VirtualFile file2, boolean onlyIfExistingProjectFile) {
        if (file2 == null) {
            ProjectOpenProcessor.$$$reportNull$$$0(6);
        }
        List<ProjectOpenProcessor> list2 = ContainerUtil.filter(EXTENSION_POINT_NAME.getExtensionList(), provider -> provider.canOpenProject(file2) && (!onlyIfExistingProjectFile || provider.isProjectFile(file2)));
        if (list2 == null) {
            ProjectOpenProcessor.$$$reportNull$$$0(7);
        }
        return list2;
    }

    public boolean isStrongProjectInfoHolder() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/projectImport/ProjectOpenProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/projectImport/ProjectOpenProcessor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpenProcessors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isProjectFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importProjectAfterwards";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getImportProvider";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getOpenProcessors";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

