/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.projectView;

import com.intellij.ide.projectView.ProjectViewSettings;
import com.intellij.ide.projectView.impl.AbstractProjectTreeStructure;
import com.intellij.ide.projectView.impl.AbstractProjectViewPSIPane;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.projectView.TestProjectViewPSIPane;
import com.intellij.psi.PsiElement;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.ProjectViewTestUtil;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class TestProjectTreeStructure
extends AbstractProjectTreeStructure
implements Disposable,
ProjectViewSettings {
    private boolean myShowExcludedFiles;
    protected boolean myShowMembers;
    protected boolean myHideEmptyMiddlePackages;
    protected boolean myFlattenPackages;
    private boolean myFlattenModules;
    protected boolean myShowLibraryContents;

    public TestProjectTreeStructure(@NotNull Project project2, Disposable parentDisposable) {
        if (project2 == null) {
            TestProjectTreeStructure.$$$reportNull$$$0(0);
        }
        super(project2);
        this.myShowExcludedFiles = true;
        this.myShowMembers = false;
        this.myShowLibraryContents = true;
        Disposer.register(parentDisposable, this);
    }

    public void checkNavigateFromSourceBehaviour(PsiElement element2, VirtualFile virtualFile2, AbstractProjectViewPSIPane pane2) {
        Assert.assertNull((Object)ProjectViewTestUtil.getNodeForElement(element2, pane2));
        pane2.select(element2, virtualFile2, true);
        PlatformTestUtil.waitWhileBusy(pane2.getTree());
        Assert.assertTrue((boolean)ProjectViewTestUtil.isExpanded(element2, pane2));
    }

    public AbstractProjectViewPSIPane createPane() {
        TestProjectViewPSIPane pane2 = new TestProjectViewPSIPane(this.myProject, this, 9);
        pane2.createComponent();
        Disposer.register(this, pane2);
        PlatformTestUtil.waitWhileBusy(pane2.getTree());
        return pane2;
    }

    @Override
    public boolean isShowMembers() {
        return this.myShowMembers;
    }

    @Override
    public boolean isFlattenPackages() {
        return this.myFlattenPackages;
    }

    @Override
    public boolean isHideEmptyMiddlePackages() {
        return this.myHideEmptyMiddlePackages;
    }

    @Override
    public boolean isShowLibraryContents() {
        return this.myShowLibraryContents;
    }

    @Override
    public boolean isShowExcludedFiles() {
        return this.myShowExcludedFiles;
    }

    public void setShowMembers(boolean showMembers) {
        this.myShowMembers = showMembers;
    }

    @Override
    public boolean isFlattenModules() {
        return this.myFlattenModules;
    }

    public void setFlattenModules(boolean flattenModules) {
        this.myFlattenModules = flattenModules;
    }

    public void setHideEmptyMiddlePackages(boolean hideEmptyMiddlePackages) {
        this.myHideEmptyMiddlePackages = hideEmptyMiddlePackages;
    }

    public void setFlattenPackages(boolean flattenPackages) {
        this.myFlattenPackages = flattenPackages;
    }

    public void hideExcludedFiles() {
        this.myShowExcludedFiles = false;
    }

    public void setShowLibraryContents(boolean showLibraryContents) {
        this.myShowLibraryContents = showLibraryContents;
    }

    @Override
    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/projectView/TestProjectTreeStructure", "<init>"));
    }
}

