/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiMethodReferenceUtil {
    private static final Logger LOG = Logger.getInstance(PsiMethodReferenceUtil.class);

    public static boolean isSecondSearchPossible(PsiType[] parameterTypes, QualifierResolveResult qualifierResolveResult, PsiMethodReferenceExpression methodRef) {
        return parameterTypes.length > 0 && !(parameterTypes[0] instanceof PsiPrimitiveType) && !methodRef.isConstructor() && PsiMethodReferenceUtil.isStaticallyReferenced(methodRef) && PsiMethodReferenceUtil.isReceiverType(parameterTypes[0], qualifierResolveResult.getContainingClass(), qualifierResolveResult.getSubstitutor());
    }

    public static boolean isResolvedBySecondSearch(@NotNull PsiMethodReferenceExpression methodRef) {
        PsiElement resolve2;
        if (methodRef == null) {
            PsiMethodReferenceUtil.$$$reportNull$$$0(0);
        }
        if ((resolve2 = methodRef.resolve()) instanceof PsiMethod) {
            PsiMethod method2 = (PsiMethod)resolve2;
            PsiType functionalInterfaceType = methodRef.getFunctionalInterfaceType();
            PsiClassType.ClassResolveResult functionalResolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(functionalResolveResult);
            return interfaceMethod != null && PsiMethodReferenceUtil.isResolvedBySecondSearch(methodRef, interfaceMethod.getSignature(LambdaUtil.getSubstitutor(interfaceMethod, functionalResolveResult)), method2.isVarArgs(), method2.hasModifierProperty("static"), method2.getParameterList().getParametersCount());
        }
        return false;
    }

    public static boolean isResolvedBySecondSearch(@NotNull PsiMethodReferenceExpression methodRef, @Nullable MethodSignature signature, boolean varArgs, boolean isStatic, int parametersCount) {
        if (methodRef == null) {
            PsiMethodReferenceUtil.$$$reportNull$$$0(1);
        }
        if (signature == null) {
            return false;
        }
        QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult(methodRef);
        PsiType[] functionalMethodParameterTypes = signature.getParameterTypes();
        return (parametersCount + 1 == functionalMethodParameterTypes.length && !varArgs || varArgs && functionalMethodParameterTypes.length > 0 && !isStatic) && PsiMethodReferenceUtil.isSecondSearchPossible(functionalMethodParameterTypes, qualifierResolveResult, methodRef);
    }

    @Nullable
    public static PsiType getQualifierType(PsiMethodReferenceExpression expression) {
        PsiTypeElement typeElement = expression.getQualifierType();
        if (typeElement != null) {
            return typeElement.getType();
        }
        PsiType qualifierType = null;
        PsiElement qualifier = expression.getQualifier();
        if (qualifier instanceof PsiExpression) {
            qualifierType = ((PsiExpression)qualifier).getType();
        }
        if (qualifierType == null && qualifier instanceof PsiReferenceExpression) {
            return JavaPsiFacade.getElementFactory(expression.getProject()).createType((PsiReferenceExpression)qualifier);
        }
        return qualifierType;
    }

    public static boolean isReturnTypeCompatible(PsiMethodReferenceExpression expression, JavaResolveResult result2, PsiType functionalInterfaceType) {
        return PsiMethodReferenceUtil.isReturnTypeCompatible(expression, result2, functionalInterfaceType, null);
    }

    public static PsiType getMethodReferenceReturnType(PsiMethodReferenceExpression expression) {
        return PsiMethodReferenceUtil.getMethodReferenceReturnType(expression, expression.advancedResolve(false));
    }

    private static PsiType getMethodReferenceReturnType(PsiMethodReferenceExpression expression, JavaResolveResult result2) {
        PsiSubstitutor subst = result2.getSubstitutor();
        PsiType methodReturnType = null;
        PsiClass containingClass = null;
        PsiElement resolve2 = result2.getElement();
        if (resolve2 instanceof PsiMethod) {
            containingClass = ((PsiMethod)resolve2).getContainingClass();
            methodReturnType = PsiTypesUtil.patchMethodGetClassReturnType(expression, (PsiMethod)resolve2);
            if (methodReturnType == null) {
                methodReturnType = ((PsiMethod)resolve2).getReturnType();
                if (PsiType.VOID.equals(methodReturnType)) {
                    return methodReturnType;
                }
                methodReturnType = subst.substitute(methodReturnType);
            }
        } else if (resolve2 instanceof PsiClass) {
            PsiTypeParameter[] typeParameters;
            if (PsiUtil.isArrayClass(resolve2) && (typeParameters = ((PsiClass)resolve2).getTypeParameters()).length == 1) {
                PsiType arrayComponentType = subst.substitute(typeParameters[0]);
                if (arrayComponentType == null) {
                    return null;
                }
                methodReturnType = arrayComponentType.createArrayType();
            }
            containingClass = (PsiClass)resolve2;
        }
        if (methodReturnType == null) {
            if (containingClass == null) {
                return null;
            }
            methodReturnType = JavaPsiFacade.getElementFactory(expression.getProject()).createType(containingClass, subst);
        }
        return PsiUtil.captureToplevelWildcards(methodReturnType, expression);
    }

    private static boolean isReturnTypeCompatible(PsiMethodReferenceExpression expression, JavaResolveResult result2, PsiType functionalInterfaceType, Ref<? super String> errorMessage) {
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
        if (interfaceMethod != null) {
            PsiType interfaceReturnType = LambdaUtil.getFunctionalInterfaceReturnType(functionalInterfaceType);
            if (PsiType.VOID.equals(interfaceReturnType) || interfaceReturnType == null) {
                return true;
            }
            PsiType methodReturnType = PsiMethodReferenceUtil.getMethodReferenceReturnType(expression, result2);
            if (methodReturnType == null) {
                return false;
            }
            if (TypeConversionUtil.isAssignable(interfaceReturnType, methodReturnType)) {
                return true;
            }
            if (errorMessage != null) {
                errorMessage.set("Bad return type in method reference: cannot convert " + methodReturnType.getCanonicalText() + " to " + interfaceReturnType.getCanonicalText());
            }
        }
        return false;
    }

    public static boolean isValidQualifier(PsiMethodReferenceExpression expression) {
        PsiElement referenceNameElement = expression.getReferenceNameElement();
        if (referenceNameElement instanceof PsiKeyword) {
            PsiElement qualifier = expression.getQualifier();
            if (qualifier instanceof PsiTypeElement) {
                return true;
            }
            if (qualifier instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifier).resolve() instanceof PsiClass) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static QualifierResolveResult getQualifierResolveResult(@NotNull PsiMethodReferenceExpression methodReferenceExpression) {
        if (methodReferenceExpression == null) {
            PsiMethodReferenceUtil.$$$reportNull$$$0(2);
        }
        PsiClass containingClass = null;
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        PsiExpression expression = methodReferenceExpression.getQualifierExpression();
        if (expression != null) {
            JavaResolveResult resolveResult;
            PsiElement resolve2;
            PsiType expressionType = expression.getType();
            expressionType = expressionType instanceof PsiCapturedWildcardType ? ((PsiCapturedWildcardType)expressionType).getUpperBound() : PsiMethodReferenceUtil.replaceArrayType(expressionType, expression);
            PsiClassType.ClassResolveResult result2 = PsiUtil.resolveGenericsClassInType(expressionType);
            containingClass = result2.getElement();
            if (containingClass != null) {
                substitutor = result2.getSubstitutor();
            }
            if (containingClass == null && expression instanceof PsiReferenceExpression && (resolve2 = (resolveResult = ((PsiReferenceExpression)expression).advancedResolve(false)).getElement()) instanceof PsiClass) {
                containingClass = (PsiClass)resolve2;
                substitutor = resolveResult.getSubstitutor();
                return new QualifierResolveResult(containingClass, substitutor, true);
            }
        } else {
            PsiType type;
            PsiClassType.ClassResolveResult result3;
            PsiTypeElement typeElement = methodReferenceExpression.getQualifierType();
            if (typeElement != null && (containingClass = (result3 = PsiUtil.resolveGenericsClassInType(type = PsiMethodReferenceUtil.replaceArrayType(typeElement.getType(), typeElement))).getElement()) != null) {
                return new QualifierResolveResult(containingClass, result3.getSubstitutor(), true);
            }
        }
        return new QualifierResolveResult(containingClass, substitutor, false);
    }

    public static boolean isStaticallyReferenced(@NotNull PsiMethodReferenceExpression methodReferenceExpression) {
        PsiExpression qualifierExpression;
        if (methodReferenceExpression == null) {
            PsiMethodReferenceUtil.$$$reportNull$$$0(3);
        }
        if ((qualifierExpression = methodReferenceExpression.getQualifierExpression()) != null) {
            return qualifierExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifierExpression).resolve() instanceof PsiClass;
        }
        return true;
    }

    public static boolean isReceiverType(@Nullable PsiType receiverType, PsiClass containingClass, PsiSubstitutor psiSubstitutor) {
        if (receiverType == null) {
            return false;
        }
        return TypeConversionUtil.isAssignable(JavaPsiFacade.getElementFactory(containingClass.getProject()).createType(containingClass, psiSubstitutor), PsiMethodReferenceUtil.replaceArrayType(receiverType, containingClass));
    }

    public static PsiType getFirstParameterType(PsiType functionalInterfaceType, PsiElement context) {
        int interfaceMethodParamsLength;
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        MethodSignature function = LambdaUtil.getFunction(resolveResult.getElement());
        if (function != null && (interfaceMethodParamsLength = function.getParameterTypes().length) > 0) {
            PsiType type = resolveResult.getSubstitutor().substitute(function.getParameterTypes()[0]);
            return type != null ? PsiUtil.captureToplevelWildcards(type, context) : null;
        }
        return null;
    }

    private static PsiType replaceArrayType(PsiType type, @NotNull PsiElement context) {
        if (context == null) {
            PsiMethodReferenceUtil.$$$reportNull$$$0(4);
        }
        if (type instanceof PsiArrayType) {
            type = JavaPsiFacade.getElementFactory(context.getProject()).getArrayClassType(((PsiArrayType)type).getComponentType(), PsiUtil.getLanguageLevel(context));
        }
        return type;
    }

    public static String checkMethodReferenceContext(PsiMethodReferenceExpression methodRef) {
        PsiElement resolve2 = methodRef.resolve();
        if (resolve2 == null) {
            return null;
        }
        return PsiMethodReferenceUtil.checkMethodReferenceContext(methodRef, resolve2, methodRef.getFunctionalInterfaceType());
    }

    public static String checkMethodReferenceContext(PsiMethodReferenceExpression methodRef, PsiElement resolve2, PsiType functionalInterfaceType) {
        PsiClass outerClass;
        PsiReferenceParameterList parameterList;
        PsiJavaCodeReferenceElement referenceElement;
        PsiClass containingClass = resolve2 instanceof PsiMethod ? ((PsiMethod)resolve2).getContainingClass() : (PsiClass)resolve2;
        boolean isStaticSelector = PsiMethodReferenceUtil.isStaticallyReferenced(methodRef);
        PsiElement qualifier = methodRef.getQualifier();
        boolean isMethodStatic = false;
        boolean receiverReferenced = false;
        boolean isConstructor = true;
        if (resolve2 instanceof PsiMethod) {
            PsiMethod method2 = (PsiMethod)resolve2;
            isMethodStatic = method2.hasModifierProperty("static");
            isConstructor = method2.isConstructor();
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(resolveResult);
            receiverReferenced = PsiMethodReferenceUtil.isResolvedBySecondSearch(methodRef, interfaceMethod != null ? interfaceMethod.getSignature(LambdaUtil.getSubstitutor(interfaceMethod, resolveResult)) : null, method2.isVarArgs(), isMethodStatic, method2.getParameterList().getParametersCount());
            if (method2.hasModifierProperty("abstract") && qualifier instanceof PsiSuperExpression) {
                return "Abstract method '" + method2.getName() + "' cannot be accessed directly";
            }
        }
        if (!receiverReferenced) {
            if (isStaticSelector && !isMethodStatic && !isConstructor) {
                return "Non-static method cannot be referenced from a static context";
            }
            if (!isStaticSelector && isMethodStatic) {
                return "Static method referenced through non-static qualifier";
            }
        } else if (isStaticSelector && isMethodStatic) {
            return "Static method referenced through receiver";
        }
        if (isMethodStatic && isStaticSelector && qualifier instanceof PsiTypeElement && (referenceElement = PsiTreeUtil.getChildOfType(qualifier, PsiJavaCodeReferenceElement.class)) != null && (parameterList = referenceElement.getParameterList()) != null && parameterList.getTypeArguments().length > 0) {
            return "Parameterized qualifier on static method reference";
        }
        if (isConstructor && containingClass != null && PsiUtil.isInnerClass(containingClass) && containingClass.isPhysical() && (outerClass = containingClass.getContainingClass()) != null && !InheritanceUtil.hasEnclosingInstanceInScope(outerClass, (PsiElement)methodRef, true, false)) {
            return "An enclosing instance of type " + PsiFormatUtil.formatClass(outerClass, 1) + " is not in scope";
        }
        return null;
    }

    public static String checkTypeArguments(PsiTypeElement qualifier, PsiType psiType) {
        PsiJavaCodeReferenceElement referenceElement;
        if (psiType instanceof PsiClassType && (referenceElement = qualifier.getInnermostComponentReferenceElement()) != null) {
            PsiType[] typeParameters;
            for (PsiType typeParameter : typeParameters = referenceElement.getTypeParameters()) {
                if (!(typeParameter instanceof PsiWildcardType)) continue;
                return "Unexpected wildcard";
            }
        }
        return null;
    }

    public static String checkReturnType(PsiMethodReferenceExpression expression, JavaResolveResult result2, PsiType functionalInterfaceType) {
        Ref errorMessage = Ref.create();
        if (!PsiMethodReferenceUtil.isReturnTypeCompatible(expression, result2, functionalInterfaceType, errorMessage)) {
            return (String)errorMessage.get();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodRef";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodReferenceExpression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/PsiMethodReferenceUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isResolvedBySecondSearch";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getQualifierResolveResult";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isStaticallyReferenced";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceArrayType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class QualifierResolveResult {
        private final PsiClass myContainingClass;
        private final PsiSubstitutor mySubstitutor;
        private final boolean myReferenceTypeQualified;

        public QualifierResolveResult(PsiClass containingClass, PsiSubstitutor substitutor, boolean referenceTypeQualified) {
            this.myContainingClass = containingClass;
            this.mySubstitutor = substitutor;
            this.myReferenceTypeQualified = referenceTypeQualified;
        }

        @Nullable
        public PsiClass getContainingClass() {
            return this.myContainingClass;
        }

        public PsiSubstitutor getSubstitutor() {
            return this.mySubstitutor;
        }

        public boolean isReferenceTypeQualified() {
            return this.myReferenceTypeQualified;
        }
    }
}

