/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionException;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CommonCodeStyleSettingsManager {
    private volatile Map<Language, CommonCodeStyleSettings> myCommonSettingsMap;
    private volatile Map<String, Content> myUnknownSettingsMap;
    @NotNull
    private final CodeStyleSettings myParentSettings;
    @NonNls
    static final String COMMON_SETTINGS_TAG = "codeStyleSettings";
    private static final String LANGUAGE_ATTR = "language";
    private static final Logger LOG = Logger.getInstance(CommonCodeStyleSettingsManager.class);

    CommonCodeStyleSettingsManager(@NotNull CodeStyleSettings parentSettings) {
        if (parentSettings == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(0);
        }
        this.myParentSettings = parentSettings;
    }

    @Nullable
    CommonCodeStyleSettings getCommonSettings(@Nullable Language lang2) {
        Map<Language, CommonCodeStyleSettings> commonSettingsMap = this.getCommonSettingsMap();
        for (Language baseLang = ObjectUtils.notNull(lang2, Language.ANY); baseLang != null; baseLang = baseLang.getBaseLanguage()) {
            CommonCodeStyleSettings settings = commonSettingsMap.get(baseLang);
            if (settings == null) continue;
            return settings;
        }
        return null;
    }

    CommonCodeStyleSettings getDefaults() {
        return DefaultsHolder.SETTINGS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private Map<Language, CommonCodeStyleSettings> getCommonSettingsMap() {
        Map<Language, CommonCodeStyleSettings> commonSettingsMap = this.myCommonSettingsMap;
        if (commonSettingsMap == null) {
            CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = this;
            synchronized (commonCodeStyleSettingsManager) {
                commonSettingsMap = this.myCommonSettingsMap;
                if (commonSettingsMap == null) {
                    commonSettingsMap = this.initCommonSettingsMap();
                    this.initNonReadSettings();
                }
            }
        }
        Map<Language, CommonCodeStyleSettings> map2 = commonSettingsMap;
        if (map2 == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(1);
        }
        return map2;
    }

    @NotNull
    public CommonCodeStyleSettings getCommonSettings(@NotNull String langName) {
        if (langName == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(2);
        }
        Map<Language, CommonCodeStyleSettings> map2 = this.getCommonSettingsMap();
        for (Map.Entry<Language, CommonCodeStyleSettings> entry : map2.entrySet()) {
            if (!langName.equals(entry.getKey().getDisplayName())) continue;
            CommonCodeStyleSettings commonCodeStyleSettings = entry.getValue();
            if (commonCodeStyleSettings == null) {
                CommonCodeStyleSettingsManager.$$$reportNull$$$0(3);
            }
            return commonCodeStyleSettings;
        }
        return new CommonCodeStyleSettings(Language.ANY);
    }

    private void initNonReadSettings() {
        for (LanguageCodeStyleSettingsProvider provider : LanguageCodeStyleSettingsProvider.EP_NAME.getExtensionList()) {
            CommonCodeStyleSettings initialSettings;
            Language target2 = provider.getLanguage();
            if (this.myCommonSettingsMap.containsKey(target2) || (initialSettings = CommonCodeStyleSettingsManager.safelyGetDefaults(provider)) == null) continue;
            this.init(initialSettings, target2);
        }
    }

    private void init(@NotNull CommonCodeStyleSettings initialSettings, @NotNull Language target2) {
        if (initialSettings == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(4);
        }
        if (target2 == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(5);
        }
        initialSettings.setRootSettings(this.myParentSettings);
        this.registerCommonSettings(target2, initialSettings);
    }

    private Map<Language, CommonCodeStyleSettings> initCommonSettingsMap() {
        LinkedHashMap<Language, CommonCodeStyleSettings> map2 = new LinkedHashMap<Language, CommonCodeStyleSettings>();
        this.myCommonSettingsMap = map2;
        this.myUnknownSettingsMap = new LinkedHashMap<String, Content>();
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCommonSettings(@NotNull Language lang2, @NotNull CommonCodeStyleSettings settings) {
        if (lang2 == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(6);
        }
        if (settings == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(7);
        }
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = this;
        synchronized (commonCodeStyleSettingsManager) {
            if (!this.myCommonSettingsMap.containsKey(lang2)) {
                this.myCommonSettingsMap.put(lang2, settings);
                settings.getRootSettings();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public CommonCodeStyleSettingsManager clone(@NotNull CodeStyleSettings parentSettings) {
        if (parentSettings == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(8);
        }
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager2 = this;
        // MONITORENTER : commonCodeStyleSettingsManager2
        CommonCodeStyleSettingsManager settingsManager = new CommonCodeStyleSettingsManager(parentSettings);
        if (this.myCommonSettingsMap != null && !this.myCommonSettingsMap.isEmpty()) {
            settingsManager.initCommonSettingsMap();
            for (Map.Entry<Language, CommonCodeStyleSettings> entry : this.myCommonSettingsMap.entrySet()) {
                CommonCodeStyleSettings clonedSettings = entry.getValue().clone(parentSettings);
                settingsManager.registerCommonSettings(entry.getKey(), clonedSettings);
            }
            settingsManager.myUnknownSettingsMap.putAll(this.myUnknownSettingsMap);
        }
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = settingsManager;
        // MONITOREXIT : commonCodeStyleSettingsManager2
        if (commonCodeStyleSettingsManager != null) return commonCodeStyleSettingsManager;
        CommonCodeStyleSettingsManager.$$$reportNull$$$0(9);
        return commonCodeStyleSettingsManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readExternal(@NotNull Element element2) throws InvalidDataException {
        if (element2 == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(10);
        }
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = this;
        synchronized (commonCodeStyleSettingsManager) {
            this.initCommonSettingsMap();
            for (Element commonSettingsElement : element2.getChildren(COMMON_SETTINGS_TAG)) {
                boolean isKnownLanguage;
                String languageId = commonSettingsElement.getAttributeValue(LANGUAGE_ATTR);
                if (StringUtil.isEmpty(languageId)) continue;
                Language target2 = Language.findLanguageByID(languageId);
                boolean bl = isKnownLanguage = target2 != null;
                if (isKnownLanguage) {
                    LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage(target2);
                    if (provider != null) {
                        CommonCodeStyleSettings settings = CommonCodeStyleSettingsManager.safelyGetDefaults(provider);
                        if (settings != null) {
                            settings.readExternal(commonSettingsElement);
                            this.init(settings, target2);
                        }
                    } else {
                        isKnownLanguage = false;
                    }
                }
                if (isKnownLanguage) continue;
                this.myUnknownSettingsMap.put(languageId, JDOMUtil.internElement(commonSettingsElement));
            }
            this.initNonReadSettings();
        }
    }

    private static CommonCodeStyleSettings safelyGetDefaults(LanguageCodeStyleSettingsProvider provider) {
        Ref defaultSettingsRef = RecursionManager.doPreventingRecursion(provider, true, () -> Ref.create(provider.getDefaultCommonSettings()));
        if (defaultSettingsRef == null) {
            LOG.error(new ExtensionException(provider.getClass(), new Throwable(provider.getClass().getCanonicalName() + ".getDefaultCommonSettings() recursively creates root settings.")));
            return null;
        }
        CommonCodeStyleSettings defaultSettings = (CommonCodeStyleSettings)defaultSettingsRef.get();
        if (defaultSettings instanceof CodeStyleSettings) {
            LOG.error(new ExtensionException(provider.getClass(), new Throwable(provider.getClass().getName() + ".getDefaultCommonSettings() creates root CodeStyleSettings instead of CommonCodeStyleSettings")));
        }
        return defaultSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(@NotNull Element element2) throws WriteExternalException {
        if (element2 == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(11);
        }
        CommonCodeStyleSettingsManager commonCodeStyleSettingsManager = this;
        synchronized (commonCodeStyleSettingsManager) {
            if (this.myCommonSettingsMap == null) {
                return;
            }
            THashMap<String, Language> idToLang = new THashMap<String, Language>();
            for (Language language2 : this.myCommonSettingsMap.keySet()) {
                idToLang.put(language2.getID(), language2);
            }
            Object[] languages = ArrayUtilRt.toStringArray(ContainerUtil.union(this.myUnknownSettingsMap.keySet(), idToLang.keySet()));
            Arrays.sort(languages);
            for (Object id2 : languages) {
                Language language3 = (Language)idToLang.get(id2);
                if (language3 != null) {
                    CommonCodeStyleSettings commonSettings = this.myCommonSettingsMap.get(language3);
                    Element commonSettingsElement = new Element(COMMON_SETTINGS_TAG);
                    commonSettings.writeExternal(commonSettingsElement);
                    commonSettingsElement.setAttribute(LANGUAGE_ATTR, language3.getID());
                    if (commonSettingsElement.getChildren().isEmpty()) continue;
                    element2.addContent(commonSettingsElement);
                    continue;
                }
                Content unknown = this.myUnknownSettingsMap.get(id2);
                if (unknown == null) continue;
                element2.addContent(unknown.clone());
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof CommonCodeStyleSettingsManager) {
            CommonCodeStyleSettingsManager other = (CommonCodeStyleSettingsManager)obj;
            if (this.getCommonSettingsMap().size() != other.getCommonSettingsMap().size() || this.myUnknownSettingsMap.size() != other.myUnknownSettingsMap.size()) {
                return false;
            }
            for (Language language2 : this.myCommonSettingsMap.keySet()) {
                CommonCodeStyleSettings otherSettings;
                CommonCodeStyleSettings theseSettings = this.myCommonSettingsMap.get(language2);
                if (theseSettings.equals(otherSettings = other.getCommonSettings(language2))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    void removeLanguageSettings(@NotNull Language language2) {
        if (language2 == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(12);
        }
        this.getCommonSettingsMap().remove(language2);
    }

    void addLanguageSettings(@NotNull Language language2, @NotNull CommonCodeStyleSettings settings) {
        if (language2 == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(13);
        }
        if (settings == null) {
            CommonCodeStyleSettingsManager.$$$reportNull$$$0(14);
        }
        this.getCommonSettingsMap().put(language2, settings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentSettings";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/CommonCodeStyleSettingsManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "langName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lang";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = LANGUAGE_ATTR;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/CommonCodeStyleSettingsManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonSettingsMap";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonSettings";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCommonSettings";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerCommonSettings";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "clone";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeLanguageSettings";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addLanguageSettings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DefaultsHolder {
        private static final CommonCodeStyleSettings SETTINGS = new CommonCodeStyleSettings(Language.ANY);

        private DefaultsHolder() {
        }

        static {
            SETTINGS.initIndentOptions();
            SETTINGS.setRootSettings(CodeStyleSettings.getDefaults());
        }
    }
}

