/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.engine;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.LanguageAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.NameAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.Rearranger;
import com.intellij.psi.codeStyle.arrangement.TextAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.TypeAwareArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementCallback;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementEntryWrapper;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementMoveInfo;
import com.intellij.psi.codeStyle.arrangement.engine.RestoreFoldArrangementCallback;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementSectionRule;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.CustomArrangementOrderToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class ArrangementEngine {
    private boolean myCodeChanged;

    public static ArrangementEngine getInstance() {
        return ServiceManager.getService(ArrangementEngine.class);
    }

    @Nullable
    public String getUserNotificationInfo() {
        if (this.myCodeChanged) {
            return "rearranged code";
        }
        return null;
    }

    public void arrange(@NotNull Editor editor, @NotNull PsiFile file2, Collection<TextRange> ranges2) {
        if (editor == null) {
            ArrangementEngine.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ArrangementEngine.$$$reportNull$$$0(1);
        }
        this.arrange(file2, ranges2, new RestoreFoldArrangementCallback(editor));
    }

    public void arrange(@NotNull PsiFile file2, @NotNull Collection<TextRange> ranges2) {
        if (file2 == null) {
            ArrangementEngine.$$$reportNull$$$0(2);
        }
        if (ranges2 == null) {
            ArrangementEngine.$$$reportNull$$$0(3);
        }
        this.arrange(file2, ranges2, null);
    }

    public void arrange(@NotNull PsiFile file2, @NotNull Collection<TextRange> ranges2, @Nullable ArrangementCallback callback2) {
        if (file2 == null) {
            ArrangementEngine.$$$reportNull$$$0(4);
        }
        if (ranges2 == null) {
            ArrangementEngine.$$$reportNull$$$0(5);
        }
        this.myCodeChanged = false;
        Document document = PsiDocumentManager.getInstance(file2.getProject()).getDocument(file2);
        if (document == null || !document.isWritable()) {
            return;
        }
        Rearranger<?> rearranger = Rearranger.EXTENSION.forLanguage(file2.getLanguage());
        if (rearranger == null) {
            return;
        }
        CodeStyleSettings settings = CodeStyle.getSettings(file2);
        if (settings.getExcludedFiles().contains(file2)) {
            return;
        }
        ArrangementSettings arrangementSettings = ArrangementUtil.getArrangementSettings(settings, file2.getLanguage());
        if (arrangementSettings == null) {
            return;
        }
        Context context = DumbService.getInstance(file2.getProject()).computeWithAlternativeResolveEnabled(() -> Context.from(rearranger, document, file2, ranges2, arrangementSettings, settings));
        ApplicationManager.getApplication().runWriteAction(() -> FormatChangedTextUtil.getInstance().runHeavyModificationTask(file2.getProject(), document, () -> {
            this.doArrange(context);
            if (callback2 != null) {
                callback2.afterArrangement(context.moveInfos);
            }
        }));
    }

    private <E extends ArrangementEntry> void doArrange(Context<E> context) {
        Stack<StackEntry> stack = new Stack<StackEntry>();
        ArrayList entries = new ArrayList(context.wrappers);
        stack.push(new StackEntry(0, context.wrappers.size()));
        while (!stack.isEmpty()) {
            ArrangementEntryWrapper wrapper2;
            List children2;
            StackEntry stackEntry = (StackEntry)stack.peek();
            if (stackEntry.current >= stackEntry.end) {
                List subEntries = entries.subList(stackEntry.start, stackEntry.end);
                this.doArrange(subEntries, context);
                subEntries.clear();
                stack.pop();
                continue;
            }
            if ((children2 = (wrapper2 = (ArrangementEntryWrapper)entries.get(stackEntry.current++)).getChildren()).isEmpty()) continue;
            entries.addAll(children2);
            stack.push(new StackEntry(stackEntry.end, children2.size()));
        }
    }

    @NotNull
    public static <E extends ArrangementEntry> List<E> arrange(@NotNull Collection<? extends E> entries, @NotNull List<? extends ArrangementSectionRule> sectionRules, @NotNull List<? extends ArrangementMatchRule> rulesByPriority, @Nullable Map<E, ArrangementSectionRule> entryToSection) {
        if (entries == null) {
            ArrangementEngine.$$$reportNull$$$0(6);
        }
        if (sectionRules == null) {
            ArrangementEngine.$$$reportNull$$$0(7);
        }
        if (rulesByPriority == null) {
            ArrangementEngine.$$$reportNull$$$0(8);
        }
        ArrayList<ArrangementEntry> arranged = new ArrayList<ArrangementEntry>();
        LinkedHashSet<ArrangementEntry> unprocessed = new LinkedHashSet<ArrangementEntry>();
        ArrayList dependent = new ArrayList();
        for (ArrangementEntry entry : entries) {
            List<? extends ArrangementEntry> dependencies = entry.getDependencies();
            if (dependencies == null) {
                unprocessed.add(entry);
                continue;
            }
            if (dependencies.size() == 1 && dependencies.get(0) == entry.getParent()) {
                arranged.add(entry);
                continue;
            }
            HashSet hashSet = new HashSet(dependencies);
            dependent.add(Pair.create(hashSet, entry));
        }
        HashSet<ArrangementEntry> matched = new HashSet<ArrangementEntry>();
        MultiMap<ArrangementMatchRule, ArrangementEntry> elementsByRule = new MultiMap<ArrangementMatchRule, ArrangementEntry>();
        for (ArrangementMatchRule arrangementMatchRule : rulesByPriority) {
            matched.clear();
            for (ArrangementEntry arrangementEntry : unprocessed) {
                if (!arrangementEntry.canBeMatched() || !arrangementMatchRule.getMatcher().isMatched(arrangementEntry)) continue;
                elementsByRule.putValue(arrangementMatchRule, arrangementEntry);
                matched.add(arrangementEntry);
            }
            unprocessed.removeAll(matched);
        }
        for (ArrangementSectionRule arrangementSectionRule : sectionRules) {
            for (ArrangementMatchRule arrangementMatchRule : arrangementSectionRule.getMatchRules()) {
                Collection<ArrangementEntry> arrangedEntries = ArrangementEngine.arrangeByRule(arranged, elementsByRule, arrangementMatchRule);
                if (entryToSection == null || arrangedEntries == null) continue;
                for (ArrangementEntry entry : arrangedEntries) {
                    entryToSection.put(entry, arrangementSectionRule);
                }
            }
        }
        arranged.addAll(unprocessed);
        for (int i = 0; i < arranged.size() && !dependent.isEmpty(); ++i) {
            ArrangementEntry arrangementEntry = (ArrangementEntry)arranged.get(i);
            ArrayList shouldBeAddedAfterCurrentElement = new ArrayList();
            Iterator iterator2 = dependent.iterator();
            while (iterator2.hasNext()) {
                Pair pair = (Pair)iterator2.next();
                ((Set)pair.first).remove(arrangementEntry);
                if (!((Set)pair.first).isEmpty()) continue;
                iterator2.remove();
                shouldBeAddedAfterCurrentElement.add(pair.second);
            }
            if (entryToSection != null && entryToSection.containsKey(arrangementEntry)) {
                ArrangementSectionRule arrangementSectionRule = entryToSection.get(arrangementEntry);
                for (ArrangementEntry e1 : shouldBeAddedAfterCurrentElement) {
                    entryToSection.put(e1, arrangementSectionRule);
                }
            }
            arranged.addAll(i + 1, shouldBeAddedAfterCurrentElement);
        }
        ArrayList<ArrangementEntry> arrayList = arranged;
        if (arrayList == null) {
            ArrangementEngine.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Nullable
    private static <E extends ArrangementEntry> Collection<E> arrangeByRule(@NotNull List<? super E> arranged, @NotNull MultiMap<ArrangementMatchRule, E> elementsByRule, @NotNull ArrangementMatchRule rule2) {
        if (arranged == null) {
            ArrangementEngine.$$$reportNull$$$0(10);
        }
        if (elementsByRule == null) {
            ArrangementEngine.$$$reportNull$$$0(11);
        }
        if (rule2 == null) {
            ArrangementEngine.$$$reportNull$$$0(12);
        }
        if (elementsByRule.containsKey(rule2)) {
            List arrangedEntries = (List)elementsByRule.remove(rule2);
            assert (arrangedEntries != null);
            ArrangementSettingsToken order = rule2.getOrderType();
            if (order instanceof CustomArrangementOrderToken) {
                arrangedEntries.sort(((CustomArrangementOrderToken)order).getEntryComparator());
            } else if (rule2.getOrderType().equals(StdArrangementTokens.Order.BY_NAME)) {
                ArrangementEngine.sortByName(arrangedEntries);
            }
            arranged.addAll(arrangedEntries);
            return arrangedEntries;
        }
        return null;
    }

    private static <E extends ArrangementEntry> void sortByName(@NotNull List<E> entries) {
        if (entries == null) {
            ArrangementEngine.$$$reportNull$$$0(13);
        }
        if (entries.size() < 2) {
            return;
        }
        TObjectIntHashMap<ArrangementEntry> weights = new TObjectIntHashMap<ArrangementEntry>();
        int i = 0;
        for (ArrangementEntry e : entries) {
            weights.put(e, ++i);
        }
        ContainerUtil.sort(entries, (e1, e2) -> {
            String name2;
            String name1 = e1 instanceof NameAwareArrangementEntry ? ((NameAwareArrangementEntry)e1).getName() : null;
            String string = name2 = e2 instanceof NameAwareArrangementEntry ? ((NameAwareArrangementEntry)e2).getName() : null;
            if (name1 != null && name2 != null) {
                return name1.compareTo(name2);
            }
            if (name1 == null && name2 == null) {
                return weights.get((ArrangementEntry)e1) - weights.get((ArrangementEntry)e2);
            }
            if (name2 == null) {
                return -1;
            }
            return 1;
        });
    }

    private <E extends ArrangementEntry> void doArrange(@NotNull List<? extends ArrangementEntryWrapper<E>> wrappers, @NotNull Context<E> context) {
        if (wrappers == null) {
            ArrangementEngine.$$$reportNull$$$0(14);
        }
        if (context == null) {
            ArrangementEngine.$$$reportNull$$$0(15);
        }
        if (wrappers.isEmpty()) {
            return;
        }
        HashMap entryToSection = new HashMap();
        HashMap<E, ArrangementEntryWrapper<E>> map2 = new HashMap<E, ArrangementEntryWrapper<E>>();
        ArrayList arranged = new ArrayList();
        ArrayList<E> toArrange = new ArrayList<E>();
        for (ArrangementEntryWrapper<E> wrapper2 : wrappers) {
            E entry = wrapper2.getEntry();
            map2.put(wrapper2.getEntry(), wrapper2);
            if (!entry.canBeMatched()) {
                arranged.add(entry);
                toArrange.clear();
                continue;
            }
            toArrange.add(entry);
        }
        if (!toArrange.isEmpty()) {
            ArrangementEntry contextEntry = (ArrangementEntry)toArrange.get(0);
            Language language2 = contextEntry instanceof LanguageAwareArrangementEntry ? ((LanguageAwareArrangementEntry)contextEntry).getLanguage() : null;
            ArrangementSettings settings = context.getArrangementSettings(language2);
            List<? extends ArrangementMatchRule> rulesByPriority = settings.getRulesSortedByPriority();
            List<ArrangementSectionRule> sectionRules = ArrangementUtil.getExtendedSectionRules(settings);
            arranged.addAll(ArrangementEngine.arrange(toArrange, sectionRules, rulesByPriority, entryToSection));
        }
        NewSectionInfo newSectionsInfo = NewSectionInfo.create(arranged, entryToSection);
        context.changer.prepare(wrappers, context);
        for (int i = arranged.size() - 1; i >= 0; --i) {
            ArrangementEntryWrapper arrangedWrapper = (ArrangementEntryWrapper)map2.get(arranged.get(i));
            ArrangementEntryWrapper<E> initialWrapper = wrappers.get(i);
            ArrangementEntryWrapper previous = i > 0 ? (ArrangementEntryWrapper)map2.get(arranged.get(i - 1)) : null;
            ArrangementEntryWrapper<E> previousInitial = i > 0 ? wrappers.get(i - 1) : null;
            ArrangementEntryWrapper<E> parentWrapper = initialWrapper.getParent();
            if (arrangedWrapper.equals(initialWrapper) && (previous != null && previous.equals(previousInitial) || previous == null && previousInitial == null)) {
                int beforeOffset = arrangedWrapper.getStartOffset();
                int afterOffset = arrangedWrapper.getEndOffset();
                boolean isInserted = context.changer.insertSection(context, (ArrangementEntry)arranged.get(i), newSectionsInfo, parentWrapper, beforeOffset, afterOffset);
                this.myCodeChanged = isInserted || this.myCodeChanged;
                continue;
            }
            ArrangementEntryWrapper next = i < arranged.size() - 1 ? (ArrangementEntryWrapper)map2.get(arranged.get(i + 1)) : null;
            context.changer.replace(arrangedWrapper, initialWrapper, previous, next, context);
            context.changer.insertSection(context, (ArrangementEntry)arranged.get(i), newSectionsInfo, arrangedWrapper, initialWrapper, parentWrapper);
            this.myCodeChanged = true;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sectionRules";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rulesByPriority";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arranged";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsByRule";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrappers";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "arrange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "arrange";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "arrangeByRule";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sortByName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doArrange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RangeMarkerAwareChanger<E extends ArrangementEntry>
    extends Changer<E> {
        @NotNull
        private final List<ArrangementEntryWrapper<E>> myWrappers;
        @NotNull
        private final DocumentEx myDocument;

        RangeMarkerAwareChanger(@NotNull DocumentEx document) {
            if (document == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(0);
            }
            this.myWrappers = new ArrayList<ArrangementEntryWrapper<E>>();
            this.myDocument = document;
        }

        @Override
        public void prepare(@NotNull List<? extends ArrangementEntryWrapper<E>> toArrange, @NotNull Context<E> context) {
            if (toArrange == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(1);
            }
            if (context == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(2);
            }
            this.myWrappers.clear();
            this.myWrappers.addAll(toArrange);
            for (ArrangementEntryWrapper<E> wrapper2 : toArrange) {
                wrapper2.updateBlankLines(this.myDocument);
            }
        }

        @Override
        public void replace(@NotNull ArrangementEntryWrapper<E> newWrapper, @NotNull ArrangementEntryWrapper<E> oldWrapper, @Nullable ArrangementEntryWrapper<E> previous, @Nullable ArrangementEntryWrapper<E> next, @NotNull Context<E> context) {
            if (newWrapper == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(3);
            }
            if (oldWrapper == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(4);
            }
            if (context == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(5);
            }
            int blankLinesBefore = oldWrapper.getBlankLinesBefore();
            ArrangementEntryWrapper<E> parentWrapper = oldWrapper.getParent();
            int desiredBlankLinesNumber = this.getBlankLines(context, parentWrapper, newWrapper, previous, next);
            if ((desiredBlankLinesNumber < 0 || desiredBlankLinesNumber == blankLinesBefore) && newWrapper.equals(oldWrapper)) {
                return;
            }
            int lineFeedsDiff = desiredBlankLinesNumber - blankLinesBefore;
            int insertionOffset = oldWrapper.getStartOffset();
            if (oldWrapper.getStartOffset() > newWrapper.getStartOffset()) {
                insertionOffset -= newWrapper.getEndOffset() - newWrapper.getStartOffset();
            }
            if (newWrapper.getStartOffset() != oldWrapper.getStartOffset() || !newWrapper.equals(oldWrapper)) {
                context.addMoveInfo(newWrapper.getStartOffset(), newWrapper.getEndOffset(), oldWrapper.getStartOffset());
                this.myDocument.moveText(newWrapper.getStartOffset(), newWrapper.getEndOffset(), oldWrapper.getStartOffset());
                for (int i = this.myWrappers.size() - 1; i >= 0; --i) {
                    ArrangementEntryWrapper<E> w = this.myWrappers.get(i);
                    if (w == newWrapper) continue;
                    if (w.getStartOffset() >= oldWrapper.getStartOffset() && w.getStartOffset() < newWrapper.getStartOffset()) {
                        w.applyShift(newWrapper.getEndOffset() - newWrapper.getStartOffset());
                        continue;
                    }
                    if (oldWrapper == w || w.getStartOffset() > oldWrapper.getStartOffset() || w.getStartOffset() <= newWrapper.getStartOffset()) continue;
                    w.applyShift(newWrapper.getStartOffset() - newWrapper.getEndOffset());
                }
            }
            if (desiredBlankLinesNumber >= 0 && lineFeedsDiff > 0) {
                this.myDocument.insertString(insertionOffset, StringUtil.repeat("\n", lineFeedsDiff));
                this.shiftOffsets(lineFeedsDiff, insertionOffset);
            }
            if (desiredBlankLinesNumber >= 0 && lineFeedsDiff < 0) {
                int replacementStartOffset = this.getBlankLineOffset(-lineFeedsDiff, insertionOffset);
                this.myDocument.deleteString(replacementStartOffset, insertionOffset);
                this.shiftOffsets(replacementStartOffset - insertionOffset, insertionOffset);
            }
            if (desiredBlankLinesNumber < 0) {
                return;
            }
            this.updateAllWrapperRanges(parentWrapper, lineFeedsDiff);
        }

        protected void updateAllWrapperRanges(@Nullable ArrangementEntryWrapper<E> parentWrapper, int lineFeedsDiff) {
            if (lineFeedsDiff == 0 || parentWrapper == null) {
                return;
            }
            ArrayDeque<ArrangementEntryWrapper<E>> parents2 = new ArrayDeque<ArrangementEntryWrapper<E>>();
            do {
                parents2.add(parentWrapper);
                parentWrapper.setEndOffset(parentWrapper.getEndOffset() + lineFeedsDiff);
            } while ((parentWrapper = parentWrapper.getParent()) != null);
            while (!parents2.isEmpty()) {
                for (ArrangementEntryWrapper wrapper2 = ((ArrangementEntryWrapper)parents2.removeLast()).getNext(); wrapper2 != null; wrapper2 = wrapper2.getNext()) {
                    wrapper2.applyShift(lineFeedsDiff);
                }
            }
        }

        @Override
        public void insert(@NotNull Context<E> context, int startOffset, @NotNull String text2) {
            if (context == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(6);
            }
            if (text2 == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(7);
            }
            this.myDocument.insertString(startOffset, text2);
            int shift = text2.length();
            for (int i = this.myWrappers.size() - 1; i >= 0; --i) {
                ArrangementEntryWrapper<E> wrapper2 = this.myWrappers.get(i);
                if (wrapper2.getStartOffset() < startOffset) continue;
                wrapper2.applyShift(shift);
            }
        }

        @Override
        public void insertSection(@NotNull Context<E> context, @NotNull E entry, @NotNull NewSectionInfo<E> newSectionsInfo, @NotNull ArrangementEntryWrapper<E> arrangedWrapper, @NotNull ArrangementEntryWrapper<E> initialWrapper, @Nullable ArrangementEntryWrapper<E> parent) {
            if (context == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(8);
            }
            if (entry == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(9);
            }
            if (newSectionsInfo == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(10);
            }
            if (arrangedWrapper == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(11);
            }
            if (initialWrapper == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(12);
            }
            int afterOffset = arrangedWrapper.equals(initialWrapper) ? arrangedWrapper.getEndOffset() : initialWrapper.getStartOffset();
            int length = arrangedWrapper.getEndOffset() - arrangedWrapper.getStartOffset();
            int beforeOffset = arrangedWrapper.equals(initialWrapper) ? arrangedWrapper.getStartOffset() : afterOffset - length;
            this.insertSection(context, entry, newSectionsInfo, parent, beforeOffset, afterOffset);
        }

        @Override
        protected boolean insertSection(@NotNull Context<E> context, @NotNull E entry, @NotNull NewSectionInfo<E> newSectionsInfo, @Nullable ArrangementEntryWrapper<E> parent, int beforeOffset, int afterOffset) {
            String beforeComment;
            if (context == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(13);
            }
            if (entry == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(14);
            }
            if (newSectionsInfo == null) {
                RangeMarkerAwareChanger.$$$reportNull$$$0(15);
            }
            boolean isInserted = false;
            int diff = 0;
            String afterComment = newSectionsInfo.getEndComment(entry);
            if (afterComment != null) {
                this.insert(context, afterOffset, "\n" + afterComment);
                diff += afterComment.length() + 1;
                isInserted = true;
            }
            if ((beforeComment = newSectionsInfo.getStartComment(entry)) != null) {
                this.insert(context, beforeOffset, beforeComment + "\n");
                diff += beforeComment.length() + 1;
                isInserted = true;
            }
            this.updateAllWrapperRanges(parent, diff);
            return isInserted;
        }

        private int getBlankLineOffset(int blankLinesNumber, int startOffset) {
            int startLine = this.myDocument.getLineNumber(startOffset);
            if (startLine <= 0) {
                return 0;
            }
            CharSequence text2 = this.myDocument.getCharsSequence();
            int i = this.myDocument.getLineStartOffset(startLine - 1) - 1;
            while (i >= 0) {
                if (--blankLinesNumber <= 0) {
                    return i + 1;
                }
                i = CharArrayUtil.lastIndexOf(text2, "\n", i - 1);
            }
            return 0;
        }

        private void shiftOffsets(int shift, int changeOffset) {
            ArrangementEntryWrapper<E> wrapper2;
            for (int i = this.myWrappers.size() - 1; i >= 0 && (wrapper2 = this.myWrappers.get(i)).getStartOffset() >= changeOffset; --i) {
                wrapper2.applyShift(shift);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toArrange";
                    break;
                }
                case 2: 
                case 5: 
                case 6: 
                case 8: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newWrapper";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldWrapper";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 9: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 10: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newSectionsInfo";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrangedWrapper";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialWrapper";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$RangeMarkerAwareChanger";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prepare";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replace";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "insert";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "insertSection";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DefaultChanger<E extends ArrangementEntry>
    extends Changer<E> {
        @NotNull
        private String myParentText;
        private int myParentShift;

        private DefaultChanger() {
        }

        @Override
        public void prepare(@NotNull List<? extends ArrangementEntryWrapper<E>> toArrange, @NotNull Context<E> context) {
            ArrangementEntryWrapper<E> parent;
            if (toArrange == null) {
                DefaultChanger.$$$reportNull$$$0(0);
            }
            if (context == null) {
                DefaultChanger.$$$reportNull$$$0(1);
            }
            if ((parent = toArrange.get(0).getParent()) == null) {
                this.myParentText = context.document.getText();
                this.myParentShift = 0;
            } else {
                this.myParentText = context.document.getCharsSequence().subSequence(parent.getStartOffset(), parent.getEndOffset()).toString();
                this.myParentShift = parent.getStartOffset();
            }
        }

        @Override
        public void replace(@NotNull ArrangementEntryWrapper<E> newWrapper, @NotNull ArrangementEntryWrapper<E> oldWrapper, @Nullable ArrangementEntryWrapper<E> previous, @Nullable ArrangementEntryWrapper<E> next, @NotNull Context<E> context) {
            ArrangementEntryWrapper<E> parentWrapper;
            int desiredBlankLinesNumber;
            if (newWrapper == null) {
                DefaultChanger.$$$reportNull$$$0(2);
            }
            if (oldWrapper == null) {
                DefaultChanger.$$$reportNull$$$0(3);
            }
            if (context == null) {
                DefaultChanger.$$$reportNull$$$0(4);
            }
            int blankLinesBefore = 0;
            TIntArrayList lineFeedOffsets = new TIntArrayList();
            int oldStartLine = context.document.getLineNumber(oldWrapper.getStartOffset());
            if (oldStartLine > 0) {
                int lastLineFeed = context.document.getLineStartOffset(oldStartLine) - 1;
                lineFeedOffsets.add(lastLineFeed);
                for (int i = lastLineFeed - 1 - this.myParentShift; i >= 0 && this.myParentText.charAt(i = CharArrayUtil.shiftBackward(this.myParentText, i, " \t")) == '\n'; --i) {
                    ++blankLinesBefore;
                    lineFeedOffsets.add(i + this.myParentShift);
                }
            }
            if ((desiredBlankLinesNumber = this.getBlankLines(context, parentWrapper = oldWrapper.getParent(), newWrapper, previous, next)) == blankLinesBefore && newWrapper.equals(oldWrapper)) {
                return;
            }
            String newEntryText = this.myParentText.substring(newWrapper.getStartOffset() - this.myParentShift, newWrapper.getEndOffset() - this.myParentShift);
            int lineFeedsDiff = desiredBlankLinesNumber - blankLinesBefore;
            if (lineFeedsDiff == 0 || desiredBlankLinesNumber < 0) {
                context.addMoveInfo(newWrapper.getStartOffset() - this.myParentShift, newWrapper.getEndOffset() - this.myParentShift, oldWrapper.getStartOffset());
                context.document.replaceString(oldWrapper.getStartOffset(), oldWrapper.getEndOffset(), newEntryText);
                return;
            }
            if (lineFeedsDiff > 0) {
                StringBuilder buffer = new StringBuilder(StringUtil.repeat("\n", lineFeedsDiff));
                buffer.append(newEntryText);
                context.document.replaceString(oldWrapper.getStartOffset(), oldWrapper.getEndOffset(), buffer);
            } else {
                int replacementStartOffset = lineFeedOffsets.get(-lineFeedsDiff) + 1;
                context.document.replaceString(replacementStartOffset, oldWrapper.getEndOffset(), newEntryText);
            }
            ArrangementEntryWrapper<E> parent = oldWrapper.getParent();
            if (parent == null) {
                return;
            }
            ArrayDeque<ArrangementEntryWrapper<E>> parents2 = new ArrayDeque<ArrangementEntryWrapper<E>>();
            do {
                parents2.add(parent);
                parent.setEndOffset(parent.getEndOffset() + lineFeedsDiff);
            } while ((parent = parent.getParent()) != null);
            while (!parents2.isEmpty()) {
                for (ArrangementEntryWrapper wrapper2 = ((ArrangementEntryWrapper)parents2.removeLast()).getNext(); wrapper2 != null; wrapper2 = wrapper2.getNext()) {
                    wrapper2.applyShift(lineFeedsDiff);
                }
            }
        }

        @Override
        public void insert(@NotNull Context<E> context, int startOffset, @NotNull String text2) {
            if (context == null) {
                DefaultChanger.$$$reportNull$$$0(5);
            }
            if (text2 == null) {
                DefaultChanger.$$$reportNull$$$0(6);
            }
            context.document.insertString(startOffset, text2);
        }

        @Override
        public void insertSection(@NotNull Context<E> context, @NotNull E entry, @NotNull NewSectionInfo<E> newSectionsInfo, @NotNull ArrangementEntryWrapper<E> arrangedWrapper, @NotNull ArrangementEntryWrapper<E> initialWrapper, @Nullable ArrangementEntryWrapper<E> parent) {
            if (context == null) {
                DefaultChanger.$$$reportNull$$$0(7);
            }
            if (entry == null) {
                DefaultChanger.$$$reportNull$$$0(8);
            }
            if (newSectionsInfo == null) {
                DefaultChanger.$$$reportNull$$$0(9);
            }
            if (arrangedWrapper == null) {
                DefaultChanger.$$$reportNull$$$0(10);
            }
            if (initialWrapper == null) {
                DefaultChanger.$$$reportNull$$$0(11);
            }
            int beforeOffset = arrangedWrapper.equals(initialWrapper) ? arrangedWrapper.getStartOffset() : initialWrapper.getStartOffset();
            int length = arrangedWrapper.getEndOffset() - arrangedWrapper.getStartOffset();
            int afterOffset = arrangedWrapper.equals(initialWrapper) ? arrangedWrapper.getEndOffset() : beforeOffset + length;
            this.insertSection(context, entry, newSectionsInfo, parent, beforeOffset, afterOffset);
        }

        @Override
        protected boolean insertSection(@NotNull Context<E> context, @NotNull E entry, @NotNull NewSectionInfo<E> newSectionsInfo, ArrangementEntryWrapper<E> parent, int beforeOffset, int afterOffset) {
            String beforeComment;
            if (context == null) {
                DefaultChanger.$$$reportNull$$$0(12);
            }
            if (entry == null) {
                DefaultChanger.$$$reportNull$$$0(13);
            }
            if (newSectionsInfo == null) {
                DefaultChanger.$$$reportNull$$$0(14);
            }
            boolean isInserted = false;
            String afterComment = newSectionsInfo.getEndComment(entry);
            if (afterComment != null) {
                this.insert(context, afterOffset, "\n" + afterComment);
                isInserted = true;
            }
            if ((beforeComment = newSectionsInfo.getStartComment(entry)) != null) {
                this.insert(context, beforeOffset, beforeComment + "\n");
                isInserted = true;
            }
            return isInserted;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toArrange";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 7: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newWrapper";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldWrapper";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 8: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 9: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newSectionsInfo";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrangedWrapper";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initialWrapper";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$DefaultChanger";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prepare";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replace";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "insert";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "insertSection";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class Changer<E extends ArrangementEntry> {
        private Changer() {
        }

        public abstract void prepare(@NotNull List<? extends ArrangementEntryWrapper<E>> var1, @NotNull Context<E> var2);

        public abstract void replace(@NotNull ArrangementEntryWrapper<E> var1, @NotNull ArrangementEntryWrapper<E> var2, @Nullable ArrangementEntryWrapper<E> var3, @Nullable ArrangementEntryWrapper<E> var4, @NotNull Context<E> var5);

        public abstract void insert(@NotNull Context<E> var1, int var2, @NotNull String var3);

        public abstract void insertSection(@NotNull Context<E> var1, @NotNull E var2, @NotNull NewSectionInfo<E> var3, @NotNull ArrangementEntryWrapper<E> var4, @NotNull ArrangementEntryWrapper<E> var5, @Nullable ArrangementEntryWrapper<E> var6);

        protected abstract boolean insertSection(@NotNull Context<E> var1, @NotNull E var2, @NotNull NewSectionInfo<E> var3, @Nullable ArrangementEntryWrapper<E> var4, int var5, int var6);

        protected int getBlankLines(@NotNull Context<E> context, @Nullable ArrangementEntryWrapper<E> parentWrapper, @NotNull ArrangementEntryWrapper<E> targetWrapper, @Nullable ArrangementEntryWrapper<E> previousWrapper, @Nullable ArrangementEntryWrapper<E> nextWrapper) {
            Object previous;
            if (context == null) {
                Changer.$$$reportNull$$$0(0);
            }
            if (targetWrapper == null) {
                Changer.$$$reportNull$$$0(1);
            }
            E target2 = targetWrapper.getEntry();
            Object e = previous = previousWrapper == null ? null : (Object)previousWrapper.getEntry();
            if (this.isTypeOf(target2, StdArrangementTokens.Section.END_SECTION) || this.isTypeOf(previous, StdArrangementTokens.Section.START_SECTION)) {
                return 0;
            }
            Object next = nextWrapper == null ? null : (Object)nextWrapper.getEntry();
            Object parentEntry = parentWrapper == null ? null : (Object)parentWrapper.getEntry();
            Language language2 = parentEntry instanceof LanguageAwareArrangementEntry ? ((LanguageAwareArrangementEntry)parentEntry).getLanguage() : null;
            Rearranger<Object> rearranger = context.getRearranger(language2);
            if (next != null && this.isTypeOf(target2, StdArrangementTokens.Section.START_SECTION)) {
                return rearranger.getBlankLines(context.settings, parentEntry, previous, next);
            }
            return rearranger.getBlankLines(context.settings, parentEntry, previous, target2);
        }

        private boolean isTypeOf(@Nullable E element2, @NotNull ArrangementSettingsToken token) {
            if (token == null) {
                Changer.$$$reportNull$$$0(2);
            }
            if (element2 instanceof TypeAwareArrangementEntry) {
                Set<ArrangementSettingsToken> types = ((TypeAwareArrangementEntry)element2).getTypes();
                return types.size() == 1 && token.equals(types.iterator().next());
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetWrapper";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "token";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Changer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getBlankLines";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isTypeOf";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class StackEntry {
        public int start;
        public int current;
        public int end;

        StackEntry(int start2, int count) {
            this.start = start2;
            this.current = start2;
            this.end = start2 + count;
        }
    }

    private static class Context<E extends ArrangementEntry> {
        @NotNull
        public final List<ArrangementMoveInfo> moveInfos;
        @NotNull
        private final Rearranger<E> rearranger;
        @NotNull
        public final Collection<ArrangementEntryWrapper<E>> wrappers;
        @NotNull
        public final Document document;
        @NotNull
        private final ArrangementSettings arrangementSettings;
        @NotNull
        public final CodeStyleSettings settings;
        @NotNull
        public final Changer changer;

        private Context(@NotNull Rearranger<E> rearranger, @NotNull Collection<ArrangementEntryWrapper<E>> wrappers, @NotNull Document document, @NotNull ArrangementSettings arrangementSettings, @NotNull CodeStyleSettings settings, @NotNull Changer changer) {
            if (rearranger == null) {
                Context.$$$reportNull$$$0(0);
            }
            if (wrappers == null) {
                Context.$$$reportNull$$$0(1);
            }
            if (document == null) {
                Context.$$$reportNull$$$0(2);
            }
            if (arrangementSettings == null) {
                Context.$$$reportNull$$$0(3);
            }
            if (settings == null) {
                Context.$$$reportNull$$$0(4);
            }
            if (changer == null) {
                Context.$$$reportNull$$$0(5);
            }
            this.moveInfos = new ArrayList<ArrangementMoveInfo>();
            this.rearranger = rearranger;
            this.wrappers = wrappers;
            this.document = document;
            this.arrangementSettings = arrangementSettings;
            this.settings = settings;
            this.changer = changer;
        }

        public void addMoveInfo(int oldStart, int oldEnd, int newStart) {
            this.moveInfos.add(new ArrangementMoveInfo(oldStart, oldEnd, newStart));
        }

        @NotNull
        public ArrangementSettings getArrangementSettings(@Nullable Language languageOverride) {
            ArrangementSettings languageSettings;
            if (languageOverride != null && (languageSettings = ArrangementUtil.getArrangementSettings(this.settings, languageOverride)) != null) {
                ArrangementSettings arrangementSettings = languageSettings;
                if (arrangementSettings == null) {
                    Context.$$$reportNull$$$0(6);
                }
                return arrangementSettings;
            }
            ArrangementSettings arrangementSettings = this.arrangementSettings;
            if (arrangementSettings == null) {
                Context.$$$reportNull$$$0(7);
            }
            return arrangementSettings;
        }

        @NotNull
        public Rearranger<E> getRearranger(@Nullable Language language2) {
            Rearranger<?> forLanguage;
            if (language2 != null && (forLanguage = Rearranger.EXTENSION.forLanguage(language2)) != null) {
                Rearranger<?> rearranger = forLanguage;
                if (rearranger == null) {
                    Context.$$$reportNull$$$0(8);
                }
                return rearranger;
            }
            Rearranger<E> rearranger = this.rearranger;
            if (rearranger == null) {
                Context.$$$reportNull$$$0(9);
            }
            return rearranger;
        }

        public static <T extends ArrangementEntry> Context<T> from(@NotNull Rearranger<T> rearranger, @NotNull Document document, @NotNull PsiElement root, @NotNull Collection<TextRange> ranges2, @NotNull ArrangementSettings arrangementSettings, @NotNull CodeStyleSettings codeStyleSettings) {
            if (rearranger == null) {
                Context.$$$reportNull$$$0(10);
            }
            if (document == null) {
                Context.$$$reportNull$$$0(11);
            }
            if (root == null) {
                Context.$$$reportNull$$$0(12);
            }
            if (ranges2 == null) {
                Context.$$$reportNull$$$0(13);
            }
            if (arrangementSettings == null) {
                Context.$$$reportNull$$$0(14);
            }
            if (codeStyleSettings == null) {
                Context.$$$reportNull$$$0(15);
            }
            List<T> entries = rearranger.parse(root, document, ranges2, arrangementSettings);
            ArrayList<ArrangementEntryWrapper<ArrangementEntryWrapper<ArrangementEntry>>> wrappers = new ArrayList<ArrangementEntryWrapper<ArrangementEntryWrapper<ArrangementEntry>>>();
            ArrangementEntryWrapper<ArrangementEntry> previous = null;
            for (ArrangementEntry entry : entries) {
                ArrangementEntryWrapper<ArrangementEntry> wrapper2 = new ArrangementEntryWrapper<ArrangementEntry>(entry);
                if (previous != null) {
                    previous.setNext(wrapper2);
                    wrapper2.setPrevious(previous);
                }
                wrappers.add(wrapper2);
                previous = wrapper2;
            }
            Changer changer = document instanceof DocumentEx ? new RangeMarkerAwareChanger((DocumentEx)document) : new DefaultChanger();
            return new Context<T>(rearranger, wrappers, document, arrangementSettings, codeStyleSettings, changer);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rearranger";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "wrappers";
                    break;
                }
                case 2: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 3: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arrangementSettings";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "changer";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ranges";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "codeStyleSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$Context";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getArrangementSettings";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRearranger";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray;
                    objectArray[2] = "from";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class NewSectionInfo<E extends ArrangementEntry> {
        private final Map<E, String> mySectionStarts = new HashMap<E, String>();
        private final Map<E, String> mySectionEnds = new HashMap<E, String>();

        private NewSectionInfo() {
        }

        private static <E extends ArrangementEntry> NewSectionInfo create(@NotNull List<? extends E> arranged, @NotNull Map<E, ArrangementSectionRule> entryToSection) {
            if (arranged == null) {
                NewSectionInfo.$$$reportNull$$$0(0);
            }
            if (entryToSection == null) {
                NewSectionInfo.$$$reportNull$$$0(1);
            }
            NewSectionInfo<E> info = new NewSectionInfo<E>();
            boolean sectionIsOpen = false;
            ArrangementSectionRule prevSection = null;
            ArrangementEntry prev = null;
            for (ArrangementEntry e : arranged) {
                ArrangementSectionRule section = entryToSection.get(e);
                if (section != prevSection) {
                    String startComment;
                    NewSectionInfo.closeSection(prevSection, prev, info, sectionIsOpen);
                    sectionIsOpen = false;
                    if (section != null && StringUtil.isNotEmpty(startComment = section.getStartComment()) && !NewSectionInfo.isSectionEntry(e, startComment)) {
                        sectionIsOpen = true;
                        super.addSectionStart(e, startComment);
                    }
                    prevSection = section;
                }
                prev = e;
            }
            NewSectionInfo.closeSection(prevSection, prev, info, sectionIsOpen);
            return info;
        }

        public static boolean isSectionEntry(@NotNull ArrangementEntry entry, @NotNull String sectionText) {
            ArrangementSettingsToken type;
            Set<ArrangementSettingsToken> types;
            if (entry == null) {
                NewSectionInfo.$$$reportNull$$$0(2);
            }
            if (sectionText == null) {
                NewSectionInfo.$$$reportNull$$$0(3);
            }
            if (entry instanceof TypeAwareArrangementEntry && entry instanceof TextAwareArrangementEntry && (types = ((TypeAwareArrangementEntry)entry).getTypes()).size() == 1 && ((type = types.iterator().next()).equals(StdArrangementTokens.Section.START_SECTION) || type.equals(StdArrangementTokens.Section.END_SECTION))) {
                return StringUtil.equals(((TextAwareArrangementEntry)entry).getText(), sectionText);
            }
            return false;
        }

        private static <E extends ArrangementEntry> void closeSection(@Nullable ArrangementSectionRule section, @Nullable E entry, @NotNull NewSectionInfo<E> info, boolean sectionIsOpen) {
            if (info == null) {
                NewSectionInfo.$$$reportNull$$$0(4);
            }
            if (sectionIsOpen) {
                assert (section != null && entry != null);
                if (StringUtil.isNotEmpty(section.getEndComment())) {
                    super.addSectionEnd(entry, section.getEndComment());
                }
            }
        }

        private void addSectionStart(E entry, String comment) {
            this.mySectionStarts.put(entry, comment);
        }

        private void addSectionEnd(E entry, String comment) {
            this.mySectionEnds.put(entry, comment);
        }

        @Nullable
        public String getStartComment(E entry) {
            return this.mySectionStarts.get(entry);
        }

        @Nullable
        public String getEndComment(E entry) {
            return this.mySectionEnds.get(entry);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arranged";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entryToSection";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sectionText";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/engine/ArrangementEngine$NewSectionInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSectionEntry";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "closeSection";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

