/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.engine;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementCallback;
import com.intellij.psi.codeStyle.arrangement.engine.ArrangementMoveInfo;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RestoreFoldArrangementCallback
implements ArrangementCallback {
    @NotNull
    private final Editor myEditor;

    public RestoreFoldArrangementCallback(@NotNull Editor editor) {
        if (editor == null) {
            RestoreFoldArrangementCallback.$$$reportNull$$$0(0);
        }
        this.myEditor = editor;
    }

    @Override
    public void afterArrangement(@NotNull List<ArrangementMoveInfo> moveInfos) {
        Project project2;
        if (moveInfos == null) {
            RestoreFoldArrangementCallback.$$$reportNull$$$0(1);
        }
        if ((project2 = this.myEditor.getProject()) != null) {
            FoldRegion[] regions = this.myEditor.getFoldingModel().getAllFoldRegions();
            ArrayList<FoldRegionInfo> foldRegionsInfo = new ArrayList<FoldRegionInfo>();
            for (FoldRegion region : regions) {
                FoldRegionInfo info = new FoldRegionInfo(region.getStartOffset(), region.getEndOffset(), region.isExpanded());
                foldRegionsInfo.add(info);
            }
            CodeFoldingManager foldingManager = CodeFoldingManager.getInstance(project2);
            foldingManager.updateFoldRegions(this.myEditor);
            this.myEditor.getFoldingModel().runBatchFoldingOperation(() -> {
                for (FoldRegionInfo info : foldRegionsInfo) {
                    FoldRegion foldRegion = foldingManager.findFoldRegion(this.myEditor, info.myStart, info.myEnd);
                    if (foldRegion == null) continue;
                    foldRegion.setExpanded(info.myIsExpanded);
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moveInfos";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/engine/RestoreFoldArrangementCallback";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "afterArrangement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class FoldRegionInfo {
        private final int myStart;
        private final int myEnd;
        private final boolean myIsExpanded;

        private FoldRegionInfo(int start2, int end, boolean expanded) {
            this.myStart = start2;
            this.myEnd = end;
            this.myIsExpanded = expanded;
        }
    }
}

