/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor.processor;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.extractor.Utils;
import com.intellij.psi.codeStyle.extractor.differ.Differ;
import com.intellij.psi.codeStyle.extractor.differ.LangCodeStyleExtractor;
import com.intellij.psi.codeStyle.extractor.processor.CodeStyleDeriveProcessor;
import com.intellij.psi.codeStyle.extractor.values.Gens;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

public class GenProcessor
extends CodeStyleDeriveProcessor {
    private String myReport = "No result";

    public GenProcessor(LangCodeStyleExtractor langExtractor) {
        super(langExtractor);
    }

    @Override
    public Gens runWithProgress(Project project2, CodeStyleSettings settings, PsiFile file2, ProgressIndicator indicator) {
        Gens origGens = new Gens(this.getFormattingValues(settings, file2.getLanguage()));
        Gens forSelection = origGens.copy();
        Differ differ = this.myLangExtractor.getDiffer(project2, file2, settings);
        forSelection.dropToInitial();
        long startTime = System.nanoTime();
        Utils.adjustValuesGA(forSelection, differ, indicator);
        this.myReport = "<br> Genetic phase: " + GenProcessor.reportResult(forSelection, differ, startTime);
        startTime = System.nanoTime();
        Utils.adjustValuesMin(forSelection, differ, indicator);
        this.myReport = this.myReport + "<br> Minimization Phase: " + GenProcessor.reportResult(forSelection, differ, startTime);
        return forSelection;
    }

    @Override
    @NotNull
    public String getHTMLReport() {
        String string = this.myReport;
        if (string == null) {
            GenProcessor.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    private static String reportResult(@NotNull Gens gens, @NotNull Differ differ, long startTime) {
        if (gens == null) {
            GenProcessor.$$$reportNull$$$0(1);
        }
        if (differ == null) {
            GenProcessor.$$$reportNull$$$0(2);
        }
        SimpleDateFormat formatter = new SimpleDateFormat("mm:ss");
        Date date = new Date((System.nanoTime() - startTime) / 1000000L);
        String string = "Difference in spaces with the original:" + differ.getDifference(gens) + " Execution Time:" + formatter.format(date);
        if (string == null) {
            GenProcessor.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/extractor/processor/GenProcessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gens";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "differ";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHTMLReport";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/extractor/processor/GenProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "reportResult";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reportResult";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

