/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters.position;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ReflectionUtil;

public class NamespaceFilter
implements ElementFilter {
    private final String[] myNamespaces;

    public NamespaceFilter(String ... namespaces) {
        this.myNamespaces = namespaces;
    }

    @Override
    public boolean isClassAcceptable(Class hintClass) {
        return ReflectionUtil.isAssignable(XmlTag.class, hintClass) || ReflectionUtil.isAssignable(XmlDocument.class, hintClass);
    }

    @Override
    public boolean isAcceptable(Object element2, PsiElement context) {
        if (element2 instanceof XmlTag) {
            XmlTag psiElement = (XmlTag)element2;
            if (!psiElement.isValid()) {
                return false;
            }
            String ns = psiElement.getNamespace();
            if (this.isNamespaceAcceptable(ns)) {
                return true;
            }
            PsiFile psiFile = psiElement.getContainingFile();
            if (psiFile instanceof XmlFile) {
                String publicId;
                XmlDoctype doctype;
                XmlDocument document = ((XmlFile)psiFile).getDocument();
                if (document == null) {
                    return false;
                }
                XmlProlog prolog = document.getProlog();
                if (prolog != null && (doctype = prolog.getDoctype()) != null && (publicId = doctype.getPublicId()) != null && this.isNamespaceAcceptable(publicId)) {
                    return true;
                }
            }
        } else if (element2 instanceof XmlDocument) {
            return this.isAcceptable(((XmlDocument)element2).getRootTag(), context);
        }
        return false;
    }

    protected boolean isNamespaceAcceptable(String ns) {
        for (String aMyValue : this.myNamespaces) {
            if (!aMyValue.equals(ns)) continue;
            return true;
        }
        return false;
    }
}

