/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.common;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.common.InjectedLanguageBlockWrapper;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InjectedLanguageBlockBuilder {
    private static final Logger LOG = Logger.getInstance(InjectedLanguageBlockBuilder.class);

    @NotNull
    public Block createInjectedBlock(@NotNull ASTNode node, @NotNull Block originalBlock, Indent indent, int offset, TextRange range2, @NotNull Language language2) {
        if (node == null) {
            InjectedLanguageBlockBuilder.$$$reportNull$$$0(0);
        }
        if (originalBlock == null) {
            InjectedLanguageBlockBuilder.$$$reportNull$$$0(1);
        }
        if (language2 == null) {
            InjectedLanguageBlockBuilder.$$$reportNull$$$0(2);
        }
        return new InjectedLanguageBlockWrapper(originalBlock, offset, range2, indent, language2);
    }

    public abstract CodeStyleSettings getSettings();

    public abstract boolean canProcessFragment(String var1, ASTNode var2);

    public abstract Block createBlockBeforeInjection(ASTNode var1, Wrap var2, Alignment var3, Indent var4, TextRange var5);

    public abstract Block createBlockAfterInjection(ASTNode var1, Wrap var2, Alignment var3, Indent var4, TextRange var5);

    public boolean addInjectedBlocks(List<? super Block> result2, ASTNode injectionHost, Wrap wrap, Alignment alignment, Indent indent) {
        Language childLanguage;
        FormattingModelBuilder builder2;
        PsiFile[] injectedFile = new PsiFile[1];
        Ref injectedRangeInsideHost = new Ref();
        Ref prefixLength = new Ref();
        Ref suffixLength = new Ref();
        Ref<ASTNode> injectionHostToUse = new Ref<ASTNode>(injectionHost);
        PsiLanguageInjectionHost.InjectedPsiVisitor injectedPsiVisitor = (injectedPsi, places) -> {
            String childText;
            if (places.size() != 1) {
                return;
            }
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)places.get(0);
            TextRange textRange = shred.getRangeInsideHost();
            PsiLanguageInjectionHost shredHost = shred.getHost();
            if (shredHost == null) {
                return;
            }
            ASTNode node = shredHost.getNode();
            if (node == null || !injectionHost.getTextRange().contains(textRange.shiftRight(node.getStartOffset()))) {
                return;
            }
            if (node != injectionHost) {
                int shift = 0;
                boolean canProcess = false;
                ASTNode prev = injectionHost;
                for (ASTNode n = injectionHost.getTreeParent(); n != null; n = n.getTreeParent()) {
                    shift += n.getStartOffset() - prev.getStartOffset();
                    if (n == node) {
                        textRange = textRange.shiftRight(shift);
                        canProcess = true;
                        break;
                    }
                    prev = n;
                }
                if (!canProcess) {
                    return;
                }
            }
            if (injectionHost.getTextLength() == textRange.getEndOffset() && textRange.getStartOffset() == 0 || this.canProcessFragment((childText = injectionHost.getText()).substring(0, textRange.getStartOffset()), injectionHost) && this.canProcessFragment(childText.substring(textRange.getEndOffset()), injectionHost)) {
                injectedFile[0] = injectedPsi;
                injectedRangeInsideHost.set(textRange);
                prefixLength.set(shred.getPrefix().length());
                suffixLength.set(shred.getSuffix().length());
            }
        };
        PsiElement injectionHostPsi = injectionHost.getPsi();
        PsiFile containingFile = injectionHostPsi.getContainingFile();
        InjectedLanguageManager.getInstance(containingFile.getProject()).enumerateEx(injectionHostPsi, containingFile, true, injectedPsiVisitor);
        if (injectedFile[0] != null && (builder2 = LanguageFormatting.INSTANCE.forContext(childLanguage = injectedFile[0].getLanguage(), injectionHostPsi)) != null) {
            ASTNode leaf;
            int startOffset = ((TextRange)injectedRangeInsideHost.get()).getStartOffset();
            int endOffset = ((TextRange)injectedRangeInsideHost.get()).getEndOffset();
            TextRange range2 = injectionHostToUse.get().getTextRange();
            int childOffset = range2.getStartOffset();
            if (startOffset != 0) {
                leaf = injectionHostToUse.get().findLeafElementAt(startOffset - 1);
                result2.add(this.createBlockBeforeInjection(leaf, wrap, alignment, indent, new TextRange(childOffset, childOffset + startOffset)));
            }
            this.addInjectedLanguageBlockWrapper(result2, injectedFile[0].getNode(), indent, childOffset + startOffset, new TextRange((Integer)prefixLength.get(), injectedFile[0].getTextLength() - (Integer)suffixLength.get()));
            if (endOffset != injectionHostToUse.get().getTextLength()) {
                leaf = injectionHostToUse.get().findLeafElementAt(endOffset);
                result2.add(this.createBlockAfterInjection(leaf, wrap, alignment, indent, new TextRange(childOffset + endOffset, range2.getEndOffset())));
            }
            return true;
        }
        return false;
    }

    public void addInjectedLanguageBlockWrapper(List<? super Block> result2, ASTNode injectedNode, Indent indent, int offset, @Nullable TextRange range2) {
        PsiElement childPsi;
        Language childLanguage;
        FormattingModelBuilder builder2;
        if (range2 != null) {
            if (range2.getLength() == 0) {
                return;
            }
            if (StringUtil.isEmptyOrSpaces(range2.substring(injectedNode.getText()))) {
                return;
            }
        }
        LOG.assertTrue((builder2 = LanguageFormatting.INSTANCE.forContext(childLanguage = (childPsi = injectedNode.getPsi()).getLanguage(), childPsi)) != null);
        FormattingModel childModel = builder2.createModel(childPsi, this.getSettings());
        Block original = childModel.getRootBlock();
        if (original.isLeaf() && !injectedNode.getText().trim().isEmpty() || !original.getSubBlocks().isEmpty()) {
            result2.add(this.createInjectedBlock(injectedNode, original, indent, offset, range2, childLanguage));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "node";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "originalBlock";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "language";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/formatter/common/InjectedLanguageBlockBuilder";
        objectArray[2] = "createInjectedBlock";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

