/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.common;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.formatter.IndentRangesCalculator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/psi/formatter/common/NodeIndentRangesCalculator;", "", "node", "Lcom/intellij/lang/ASTNode;", "(Lcom/intellij/lang/ASTNode;)V", "calculateExtraRanges", "", "Lcom/intellij/openapi/util/TextRange;", "retrieveDocument", "Lcom/intellij/openapi/editor/Document;", "intellij.platform.lang.impl"})
public final class NodeIndentRangesCalculator {
    private final ASTNode node;

    @NotNull
    public final List<TextRange> calculateExtraRanges() {
        Document document = this.retrieveDocument(this.node);
        if (document != null) {
            TextRange ranges2;
            TextRange textRange = ranges2 = this.node.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"ranges");
            return new IndentRangesCalculator(document, textRange).calcIndentRanges();
        }
        return CollectionsKt.listOf((Object)this.node.getTextRange());
    }

    private final Document retrieveDocument(ASTNode node) {
        PsiElement psiElement = node.getPsi();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"node.psi");
        PsiFile file2 = psiElement.getContainingFile();
        PsiElement psiElement2 = node.getPsi();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"node.psi");
        return PsiDocumentManager.getInstance(psiElement2.getProject()).getDocument(file2);
    }

    public NodeIndentRangesCalculator(@NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        this.node = node;
    }
}

