/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.LighterASTTokenNode;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CharTable;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.PairConsumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.intellij.util.exception.FrequentErrorLogger;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.graph.OutboundSemiGraph;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebugUtil {
    private static final Logger LOG = Logger.getInstance(DebugUtil.class);
    public static boolean CHECK;
    public static final boolean DO_EXPENSIVE_CHECKS;
    public static final boolean CHECK_INSIDE_ATOMIC_ACTION_ENABLED;
    private static final ThreadLocal<Object> ourPsiModificationTrace;
    private static final ThreadLocal<Integer> ourPsiModificationDepth;
    private static final FrequentErrorLogger ourErrorLogger;

    @NotNull
    public static String psiTreeToString(@NotNull PsiElement element2, boolean skipWhitespaces) {
        if (element2 == null) {
            DebugUtil.$$$reportNull$$$0(0);
        }
        ASTNode node = SourceTreeToPsiMap.psiElementToTree(element2);
        assert (node != null) : element2;
        return DebugUtil.treeToString(node, skipWhitespaces);
    }

    @NotNull
    public static String treeToString(@NotNull ASTNode root, boolean skipWhitespaces) {
        if (root == null) {
            DebugUtil.$$$reportNull$$$0(1);
        }
        StringBuilder buffer = new StringBuilder();
        DebugUtil.treeToBuffer(buffer, root, 0, skipWhitespaces, false, false, true);
        String string = buffer.toString();
        if (string == null) {
            DebugUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String nodeTreeToString(@NotNull ASTNode root, boolean skipWhitespaces) {
        if (root == null) {
            DebugUtil.$$$reportNull$$$0(3);
        }
        StringBuilder buffer = new StringBuilder();
        DebugUtil.treeToBuffer(buffer, root, 0, skipWhitespaces, false, false, false);
        String string = buffer.toString();
        if (string == null) {
            DebugUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String treeToString(@NotNull ASTNode root, boolean skipWhitespaces, boolean showRanges) {
        if (root == null) {
            DebugUtil.$$$reportNull$$$0(5);
        }
        StringBuilder buffer = new StringBuilder();
        DebugUtil.treeToBuffer(buffer, root, 0, skipWhitespaces, showRanges, false, true);
        String string = buffer.toString();
        if (string == null) {
            DebugUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static void treeToBuffer(@NotNull Appendable buffer, @NotNull ASTNode root, int indent, boolean skipWhiteSpaces, boolean showRanges, boolean showChildrenRanges, boolean usePsi) {
        if (buffer == null) {
            DebugUtil.$$$reportNull$$$0(7);
        }
        if (root == null) {
            DebugUtil.$$$reportNull$$$0(8);
        }
        DebugUtil.treeToBuffer(buffer, root, indent, skipWhiteSpaces, showRanges, showChildrenRanges, usePsi, null);
    }

    private static void treeToBuffer(@NotNull Appendable buffer, @NotNull ASTNode root, int indent, boolean skipWhiteSpaces, boolean showRanges, boolean showChildrenRanges, boolean usePsi, @Nullable PairConsumer<? super PsiElement, Consumer<PsiElement>> extra) {
        if (buffer == null) {
            DebugUtil.$$$reportNull$$$0(9);
        }
        if (root == null) {
            DebugUtil.$$$reportNull$$$0(10);
        }
        ((TreeElement)root).acceptTree(new TreeToBuffer(buffer, indent, skipWhiteSpaces, showRanges, showChildrenRanges, usePsi, extra));
    }

    @NotNull
    public static String lightTreeToString(@NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, boolean skipWhitespaces) {
        if (tree == null) {
            DebugUtil.$$$reportNull$$$0(11);
        }
        StringBuilder buffer = new StringBuilder();
        DebugUtil.lightTreeToBuffer(tree, tree.getRoot(), buffer, 0, skipWhitespaces);
        String string = buffer.toString();
        if (string == null) {
            DebugUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static void lightTreeToBuffer(@NotNull FlyweightCapableTreeStructure<LighterASTNode> tree, @NotNull LighterASTNode node, @NotNull Appendable buffer, int indent, boolean skipWhiteSpaces) {
        if (tree == null) {
            DebugUtil.$$$reportNull$$$0(13);
        }
        if (node == null) {
            DebugUtil.$$$reportNull$$$0(14);
        }
        if (buffer == null) {
            DebugUtil.$$$reportNull$$$0(15);
        }
        IElementType tokenType = node.getTokenType();
        if (skipWhiteSpaces && tokenType == TokenType.WHITE_SPACE) {
            return;
        }
        boolean isLeaf = node instanceof LighterASTTokenNode;
        StringUtil.repeatSymbol(buffer, ' ', indent);
        try {
            if (tokenType == TokenType.ERROR_ELEMENT) {
                buffer.append("PsiErrorElement:").append(PsiBuilderImpl.getErrorMessage(node));
            } else if (tokenType == TokenType.WHITE_SPACE) {
                buffer.append("PsiWhiteSpace");
            } else {
                buffer.append(isLeaf ? "PsiElement" : "Element").append('(').append(tokenType.toString()).append(')');
            }
            if (isLeaf) {
                String text2 = ((LighterASTTokenNode)node).getText().toString();
                buffer.append("('").append(DebugUtil.fixWhiteSpaces(text2)).append("')");
            }
            buffer.append('\n');
            if (!isLeaf) {
                Ref<T[]> kids = new Ref<T[]>();
                int numKids = tree.getChildren(node, kids);
                if (numKids == 0) {
                    StringUtil.repeatSymbol(buffer, ' ', indent + 2);
                    buffer.append("<empty list>\n");
                } else {
                    for (int i = 0; i < numKids; ++i) {
                        DebugUtil.lightTreeToBuffer(tree, ((LighterASTNode[])kids.get())[i], buffer, indent + 2, skipWhiteSpaces);
                    }
                }
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    @NotNull
    public static String stubTreeToString(@NotNull Stub root) {
        if (root == null) {
            DebugUtil.$$$reportNull$$$0(16);
        }
        StringBuilder builder2 = new StringBuilder();
        DebugUtil.stubTreeToBuffer(root, builder2, 0);
        String string = builder2.toString();
        if (string == null) {
            DebugUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    public static void stubTreeToBuffer(@NotNull Stub node, @NotNull Appendable buffer, int indent) {
        if (node == null) {
            DebugUtil.$$$reportNull$$$0(18);
        }
        if (buffer == null) {
            DebugUtil.$$$reportNull$$$0(19);
        }
        StringUtil.repeatSymbol(buffer, ' ', indent);
        try {
            ObjectStubSerializer stubType = node.getStubType();
            if (stubType != null) {
                buffer.append(stubType.toString()).append(':');
            }
            buffer.append(node.toString()).append('\n');
            List<? extends Stub> children2 = node.getChildrenStubs();
            for (Stub stub : children2) {
                DebugUtil.stubTreeToBuffer(stub, buffer, indent + 2);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    private static void treeToBufferWithUserData(@NotNull Appendable buffer, @NotNull TreeElement root, int indent, boolean skipWhiteSpaces) {
        if (buffer == null) {
            DebugUtil.$$$reportNull$$$0(20);
        }
        if (root == null) {
            DebugUtil.$$$reportNull$$$0(21);
        }
        if (skipWhiteSpaces && root.getElementType() == TokenType.WHITE_SPACE) {
            return;
        }
        StringUtil.repeatSymbol(buffer, ' ', indent);
        try {
            PsiElement psi = SourceTreeToPsiMap.treeElementToPsi(root);
            assert (psi != null) : root;
            if (root instanceof CompositeElement) {
                buffer.append(psi.toString());
            } else {
                String text2 = DebugUtil.fixWhiteSpaces(root.getText());
                buffer.append(root.toString()).append("('").append(text2).append("')");
            }
            buffer.append(root.getUserDataString());
            buffer.append("\n");
            if (root instanceof CompositeElement) {
                PsiElement[] children2;
                for (PsiElement child2 : children2 = psi.getChildren()) {
                    DebugUtil.treeToBufferWithUserData(buffer, (TreeElement)SourceTreeToPsiMap.psiElementToTree(child2), indent + 2, skipWhiteSpaces);
                }
                if (children2.length == 0) {
                    StringUtil.repeatSymbol(buffer, ' ', indent + 2);
                    buffer.append("<empty list>\n");
                }
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    private static void treeToBufferWithUserData(@NotNull Appendable buffer, @NotNull PsiElement root, int indent, boolean skipWhiteSpaces) {
        if (buffer == null) {
            DebugUtil.$$$reportNull$$$0(22);
        }
        if (root == null) {
            DebugUtil.$$$reportNull$$$0(23);
        }
        if (skipWhiteSpaces && root instanceof PsiWhiteSpace) {
            return;
        }
        StringUtil.repeatSymbol(buffer, ' ', indent);
        try {
            PsiElement[] children2;
            if (root instanceof CompositeElement) {
                buffer.append(root.toString());
            } else {
                String text2 = DebugUtil.fixWhiteSpaces(root.getText());
                buffer.append(root.toString()).append("('").append(text2).append("')");
            }
            buffer.append(((UserDataHolderBase)((Object)root)).getUserDataString());
            buffer.append("\n");
            for (PsiElement child2 : children2 = root.getChildren()) {
                DebugUtil.treeToBufferWithUserData(buffer, child2, indent + 2, skipWhiteSpaces);
            }
            if (children2.length == 0) {
                StringUtil.repeatSymbol(buffer, ' ', indent + 2);
                buffer.append("<empty list>\n");
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    private static void doCheckTreeStructure(@Nullable ASTNode anyElement) {
        if (anyElement == null) {
            return;
        }
        ASTNode root = anyElement;
        while (root.getTreeParent() != null) {
            root = root.getTreeParent();
        }
        if (root instanceof CompositeElement) {
            DebugUtil.checkSubtree((CompositeElement)root);
        }
    }

    private static void checkSubtree(@NotNull CompositeElement root) {
        if (root == null) {
            DebugUtil.$$$reportNull$$$0(24);
        }
        if (root.rawFirstChild() == null) {
            if (root.rawLastChild() != null) {
                throw new IncorrectTreeStructureException(root, "firstChild == null, but lastChild != null");
            }
        } else {
            for (ASTNode child2 = root.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
                if (child2 instanceof CompositeElement) {
                    DebugUtil.checkSubtree((CompositeElement)child2);
                }
                if (child2.getTreeParent() != root) {
                    throw new IncorrectTreeStructureException(child2, "child has wrong parent value");
                }
                if (child2 == root.getFirstChildNode()) {
                    if (child2.getTreePrev() != null) {
                        throw new IncorrectTreeStructureException(root, "firstChild.prev != null");
                    }
                } else {
                    if (child2.getTreePrev() == null) {
                        throw new IncorrectTreeStructureException(child2, "not first child has prev == null");
                    }
                    if (child2.getTreePrev().getTreeNext() != child2) {
                        throw new IncorrectTreeStructureException(child2, "element.prev.next != element");
                    }
                }
                if (child2.getTreeNext() != null || root.getLastChildNode() == child2) continue;
                throw new IncorrectTreeStructureException(child2, "not last child has next == null");
            }
        }
    }

    public static void checkParentChildConsistent(@NotNull ASTNode element2) {
        ASTNode treeParent;
        if (element2 == null) {
            DebugUtil.$$$reportNull$$$0(25);
        }
        if ((treeParent = element2.getTreeParent()) == null) {
            return;
        }
        ASTNode[] elements2 = treeParent.getChildren(null);
        if (ArrayUtil.find(elements2, element2) == -1) {
            throw new IncorrectTreeStructureException(element2, "child cannot be found among parents children");
        }
    }

    public static void checkSameCharTabs(@NotNull ASTNode element1, @NotNull ASTNode element2) {
        CharTable toCharTab;
        CharTable fromCharTab;
        if (element1 == null) {
            DebugUtil.$$$reportNull$$$0(26);
        }
        if (element2 == null) {
            DebugUtil.$$$reportNull$$$0(27);
        }
        LOG.assertTrue((fromCharTab = SharedImplUtil.findCharTableByTree(element1)) == (toCharTab = SharedImplUtil.findCharTableByTree(element2)));
    }

    @NotNull
    public static String psiToString(@NotNull PsiElement element2, boolean skipWhitespaces) {
        if (element2 == null) {
            DebugUtil.$$$reportNull$$$0(28);
        }
        return DebugUtil.psiToString(element2, skipWhitespaces, false);
    }

    @NotNull
    public static String psiToString(@NotNull PsiElement root, boolean skipWhiteSpaces, boolean showRanges) {
        if (root == null) {
            DebugUtil.$$$reportNull$$$0(29);
        }
        return DebugUtil.psiToString(root, skipWhiteSpaces, showRanges, null);
    }

    @NotNull
    public static String psiToString(@NotNull PsiElement root, boolean skipWhiteSpaces, boolean showRanges, @Nullable PairConsumer<? super PsiElement, Consumer<PsiElement>> extra) {
        if (root == null) {
            DebugUtil.$$$reportNull$$$0(30);
        }
        StringBuilder buffer = new StringBuilder();
        DebugUtil.psiToBuffer(buffer, root, skipWhiteSpaces, showRanges, extra);
        String string = buffer.toString();
        if (string == null) {
            DebugUtil.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    public static String psiToStringIgnoringNonCode(@NotNull PsiElement element2) {
        if (element2 == null) {
            DebugUtil.$$$reportNull$$$0(32);
        }
        StringBuilder buffer = new StringBuilder();
        ((TreeElement)element2.getNode()).acceptTree(new TreeToBuffer((Appendable)buffer, 0, true, false, false, false, null){

            @Override
            protected boolean shouldSkipNode(TreeElement node) {
                return super.shouldSkipNode(node) || node instanceof PsiErrorElement || node instanceof PsiComment || node instanceof LeafPsiElement && StringUtil.isEmptyOrSpaces(node.getText()) || node instanceof OuterLanguageElement;
            }

            @Override
            protected boolean showEmptyChildren() {
                return false;
            }
        });
        String string = buffer.toString();
        if (string == null) {
            DebugUtil.$$$reportNull$$$0(33);
        }
        return string;
    }

    private static void psiToBuffer(@NotNull Appendable buffer, @NotNull PsiElement root, boolean skipWhiteSpaces, boolean showRanges, @Nullable PairConsumer<? super PsiElement, Consumer<PsiElement>> extra) {
        ASTNode node;
        if (buffer == null) {
            DebugUtil.$$$reportNull$$$0(34);
        }
        if (root == null) {
            DebugUtil.$$$reportNull$$$0(35);
        }
        if ((node = root.getNode()) == null) {
            DebugUtil.psiToBuffer(buffer, root, 0, skipWhiteSpaces, showRanges, showRanges, extra);
        } else {
            DebugUtil.treeToBuffer(buffer, node, 0, skipWhiteSpaces, showRanges, showRanges, true, extra);
        }
    }

    public static void psiToBuffer(@NotNull Appendable buffer, @NotNull PsiElement root, int indent, boolean skipWhiteSpaces, boolean showRanges, boolean showChildrenRanges) {
        if (buffer == null) {
            DebugUtil.$$$reportNull$$$0(36);
        }
        if (root == null) {
            DebugUtil.$$$reportNull$$$0(37);
        }
        DebugUtil.psiToBuffer(buffer, root, indent, skipWhiteSpaces, showRanges, showChildrenRanges, null);
    }

    private static void psiToBuffer(@NotNull Appendable buffer, @NotNull PsiElement root, int indent, boolean skipWhiteSpaces, boolean showRanges, boolean showChildrenRanges, @Nullable PairConsumer<? super PsiElement, Consumer<PsiElement>> extra) {
        if (buffer == null) {
            DebugUtil.$$$reportNull$$$0(38);
        }
        if (root == null) {
            DebugUtil.$$$reportNull$$$0(39);
        }
        if (skipWhiteSpaces && root instanceof PsiWhiteSpace) {
            return;
        }
        StringUtil.repeatSymbol(buffer, ' ', indent);
        try {
            buffer.append(root.toString());
            PsiElement child2 = root.getFirstChild();
            if (child2 == null) {
                String text2 = root.getText();
                assert (text2 != null) : "text is null for <" + root + ">";
                buffer.append("('").append(DebugUtil.fixWhiteSpaces(text2)).append("')");
            }
            if (showRanges) {
                buffer.append(root.getTextRange().toString());
            }
            buffer.append("\n");
            while (child2 != null) {
                DebugUtil.psiToBuffer(buffer, child2, indent + 2, skipWhiteSpaces, showChildrenRanges, showChildrenRanges, extra);
                child2 = child2.getNextSibling();
            }
            if (extra != null) {
                extra.consume(root, element2 -> DebugUtil.psiToBuffer(buffer, element2, indent + 2, skipWhiteSpaces, showChildrenRanges, showChildrenRanges, null));
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
    }

    @NotNull
    private static String fixWhiteSpaces(@NotNull String text2) {
        if (text2 == null) {
            DebugUtil.$$$reportNull$$$0(40);
        }
        text2 = StringUtil.replace(text2, "\n", "\\n");
        text2 = StringUtil.replace(text2, "\r", "\\r");
        String string = text2 = StringUtil.replace(text2, "\t", "\\t");
        if (string == null) {
            DebugUtil.$$$reportNull$$$0(41);
        }
        return string;
    }

    @NotNull
    public static String currentStackTrace() {
        String string = ExceptionUtil.currentStackTrace();
        if (string == null) {
            DebugUtil.$$$reportNull$$$0(42);
        }
        return string;
    }

    @Deprecated
    public static void startPsiModification(@Nullable String trace) {
        Integer depth;
        if (!PsiInvalidElementAccessException.isTrackingInvalidation()) {
            return;
        }
        if (ourPsiModificationTrace.get() == null) {
            ourPsiModificationTrace.set(trace != null || ApplicationInfoImpl.isInStressTest() ? trace : new Throwable());
        }
        if ((depth = ourPsiModificationDepth.get()) == null) {
            depth = 0;
        }
        ourPsiModificationDepth.set(depth + 1);
    }

    @Deprecated
    public static void finishPsiModification() {
        if (!PsiInvalidElementAccessException.isTrackingInvalidation()) {
            return;
        }
        Integer depth = ourPsiModificationDepth.get();
        if (depth == null) {
            LOG.warn("Unmatched PSI modification end", new Throwable());
            depth = 0;
        } else {
            Integer n = depth;
            Integer n2 = depth = Integer.valueOf(depth - 1);
            ourPsiModificationDepth.set(depth);
        }
        if (depth == 0) {
            ourPsiModificationTrace.set(null);
        }
    }

    public static <T extends Throwable> void performPsiModification(String trace, @NotNull ThrowableRunnable<T> runnable2) throws T {
        if (runnable2 == null) {
            DebugUtil.$$$reportNull$$$0(43);
        }
        DebugUtil.startPsiModification(trace);
        try {
            runnable2.run();
        }
        finally {
            DebugUtil.finishPsiModification();
        }
    }

    public static <T, E extends Throwable> T performPsiModification(String trace, @NotNull ThrowableComputable<T, E> runnable2) throws E {
        if (runnable2 == null) {
            DebugUtil.$$$reportNull$$$0(44);
        }
        DebugUtil.startPsiModification(trace);
        try {
            T t = runnable2.compute();
            return t;
        }
        finally {
            DebugUtil.finishPsiModification();
        }
    }

    public static void onInvalidated(@NotNull ASTNode treeElement) {
        Object trace;
        if (treeElement == null) {
            DebugUtil.$$$reportNull$$$0(45);
        }
        if ((trace = DebugUtil.calcInvalidationTrace(treeElement)) != null) {
            PsiInvalidElementAccessException.setInvalidationTrace(treeElement, trace);
        }
    }

    public static void onInvalidated(@NotNull PsiElement o) {
        Object trace;
        if (o == null) {
            DebugUtil.$$$reportNull$$$0(46);
        }
        if ((trace = PsiInvalidElementAccessException.getInvalidationTrace(o)) != null) {
            return;
        }
        PsiInvalidElementAccessException.setInvalidationTrace(o, DebugUtil.currentInvalidationTrace());
    }

    public static void onInvalidated(@NotNull FileViewProvider provider) {
        Object trace;
        if (provider == null) {
            DebugUtil.$$$reportNull$$$0(47);
        }
        if ((trace = DebugUtil.calcInvalidationTrace(null)) != null) {
            PsiInvalidElementAccessException.setInvalidationTrace(provider, trace);
        }
    }

    @Nullable
    private static Object calcInvalidationTrace(@Nullable ASTNode treeElement) {
        if (!PsiInvalidElementAccessException.isTrackingInvalidation()) {
            return null;
        }
        if (PsiInvalidElementAccessException.findInvalidationTrace(treeElement) != null) {
            return null;
        }
        return DebugUtil.currentInvalidationTrace();
    }

    @NotNull
    private static Object currentInvalidationTrace() {
        Object trace = ourPsiModificationTrace.get();
        if (trace == null) {
            trace = new Throwable();
            ourErrorLogger.info("PSI invalidated outside transaction", (Throwable)trace);
        }
        Object object = trace;
        if (object == null) {
            DebugUtil.$$$reportNull$$$0(48);
        }
        return object;
    }

    public static void revalidateNode(@NotNull ASTNode element2) {
        if (element2 == null) {
            DebugUtil.$$$reportNull$$$0(49);
        }
        PsiInvalidElementAccessException.setInvalidationTrace(element2, null);
    }

    public static void sleep(long millis) {
        TimeoutUtil.sleep(millis);
    }

    public static void checkTreeStructure(ASTNode element2) {
        if (CHECK) {
            DebugUtil.doCheckTreeStructure(element2);
        }
    }

    @NotNull
    public static String diagnosePsiDocumentInconsistency(@NotNull PsiElement element2, @NotNull Document document) {
        int docLength;
        FileViewProvider actualViewProvider;
        if (element2 == null) {
            DebugUtil.$$$reportNull$$$0(50);
        }
        if (document == null) {
            DebugUtil.$$$reportNull$$$0(51);
        }
        PsiUtilCore.ensureValid(element2);
        PsiFile file2 = element2.getContainingFile();
        if (file2 == null) {
            String string = "no file for " + element2 + " of " + element2.getClass();
            if (string == null) {
                DebugUtil.$$$reportNull$$$0(52);
            }
            return string;
        }
        PsiUtilCore.ensureValid(file2);
        FileViewProvider viewProvider = file2.getViewProvider();
        PsiDocumentManager manager = PsiDocumentManager.getInstance(file2.getProject());
        Document actualDocument = viewProvider.getDocument();
        String fileDiagnostics = "File[" + file2 + " " + file2.getName() + ", " + file2.getLanguage() + ", " + viewProvider + "]";
        if (actualDocument != document) {
            String string = "wrong document for " + fileDiagnostics + "; expected " + document + "; actual " + actualDocument;
            if (string == null) {
                DebugUtil.$$$reportNull$$$0(53);
            }
            return string;
        }
        PsiFile cachedPsiFile = manager.getCachedPsiFile(document);
        FileViewProvider fileViewProvider = actualViewProvider = cachedPsiFile == null ? null : cachedPsiFile.getViewProvider();
        if (actualViewProvider != viewProvider) {
            String string = "wrong view provider for " + document + ", expected " + viewProvider + "; actual " + actualViewProvider;
            if (string == null) {
                DebugUtil.$$$reportNull$$$0(54);
            }
            return string;
        }
        if (!manager.isCommitted(document)) {
            String string = "not committed document " + document + ", " + fileDiagnostics;
            if (string == null) {
                DebugUtil.$$$reportNull$$$0(55);
            }
            return string;
        }
        int fileLength = file2.getTextLength();
        if (fileLength != (docLength = document.getTextLength())) {
            String string = "file/doc text length different, " + fileDiagnostics + " file.length=" + fileLength + "; doc.length=" + docLength;
            if (string == null) {
                DebugUtil.$$$reportNull$$$0(56);
            }
            return string;
        }
        String string = "unknown inconsistency in " + fileDiagnostics;
        if (string == null) {
            DebugUtil.$$$reportNull$$$0(57);
        }
        return string;
    }

    @NotNull
    public static <T> String graphToString(@NotNull InboundSemiGraph<T> graph2) {
        if (graph2 == null) {
            DebugUtil.$$$reportNull$$$0(58);
        }
        StringBuilder buffer = new StringBuilder();
        DebugUtil.printNodes(graph2.getNodes().iterator(), node -> graph2.getIn(node), 0, new HashSet(), buffer);
        String string = buffer.toString();
        if (string == null) {
            DebugUtil.$$$reportNull$$$0(59);
        }
        return string;
    }

    @NotNull
    public static <T> String graphToString(@NotNull OutboundSemiGraph<T> graph2) {
        if (graph2 == null) {
            DebugUtil.$$$reportNull$$$0(60);
        }
        StringBuilder buffer = new StringBuilder();
        DebugUtil.printNodes(graph2.getNodes().iterator(), node -> graph2.getOut(node), 0, new HashSet(), buffer);
        String string = buffer.toString();
        if (string == null) {
            DebugUtil.$$$reportNull$$$0(61);
        }
        return string;
    }

    private static <T> void printNodes(@NotNull Iterator<? extends T> nodes, @NotNull Function<? super T, ? extends Iterator<T>> getter, int indent, @NotNull Set<? super T> visited, @NotNull StringBuilder buffer) {
        if (nodes == null) {
            DebugUtil.$$$reportNull$$$0(62);
        }
        if (getter == null) {
            DebugUtil.$$$reportNull$$$0(63);
        }
        if (visited == null) {
            DebugUtil.$$$reportNull$$$0(64);
        }
        if (buffer == null) {
            DebugUtil.$$$reportNull$$$0(65);
        }
        while (nodes.hasNext()) {
            T node = nodes.next();
            StringUtil.repeatSymbol(buffer, ' ', indent);
            buffer.append(node);
            if (visited.add(node)) {
                buffer.append('\n');
                DebugUtil.printNodes(getter.fun(node), getter, indent + 2, visited, buffer);
                continue;
            }
            buffer.append(" [...]\n");
        }
    }

    static {
        Application application = ApplicationManager.getApplication();
        CHECK_INSIDE_ATOMIC_ACTION_ENABLED = DO_EXPENSIVE_CHECKS = application != null && application.isUnitTestMode();
        ourPsiModificationTrace = new ThreadLocal();
        ourPsiModificationDepth = new ThreadLocal();
        ourErrorLogger = FrequentErrorLogger.newInstance(LOG);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 12: 
            case 17: 
            case 31: 
            case 33: 
            case 41: 
            case 42: 
            case 48: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 61: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 12: 
            case 17: 
            case 31: 
            case 33: 
            case 41: 
            case 42: 
            case 48: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 61: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 16: 
            case 21: 
            case 23: 
            case 24: 
            case 29: 
            case 30: 
            case 35: 
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 12: 
            case 17: 
            case 31: 
            case 33: 
            case 41: 
            case 42: 
            case 48: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/DebugUtil";
                break;
            }
            case 7: 
            case 9: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 34: 
            case 36: 
            case 38: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element1";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeElement";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 58: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/DebugUtil";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "treeToString";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "nodeTreeToString";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "lightTreeToString";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "stubTreeToString";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "psiToString";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "psiToStringIgnoringNonCode";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "fixWhiteSpaces";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "currentStackTrace";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "currentInvalidationTrace";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "diagnosePsiDocumentInconsistency";
                break;
            }
            case 59: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "graphToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "psiTreeToString";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "treeToString";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 12: 
            case 17: 
            case 31: 
            case 33: 
            case 41: 
            case 42: 
            case 48: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 61: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "nodeTreeToString";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "treeToBuffer";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lightTreeToString";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lightTreeToBuffer";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "stubTreeToString";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "stubTreeToBuffer";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "treeToBufferWithUserData";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkSubtree";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkParentChildConsistent";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkSameCharTabs";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "psiToString";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "psiToStringIgnoringNonCode";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "psiToBuffer";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "fixWhiteSpaces";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "performPsiModification";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "onInvalidated";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "revalidateNode";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "diagnosePsiDocumentInconsistency";
                break;
            }
            case 58: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "graphToString";
                break;
            }
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "printNodes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 12: 
            case 17: 
            case 31: 
            case 33: 
            case 41: 
            case 42: 
            case 48: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 61: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class IncorrectTreeStructureException
    extends RuntimeException {
        private final ASTNode myElement;

        IncorrectTreeStructureException(ASTNode element2, String message) {
            super(message);
            this.myElement = element2;
        }

        public ASTNode getElement() {
            return this.myElement;
        }
    }

    private static class TreeToBuffer
    extends RecursiveTreeElementWalkingVisitor {
        final Appendable buffer;
        final boolean skipWhiteSpaces;
        final boolean showRanges;
        final boolean showChildrenRanges;
        final boolean usePsi;
        final PairConsumer<? super PsiElement, Consumer<PsiElement>> extra;
        int indent;

        TreeToBuffer(Appendable buffer, int indent, boolean skipWhiteSpaces, boolean showRanges, boolean showChildrenRanges, boolean usePsi, PairConsumer<? super PsiElement, Consumer<PsiElement>> extra) {
            this.buffer = buffer;
            this.skipWhiteSpaces = skipWhiteSpaces;
            this.showRanges = showRanges;
            this.showChildrenRanges = showChildrenRanges;
            this.usePsi = usePsi;
            this.extra = extra;
            this.indent = indent;
        }

        @Override
        protected void visitNode(TreeElement root) {
            if (this.shouldSkipNode(root)) {
                this.indent += 2;
                return;
            }
            StringUtil.repeatSymbol(this.buffer, ' ', this.indent);
            try {
                if (root instanceof CompositeElement) {
                    if (this.usePsi) {
                        PsiElement psiElement = root.getPsi();
                        if (psiElement != null) {
                            this.buffer.append(psiElement.toString());
                        } else {
                            this.buffer.append(root.getElementType().toString());
                        }
                    } else {
                        this.buffer.append(root.toString());
                    }
                } else {
                    String text2 = DebugUtil.fixWhiteSpaces(root.getText());
                    this.buffer.append(root.toString()).append("('").append(text2).append("')");
                }
                if (this.showRanges) {
                    this.buffer.append(root.getTextRange().toString());
                }
                this.buffer.append("\n");
                this.indent += 2;
                if (root instanceof CompositeElement && root.getFirstChildNode() == null && this.showEmptyChildren()) {
                    StringUtil.repeatSymbol(this.buffer, ' ', this.indent);
                    this.buffer.append("<empty list>\n");
                }
            }
            catch (IOException e) {
                LOG.error(e);
            }
            super.visitNode(root);
        }

        protected boolean showEmptyChildren() {
            return true;
        }

        protected boolean shouldSkipNode(TreeElement node) {
            return this.skipWhiteSpaces && node.getElementType() == TokenType.WHITE_SPACE;
        }

        @Override
        protected void elementFinished(@NotNull ASTNode e) {
            PsiElement psiElement;
            if (e == null) {
                TreeToBuffer.$$$reportNull$$$0(0);
            }
            PsiElement psiElement2 = psiElement = this.extra != null && this.usePsi && e instanceof CompositeElement ? e.getPsi() : null;
            if (psiElement != null) {
                this.extra.consume(psiElement, element2 -> DebugUtil.treeToBuffer(this.buffer, element2.getNode(), this.indent, this.skipWhiteSpaces, this.showRanges, this.showChildrenRanges, true, null));
            }
            this.indent -= 2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/psi/impl/DebugUtil$TreeToBuffer", "elementFinished"));
        }
    }
}

