/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.psi.impl.cache.CommentTokenSetProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;

public class CacheUtil {
    public static boolean isInComments(IElementType tokenType) {
        TokenSet commentTokens;
        Language language2 = tokenType.getLanguage();
        for (CommentTokenSetProvider provider : CommentTokenSetProvider.EXTENSION.allForLanguage(language2)) {
            if (!provider.isInComments(tokenType)) continue;
            return true;
        }
        boolean inComments = false;
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language2);
        if (parserDefinition != null && (commentTokens = parserDefinition.getCommentTokens()).contains(tokenType)) {
            inComments = true;
        }
        return inComments;
    }
}

