/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class IndexCacheManagerImpl
implements CacheManager {
    private final Project myProject;

    public IndexCacheManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
    }

    @Override
    public PsiFile @NotNull [] getFilesWithWord(@NotNull String word, short occurenceMask, @NotNull GlobalSearchScope scope, boolean caseSensitively) {
        if (word == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(2);
        }
        if (this.myProject.isDefault()) {
            if (PsiFile.EMPTY_ARRAY == null) {
                IndexCacheManagerImpl.$$$reportNull$$$0(3);
            }
            return PsiFile.EMPTY_ARRAY;
        }
        ArrayList result2 = new ArrayList();
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        this.processFilesWithWord(processor2, word, occurenceMask, scope, caseSensitively);
        PsiFile[] psiFileArray = result2.isEmpty() ? PsiFile.EMPTY_ARRAY : result2.toArray(PsiFile.EMPTY_ARRAY);
        if (psiFileArray == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(4);
        }
        return psiFileArray;
    }

    @Override
    public VirtualFile @NotNull [] getVirtualFilesWithWord(@NotNull String word, short occurenceMask, @NotNull GlobalSearchScope scope, boolean caseSensitively) {
        if (word == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(6);
        }
        if (this.myProject.isDefault()) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                IndexCacheManagerImpl.$$$reportNull$$$0(7);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        ArrayList result2 = new ArrayList(5);
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        FileBasedIndex.getInstance().ignoreDumbMode(() -> this.collectVirtualFilesWithWord(word, occurenceMask, scope, caseSensitively, processor2), this.myProject, DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE);
        VirtualFile[] virtualFileArray = result2.isEmpty() ? VirtualFile.EMPTY_ARRAY : result2.toArray(VirtualFile.EMPTY_ARRAY);
        if (virtualFileArray == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(8);
        }
        return virtualFileArray;
    }

    private boolean collectVirtualFilesWithWord(@NotNull String word, short occurrenceMask, @NotNull GlobalSearchScope scope, boolean caseSensitively, @NotNull Processor<? super VirtualFile> fileProcessor) {
        if (word == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(10);
        }
        if (fileProcessor == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(11);
        }
        if (this.myProject.isDefault()) {
            return true;
        }
        try {
            return ReadAction.compute(() -> FileBasedIndex.getInstance().processValues(IdIndex.NAME, new IdIndexEntry(word, caseSensitively), null, (file2, value2) -> {
                ProgressIndicatorProvider.checkCanceled();
                int mask = value2;
                return (mask & occurrenceMask) == 0 || fileProcessor.process(file2);
            }, scope));
        }
        catch (IndexNotReadyException e) {
            throw new ProcessCanceledException();
        }
    }

    @Override
    public boolean processFilesWithWord(final @NotNull Processor<? super PsiFile> psiFileProcessor, @NotNull String word, short occurrenceMask, @NotNull GlobalSearchScope scope, boolean caseSensitively) {
        if (psiFileProcessor == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(12);
        }
        if (word == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(13);
        }
        if (scope == null) {
            IndexCacheManagerImpl.$$$reportNull$$$0(14);
        }
        ArrayList result2 = new ArrayList(5);
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        this.collectVirtualFilesWithWord(word, occurrenceMask, scope, caseSensitively, processor2);
        if (result2.isEmpty()) {
            return true;
        }
        final PsiManager psiManager = PsiManager.getInstance(this.myProject);
        ReadActionProcessor<VirtualFile> virtualFileProcessor = new ReadActionProcessor<VirtualFile>(){

            @Override
            public boolean processInReadAction(VirtualFile virtualFile2) {
                if (virtualFile2.isValid()) {
                    PsiFile psiFile = psiManager.findFile(virtualFile2);
                    return psiFile == null || psiFileProcessor.process(psiFile);
                }
                return true;
            }
        };
        for (VirtualFile vFile : result2) {
            ProgressIndicatorProvider.checkCanceled();
            if (virtualFileProcessor.process(vFile)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 2: 
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/cache/impl/IndexCacheManagerImpl";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileProcessor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFileProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/cache/impl/IndexCacheManagerImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesWithWord";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFilesWithWord";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFilesWithWord";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFilesWithWord";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectVirtualFilesWithWord";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processFilesWithWord";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

