/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntriesExternalizer;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.cache.impl.id.IdIndexer;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.util.indexing.CustomInputsIndexFileBasedIndexExtension;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.io.DataExternalizer;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class IdIndexImpl
extends IdIndex
implements CustomInputsIndexFileBasedIndexExtension<IdIndexEntry> {
    @Override
    public int getVersion() {
        int version2 = super.getVersion();
        if (!InvertedIndex.ARE_COMPOSITE_INDEXERS_ENABLED) {
            FileType[] types = FileTypeRegistry.getInstance().getRegisteredFileTypes();
            Arrays.sort(types, (o1, o2) -> Comparing.compare(o1.getName(), o2.getName()));
            for (FileType fileType : types) {
                IdIndexer indexer;
                if (!IdIndexImpl.isIndexable(fileType) || (indexer = IdTableBuilding.getFileTypeIndexer(fileType)) == null) continue;
                version2 = version2 * 31 + (indexer.getVersion() ^ indexer.getClass().getName().hashCode());
            }
        }
        return version2;
    }

    @Override
    @NotNull
    public DataExternalizer<Collection<IdIndexEntry>> createExternalizer() {
        return new IdIndexEntriesExternalizer();
    }
}

