/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.lang.cacheBuilder.VersionedWordsScanner;
import com.intellij.lang.cacheBuilder.WordOccurrence;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.cache.impl.id.IdIndexer;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IdDataConsumer;
import com.intellij.util.text.CharArrayUtil;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class ScanningIdIndexer
implements IdIndexer {
    protected abstract WordsScanner createScanner();

    @Override
    @NotNull
    public Map<IdIndexEntry, Integer> map(@NotNull FileContent inputData) {
        if (inputData == null) {
            ScanningIdIndexer.$$$reportNull$$$0(0);
        }
        final CharSequence chars = inputData.getContentAsText();
        final char[] charsArray = CharArrayUtil.fromSequenceWithoutCopying(chars);
        final IdDataConsumer consumer = new IdDataConsumer();
        this.createScanner().processWords(chars, (Processor<? super WordOccurrence>)new Processor<WordOccurrence>(){

            @Override
            public boolean process(WordOccurrence t) {
                if (charsArray != null && t.getBaseText() == chars) {
                    consumer.addOccurrence(charsArray, t.getStart(), t.getEnd(), this.convertToMask(t.getKind()));
                } else {
                    consumer.addOccurrence(t.getBaseText(), t.getStart(), t.getEnd(), this.convertToMask(t.getKind()));
                }
                return true;
            }

            private int convertToMask(WordOccurrence.Kind kind) {
                if (kind == null) {
                    return 255;
                }
                if (kind == WordOccurrence.Kind.CODE) {
                    return 1;
                }
                if (kind == WordOccurrence.Kind.COMMENTS) {
                    return 2;
                }
                if (kind == WordOccurrence.Kind.LITERALS) {
                    return 4;
                }
                if (kind == WordOccurrence.Kind.FOREIGN_LANGUAGE) {
                    return 8;
                }
                return 0;
            }
        });
        Map<IdIndexEntry, Integer> map2 = consumer.getResult();
        if (map2 == null) {
            ScanningIdIndexer.$$$reportNull$$$0(1);
        }
        return map2;
    }

    @Override
    public int getVersion() {
        WordsScanner scanner = this.createScanner();
        return scanner instanceof VersionedWordsScanner ? ((VersionedWordsScanner)scanner).getVersion() : -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/cache/impl/id/ScanningIdIndexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/cache/impl/id/ScanningIdIndexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

