/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.todo;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileTypes.FileTypeExtension;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.cache.impl.todo.TodoIndexEntry;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileContent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TodoIndexers
extends FileTypeExtension<DataIndexer<TodoIndexEntry, Integer, FileContent>> {
    public static final TodoIndexers INSTANCE = new TodoIndexers();
    private static final ExtensionPointName<ExtraPlaceChecker> EP_NAME = ExtensionPointName.create("com.intellij.todoExtraPlaces");

    private TodoIndexers() {
        super("com.intellij.todoIndexer");
    }

    public static boolean needsTodoIndex(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TodoIndexers.$$$reportNull$$$0(0);
        }
        for (ExtraPlaceChecker checker : EP_NAME.getExtensionList()) {
            if (!checker.accept(null, file2)) continue;
            return true;
        }
        return file2.isInLocalFileSystem() && TodoIndexers.isInContentOfAnyProject(file2);
    }

    public static boolean belongsToProject(@NotNull Project project2, @NotNull VirtualFile file2) {
        if (project2 == null) {
            TodoIndexers.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            TodoIndexers.$$$reportNull$$$0(2);
        }
        for (ExtraPlaceChecker checker : EP_NAME.getExtensionList()) {
            if (!checker.accept(project2, file2)) continue;
            return true;
        }
        return ProjectFileIndex.getInstance(project2).isInContent(file2);
    }

    private static boolean isInContentOfAnyProject(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TodoIndexers.$$$reportNull$$$0(3);
        }
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            if (project2.isDisposed() || !ProjectFileIndex.getInstance(project2).isInContent(file2)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/cache/impl/todo/TodoIndexers";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "needsTodoIndex";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "belongsToProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isInContentOfAnyProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface ExtraPlaceChecker {
        public boolean accept(@Nullable Project var1, @NotNull VirtualFile var2);
    }
}

