/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.model.search.SearchParameters;
import com.intellij.model.search.Searcher;
import com.intellij.model.search.impl.LayeredQuery;
import com.intellij.model.search.impl.ParametersRequest;
import com.intellij.model.search.impl.PrimitiveRequests;
import com.intellij.model.search.impl.QueryRequest;
import com.intellij.model.search.impl.Requests;
import com.intellij.model.search.impl.RequestsKt;
import com.intellij.model.search.impl.TransformationKt;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClassExtension;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.impl.search.Layer;
import com.intellij.psi.impl.search.LayerResult;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001f\n\u0000\u001a<\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\t0\b\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0014\u0010\r\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\t0\u000f0\u000eH\u0002\u001a*\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\t0\u000f0\u000e\"\u0004\b\u0000\u0010\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\t0\u0012H\u0002\u001a*\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\t0\u000f0\u000e\"\u0004\b\u0000\u0010\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\t0\u0012H\u0002\u001aL\u0010\u0014\u001a\u00020\u0015\"\u0004\b\u0000\u0010\u0016\"\u0004\b\u0001\u0010\t2\u0006\u0010\n\u001a\u00020\u00012\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\t0\u00182\u001a\u0010\u0019\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\t0\u000f\u0012\u0004\u0012\u00020\u00150\u001aH\u0002\u001aT\u0010\u001b\u001a\u00020\u0015\"\u0004\b\u0000\u0010\u0016\"\u0004\b\u0001\u0010\t2\u0006\u0010\n\u001a\u00020\u00012\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u0002H\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\t0\u000f0\u00182\u001a\u0010\u0019\u001a\u0016\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\t0\u000f\u0012\u0004\u0012\u00020\u00150\u001aH\u0002\u001a>\u0010\u001c\u001a\u00020\u001d\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u00012\u0016\u0010\u001e\u001a\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u0002H\t0\u001f0\u000e2\u000e\u0010 \u001a\n\u0012\u0006\b\u0000\u0012\u0002H\t0!H\u0002\u001ad\u0010\"\u001a\u00020\u001d\"\u0004\b\u0000\u0010\u0016\"\u0004\b\u0001\u0010\t2\u000e\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00160\u000f2.\u0010$\u001a*\u0012&\u0012$\u0012\u0004\u0012\u0002H\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\u000e0\u001aj\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\t`%0\u000e2\u000e\u0010 \u001a\n\u0012\u0006\b\u0000\u0012\u0002H\t0!H\u0002\u001a6\u0010&\u001a\u00020\u001d\"\u0004\b\u0000\u0010\t2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\t0\u000f2\u000e\u0010 \u001a\n\u0012\u0006\b\u0000\u0012\u0002H\t0!H\u0007\u001a$\u0010'\u001a\b\u0012\u0004\u0012\u0002H(0!\"\u0004\b\u0000\u0010(2\u000e\u0010)\u001a\n\u0012\u0006\b\u0000\u0012\u0002H(0*H\u0002\"\u0014\u0010\u0000\u001a\u00020\u00018@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"indicatorOrEmpty", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getIndicatorOrEmpty", "()Lcom/intellij/openapi/progress/ProgressIndicator;", "searchersExtension", "Lcom/intellij/openapi/util/ClassExtension;", "Lcom/intellij/model/search/Searcher;", "buildLayer", "Lcom/intellij/psi/impl/search/Layer;", "R", "progress", "project", "Lcom/intellij/openapi/project/Project;", "queries", "", "Lcom/intellij/util/Query;", "collectSearchRequests", "parameters", "Lcom/intellij/model/search/SearchParameters;", "doCollectSearchRequests", "handleParamRequest", "", "B", "request", "Lcom/intellij/model/search/impl/ParametersRequest;", "queue", "Lkotlin/Function1;", "handleSubQueryParamRequest", "processQueryRequests", "", "requests", "Lcom/intellij/model/search/impl/QueryRequest;", "processor", "Lcom/intellij/util/Processor;", "runQueryRequest", "query", "transformations", "Lcom/intellij/model/search/impl/Transformation;", "runSearch", "synchronizedCollectProcessor", "T", "subQueries", "", "intellij.platform.indexing.impl"})
public final class HelperKt {
    private static final ClassExtension<Searcher<?, ?>> searchersExtension = new ClassExtension("com.intellij.searcher");

    @NotNull
    public static final ProgressIndicator getIndicatorOrEmpty() {
        ProgressIndicator progressIndicator2 = EmptyProgressIndicator.notNullize(ProgressIndicatorProvider.getGlobalProgressIndicator());
        Intrinsics.checkExpressionValueIsNotNull((Object)progressIndicator2, (String)"EmptyProgressIndicator.n\u2026lobalProgressIndicator())");
        return progressIndicator2;
    }

    @ApiStatus.Internal
    public static final <R> boolean runSearch(@NotNull Project project2, @NotNull Query<? extends R> query, @NotNull Processor<? super R> processor2) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull(query, (String)"query");
            Intrinsics.checkParameterIsNotNull(processor2, (String)"processor");
            ProgressIndicator progress2 = HelperKt.getIndicatorOrEmpty();
            Collection currentQueries = CollectionsKt.listOf(query);
            while (true) {
                Collection collection = currentQueries;
                boolean bl = false;
                if (!(!collection.isEmpty())) break block2;
                progress2.checkCanceled();
                Layer<R> layer = HelperKt.buildLayer(progress2, project2, currentQueries);
                LayerResult<? super R> layerResult = layer.runLayer(processor2);
                if (layerResult instanceof LayerResult.Ok) {
                    currentQueries = ((LayerResult.Ok)layerResult).getSubqueries();
                    continue;
                }
                if (layerResult instanceof LayerResult.Stop) break;
            }
            return false;
        }
        return true;
    }

    private static final <R> Layer<? extends R> buildLayer(ProgressIndicator progress2, Project project2, Collection<? extends Query<? extends R>> queries) {
        Queue queue = new ArrayDeque();
        queue.addAll(queries);
        SmartList queryRequests = new SmartList();
        SmartList subQueryQueryRequests = new SmartList();
        SmartList wordRequests = new SmartList();
        SmartList subQueryWordRequests = new SmartList();
        block0: while (true) {
            Collection collection = queue;
            boolean bl = false;
            if (!(!collection.isEmpty())) break;
            progress2.checkCanceled();
            Object e = queue.remove();
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"queue.remove()");
            Query query = (Query)e;
            PrimitiveRequests primitives = RequestsKt.decompose(query);
            Requests resultRequests = primitives.getResultRequests();
            queryRequests.addAll(resultRequests.getQueryRequests());
            wordRequests.addAll(resultRequests.getWordRequests());
            for (ParametersRequest parametersRequest : resultRequests.getParametersRequests()) {
                progress2.checkCanceled();
                HelperKt.handleParamRequest(progress2, parametersRequest, (Function1)new Function1<Query<? extends R>, Unit>(queue){
                    final /* synthetic */ Queue $queue;

                    public final void invoke(@NotNull Query<? extends R> it) {
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        this.$queue.offer(it);
                    }
                    {
                        this.$queue = queue;
                        super(1);
                    }
                });
            }
            Requests subQueryRequests = primitives.getSubQueryRequests();
            subQueryQueryRequests.addAll(subQueryRequests.getQueryRequests());
            subQueryWordRequests.addAll(subQueryRequests.getWordRequests());
            Iterator iterator2 = subQueryRequests.getParametersRequests().iterator();
            while (true) {
                if (!iterator2.hasNext()) continue block0;
                ParametersRequest parametersRequest = iterator2.next();
                progress2.checkCanceled();
                HelperKt.handleSubQueryParamRequest(progress2, parametersRequest, (Function1)new Function1<Query<? extends R>, Unit>(queue){
                    final /* synthetic */ Queue $queue;

                    public final void invoke(@NotNull Query<? extends R> it) {
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        this.$queue.offer(it);
                    }
                    {
                        this.$queue = queue;
                        super(1);
                    }
                });
            }
            break;
        }
        return new Layer(project2, progress2, queryRequests, wordRequests, subQueryQueryRequests, subQueryWordRequests);
    }

    private static final <B, R> void handleParamRequest(ProgressIndicator progress2, ParametersRequest<B, ? extends R> request2, Function1<? super Query<? extends R>, Unit> queue) {
        Collection<Query<B>> searchRequests = HelperKt.collectSearchRequests(request2.getParams());
        for (Query<B> query : searchRequests) {
            progress2.checkCanceled();
            queue.invoke(TransformationKt.transformingQuery(query, request2.getTransformation()));
        }
    }

    private static final <B, R> void handleSubQueryParamRequest(ProgressIndicator progress2, ParametersRequest<B, ? extends Query<? extends R>> request2, Function1<? super Query<? extends R>, Unit> queue) {
        Collection<Query<B>> searchRequests = HelperKt.collectSearchRequests(request2.getParams());
        for (Query<B> query : searchRequests) {
            progress2.checkCanceled();
            queue.invoke(new LayeredQuery(query, request2.getTransformation()));
        }
    }

    private static final <R> Collection<Query<? extends R>> collectSearchRequests(SearchParameters<R> parameters) {
        Object t = DumbService.getInstance(parameters.getProject()).runReadActionInSmartMode(new Computable<Collection<? extends Query<? extends R>>>(parameters){
            final /* synthetic */ SearchParameters $parameters;

            @NotNull
            public final Collection<Query<? extends R>> compute() {
                return this.$parameters.areValid() ? HelperKt.access$doCollectSearchRequests(this.$parameters) : (Collection)CollectionsKt.emptyList();
            }
            {
                this.$parameters = searchParameters;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"DumbService.getInstance(\u2026   emptyList()\n    }\n  })");
        return (Collection)t;
    }

    private static final <R> Collection<Query<? extends R>> doCollectSearchRequests(SearchParameters<R> parameters) {
        ArrayList queries = new ArrayList();
        List list2 = searchersExtension.forKey(parameters.getClass());
        if (list2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<com.intellij.model.search.Searcher<com.intellij.model.search.SearchParameters<R>, R>>");
        }
        List searchers = list2;
        for (Searcher searcher : searchers) {
            ProgressManager.checkCanceled();
            Collection collection = queries;
            Collection collection2 = searcher.collectSearchRequests(parameters);
            Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"searcher.collectSearchRequests(parameters)");
            Iterable iterable = collection2;
            boolean bl = false;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        }
        return queries;
    }

    /*
     * WARNING - void declaration
     */
    private static final <R> boolean processQueryRequests(ProgressIndicator progress2, Collection<? extends QueryRequest<?, ? extends R>> requests, Processor<? super R> processor2) {
        Object $this$groupByTo$iv$iv;
        if (requests.isEmpty()) {
            return true;
        }
        Iterable $this$groupBy$iv = requests;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv22 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object object;
            Object element$iv$iv = iterator2.next();
            QueryRequest it2 = (QueryRequest)element$iv$iv;
            boolean $i$a$-groupBy-HelperKt$processQueryRequests$map$32 = false;
            Query key$iv$iv = it2.getQuery();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv22;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                ArrayList answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            QueryRequest $i$a$-groupBy-HelperKt$processQueryRequests$map$32 = (QueryRequest)element$iv$iv;
            List list2 = list$iv$iv;
            boolean bl = false;
            Function1 function1 = it.getTransformation();
            list2.add(function1);
        }
        Map map2 = destination$iv$iv22;
        $this$groupByTo$iv$iv = map2;
        boolean destination$iv$iv22 = false;
        $this$groupByTo$iv$iv = $this$groupByTo$iv$iv.entrySet().iterator();
        destination$iv$iv22 = false;
        Object object = $this$groupByTo$iv$iv;
        while (object.hasNext()) {
            void query;
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)object.next();
            boolean bl = false;
            $this$groupByTo$iv$iv = (Query)entry2.getKey();
            entry2 = entry;
            bl = false;
            List transforms = (List)entry2.getValue();
            progress2.checkCanceled();
            void v1 = query;
            if (v1 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.Query<kotlin.Any>");
            }
            List list3 = transforms;
            if (list3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Collection<com.intellij.model.search.impl.Transformation<kotlin.Any, R> /* = (kotlin.Any) -> kotlin.collections.Collection<R> */>");
            }
            if (HelperKt.runQueryRequest(v1, list3, processor2)) continue;
            return false;
        }
        return true;
    }

    private static final <B, R> boolean runQueryRequest(Query<? extends B> query, Collection<? extends Function1<? super B, ? extends Collection<? extends R>>> transformations, Processor<? super R> processor2) {
        return query.forEach(new Processor<B>(transformations, processor2){
            final /* synthetic */ Collection $transformations;
            final /* synthetic */ Processor $processor;

            public final boolean invoke(B baseValue) {
                for (Function1 transformation : this.$transformations) {
                    for (E resultValue : (Collection)transformation.invoke(baseValue)) {
                        if (this.$processor.process(resultValue)) continue;
                        return false;
                    }
                }
                return true;
            }
            {
                this.$transformations = collection;
                this.$processor = processor2;
            }
        });
    }

    private static final <T> Processor<T> synchronizedCollectProcessor(Collection<? super T> subQueries) {
        Object object = ObjectUtils.sentinel("synchronizedCollectProcessor");
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ObjectUtils.sentinel(\"sy\u2026ronizedCollectProcessor\")");
        Object lock = object;
        return new Processor<T>(lock, subQueries){
            final /* synthetic */ Object $lock;
            final /* synthetic */ Collection $subQueries;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final boolean process(T it) {
                Object object = this.$lock;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (object) {
                    boolean bl3 = false;
                    Collection collection = this.$subQueries;
                    T t = it;
                    boolean bl4 = false;
                    collection.add(t);
                    Unit unit = Unit.INSTANCE;
                }
                return true;
            }
            {
                this.$lock = object;
                this.$subQueries = collection;
            }
        };
    }

    public static final /* synthetic */ boolean access$processQueryRequests(ProgressIndicator progress2, Collection requests, Processor processor2) {
        return HelperKt.processQueryRequests(progress2, requests, processor2);
    }

    public static final /* synthetic */ Processor access$synchronizedCollectProcessor(Collection subQueries) {
        return HelperKt.synchronizedCollectProcessor(subQueries);
    }

    public static final /* synthetic */ Collection access$doCollectSearchRequests(SearchParameters parameters) {
        return HelperKt.doCollectSearchRequests(parameters);
    }
}

