/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringSearcher;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LowLevelSearchUtil {
    private static final Logger LOG = Logger.getInstance(LowLevelSearchUtil.class);
    private static final ConcurrentMap<CharSequence, Map<StringSearcher, int[]>> cache = ContainerUtil.createConcurrentWeakMap(ContainerUtil.identityStrategy());

    private static Boolean processInjectedFile(PsiElement element2, @NotNull StringSearcher searcher, int start2, @NotNull ProgressIndicator progress2, InjectedLanguageManager injectedLanguageManager, @NotNull TextOccurenceProcessor processor2) {
        if (searcher == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(0);
        }
        if (progress2 == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(1);
        }
        if (processor2 == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(2);
        }
        if (!(element2 instanceof PsiLanguageInjectionHost)) {
            return null;
        }
        if (injectedLanguageManager == null) {
            return null;
        }
        List<Pair<PsiElement, TextRange>> list2 = injectedLanguageManager.getInjectedPsiFiles(element2);
        if (list2 == null) {
            return null;
        }
        boolean hasMatchedRange = false;
        for (Pair<PsiElement, TextRange> pair : list2) {
            if (!((TextRange)pair.second).containsRange(start2, start2 + searcher.getPatternLength())) continue;
            hasMatchedRange = true;
            PsiElement injected = pair.getFirst();
            if (LowLevelSearchUtil.processElementsContainingWordInElement(processor2, injected, searcher, false, progress2)) continue;
            return Boolean.FALSE;
        }
        return hasMatchedRange ? Boolean.TRUE : null;
    }

    private static boolean processTreeUp(@NotNull Project project2, @NotNull PsiElement scope, @NotNull ASTNode leafNode, int offsetInLeaf, @NotNull StringSearcher searcher, boolean processInjectedPsi, @NotNull ProgressIndicator progress2, @NotNull TextOccurenceProcessor processor2) {
        if (project2 == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(3);
        }
        if (scope == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(4);
        }
        if (leafNode == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(5);
        }
        if (searcher == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(6);
        }
        if (progress2 == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(7);
        }
        if (processor2 == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(8);
        }
        int patternLength = searcher.getPatternLength();
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance(project2);
        ASTNode currentNode = leafNode;
        int currentOffset = offsetInLeaf;
        boolean contains = false;
        ASTNode prevNode = null;
        PsiElement run2 = null;
        while (run2 != scope) {
            ProgressManager.checkCanceled();
            currentOffset += prevNode == null ? 0 : prevNode.getStartOffsetInParent();
            prevNode = currentNode;
            run2 = currentNode.getPsi();
            if (!contains) {
                boolean bl = contains = run2.getTextLength() - currentOffset >= patternLength;
            }
            if (contains) {
                Boolean result2;
                if (processInjectedPsi && (result2 = LowLevelSearchUtil.processInjectedFile(run2, searcher, currentOffset, progress2, injectedLanguageManager, processor2)) != null) {
                    return result2;
                }
                if (!processor2.execute(run2, currentOffset)) {
                    return false;
                }
            }
            if ((currentNode = currentNode.getTreeParent()) != null) continue;
        }
        assert (run2 == scope) : "Malbuilt PSI; scopeNode: " + scope + "; containingFile: " + PsiTreeUtil.getParentOfType(scope, PsiFile.class, false) + "; currentNode: " + run2 + "; isAncestor: " + PsiTreeUtil.isAncestor(scope, run2, false) + "; in same file: " + (PsiTreeUtil.getParentOfType(scope, PsiFile.class, false) == PsiTreeUtil.getParentOfType(run2, PsiFile.class, false));
        return true;
    }

    private static ASTNode findNextLeafElementAt(ASTNode scopeNode, ASTNode last, int offset) {
        int offsetR = offset;
        if (last != null) {
            offsetR -= last.getStartOffset() - scopeNode.getStartOffset() + last.getTextLength();
            while (offsetR >= 0) {
                ASTNode next = last.getTreeNext();
                if (next == null) {
                    last = last.getTreeParent();
                    continue;
                }
                int length = next.getTextLength();
                offsetR -= length;
                last = next;
            }
            scopeNode = last;
            offsetR += scopeNode.getTextLength();
        }
        return scopeNode.findLeafElementAt(offsetR);
    }

    public static boolean processElementsContainingWordInElement(@NotNull TextOccurenceProcessor processor2, @NotNull PsiElement scope, @NotNull StringSearcher searcher, boolean processInjectedPsi, @NotNull ProgressIndicator progress2) {
        if (processor2 == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(9);
        }
        if (scope == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(10);
        }
        if (searcher == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(11);
        }
        if (progress2 == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(12);
        }
        int[] occurrences = LowLevelSearchUtil.getTextOccurrencesInScope(scope, searcher);
        return LowLevelSearchUtil.processElementsAtOffsets(scope, searcher, processInjectedPsi, progress2, occurrences, processor2);
    }

    static int @NotNull [] getTextOccurrencesInScope(@NotNull PsiElement scope, @NotNull StringSearcher searcher) {
        if (scope == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(13);
        }
        if (searcher == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(14);
        }
        ProgressManager.checkCanceled();
        PsiFile file2 = scope.getContainingFile();
        FileViewProvider viewProvider = file2.getViewProvider();
        CharSequence buffer = viewProvider.getContents();
        TextRange range2 = scope.getTextRange();
        if (range2 == null) {
            LOG.error("Element " + scope + " of class " + scope.getClass() + " has null range");
            if (ArrayUtilRt.EMPTY_INT_ARRAY == null) {
                LowLevelSearchUtil.$$$reportNull$$$0(15);
            }
            return ArrayUtilRt.EMPTY_INT_ARRAY;
        }
        int startOffset = range2.getStartOffset();
        int endOffset = range2.getEndOffset();
        if (endOffset > buffer.length()) {
            LowLevelSearchUtil.diagnoseInvalidRange(scope, file2, viewProvider, buffer, range2);
            if (ArrayUtilRt.EMPTY_INT_ARRAY == null) {
                LowLevelSearchUtil.$$$reportNull$$$0(16);
            }
            return ArrayUtilRt.EMPTY_INT_ARRAY;
        }
        int[] offsets2 = LowLevelSearchUtil.getTextOccurrences(buffer, startOffset, endOffset, searcher);
        int i = 0;
        while (i < offsets2.length) {
            int n = i++;
            offsets2[n] = offsets2[n] - startOffset;
        }
        if (offsets2 == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(17);
        }
        return offsets2;
    }

    static boolean processElementsAtOffsets(@NotNull PsiElement scope, @NotNull StringSearcher searcher, boolean processInjectedPsi, @NotNull ProgressIndicator progress2, int @NotNull [] offsetsInScope, @NotNull TextOccurenceProcessor processor2) {
        if (scope == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(18);
        }
        if (searcher == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(19);
        }
        if (progress2 == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(20);
        }
        if (processor2 == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(21);
        }
        if (offsetsInScope == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(22);
        }
        if (offsetsInScope.length == 0) {
            return true;
        }
        ASTNode scopeNode = scope.getNode();
        if (scopeNode == null) {
            throw new IllegalArgumentException("Scope doesn't have node, can't scan: " + scope + "; containingFile: " + scope.getContainingFile());
        }
        Project project2 = scope.getProject();
        return LowLevelSearchUtil.processOffsets(scopeNode, offsetsInScope, progress2, (node, offsetInNode) -> LowLevelSearchUtil.processTreeUp(project2, scope, node, offsetInNode, searcher, processInjectedPsi, progress2, processor2));
    }

    static boolean processOffsets(@NotNull ASTNode node, int @NotNull [] offsetsInNode, @NotNull ProgressIndicator progress2, @NotNull NodeTextOccurrenceProcessor processor2) {
        if (node == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(23);
        }
        if (progress2 == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(24);
        }
        if (processor2 == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(25);
        }
        if (offsetsInNode == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(26);
        }
        int scopeStartOffset = node.getStartOffset();
        ASTNode lastElement = null;
        for (int offset : offsetsInNode) {
            progress2.checkCanceled();
            ASTNode leafNode = LowLevelSearchUtil.findNextLeafElementAt(node, lastElement, offset);
            if (leafNode == null) {
                LOG.error("Cannot find leaf: node=" + node + "; offset=" + offset + "; lastElement=" + lastElement);
                continue;
            }
            int offsetInLeaf = offset - leafNode.getStartOffset() + scopeStartOffset;
            if (offsetInLeaf < 0) {
                throw new AssertionError((Object)("offset=" + offset + "; scopeStartOffset=" + scopeStartOffset + "; node=" + node));
            }
            if (!processor2.execute(leafNode, offsetInLeaf)) {
                return false;
            }
            lastElement = leafNode;
        }
        return true;
    }

    private static void diagnoseInvalidRange(@NotNull PsiElement scope, PsiFile file2, FileViewProvider viewProvider, CharSequence buffer, TextRange range2) {
        if (scope == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(27);
        }
        String msg = "Range for element: '" + scope + "' = " + range2 + " is out of file '" + file2 + "' range: " + file2.getTextRange();
        msg = msg + "; file contents length: " + buffer.length();
        msg = msg + "\n file provider: " + viewProvider;
        Document document = viewProvider.getDocument();
        if (document != null) {
            msg = msg + "\n committed=" + PsiDocumentManager.getInstance(file2.getProject()).isCommitted(document);
        }
        for (Language language2 : viewProvider.getLanguages()) {
            PsiFile root = viewProvider.getPsi(language2);
            msg = msg + "\n root " + language2 + " length=" + root.getTextLength() + (root instanceof PsiFileImpl ? "; contentsLoaded=" + ((PsiFileImpl)root).isContentsLoaded() : "");
        }
        LOG.error(msg);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    public static boolean processTextOccurrences(@NotNull CharSequence text2, int startOffset, int endOffset, @NotNull StringSearcher searcher, @Nullable ProgressIndicator progress2, @NotNull TIntProcedure processor2) {
        if (text2 == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(28);
        }
        if (searcher == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(29);
        }
        if (processor2 == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(30);
        }
        return LowLevelSearchUtil.processTextOccurrences(text2, startOffset, endOffset, searcher, processor2);
    }

    public static boolean processTextOccurrences(@NotNull CharSequence text2, int startOffset, int endOffset, @NotNull StringSearcher searcher, @NotNull TIntProcedure processor2) {
        if (text2 == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(31);
        }
        if (searcher == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(32);
        }
        if (processor2 == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(33);
        }
        for (int offset : LowLevelSearchUtil.getTextOccurrences(text2, startOffset, endOffset, searcher)) {
            if (processor2.execute(offset)) continue;
            return false;
        }
        return true;
    }

    private static int @NotNull [] getTextOccurrences(@NotNull CharSequence text2, int startOffset, int endOffset, @NotNull StringSearcher searcher) {
        int occurrence;
        boolean hasCachedOccurrences;
        if (text2 == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(34);
        }
        if (searcher == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(35);
        }
        if (endOffset > text2.length()) {
            throw new IllegalArgumentException("end: " + endOffset + " > length: " + text2.length());
        }
        Map cachedMap = (Map)cache.get(text2);
        int[] cachedOccurrences = cachedMap == null ? null : (int[])cachedMap.get(searcher);
        boolean bl = hasCachedOccurrences = cachedOccurrences != null && cachedOccurrences[0] <= startOffset && cachedOccurrences[1] >= endOffset;
        if (!hasCachedOccurrences) {
            TIntArrayList occurrences = new TIntArrayList();
            int newStart = Math.min(startOffset, cachedOccurrences == null ? startOffset : cachedOccurrences[0]);
            int newEnd = Math.max(endOffset, cachedOccurrences == null ? endOffset : cachedOccurrences[1]);
            occurrences.add(newStart);
            occurrences.add(newEnd);
            for (int index = newStart; index < newEnd; ++index) {
                ProgressManager.checkCanceled();
                index = searcher.scan(text2, index, newEnd);
                if (index < 0) break;
                if (!LowLevelSearchUtil.checkJavaIdentifier(text2, searcher, index)) continue;
                occurrences.add(index);
            }
            cachedOccurrences = occurrences.toNativeArray();
            if (cachedMap == null) {
                cachedMap = ConcurrencyUtil.cacheOrGet(cache, text2, ContainerUtil.createConcurrentSoftMap());
            }
            cachedMap.put(searcher, cachedOccurrences);
        }
        TIntArrayList offsets2 = new TIntArrayList(cachedOccurrences.length - 2);
        for (int i = 2; i < cachedOccurrences.length && (occurrence = cachedOccurrences[i]) <= endOffset - searcher.getPatternLength(); ++i) {
            if (occurrence < startOffset) continue;
            offsets2.add(occurrence);
        }
        int[] nArray = offsets2.toNativeArray();
        if (nArray == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(36);
        }
        return nArray;
    }

    private static boolean checkJavaIdentifier(@NotNull CharSequence text2, @NotNull StringSearcher searcher, int index) {
        char c;
        if (text2 == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(37);
        }
        if (searcher == null) {
            LowLevelSearchUtil.$$$reportNull$$$0(38);
        }
        if (!searcher.isJavaIdentifier()) {
            return true;
        }
        if (index > 0 && (Character.isJavaIdentifierPart(c = text2.charAt(index - 1)) && c != '$' ? !searcher.isHandleEscapeSequences() || index < 2 || StringUtil.isEscapedBackslash(text2, 0, index - 2) : searcher.isHandleEscapeSequences() && !StringUtil.isEscapedBackslash(text2, 0, index - 1))) {
            return false;
        }
        int patternLength = searcher.getPattern().length();
        if (index + patternLength < text2.length()) {
            char c2 = text2.charAt(index + patternLength);
            return !Character.isJavaIdentifierPart(c2) || c2 == '$';
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 36: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 36: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searcher";
                break;
            }
            case 1: 
            case 7: 
            case 12: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 21: 
            case 25: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 10: 
            case 13: 
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafNode";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/LowLevelSearchUtil";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offsetsInScope";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offsetsInNode";
                break;
            }
            case 28: 
            case 31: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/LowLevelSearchUtil";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextOccurrencesInScope";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextOccurrences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processInjectedFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processTreeUp";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processElementsContainingWordInElement";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTextOccurrencesInScope";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 36: {
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processElementsAtOffsets";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processOffsets";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "diagnoseInvalidRange";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "processTextOccurrences";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getTextOccurrences";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "checkJavaIdentifier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 36: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface NodeTextOccurrenceProcessor {
        public boolean execute(@NotNull ASTNode var1, int var2);
    }
}

