/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class NonPhysicalReferenceSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public NonPhysicalReferenceSearcher() {
        super(true);
    }

    @Override
    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        LocalSearchScope currentScope;
        if (queryParameters == null) {
            NonPhysicalReferenceSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            NonPhysicalReferenceSearcher.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        SearchScope scope = queryParameters.getScopeDeterminedByUser();
        PsiElement element2 = queryParameters.getElementToSearch();
        PsiFile containingFile = element2.getContainingFile();
        if (!(scope instanceof GlobalSearchScope) && !NonPhysicalReferenceSearcher.isApplicableTo(containingFile)) {
            return;
        }
        if (scope instanceof LocalSearchScope) {
            if (queryParameters.isIgnoreAccessScope()) {
                return;
            }
            currentScope = (LocalSearchScope)scope;
        } else {
            currentScope = null;
        }
        Project project2 = element2.getProject();
        if (!project2.isInitialized()) {
            return;
        }
        PsiManager psiManager = PsiManager.getInstance(project2);
        for (VirtualFile virtualFile2 : FileEditorManager.getInstance(project2).getOpenFiles()) {
            PsiFile file2;
            if (!virtualFile2.isValid() || virtualFile2.getFileType().isBinary() || !NonPhysicalReferenceSearcher.isApplicableTo(file2 = psiManager.findFile(virtualFile2))) continue;
            LocalSearchScope fileScope = new LocalSearchScope(file2);
            LocalSearchScope searchScope = currentScope == null ? fileScope : fileScope.intersectWith(currentScope);
            ReferencesSearch.searchOptimized(element2, searchScope, true, queryParameters.getOptimizer(), consumer);
        }
    }

    private static boolean isApplicableTo(PsiFile file2) {
        if (file2 == null) {
            return false;
        }
        return !file2.getViewProvider().isPhysical() && !(file2 instanceof PsiCodeFragment) || ScratchUtil.isScratch(file2.getVirtualFile());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/impl/search/NonPhysicalReferenceSearcher";
        objectArray[2] = "processQuery";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

