/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.concurrency.AsyncFuture;
import com.intellij.concurrency.AsyncUtil;
import com.intellij.concurrency.JobLauncher;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBinaryFile;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.search.BulkOccurrenceProcessor;
import com.intellij.psi.impl.search.LowLevelSearchUtil;
import com.intellij.psi.impl.search.WordRequestInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiNonJavaFileReferenceProcessor;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.PsiSearchRequest;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.ScopeOptimizer;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.psi.search.UseScopeEnlarger;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.codeInsight.CommentUtilCore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.text.StringSearcher;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSearchHelperImpl
implements PsiSearchHelper {
    private static final ExtensionPointName<ScopeOptimizer> USE_SCOPE_OPTIMIZER_EP_NAME = ExtensionPointName.create("com.intellij.useScopeOptimizer");
    private static final Logger LOG = Logger.getInstance(PsiSearchHelperImpl.class);
    private final PsiManagerEx myManager;
    private final DumbService myDumbService;

    @Override
    @NotNull
    public SearchScope getUseScope(@NotNull PsiElement element2) {
        if (element2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(0);
        }
        SearchScope scope = element2.getUseScope();
        for (UseScopeEnlarger enlarger : UseScopeEnlarger.EP_NAME.getExtensions()) {
            ProgressManager.checkCanceled();
            SearchScope additionalScope = enlarger.getAdditionalUseScope(element2);
            if (additionalScope == null) continue;
            scope = scope.union(additionalScope);
        }
        SearchScope scopeToRestrict = ScopeOptimizer.calculateOverallRestrictedUseScope(USE_SCOPE_OPTIMIZER_EP_NAME.getExtensions(), element2);
        if (scopeToRestrict != null) {
            scope = scope.intersectWith(scopeToRestrict);
        }
        SearchScope searchScope = scope;
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(1);
        }
        return searchScope;
    }

    public PsiSearchHelperImpl(@NotNull Project project2) {
        if (project2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(2);
        }
        this.myManager = PsiManagerEx.getInstanceEx(project2);
        this.myDumbService = DumbService.getInstance(this.myManager.getProject());
    }

    @Deprecated
    public PsiSearchHelperImpl(@NotNull PsiManagerEx psiManager) {
        if (psiManager == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(3);
        }
        this.myManager = psiManager;
        this.myDumbService = DumbService.getInstance(this.myManager.getProject());
    }

    @Override
    public PsiElement @NotNull [] findCommentsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope) {
        if (identifier == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(4);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(5);
        }
        List result2 = Collections.synchronizedList(new ArrayList());
        Processor processor2 = Processors.cancelableCollectProcessor(result2);
        this.processCommentsContainingIdentifier(identifier, searchScope, processor2);
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result2);
        if (psiElementArray == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(6);
        }
        return psiElementArray;
    }

    @Override
    public boolean processCommentsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope, @NotNull Processor<? super PsiElement> processor2) {
        if (identifier == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(7);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(8);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(9);
        }
        TextOccurenceProcessor occurrenceProcessor2 = (element2, offsetInElement) -> {
            if (CommentUtilCore.isCommentTextElement(element2) && element2.findReferenceAt(offsetInElement) == null) {
                return processor2.process(element2);
            }
            return true;
        };
        return this.processElementsWithWord(occurrenceProcessor2, searchScope, identifier, (short)2, true);
    }

    @Override
    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor2, @NotNull SearchScope searchScope, @NotNull String text2, short searchContext, boolean caseSensitive) {
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(10);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(11);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(12);
        }
        return this.processElementsWithWord(processor2, searchScope, text2, searchContext, caseSensitive, PsiSearchHelperImpl.shouldProcessInjectedPsi(searchScope));
    }

    @Override
    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor2, @NotNull SearchScope searchScope, @NotNull String text2, short searchContext, boolean caseSensitive, boolean processInjectedPsi) {
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(13);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(14);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(15);
        }
        EnumSet<Options> options = EnumSet.of(Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE);
        if (caseSensitive) {
            options.add(Options.CASE_SENSITIVE_SEARCH);
        }
        if (processInjectedPsi) {
            options.add(Options.PROCESS_INJECTED_PSI);
        }
        return this.processElementsWithWord(processor2, searchScope, text2, searchContext, options, null);
    }

    @Override
    @NotNull
    public AsyncFuture<Boolean> processElementsWithWordAsync(@NotNull TextOccurenceProcessor processor2, @NotNull SearchScope searchScope, @NotNull String text2, short searchContext, boolean caseSensitively) {
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(16);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(17);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(18);
        }
        boolean result2 = this.processElementsWithWord(processor2, searchScope, text2, searchContext, caseSensitively, PsiSearchHelperImpl.shouldProcessInjectedPsi(searchScope));
        AsyncFuture<Boolean> asyncFuture = AsyncUtil.wrapBoolean(result2);
        if (asyncFuture == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(19);
        }
        return asyncFuture;
    }

    public boolean processElementsWithWord(@NotNull TextOccurenceProcessor processor2, @NotNull SearchScope searchScope, @NotNull String text2, short searchContext, @NotNull EnumSet<Options> options, @Nullable String containerName) {
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(20);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(21);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(22);
        }
        if (options == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(23);
        }
        return this.bulkProcessElementsWithWord(searchScope, text2, searchContext, options, containerName, (scope, offsetsInScope, searcher) -> LowLevelSearchUtil.processElementsAtOffsets(scope, searcher, options.contains((Object)Options.PROCESS_INJECTED_PSI), PsiSearchHelperImpl.getOrCreateIndicator(), offsetsInScope, processor2));
    }

    boolean bulkProcessElementsWithWord(@NotNull SearchScope searchScope, @NotNull String text2, short searchContext, @NotNull EnumSet<Options> options, @Nullable String containerName, final @NotNull BulkOccurrenceProcessor processor2) {
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(24);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(25);
        }
        if (options == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(26);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(27);
        }
        if (text2.isEmpty()) {
            throw new IllegalArgumentException("Cannot search for elements with empty text");
        }
        ProgressIndicator progress2 = PsiSearchHelperImpl.getOrCreateIndicator();
        if (searchScope instanceof GlobalSearchScope) {
            StringSearcher searcher = new StringSearcher(text2, options.contains((Object)Options.CASE_SENSITIVE_SEARCH), true, searchContext == 4, options.contains((Object)Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE));
            return this.processElementsWithTextInGlobalScope((GlobalSearchScope)searchScope, searcher, searchContext, options.contains((Object)Options.CASE_SENSITIVE_SEARCH), containerName, progress2, processor2);
        }
        LocalSearchScope scope = (LocalSearchScope)searchScope;
        PsiElement[] scopeElements = scope.getScope();
        final StringSearcher searcher = new StringSearcher(text2, options.contains((Object)Options.CASE_SENSITIVE_SEARCH), true, searchContext == 4, options.contains((Object)Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE));
        ReadActionProcessor<PsiElement> localProcessor = new ReadActionProcessor<PsiElement>(){

            @Override
            public boolean processInReadAction(PsiElement scopeElement) {
                if (!scopeElement.isValid()) {
                    return true;
                }
                if (!scopeElement.isPhysical() || scopeElement instanceof PsiCompiledElement) {
                    scopeElement = scopeElement.getNavigationElement();
                }
                if (scopeElement instanceof PsiCompiledElement) {
                    return true;
                }
                if (scopeElement.getTextRange() == null) {
                    LOG.debug("Element " + scopeElement + " of class " + scopeElement.getClass() + " has null range");
                    return true;
                }
                return processor2.execute(scopeElement, LowLevelSearchUtil.getTextOccurrencesInScope(scopeElement, searcher), searcher);
            }

            public String toString() {
                return processor2.toString();
            }
        };
        return JobLauncher.getInstance().invokeConcurrentlyUnderProgress(Arrays.asList(scopeElements), progress2, localProcessor);
    }

    @NotNull
    private static ProgressIndicator getOrCreateIndicator() {
        ProgressIndicator progress2 = ProgressIndicatorProvider.getGlobalProgressIndicator();
        if (progress2 == null) {
            progress2 = new EmptyProgressIndicator();
        }
        progress2.setIndeterminate(false);
        ProgressIndicator progressIndicator2 = progress2;
        if (progressIndicator2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(28);
        }
        return progressIndicator2;
    }

    public static boolean shouldProcessInjectedPsi(@NotNull SearchScope scope) {
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(29);
        }
        return !(scope instanceof LocalSearchScope) || !((LocalSearchScope)scope).isIgnoreInjectedPsi();
    }

    @NotNull
    static Processor<PsiElement> localProcessor(final @NotNull StringSearcher searcher, final @NotNull BulkOccurrenceProcessor processor2) {
        if (searcher == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(30);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(31);
        }
        return new ReadActionProcessor<PsiElement>(){

            @Override
            public boolean processInReadAction(PsiElement scopeElement) {
                if (scopeElement instanceof PsiCompiledElement) {
                    return true;
                }
                return scopeElement.isValid() && processor2.execute(scopeElement, LowLevelSearchUtil.getTextOccurrencesInScope(scopeElement, searcher), searcher);
            }

            public String toString() {
                return processor2.toString();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processElementsWithTextInGlobalScope(@NotNull GlobalSearchScope scope, @NotNull StringSearcher searcher, short searchContext, boolean caseSensitively, @Nullable String containerName, @NotNull ProgressIndicator progress2, @NotNull BulkOccurrenceProcessor processor2) {
        boolean result2;
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(32);
        }
        if (searcher == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(33);
        }
        if (progress2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(34);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(35);
        }
        progress2.pushState();
        try {
            progress2.setText(IndexingBundle.message("psi.scanning.files.progress", new Object[0]));
            String text2 = searcher.getPattern();
            THashSet fileSet = new THashSet();
            this.getFilesWithText(scope, searchContext, caseSensitively, text2, fileSet);
            progress2.setText(IndexingBundle.message("psi.search.for.word.progress", text2));
            Processor<PsiElement> localProcessor = PsiSearchHelperImpl.localProcessor(searcher, processor2);
            if (containerName != null) {
                ArrayList intersectionWithContainerFiles = new ArrayList();
                this.getFilesWithText(scope, searchContext, caseSensitively, text2 + " " + containerName, intersectionWithContainerFiles);
                if (!intersectionWithContainerFiles.isEmpty()) {
                    int totalSize = fileSet.size();
                    boolean result3 = this.processPsiFileRoots(intersectionWithContainerFiles, totalSize, 0, progress2, localProcessor);
                    if (result3) {
                        fileSet.removeAll(intersectionWithContainerFiles);
                        if (!fileSet.isEmpty()) {
                            result3 = this.processPsiFileRoots(new ArrayList(fileSet), totalSize, intersectionWithContainerFiles.size(), progress2, localProcessor);
                        }
                    }
                    boolean bl = result3;
                    return bl;
                }
            }
            result2 = fileSet.isEmpty() || this.processPsiFileRoots(new ArrayList(fileSet), fileSet.size(), 0, progress2, localProcessor);
        }
        finally {
            progress2.popState();
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processPsiFileRoots(@NotNull List<? extends VirtualFile> files2, int totalSize, int alreadyProcessedFiles, @NotNull ProgressIndicator progress2, @NotNull Processor<? super PsiFile> localProcessor) {
        if (files2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(36);
        }
        if (progress2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(37);
        }
        if (localProcessor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(38);
        }
        this.myManager.startBatchFilesProcessingMode();
        try {
            AtomicInteger counter = new AtomicInteger(alreadyProcessedFiles);
            AtomicBoolean stopped = new AtomicBoolean(false);
            ProgressIndicator originalIndicator = ProgressWrapper.unwrapAll(progress2);
            boolean bl = PsiSearchHelperImpl.processFilesConcurrentlyDespiteWriteActions(this.myManager.getProject(), files2, progress2, stopped, vfile -> {
                TooManyUsagesStatus.getFrom(originalIndicator).pauseProcessingIfTooManyUsages();
                try {
                    this.processVirtualFile((VirtualFile)vfile, stopped, localProcessor);
                }
                catch (ProcessCanceledException | IndexNotReadyException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error("Error during processing of: " + vfile.getName(), e);
                    throw e;
                }
                if (progress2.isRunning()) {
                    double fraction = (double)counter.incrementAndGet() / (double)totalSize;
                    progress2.setFraction(fraction);
                }
                return !stopped.get();
            });
            return bl;
        }
        finally {
            this.myManager.finishBatchFilesProcessingMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean processFilesConcurrentlyDespiteWriteActions(@NotNull Project project2, @NotNull List<? extends VirtualFile> files2, @NotNull ProgressIndicator progress2, @NotNull AtomicBoolean stopped, @NotNull Processor<? super VirtualFile> localProcessor) {
        ApplicationEx app;
        if (project2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(39);
        }
        if (files2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(40);
        }
        if (progress2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(41);
        }
        if (stopped == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(42);
        }
        if (localProcessor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(43);
        }
        if (!(app = (ApplicationEx)ApplicationManager.getApplication()).isDispatchThread()) {
            CoreProgressManager.assertUnderProgress(progress2);
        }
        List<? extends VirtualFile> processedFiles = Collections.synchronizedList(new ArrayList(files2.size()));
        while (true) {
            ProgressManager.checkCanceled();
            final SensitiveProgressWrapper wrapper2 = new SensitiveProgressWrapper(progress2);
            ApplicationListener listener2 = new ApplicationListener(){

                @Override
                public void beforeWriteActionStart(@NotNull Object action2) {
                    if (action2 == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    wrapper2.cancel();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/psi/impl/search/PsiSearchHelperImpl$3", "beforeWriteActionStart"));
                }
            };
            processedFiles.clear();
            Disposable disposable2 = Disposer.newDisposable();
            app.addApplicationListener(listener2, disposable2);
            boolean processorCanceled = false;
            try {
                if (app.isWriteAccessAllowed() || app.isReadAccessAllowed() && app.isWriteActionPending()) {
                    boolean bl = processorCanceled = !ContainerUtil.process(files2, localProcessor);
                    if (processorCanceled) {
                        stopped.set(true);
                    }
                    processedFiles.addAll(files2);
                } else if (app.isWriteActionPending()) {
                } else {
                    AtomicBoolean someTaskFailed = new AtomicBoolean();
                    Processor<VirtualFile> processor2 = vfile -> {
                        ProgressManager.checkCanceled();
                        if (someTaskFailed.get()) {
                            return false;
                        }
                        try {
                            app.executeByImpatientReader(() -> {
                                if (localProcessor.process((VirtualFile)vfile)) {
                                    processedFiles.add((VirtualFile)vfile);
                                } else {
                                    stopped.set(true);
                                }
                            });
                        }
                        catch (ProcessCanceledException e) {
                            someTaskFailed.set(true);
                            throw e;
                        }
                        return !stopped.get();
                    };
                    try {
                        JobLauncher.getInstance().invokeConcurrentlyUnderProgress(files2, wrapper2, processor2);
                        processorCanceled = stopped.get();
                    }
                    catch (ProcessCanceledException e) {
                        progress2.checkCanceled();
                    }
                }
            }
            finally {
                Disposer.dispose(disposable2);
            }
            if (processorCanceled) {
                return false;
            }
            if (processedFiles.size() == files2.size()) break;
            DumbService.getInstance(project2).runReadActionInSmartMode(EmptyRunnable.getInstance());
            THashSet<? extends VirtualFile> t = new THashSet<VirtualFile>(files2);
            List<? extends VirtualFile> list2 = processedFiles;
            synchronized (list2) {
                t.removeAll(processedFiles);
            }
            files2 = new ArrayList<VirtualFile>(t);
        }
        return true;
    }

    private void processVirtualFile(@NotNull VirtualFile vfile, @NotNull AtomicBoolean stopped, @NotNull Processor<? super PsiFile> localProcessor) throws ApplicationUtil.CannotRunReadActionException {
        PsiFile file2;
        if (vfile == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(44);
        }
        if (stopped == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(45);
        }
        if (localProcessor == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(46);
        }
        if ((file2 = ApplicationUtil.tryRunReadAction(() -> vfile.isValid() ? this.myManager.findFile(vfile) : null)) != null && !(file2 instanceof PsiBinaryFile)) {
            ApplicationUtil.tryRunReadAction(() -> {
                Project project2 = this.myManager.getProject();
                if (project2.isDisposed()) {
                    throw new ProcessCanceledException();
                }
                if (DumbService.isDumb(project2)) {
                    throw ApplicationUtil.CannotRunReadActionException.create();
                }
                List<PsiFile> psiRoots = file2.getViewProvider().getAllFiles();
                THashSet<PsiFile> processed2 = new THashSet<PsiFile>(psiRoots.size() * 2, 0.5f);
                for (PsiFile psiRoot : psiRoots) {
                    ProgressManager.checkCanceled();
                    assert (psiRoot != null) : "One of the roots of file " + file2 + " is null. All roots: " + psiRoots + "; ViewProvider: " + file2.getViewProvider() + "; Virtual file: " + file2.getViewProvider().getVirtualFile();
                    if (!processed2.add(psiRoot) || !psiRoot.isValid() || localProcessor.process(psiRoot)) continue;
                    stopped.set(true);
                    break;
                }
            });
        }
    }

    private void getFilesWithText(@NotNull GlobalSearchScope scope, short searchContext, boolean caseSensitively, @NotNull String text2, @NotNull Collection<? super VirtualFile> result2) {
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(47);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(48);
        }
        if (result2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(49);
        }
        this.processCandidateFilesForText(scope, searchContext, caseSensitively, text2, Processors.cancelableCollectProcessor(result2));
    }

    @Override
    public boolean processCandidateFilesForText(@NotNull GlobalSearchScope scope, short searchContext, boolean caseSensitively, @NotNull String text2, @NotNull Processor<? super VirtualFile> processor2) {
        List<IdIndexEntry> entries;
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(50);
        }
        if (text2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(51);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(52);
        }
        if ((entries = PsiSearchHelperImpl.getWordEntries(text2, caseSensitively)).isEmpty()) {
            return true;
        }
        Condition<Integer> contextMatches = integer -> (integer & searchContext) != 0;
        return PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), scope, contextMatches, entries, processor2);
    }

    @Override
    public PsiFile @NotNull [] findFilesWithPlainTextWords(@NotNull String word) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(53);
        }
        PsiFile[] psiFileArray = CacheManager.SERVICE.getInstance(this.myManager.getProject()).getFilesWithWord(word, (short)16, GlobalSearchScope.projectScope(this.myManager.getProject()), true);
        if (psiFileArray == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(54);
        }
        return psiFileArray;
    }

    @Override
    public boolean processUsagesInNonJavaFiles(@NotNull String qName, @NotNull PsiNonJavaFileReferenceProcessor processor2, @NotNull GlobalSearchScope searchScope) {
        if (qName == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(55);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(56);
        }
        if (searchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(57);
        }
        return this.processUsagesInNonJavaFiles(null, qName, processor2, searchScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processUsagesInNonJavaFiles(@Nullable PsiElement originalElement, @NotNull String qName, @NotNull PsiNonJavaFileReferenceProcessor processor2, @NotNull GlobalSearchScope initialScope) {
        int dollarIndex;
        if (qName == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(58);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(59);
        }
        if (initialScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(60);
        }
        if (qName.isEmpty()) {
            throw new IllegalArgumentException("Cannot search for elements with empty text. Element: " + originalElement + "; " + (originalElement == null ? null : originalElement.getClass()));
        }
        ProgressIndicator progress2 = PsiSearchHelperImpl.getOrCreateIndicator();
        int dotIndex = qName.lastIndexOf(46);
        int maxIndex = Math.max(dotIndex, dollarIndex = qName.lastIndexOf(36));
        String wordToSearch = maxIndex >= 0 ? qName.substring(maxIndex + 1) : qName;
        GlobalSearchScope theSearchScope = ReadAction.compute(() -> {
            if (originalElement != null && this.myManager.isInProject(originalElement) && initialScope.isSearchInLibraries()) {
                return initialScope.intersectWith(GlobalSearchScope.projectScope(this.myManager.getProject()));
            }
            return initialScope;
        });
        PsiFile[] files2 = this.myDumbService.runReadActionInSmartMode(() -> CacheManager.SERVICE.getInstance(this.myManager.getProject()).getFilesWithWord(wordToSearch, (short)16, theSearchScope, true));
        StringSearcher searcher = new StringSearcher(qName, true, true, false);
        progress2.pushState();
        Ref<Boolean> stopped = Ref.create(Boolean.FALSE);
        try {
            progress2.setText(IndexingBundle.message("psi.search.in.non.java.files.progress", new Object[0]));
            SearchScope useScope = originalElement == null ? null : this.myDumbService.runReadActionInSmartMode(() -> this.getUseScope(originalElement));
            int patternLength = qName.length();
            for (int i = 0; i < files2.length; ++i) {
                ProgressManager.checkCanceled();
                PsiFile psiFile = files2[i];
                if (psiFile instanceof PsiBinaryFile) continue;
                CharSequence text2 = ReadAction.compute(() -> psiFile.getViewProvider().getContents());
                LowLevelSearchUtil.processTextOccurrences(text2, 0, text2.length(), searcher, index -> {
                    boolean isReferenceOK = this.myDumbService.runReadActionInSmartMode(() -> {
                        PsiReference referenceAt = psiFile.findReferenceAt(index);
                        return referenceAt == null || useScope == null || !PsiSearchScopeUtil.isInScope(useScope.intersectWith(initialScope), (PsiElement)psiFile);
                    });
                    if (isReferenceOK && !processor2.process(psiFile, index, index + patternLength)) {
                        stopped.set(Boolean.TRUE);
                        return false;
                    }
                    return true;
                });
                if (stopped.get().booleanValue()) {
                    break;
                }
                progress2.setFraction((double)(i + 1) / (double)files2.length);
            }
        }
        finally {
            progress2.popState();
        }
        return stopped.get() == false;
    }

    @Override
    public boolean processAllFilesWithWord(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiFile> processor2, boolean caseSensitively) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(61);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(62);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(63);
        }
        return CacheManager.SERVICE.getInstance(this.myManager.getProject()).processFilesWithWord(processor2, word, (short)1, scope, caseSensitively);
    }

    @Override
    public boolean processAllFilesWithWordInText(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiFile> processor2, boolean caseSensitively) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(64);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(65);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(66);
        }
        return CacheManager.SERVICE.getInstance(this.myManager.getProject()).processFilesWithWord(processor2, word, (short)16, scope, caseSensitively);
    }

    @Override
    public boolean processAllFilesWithWordInComments(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiFile> processor2) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(67);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(68);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(69);
        }
        return CacheManager.SERVICE.getInstance(this.myManager.getProject()).processFilesWithWord(processor2, word, (short)2, scope, true);
    }

    @Override
    public boolean processAllFilesWithWordInLiterals(@NotNull String word, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiFile> processor2) {
        if (word == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(70);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(71);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(72);
        }
        return CacheManager.SERVICE.getInstance(this.myManager.getProject()).processFilesWithWord(processor2, word, (short)4, scope, true);
    }

    @Override
    public boolean processRequests(@NotNull SearchRequestCollector collector, @NotNull Processor<? super PsiReference> processor2) {
        QueryRequestsRunResult result2;
        if (collector == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(73);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(74);
        }
        HashMap<SearchRequestCollector, Processor<? super PsiReference>> collectors = new HashMap<SearchRequestCollector, Processor<? super PsiReference>>();
        collectors.put(collector, processor2);
        ProgressIndicator progress2 = PsiSearchHelperImpl.getOrCreateIndicator();
        if (PsiSearchHelperImpl.appendCollectorsFromQueryRequests(progress2, collectors) == QueryRequestsRunResult.STOPPED) {
            return false;
        }
        do {
            HashMap<Set<IdIndexEntry>, Collection<RequestWithProcessor>> globals = new HashMap<Set<IdIndexEntry>, Collection<RequestWithProcessor>>();
            ArrayList customs = new ArrayList();
            LinkedHashSet<RequestWithProcessor> locals = new LinkedHashSet<RequestWithProcessor>();
            THashMap<RequestWithProcessor, Processor<? super PsiElement>> localProcessors = new THashMap<RequestWithProcessor, Processor<? super PsiElement>>();
            PsiSearchHelperImpl.distributePrimitives(collectors, locals, globals, customs, localProcessors);
            if (!this.processGlobalRequestsOptimized(globals, progress2, localProcessors)) {
                return false;
            }
            for (RequestWithProcessor local : locals) {
                progress2.checkCanceled();
                if (this.processSingleRequest(local.request, local.refProcessor)) continue;
                return false;
            }
            for (Computable custom : customs) {
                progress2.checkCanceled();
                if (((Boolean)custom.compute()).booleanValue()) continue;
                return false;
            }
            result2 = PsiSearchHelperImpl.appendCollectorsFromQueryRequests(progress2, collectors);
            if (result2 != QueryRequestsRunResult.STOPPED) continue;
            return false;
        } while (result2 != QueryRequestsRunResult.UNCHANGED);
        return true;
    }

    @Override
    @NotNull
    public AsyncFuture<Boolean> processRequestsAsync(@NotNull SearchRequestCollector collector, @NotNull Processor<? super PsiReference> processor2) {
        if (collector == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(75);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(76);
        }
        AsyncFuture<Boolean> asyncFuture = AsyncUtil.wrapBoolean(this.processRequests(collector, processor2));
        if (asyncFuture == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(77);
        }
        return asyncFuture;
    }

    @NotNull
    private static QueryRequestsRunResult appendCollectorsFromQueryRequests(@NotNull ProgressIndicator progress2, @NotNull Map<SearchRequestCollector, Processor<? super PsiReference>> collectors) {
        if (progress2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(78);
        }
        if (collectors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(79);
        }
        boolean changed2 = false;
        LinkedList<SearchRequestCollector> queue = new LinkedList<SearchRequestCollector>(collectors.keySet());
        while (!queue.isEmpty()) {
            progress2.checkCanceled();
            SearchRequestCollector each = (SearchRequestCollector)queue.removeFirst();
            for (QuerySearchRequest request2 : each.takeQueryRequests()) {
                progress2.checkCanceled();
                if (!request2.runQuery()) {
                    QueryRequestsRunResult queryRequestsRunResult = QueryRequestsRunResult.STOPPED;
                    if (queryRequestsRunResult == null) {
                        PsiSearchHelperImpl.$$$reportNull$$$0(80);
                    }
                    return queryRequestsRunResult;
                }
                assert (!collectors.containsKey(request2.collector) || collectors.get(request2.collector) == request2.processor);
                collectors.put(request2.collector, request2.processor);
                queue.addLast(request2.collector);
                changed2 = true;
            }
        }
        QueryRequestsRunResult queryRequestsRunResult = changed2 ? QueryRequestsRunResult.CHANGED : QueryRequestsRunResult.UNCHANGED;
        if (queryRequestsRunResult == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(81);
        }
        return queryRequestsRunResult;
    }

    private boolean processGlobalRequestsOptimized(@NotNull Map<Set<IdIndexEntry>, Collection<RequestWithProcessor>> singles, @NotNull ProgressIndicator progress2, @NotNull Map<RequestWithProcessor, Processor<? super PsiElement>> localProcessors) {
        Collection<RequestWithProcessor> requests;
        if (singles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(82);
        }
        if (progress2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(83);
        }
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(84);
        }
        if (singles.isEmpty()) {
            return true;
        }
        if (singles.size() == 1 && (requests = singles.values().iterator().next()).size() == 1) {
            RequestWithProcessor theOnly = requests.iterator().next();
            return this.processSingleRequest(theOnly.request, theOnly.refProcessor);
        }
        return this.processGlobalRequests(singles, progress2, localProcessors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends WordRequestInfo> boolean processGlobalRequests(@NotNull Map<Set<IdIndexEntry>, Collection<T>> singles, @NotNull ProgressIndicator progress2, @NotNull Map<T, Processor<? super PsiElement>> localProcessors) {
        boolean result2;
        if (singles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(85);
        }
        if (progress2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(86);
        }
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(87);
        }
        progress2.pushState();
        progress2.setText(IndexingBundle.message("psi.scanning.files.progress", new Object[0]));
        try {
            HashMap intersectionCandidateFiles = new HashMap();
            HashMap restCandidateFiles = new HashMap();
            this.collectFiles(singles, intersectionCandidateFiles, restCandidateFiles);
            if (intersectionCandidateFiles.isEmpty() && restCandidateFiles.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            TreeSet<String> allWords = new TreeSet<String>();
            for (WordRequestInfo singleRequest : localProcessors.keySet()) {
                ProgressManager.checkCanceled();
                allWords.add(singleRequest.getWord());
            }
            progress2.setText(IndexingBundle.message("psi.search.for.word.progress", PsiSearchHelperImpl.getPresentableWordsDescription(allWords)));
            if (intersectionCandidateFiles.isEmpty()) {
                result2 = this.processCandidates(localProcessors, restCandidateFiles, progress2, restCandidateFiles.size(), 0);
            } else {
                int totalSize = restCandidateFiles.size() + intersectionCandidateFiles.size();
                result2 = this.processCandidates(localProcessors, intersectionCandidateFiles, progress2, totalSize, 0);
                if (result2) {
                    result2 = this.processCandidates(localProcessors, restCandidateFiles, progress2, totalSize, intersectionCandidateFiles.size());
                }
            }
        }
        finally {
            progress2.popState();
        }
        return result2;
    }

    private <X> boolean processCandidates(@NotNull Map<X, Processor<? super PsiElement>> localProcessors, @NotNull Map<VirtualFile, Collection<X>> candidateFiles, @NotNull ProgressIndicator progress2, int totalSize, int alreadyProcessedFiles) {
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(88);
        }
        if (candidateFiles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(89);
        }
        if (progress2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(90);
        }
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>(candidateFiles.keySet());
        return this.processPsiFileRoots(files2, totalSize, alreadyProcessedFiles, progress2, psiRoot -> {
            VirtualFile vfile = psiRoot.getVirtualFile();
            for (Object singleRequest : (Collection)candidateFiles.get(vfile)) {
                ProgressManager.checkCanceled();
                Processor localProcessor = (Processor)localProcessors.get(singleRequest);
                if (localProcessor.process(psiRoot)) continue;
                return false;
            }
            return true;
        });
    }

    @NotNull
    private static String getPresentableWordsDescription(@NotNull Set<String> allWords) {
        if (allWords == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(91);
        }
        StringBuilder result2 = new StringBuilder();
        for (String string : allWords) {
            ProgressManager.checkCanceled();
            if (string == null || string.isEmpty()) continue;
            if (result2.length() > 50) {
                result2.append("...");
                break;
            }
            if (result2.length() != 0) {
                result2.append(", ");
            }
            result2.append(string);
        }
        String string = result2.toString();
        if (string == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(92);
        }
        return string;
    }

    @NotNull
    private static BulkOccurrenceProcessor adaptProcessor(@NotNull PsiSearchRequest singleRequest, final @NotNull Processor<? super PsiReference> consumer) {
        SearchScope searchScope;
        if (singleRequest == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(93);
        }
        if (consumer == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(94);
        }
        final boolean ignoreInjectedPsi = (searchScope = singleRequest.searchScope) instanceof LocalSearchScope && ((LocalSearchScope)searchScope).isIgnoreInjectedPsi();
        final RequestResultProcessor wrapped = singleRequest.processor;
        return new BulkOccurrenceProcessor(){

            @Override
            public boolean execute(@NotNull PsiElement scope, int @NotNull [] offsetsInScope, @NotNull StringSearcher searcher) {
                if (scope == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (searcher == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (offsetsInScope == null) {
                    4.$$$reportNull$$$0(2);
                }
                try {
                    ProgressManager.checkCanceled();
                    if (wrapped instanceof RequestResultProcessor.BulkResultProcessor) {
                        return ((RequestResultProcessor.BulkResultProcessor)wrapped).processTextOccurrences(scope, offsetsInScope, consumer);
                    }
                    return LowLevelSearchUtil.processElementsAtOffsets(scope, searcher, !ignoreInjectedPsi, PsiSearchHelperImpl.getOrCreateIndicator(), offsetsInScope, (element2, offsetInElement) -> {
                        if (ignoreInjectedPsi && element2 instanceof PsiLanguageInjectionHost) {
                            return true;
                        }
                        return wrapped.processTextOccurrence(element2, offsetInElement, consumer);
                    });
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Error | Exception e) {
                    PsiFile file2 = scope.getContainingFile();
                    LOG.error("Error during processing of: " + (file2 != null ? file2.getName() : scope), e);
                    return true;
                }
            }

            public String toString() {
                return consumer.toString();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "scope";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "searcher";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "offsetsInScope";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$4";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private <T extends WordRequestInfo> void collectFiles(@NotNull Map<Set<IdIndexEntry>, Collection<T>> singles, @NotNull Map<VirtualFile, Collection<T>> intersectionResult, @NotNull Map<VirtualFile, Collection<T>> restResult) {
        if (singles == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(95);
        }
        if (intersectionResult == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(96);
        }
        if (restResult == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(97);
        }
        for (Map.Entry<Set<IdIndexEntry>, Collection<T>> entry : singles.entrySet()) {
            ProgressManager.checkCanceled();
            Set<IdIndexEntry> keys2 = entry.getKey();
            if (keys2.isEmpty()) continue;
            Collection processors = entry.getValue();
            GlobalSearchScope commonScope = PsiSearchHelperImpl.uniteScopes(processors);
            Set<VirtualFile> intersectionWithContainerNameFiles = this.intersectionWithContainerNameFiles(commonScope, processors, keys2);
            ArrayList result2 = new ArrayList();
            Processor processor2 = Processors.cancelableCollectProcessor(result2);
            PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), commonScope, null, keys2, processor2);
            for (VirtualFile file2 : result2) {
                ProgressManager.checkCanceled();
                for (IdIndexEntry indexEntry : keys2) {
                    ProgressManager.checkCanceled();
                    this.myDumbService.runReadActionInSmartMode(() -> FileBasedIndex.getInstance().processValues(IdIndex.NAME, indexEntry, file2, (file1, value2) -> {
                        int mask = value2;
                        for (WordRequestInfo single : processors) {
                            ProgressManager.checkCanceled();
                            if ((mask & single.getSearchContext()) == 0 || !single.getSearchScope().contains(file1)) continue;
                            Map result1 = intersectionWithContainerNameFiles == null || !intersectionWithContainerNameFiles.contains(file1) ? restResult : intersectionResult;
                            result1.computeIfAbsent(file1, __ -> new SmartList()).add(single);
                        }
                        return true;
                    }, commonScope));
                }
            }
        }
    }

    @Nullable(value="null means we did not find common container files")
    private @Nullable(value="null means we did not find common container files") Set<VirtualFile> intersectionWithContainerNameFiles(@NotNull GlobalSearchScope commonScope, @NotNull Collection<? extends WordRequestInfo> data2, @NotNull Set<IdIndexEntry> keys2) {
        if (commonScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(98);
        }
        if (data2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(99);
        }
        if (keys2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(100);
        }
        String commonName = null;
        short searchContext = 0;
        boolean caseSensitive = true;
        for (WordRequestInfo wordRequestInfo : data2) {
            ProgressManager.checkCanceled();
            String containerName = wordRequestInfo.getContainerName();
            if (containerName == null) continue;
            if (commonName == null) {
                commonName = containerName;
                searchContext = wordRequestInfo.getSearchContext();
                caseSensitive = wordRequestInfo.isCaseSensitive();
                continue;
            }
            if (commonName.equals(containerName)) {
                searchContext = (short)(searchContext | wordRequestInfo.getSearchContext());
                caseSensitive &= wordRequestInfo.isCaseSensitive();
                continue;
            }
            return null;
        }
        if (commonName == null) {
            return null;
        }
        List<IdIndexEntry> entries = PsiSearchHelperImpl.getWordEntries(commonName, caseSensitive);
        if (entries.isEmpty()) {
            return null;
        }
        entries.addAll(keys2);
        short s = searchContext;
        Condition<Integer> contextMatches = context -> (context & finalSearchContext) != 0;
        THashSet<VirtualFile> containerFiles = new THashSet<VirtualFile>();
        Processor processor2 = Processors.cancelableCollectProcessor(containerFiles);
        PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), commonScope, contextMatches, entries, processor2);
        return containerFiles;
    }

    @NotNull
    private static GlobalSearchScope uniteScopes(@NotNull Collection<? extends WordRequestInfo> requests) {
        if (requests == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(101);
        }
        Set<GlobalSearchScope> scopes = ContainerUtil.map2LinkedSet(requests, r -> (GlobalSearchScope)r.getSearchScope());
        GlobalSearchScope globalSearchScope = GlobalSearchScope.union(scopes.toArray(GlobalSearchScope.EMPTY_ARRAY));
        if (globalSearchScope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(102);
        }
        return globalSearchScope;
    }

    private static void distributePrimitives(@NotNull Map<SearchRequestCollector, Processor<? super PsiReference>> collectors, @NotNull Set<RequestWithProcessor> locals, @NotNull Map<Set<IdIndexEntry>, Collection<RequestWithProcessor>> globals, @NotNull List<? super Computable<Boolean>> customs, @NotNull Map<RequestWithProcessor, Processor<? super PsiElement>> localProcessors) {
        if (collectors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(103);
        }
        if (locals == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(104);
        }
        if (globals == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(105);
        }
        if (customs == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(106);
        }
        if (localProcessors == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(107);
        }
        for (Map.Entry<SearchRequestCollector, Processor<? super PsiReference>> entry : collectors.entrySet()) {
            ProgressManager.checkCanceled();
            Processor<? super PsiReference> processor2 = entry.getValue();
            SearchRequestCollector collector = entry.getKey();
            for (PsiSearchRequest psiSearchRequest : collector.takeSearchRequests()) {
                ProgressManager.checkCanceled();
                SearchScope scope = psiSearchRequest.searchScope;
                if (scope instanceof LocalSearchScope) {
                    PsiSearchHelperImpl.registerRequest(locals, psiSearchRequest, processor2);
                    continue;
                }
                HashSet<IdIndexEntry> key = new HashSet<IdIndexEntry>(PsiSearchHelperImpl.getWordEntries(psiSearchRequest.word, psiSearchRequest.caseSensitive));
                PsiSearchHelperImpl.registerRequest(globals.computeIfAbsent(key, __ -> new SmartList()), psiSearchRequest, processor2);
            }
            for (Processor processor3 : collector.takeCustomSearchActions()) {
                ProgressManager.checkCanceled();
                customs.add(() -> customAction.process(processor2));
            }
        }
        for (Map.Entry<Object, Object> entry : globals.entrySet()) {
            ProgressManager.checkCanceled();
            for (RequestWithProcessor singleRequest : (Collection)entry.getValue()) {
                ProgressManager.checkCanceled();
                PsiSearchRequest primitive = singleRequest.request;
                StringSearcher stringSearcher = new StringSearcher(primitive.word, primitive.caseSensitive, true, false);
                BulkOccurrenceProcessor adapted = PsiSearchHelperImpl.adaptProcessor(primitive, singleRequest.refProcessor);
                Processor<PsiElement> localProcessor = PsiSearchHelperImpl.localProcessor(stringSearcher, adapted);
                assert (!localProcessors.containsKey(singleRequest) || localProcessors.get(singleRequest) == localProcessor);
                localProcessors.put(singleRequest, localProcessor);
            }
        }
    }

    private static void registerRequest(@NotNull Collection<RequestWithProcessor> collection, @NotNull PsiSearchRequest primitive, @NotNull Processor<? super PsiReference> processor2) {
        if (collection == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(108);
        }
        if (primitive == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(109);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(110);
        }
        RequestWithProcessor singleRequest = new RequestWithProcessor(primitive, processor2);
        for (RequestWithProcessor existing : collection) {
            ProgressManager.checkCanceled();
            if (!existing.uniteWith(singleRequest)) continue;
            return;
        }
        collection.add(singleRequest);
    }

    private boolean processSingleRequest(@NotNull PsiSearchRequest single, @NotNull Processor<? super PsiReference> consumer) {
        if (single == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(111);
        }
        if (consumer == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(112);
        }
        EnumSet<Options> options = EnumSet.of(Options.PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE);
        if (single.caseSensitive) {
            options.add(Options.CASE_SENSITIVE_SEARCH);
        }
        if (PsiSearchHelperImpl.shouldProcessInjectedPsi(single.searchScope)) {
            options.add(Options.PROCESS_INJECTED_PSI);
        }
        return this.bulkProcessElementsWithWord(single.searchScope, single.word, single.searchContext, options, single.containerName, PsiSearchHelperImpl.adaptProcessor(single, consumer));
    }

    @Override
    @NotNull
    public PsiSearchHelper.SearchCostResult isCheapEnoughToSearch(@NotNull String name, @NotNull GlobalSearchScope scope, final @Nullable PsiFile fileToIgnoreOccurrencesIn, @Nullable ProgressIndicator progress2) {
        boolean cheap;
        if (name == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(113);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(114);
        }
        if (!ReadAction.compute(() -> scope.getUnloadedModulesBelongingToScope().isEmpty()).booleanValue()) {
            PsiSearchHelper.SearchCostResult searchCostResult = PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
            if (searchCostResult == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(115);
            }
            return searchCostResult;
        }
        final AtomicInteger filesCount = new AtomicInteger();
        final AtomicLong filesSizeToProcess = new AtomicLong();
        Processor<VirtualFile> processor2 = new Processor<VirtualFile>(){
            private final VirtualFile virtualFileToIgnoreOccurrencesIn;
            private final int maxFilesToProcess;
            private final int maxFilesSizeToProcess;
            {
                this.virtualFileToIgnoreOccurrencesIn = fileToIgnoreOccurrencesIn == null ? null : fileToIgnoreOccurrencesIn.getVirtualFile();
                this.maxFilesToProcess = Registry.intValue("ide.unused.symbol.calculation.maxFilesToSearchUsagesIn", 10);
                this.maxFilesSizeToProcess = Registry.intValue("ide.unused.symbol.calculation.maxFilesSizeToSearchUsagesIn", 524288);
            }

            @Override
            public boolean process(VirtualFile file2) {
                ProgressManager.checkCanceled();
                if (Comparing.equal(file2, this.virtualFileToIgnoreOccurrencesIn)) {
                    return true;
                }
                int currentFilesCount = filesCount.incrementAndGet();
                long accumulatedFileSizeToProcess = filesSizeToProcess.addAndGet(file2.isDirectory() ? 0L : file2.getLength());
                return currentFilesCount < this.maxFilesToProcess && accumulatedFileSizeToProcess < (long)this.maxFilesSizeToProcess;
            }
        };
        List<IdIndexEntry> keys2 = PsiSearchHelperImpl.getWordEntries(name, true);
        boolean bl = cheap = keys2.isEmpty() || PsiSearchHelperImpl.processFilesContainingAllKeys(this.myManager.getProject(), scope, null, keys2, (Processor<? super VirtualFile>)processor2);
        if (!cheap) {
            PsiSearchHelper.SearchCostResult searchCostResult = PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
            if (searchCostResult == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(116);
            }
            return searchCostResult;
        }
        PsiSearchHelper.SearchCostResult searchCostResult = filesCount.get() == 0 ? PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES : PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES;
        if (searchCostResult == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(117);
        }
        return searchCostResult;
    }

    private static boolean processFilesContainingAllKeys(@NotNull Project project2, @NotNull GlobalSearchScope scope, @Nullable Condition<? super Integer> checker, @NotNull Collection<IdIndexEntry> keys2, @NotNull Processor<? super VirtualFile> processor2) {
        if (project2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(118);
        }
        if (scope == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(119);
        }
        if (keys2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(120);
        }
        if (processor2 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(121);
        }
        Computable<Boolean> query = () -> FileBasedIndex.getInstance().processFilesContainingAllKeys(IdIndex.NAME, keys2, scope, checker, processor2);
        Boolean[] result2 = new Boolean[]{null};
        if (FileBasedIndex.isIndexAccessDuringDumbModeEnabled()) {
            ReadAction.nonBlocking(() -> FileBasedIndex.getInstance().ignoreDumbMode(() -> {
                result2[0] = (Boolean)query.compute();
            }, project2, DumbModeAccessType.RAW_INDEX_DATA_ACCEPTABLE)).executeSynchronously();
        }
        return result2[0] != null ? result2[0].booleanValue() : DumbService.getInstance(project2).runReadActionInSmartMode(query).booleanValue();
    }

    @NotNull
    static List<IdIndexEntry> getWordEntries(@NotNull String name, boolean caseSensitively) {
        String trimmed;
        List<String> words;
        if (name == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(122);
        }
        if ((words = StringUtil.getWordsInStringLongestFirst(name)).isEmpty() && StringUtil.isNotEmpty(trimmed = name.trim())) {
            words = Collections.singletonList(trimmed);
        }
        if (words.isEmpty()) {
            List<IdIndexEntry> list2 = Collections.emptyList();
            if (list2 == null) {
                PsiSearchHelperImpl.$$$reportNull$$$0(123);
            }
            return list2;
        }
        List<IdIndexEntry> list3 = ContainerUtil.map2List(words, word -> new IdIndexEntry((String)word, caseSensitively));
        if (list3 == null) {
            PsiSearchHelperImpl.$$$reportNull$$$0(124);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 19: 
            case 28: 
            case 54: 
            case 77: 
            case 80: 
            case 81: 
            case 92: 
            case 102: 
            case 115: 
            case 116: 
            case 117: 
            case 123: 
            case 124: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 19: 
            case 28: 
            case 54: 
            case 77: 
            case 80: 
            case 81: 
            case 92: 
            case 102: 
            case 115: 
            case 116: 
            case 117: 
            case 123: 
            case 124: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 6: 
            case 19: 
            case 28: 
            case 54: 
            case 77: 
            case 80: 
            case 81: 
            case 92: 
            case 102: 
            case 115: 
            case 116: 
            case 117: 
            case 123: 
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/PsiSearchHelperImpl";
                break;
            }
            case 2: 
            case 39: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 14: 
            case 17: 
            case 21: 
            case 24: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 27: 
            case 31: 
            case 35: 
            case 52: 
            case 56: 
            case 59: 
            case 63: 
            case 66: 
            case 69: 
            case 72: 
            case 74: 
            case 76: 
            case 110: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 12: 
            case 15: 
            case 18: 
            case 22: 
            case 25: 
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 29: 
            case 32: 
            case 47: 
            case 50: 
            case 62: 
            case 65: 
            case 68: 
            case 71: 
            case 114: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searcher";
                break;
            }
            case 34: 
            case 37: 
            case 41: 
            case 78: 
            case 83: 
            case 86: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 36: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 38: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localProcessor";
                break;
            }
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopped";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfile";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 53: 
            case 61: 
            case 64: 
            case 67: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 55: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialScope";
                break;
            }
            case 73: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 79: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectors";
                break;
            }
            case 82: 
            case 85: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singles";
                break;
            }
            case 84: 
            case 87: 
            case 88: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localProcessors";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateFiles";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allWords";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singleRequest";
                break;
            }
            case 94: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intersectionResult";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "restResult";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonScope";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 100: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locals";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globals";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customs";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primitive";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "single";
                break;
            }
            case 113: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/PsiSearchHelperImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findCommentsContainingIdentifier";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "processElementsWithWordAsync";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateIndicator";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "findFilesWithPlainTextWords";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "processRequestsAsync";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "appendCollectorsFromQueryRequests";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableWordsDescription";
                break;
            }
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "uniteScopes";
                break;
            }
            case 115: 
            case 116: 
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "isCheapEnoughToSearch";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordEntries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUseScope";
                break;
            }
            case 1: 
            case 6: 
            case 19: 
            case 28: 
            case 54: 
            case 77: 
            case 80: 
            case 81: 
            case 92: 
            case 102: 
            case 115: 
            case 116: 
            case 117: 
            case 123: 
            case 124: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findCommentsContainingIdentifier";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processCommentsContainingIdentifier";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithWord";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithWordAsync";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "bulkProcessElementsWithWord";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcessInjectedPsi";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "localProcessor";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "processElementsWithTextInGlobalScope";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "processPsiFileRoots";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "processFilesConcurrentlyDespiteWriteActions";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "processVirtualFile";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getFilesWithText";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "processCandidateFilesForText";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findFilesWithPlainTextWords";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "processUsagesInNonJavaFiles";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWord";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWordInText";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWordInComments";
                break;
            }
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "processAllFilesWithWordInLiterals";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "processRequests";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "processRequestsAsync";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "appendCollectorsFromQueryRequests";
                break;
            }
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "processGlobalRequestsOptimized";
                break;
            }
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "processGlobalRequests";
                break;
            }
            case 88: 
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "processCandidates";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableWordsDescription";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "adaptProcessor";
                break;
            }
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "collectFiles";
                break;
            }
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "intersectionWithContainerNameFiles";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "uniteScopes";
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "distributePrimitives";
                break;
            }
            case 108: 
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "registerRequest";
                break;
            }
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "processSingleRequest";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "isCheapEnoughToSearch";
                break;
            }
            case 118: 
            case 119: 
            case 120: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "processFilesContainingAllKeys";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "getWordEntries";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 19: 
            case 28: 
            case 54: 
            case 77: 
            case 80: 
            case 81: 
            case 92: 
            case 102: 
            case 115: 
            case 116: 
            case 117: 
            case 123: 
            case 124: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum QueryRequestsRunResult {
        STOPPED,
        UNCHANGED,
        CHANGED;

    }

    private static class RequestWithProcessor
    implements WordRequestInfo {
        @NotNull
        private final PsiSearchRequest request;
        @NotNull
        private Processor<? super PsiReference> refProcessor;

        private RequestWithProcessor(@NotNull PsiSearchRequest request2, @NotNull Processor<? super PsiReference> processor2) {
            if (request2 == null) {
                RequestWithProcessor.$$$reportNull$$$0(0);
            }
            if (processor2 == null) {
                RequestWithProcessor.$$$reportNull$$$0(1);
            }
            this.request = request2;
            this.refProcessor = processor2;
        }

        private boolean uniteWith(@NotNull RequestWithProcessor another) {
            if (another == null) {
                RequestWithProcessor.$$$reportNull$$$0(2);
            }
            if (this.request.equals(another.request)) {
                Processor<? super PsiReference> myProcessor = this.refProcessor;
                if (myProcessor != another.refProcessor) {
                    this.refProcessor = psiReference -> myProcessor.process((PsiReference)psiReference) && another.refProcessor.process((PsiReference)psiReference);
                }
                return true;
            }
            return false;
        }

        public String toString() {
            return this.request.toString();
        }

        @Override
        @NotNull
        public String getWord() {
            String string = this.request.word;
            if (string == null) {
                RequestWithProcessor.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public SearchScope getSearchScope() {
            SearchScope searchScope = this.request.searchScope;
            if (searchScope == null) {
                RequestWithProcessor.$$$reportNull$$$0(4);
            }
            return searchScope;
        }

        @Override
        public short getSearchContext() {
            return this.request.searchContext;
        }

        @Override
        public boolean isCaseSensitive() {
            return this.request.caseSensitive;
        }

        @Override
        @Nullable
        public String getContainerName() {
            return this.request.containerName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "another";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$RequestWithProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/search/PsiSearchHelperImpl$RequestWithProcessor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWord";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSearchScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteWith";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum Options {
        PROCESS_INJECTED_PSI,
        CASE_SENSITIVE_SEARCH,
        PROCESS_ONLY_JAVA_IDENTIFIERS_IF_POSSIBLE;

    }
}

