/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.LanguageUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.smartPointers.AnchorElementInfo;
import com.intellij.psi.impl.smartPointers.ClsElementInfo;
import com.intellij.psi.impl.smartPointers.DirElementInfo;
import com.intellij.psi.impl.smartPointers.FileElementInfo;
import com.intellij.psi.impl.smartPointers.HardElementInfo;
import com.intellij.psi.impl.smartPointers.Identikit;
import com.intellij.psi.impl.smartPointers.InjectedSelfElementInfo;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerEx;
import com.intellij.psi.impl.smartPointers.SmartPointerManagerImpl;
import com.intellij.psi.impl.smartPointers.SmartPointerTracker;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SmartPsiElementPointerImpl<E extends PsiElement>
implements SmartPointerEx<E> {
    private static final Logger LOG = Logger.getInstance(SmartPsiElementPointerImpl.class);
    private Reference<E> myElement;
    private final SmartPointerElementInfo myElementInfo;
    protected final SmartPointerManagerImpl myManager;
    private byte myReferenceCount;
    @Nullable
    SmartPointerTracker.PointerReference pointerReference;

    SmartPsiElementPointerImpl(SmartPointerManagerImpl manager, @NotNull E element2, @Nullable PsiFile containingFile, boolean forInjected) {
        if (element2 == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(0);
        }
        this(manager, element2, SmartPsiElementPointerImpl.createElementInfo(manager, element2, containingFile, forInjected));
    }

    SmartPsiElementPointerImpl(SmartPointerManagerImpl manager, @NotNull E element2, @NotNull SmartPointerElementInfo elementInfo) {
        if (element2 == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(1);
        }
        if (elementInfo == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(2);
        }
        this.myReferenceCount = 1;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        this.myElementInfo = elementInfo;
        this.myManager = manager;
        this.cacheElement(element2);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SmartPsiElementPointer && SmartPsiElementPointerImpl.pointsToTheSameElementAs(this, (SmartPsiElementPointer)obj);
    }

    @Override
    public int hashCode() {
        return this.myElementInfo.elementHashCode();
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project2 = this.myManager.getProject();
        if (project2 == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(3);
        }
        return project2;
    }

    @Override
    @Nullable
    public E getElement() {
        if (this.getProject().isDisposed()) {
            return null;
        }
        E element2 = this.getCachedElement();
        if (element2 == null || !element2.isValid()) {
            element2 = this.doRestoreElement();
            this.cacheElement(element2);
        }
        return element2;
    }

    @Nullable
    E doRestoreElement() {
        PsiElement element2 = this.myElementInfo.restoreElement(this.myManager);
        if (element2 != null && !element2.isValid()) {
            return null;
        }
        return (E)element2;
    }

    void cacheElement(@Nullable E element2) {
        this.myElement = element2 == null ? null : (PsiManagerEx.getInstanceEx(this.getProject()).isBatchFilesProcessingMode() ? new WeakReference<E>(element2) : new java.lang.ref.SoftReference<E>(element2));
    }

    public E getCachedElement() {
        return (E)((PsiElement)SoftReference.dereference(this.myElement));
    }

    @Override
    public PsiFile getContainingFile() {
        PsiFile file2 = this.getElementInfo().restoreFile(this.myManager);
        if (file2 != null) {
            return file2;
        }
        Document doc = this.myElementInfo.getDocumentToSynchronize();
        if (doc == null) {
            E resolved = this.getElement();
            return resolved == null ? null : resolved.getContainingFile();
        }
        return PsiDocumentManager.getInstance(this.getProject()).getPsiFile(doc);
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.myElementInfo.getVirtualFile();
    }

    @Override
    public Segment getRange() {
        return this.myElementInfo.getRange(this.myManager);
    }

    @Override
    @Nullable
    public Segment getPsiRange() {
        return this.myElementInfo.getPsiRange(this.myManager);
    }

    @NotNull
    private static <E extends PsiElement> SmartPointerElementInfo createElementInfo(SmartPointerManagerImpl manager, @NotNull E element2, PsiFile containingFile, boolean forInjected) {
        PsiElement restored;
        if (element2 == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(4);
        }
        SmartPointerElementInfo elementInfo = SmartPsiElementPointerImpl.doCreateElementInfo(manager.getProject(), element2, containingFile, forInjected);
        if (ApplicationManager.getApplication().isUnitTestMode() && !ApplicationInfoImpl.isInStressTest() && !element2.equals(restored = elementInfo.restoreElement(manager))) {
            LOG.error("Cannot restore " + element2 + " of " + element2.getClass() + " from " + elementInfo + "; restored=" + restored + " in " + element2.getProject());
        }
        SmartPointerElementInfo smartPointerElementInfo = elementInfo;
        if (smartPointerElementInfo == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(5);
        }
        return smartPointerElementInfo;
    }

    @NotNull
    private static <E extends PsiElement> SmartPointerElementInfo doCreateElementInfo(@NotNull Project project2, @NotNull E element2, PsiFile containingFile, boolean forInjected) {
        SmartPointerElementInfo info;
        if (project2 == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(6);
        }
        if (element2 == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(7);
        }
        if (element2 instanceof PsiDirectory) {
            return new DirElementInfo((PsiDirectory)element2);
        }
        if (element2 instanceof PsiCompiledElement || containingFile == null || !containingFile.isPhysical() || !element2.isPhysical()) {
            if (element2 instanceof StubBasedPsiElement && element2 instanceof PsiCompiledElement) {
                if (element2 instanceof PsiFile) {
                    return new FileElementInfo((PsiFile)element2);
                }
                PsiAnchor.StubIndexReference stubReference = PsiAnchor.createStubReference(element2, containingFile);
                if (stubReference != null) {
                    return new ClsElementInfo(stubReference);
                }
            }
            return new HardElementInfo(element2);
        }
        FileViewProvider viewProvider = containingFile.getViewProvider();
        if (viewProvider instanceof FreeThreadedFileViewProvider) {
            PsiLanguageInjectionHost hostContext = InjectedLanguageManager.getInstance(containingFile.getProject()).getInjectionHost(containingFile);
            TextRange elementRange = element2.getTextRange();
            if (hostContext != null && elementRange != null) {
                SmartPsiElementPointer<PsiLanguageInjectionHost> hostPointer = SmartPointerManager.getInstance(project2).createSmartPsiElementPointer(hostContext);
                return new InjectedSelfElementInfo(project2, element2, elementRange, containingFile, hostPointer);
            }
        }
        if (element2 instanceof PsiFile) {
            return new FileElementInfo((PsiFile)element2);
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(viewProvider.getVirtualFile());
        if (document != null && ((PsiDocumentManagerBase)PsiDocumentManager.getInstance(project2)).getSynchronizer().isDocumentAffectedByTransactions(document)) {
            LOG.error("Smart pointers must not be created during PSI changes");
        }
        if ((info = SmartPsiElementPointerImpl.createAnchorInfo(element2, containingFile)) != null) {
            SmartPointerElementInfo smartPointerElementInfo = info;
            if (smartPointerElementInfo == null) {
                SmartPsiElementPointerImpl.$$$reportNull$$$0(8);
            }
            return smartPointerElementInfo;
        }
        TextRange elementRange = element2.getTextRange();
        if (elementRange == null) {
            return new HardElementInfo(element2);
        }
        Identikit.ByType identikit = Identikit.fromPsi(element2, LanguageUtil.getRootLanguage(element2));
        if (elementRange.isEmpty() && identikit.findPsiElement(containingFile, elementRange.getStartOffset(), elementRange.getEndOffset()) != element2) {
            return new HardElementInfo(element2);
        }
        ProperTextRange proper = ProperTextRange.create(elementRange);
        return new SelfElementInfo(proper, identikit, containingFile, forInjected);
    }

    @Nullable
    private static SmartPointerElementInfo createAnchorInfo(@NotNull PsiElement element2, @NotNull PsiFile containingFile) {
        StubBasedPsiElement stubPsi;
        int stubId;
        IStubFileElementType stubType;
        if (element2 == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(9);
        }
        if (containingFile == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(10);
        }
        if (element2 instanceof StubBasedPsiElement && containingFile instanceof PsiFileImpl && (stubType = ((PsiFileImpl)containingFile).getElementTypeForStubBuilder()) != null && stubType.shouldBuildStubFor(containingFile.getViewProvider().getVirtualFile()) && (stubId = PsiAnchor.calcStubIndex(stubPsi = (StubBasedPsiElement)element2)) != -1) {
            return new AnchorElementInfo(element2, (PsiFileImpl)containingFile, stubId, stubPsi.getElementType());
        }
        Pair<Identikit.ByAnchor, PsiElement> pair = Identikit.withAnchor(element2, LanguageUtil.getRootLanguage(containingFile));
        if (pair != null) {
            return new AnchorElementInfo((PsiElement)pair.second, containingFile, (Identikit.ByAnchor)pair.first);
        }
        return null;
    }

    @NotNull
    SmartPointerElementInfo getElementInfo() {
        SmartPointerElementInfo smartPointerElementInfo = this.myElementInfo;
        if (smartPointerElementInfo == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(11);
        }
        return smartPointerElementInfo;
    }

    static boolean pointsToTheSameElementAs(@NotNull SmartPsiElementPointer pointer1, @NotNull SmartPsiElementPointer pointer2) {
        if (pointer1 == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(12);
        }
        if (pointer2 == null) {
            SmartPsiElementPointerImpl.$$$reportNull$$$0(13);
        }
        if (pointer1 == pointer2) {
            return true;
        }
        if (pointer1 instanceof SmartPsiElementPointerImpl && pointer2 instanceof SmartPsiElementPointerImpl) {
            SmartPointerElementInfo elementInfo2;
            SmartPsiElementPointerImpl impl1 = (SmartPsiElementPointerImpl)pointer1;
            SmartPsiElementPointerImpl impl2 = (SmartPsiElementPointerImpl)pointer2;
            SmartPointerElementInfo elementInfo1 = impl1.getElementInfo();
            if (!elementInfo1.pointsToTheSameElementAs(elementInfo2 = impl2.getElementInfo(), ((SmartPsiElementPointerImpl)pointer1).myManager)) {
                return false;
            }
            Object cachedElement1 = impl1.getCachedElement();
            Object cachedElement2 = impl2.getCachedElement();
            return cachedElement1 == null || cachedElement2 == null || Comparing.equal(cachedElement1, cachedElement2);
        }
        return Comparing.equal(pointer1.getElement(), pointer2.getElement());
    }

    synchronized int incrementAndGetReferenceCount(int delta) {
        if (this.myReferenceCount == 127) {
            return 127;
        }
        if (this.myReferenceCount == 0) {
            return -1;
        }
        this.myReferenceCount = (byte)(this.myReferenceCount + delta);
        return this.myReferenceCount;
    }

    public String toString() {
        return this.myElementInfo.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementInfo";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer1";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/smartPointers/SmartPsiElementPointerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createElementInfo";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateElementInfo";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createElementInfo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doCreateElementInfo";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createAnchorInfo";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "pointsToTheSameElementAs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

