/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.joinLines.JoinedLinesSpacingCalculator;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProviderEP;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleFacadeImpl
extends CodeStyleFacade {
    @Nullable
    private final Project myProject;

    public CodeStyleFacadeImpl() {
        this(null);
    }

    public CodeStyleFacadeImpl(@Nullable Project project2) {
        this.myProject = project2;
    }

    @Override
    @Deprecated
    public int getIndentSize(FileType fileType) {
        return CodeStyle.getProjectOrDefaultSettings(this.myProject).getIndentSize(fileType);
    }

    @Override
    @Deprecated
    @Nullable
    public String getLineIndent(@NotNull Document document, int offset) {
        if (document == null) {
            CodeStyleFacadeImpl.$$$reportNull$$$0(0);
        }
        if (this.myProject == null) {
            return null;
        }
        PsiDocumentManager.getInstance(this.myProject).commitDocument(document);
        return CodeStyleManager.getInstance(this.myProject).getLineIndent(document, offset);
    }

    @Override
    public String getLineIndent(@NotNull Editor editor, @Nullable Language language2, int offset, boolean allowDocCommit) {
        String indent;
        if (editor == null) {
            CodeStyleFacadeImpl.$$$reportNull$$$0(1);
        }
        if (this.myProject == null) {
            return null;
        }
        LineIndentProvider lineIndentProvider = LineIndentProviderEP.findLineIndentProvider(language2);
        String string = indent = lineIndentProvider != null ? lineIndentProvider.getLineIndent(this.myProject, editor, language2, offset) : null;
        if (indent == LineIndentProvider.DO_NOT_ADJUST) {
            return allowDocCommit ? null : indent;
        }
        return indent != null ? indent : (allowDocCommit ? this.getLineIndent(editor.getDocument(), offset) : null);
    }

    @Override
    public int getJoinedLinesSpacing(@NotNull Editor editor, @Nullable Language language2, int offset, boolean allowDocCommit) {
        int space;
        if (editor == null) {
            CodeStyleFacadeImpl.$$$reportNull$$$0(2);
        }
        if (this.myProject == null) {
            return 0;
        }
        LineIndentProvider lineIndentProvider = LineIndentProviderEP.findLineIndentProvider(language2);
        int n = space = lineIndentProvider instanceof JoinedLinesSpacingCalculator ? ((JoinedLinesSpacingCalculator)((Object)lineIndentProvider)).getJoinedLinesSpacing(this.myProject, editor, language2, offset) : -1;
        if (space < 0 && allowDocCommit) {
            Document document = editor.getDocument();
            PsiDocumentManager.getInstance(this.myProject).commitDocument(document);
            PsiFile file2 = PsiDocumentManager.getInstance(this.myProject).getPsiFile(document);
            if (file2 == null) {
                return 0;
            }
            return Math.max(0, CodeStyleManager.getInstance(this.myProject).getSpacing(file2, offset));
        }
        return Math.max(0, space);
    }

    @Override
    public String getLineSeparator() {
        return CodeStyle.getProjectOrDefaultSettings(this.myProject).getLineSeparator();
    }

    @Override
    public int getTabSize(FileType fileType) {
        return CodeStyle.getProjectOrDefaultSettings(this.myProject).getTabSize(fileType);
    }

    @Override
    public boolean useTabCharacter(FileType fileType) {
        return CodeStyle.getProjectOrDefaultSettings(this.myProject).useTabCharacter(fileType);
    }

    @Override
    public boolean useSpaceBeforeComma(@NotNull PsiFile psiFile, @NotNull Language language2) {
        if (psiFile == null) {
            CodeStyleFacadeImpl.$$$reportNull$$$0(3);
        }
        if (language2 == null) {
            CodeStyleFacadeImpl.$$$reportNull$$$0(4);
        }
        return CodeStyle.getLanguageSettings((PsiFile)psiFile, (Language)language2).SPACE_BEFORE_COMMA;
    }

    @Override
    public boolean useSpaceAfterComma(@NotNull PsiFile psiFile, @NotNull Language language2) {
        if (psiFile == null) {
            CodeStyleFacadeImpl.$$$reportNull$$$0(5);
        }
        if (language2 == null) {
            CodeStyleFacadeImpl.$$$reportNull$$$0(6);
        }
        return CodeStyle.getLanguageSettings((PsiFile)psiFile, (Language)language2).SPACE_AFTER_COMMA;
    }

    @Override
    public boolean useSpaceAroundAssignmentOperators(@NotNull PsiFile psiFile, @NotNull Language language2) {
        if (psiFile == null) {
            CodeStyleFacadeImpl.$$$reportNull$$$0(7);
        }
        if (language2 == null) {
            CodeStyleFacadeImpl.$$$reportNull$$$0(8);
        }
        return CodeStyle.getLanguageSettings((PsiFile)psiFile, (Language)language2).SPACE_AROUND_ASSIGNMENT_OPERATORS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/CodeStyleFacadeImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineIndent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getJoinedLinesSpacing";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "useSpaceBeforeComma";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "useSpaceAfterComma";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "useSpaceAroundAssignmentOperators";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

