/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.diagnostic.PluginException;
import com.intellij.formatting.CoreFormatterUtil;
import com.intellij.formatting.FormatTextRange;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormatterEx;
import com.intellij.formatting.FormatterImpl;
import com.intellij.formatting.FormatterTagHandler;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.CompositeLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PlainTextTokenTypes;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.DocCommentSettings;
import com.intellij.psi.codeStyle.ExternalFormatProcessor;
import com.intellij.psi.codeStyle.FormattingModeAwareIndentAdjuster;
import com.intellij.psi.codeStyle.Indent;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.ChangedRangesUtil;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.psi.impl.source.codeStyle.CodeStyleManagerRunnable;
import com.intellij.psi.impl.source.codeStyle.IndentHelper;
import com.intellij.psi.impl.source.codeStyle.IndentHelperImpl;
import com.intellij.psi.impl.source.codeStyle.IndentImpl;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.impl.source.codeStyle.lineIndent.FormatterBasedIndentAdjuster;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleManagerImpl
extends CodeStyleManager
implements FormattingModeAwareIndentAdjuster {
    private static final Logger LOG = Logger.getInstance(CodeStyleManagerImpl.class);
    private static final ThreadLocal<ProcessingUnderProgressInfo> SEQUENTIAL_PROCESSING_ALLOWED = ThreadLocal.withInitial(() -> new ProcessingUnderProgressInfo());
    private final ThreadLocal<FormattingMode> myCurrentFormattingMode = ThreadLocal.withInitial(() -> FormattingMode.REFORMAT);
    private final Project myProject;
    @NonNls
    private static final String DUMMY_IDENTIFIER = "xxx";

    public CodeStyleManagerImpl(Project project2) {
        this.myProject = project2;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(0);
        }
        return project2;
    }

    @Override
    @NotNull
    public PsiElement reformat(@NotNull PsiElement element2) throws IncorrectOperationException {
        if (element2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(1);
        }
        PsiElement psiElement = this.reformat(element2, false);
        if (psiElement == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiElement reformat(@NotNull PsiElement element2, boolean canChangeWhiteSpacesOnly) throws IncorrectOperationException {
        if (element2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(3);
        }
        CheckUtil.checkWritable(element2);
        if (!SourceTreeToPsiMap.hasTreeElement(element2)) {
            PsiElement psiElement = element2;
            if (psiElement == null) {
                CodeStyleManagerImpl.$$$reportNull$$$0(4);
            }
            return psiElement;
        }
        ASTNode treeElement = element2.getNode();
        PsiFile file2 = element2.getContainingFile();
        if (ExternalFormatProcessor.useExternalFormatter(file2)) {
            PsiElement psiElement = ExternalFormatProcessor.formatElement(element2, element2.getTextRange(), canChangeWhiteSpacesOnly);
            if (psiElement == null) {
                CodeStyleManagerImpl.$$$reportNull$$$0(5);
            }
            return psiElement;
        }
        PsiElement formatted = new CodeFormatterFacade(CodeStyleManagerImpl.getSettings(file2), element2.getLanguage(), canChangeWhiteSpacesOnly).processElement(treeElement).getPsi();
        if (!canChangeWhiteSpacesOnly) {
            PsiElement psiElement = CodeStyleManagerImpl.postProcessElement(file2, formatted);
            if (psiElement == null) {
                CodeStyleManagerImpl.$$$reportNull$$$0(6);
            }
            return psiElement;
        }
        PsiElement psiElement = formatted;
        if (psiElement == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(7);
        }
        return psiElement;
    }

    private static PsiElement postProcessElement(@NotNull PsiFile file2, @NotNull PsiElement formatted) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(8);
        }
        if (formatted == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(9);
        }
        PsiElement result2 = formatted;
        CodeStyleSettings settingsForFile = CodeStyle.getSettings(file2);
        if (settingsForFile.FORMATTER_TAGS_ENABLED && formatted instanceof PsiFile) {
            CodeStyleManagerImpl.postProcessEnabledRanges((PsiFile)formatted, formatted.getTextRange(), settingsForFile);
        } else {
            for (PostFormatProcessor postFormatProcessor : PostFormatProcessor.EP_NAME.getExtensionList()) {
                try {
                    result2 = postFormatProcessor.processElement(result2, settingsForFile);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(PluginException.createByClass(e, postFormatProcessor.getClass()));
                }
            }
        }
        return result2;
    }

    private static void postProcessText(@NotNull PsiFile file2, @NotNull TextRange textRange) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(10);
        }
        if (textRange == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(11);
        }
        if (!CodeStyleManagerImpl.getSettings((PsiFile)file2).FORMATTER_TAGS_ENABLED) {
            TextRange currentRange = textRange;
            for (PostFormatProcessor myPostFormatProcessor : PostFormatProcessor.EP_NAME.getExtensionList()) {
                currentRange = myPostFormatProcessor.processText(file2, currentRange, CodeStyleManagerImpl.getSettings(file2));
            }
        } else {
            CodeStyleManagerImpl.postProcessEnabledRanges(file2, textRange, CodeStyleManagerImpl.getSettings(file2));
        }
    }

    @Override
    public PsiElement reformatRange(@NotNull PsiElement element2, int startOffset, int endOffset, boolean canChangeWhiteSpacesOnly) throws IncorrectOperationException {
        if (element2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(12);
        }
        return CodeStyleManagerImpl.reformatRangeImpl(element2, startOffset, endOffset, canChangeWhiteSpacesOnly);
    }

    @Override
    public PsiElement reformatRange(@NotNull PsiElement element2, int startOffset, int endOffset) throws IncorrectOperationException {
        if (element2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(13);
        }
        return CodeStyleManagerImpl.reformatRangeImpl(element2, startOffset, endOffset, false);
    }

    private static void transformAllChildren(ASTNode file2) {
        ((TreeElement)file2).acceptTree(new RecursiveTreeElementWalkingVisitor(){});
    }

    @Override
    public void reformatText(@NotNull PsiFile file2, int startOffset, int endOffset) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(14);
        }
        this.reformatText(file2, Collections.singleton(new TextRange(startOffset, endOffset)));
    }

    @Override
    public void reformatText(@NotNull PsiFile file2, @NotNull Collection<TextRange> ranges2) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(15);
        }
        if (ranges2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(16);
        }
        this.reformatText(file2, ranges2, null);
    }

    @Override
    public void reformatTextWithContext(@NotNull PsiFile file2, @NotNull ChangedRangesInfo info) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(17);
        }
        if (info == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(18);
        }
        FormatTextRanges formatRanges = new FormatTextRanges(info, ChangedRangesUtil.processChangedRanges(file2, info));
        formatRanges.setExtendToContext(true);
        this.reformatText(file2, formatRanges, null);
    }

    public void reformatText(@NotNull PsiFile file2, @NotNull Collection<? extends TextRange> ranges2, @Nullable Editor editor) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(19);
        }
        if (ranges2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(20);
        }
        FormatTextRanges formatRanges = new FormatTextRanges();
        ranges2.forEach(range2 -> formatRanges.add((TextRange)range2, true));
        this.reformatText(file2, formatRanges, editor);
    }

    private void reformatText(@NotNull PsiFile file2, @NotNull FormatTextRanges ranges2, @Nullable Editor editor) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(21);
        }
        if (ranges2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(22);
        }
        if (ranges2.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        PsiDocumentManager.getInstance(this.getProject()).commitAllDocuments();
        CheckUtil.checkWritable(file2);
        if (!SourceTreeToPsiMap.hasTreeElement(file2)) {
            return;
        }
        ASTNode treeElement = SourceTreeToPsiMap.psiElementToTree(file2);
        CodeStyleManagerImpl.transformAllChildren(treeElement);
        LOG.assertTrue(file2.isValid(), "File name: " + file2.getName() + " , class: " + file2.getClass().getSimpleName());
        if (editor == null) {
            editor = PsiEditorUtil.findEditor(file2);
        }
        CaretPositionKeeper caretKeeper = null;
        if (editor != null) {
            caretKeeper = new CaretPositionKeeper(editor, CodeStyleManagerImpl.getSettings(file2), file2.getLanguage());
        }
        if (FormatterUtil.isFormatterCalledExplicitly()) {
            CodeStyleManagerImpl.removeEndingWhiteSpaceFromEachRange(file2, ranges2);
        }
        CodeStyleManagerImpl.formatRanges(file2, ranges2, ExternalFormatProcessor.useExternalFormatter(file2) ? null : () -> {
            CodeFormatterFacade codeFormatter = new CodeFormatterFacade(CodeStyleManagerImpl.getSettings(file2), file2.getLanguage());
            codeFormatter.processText(file2, ranges2, true);
        });
        if (caretKeeper != null) {
            caretKeeper.restoreCaretPosition();
        }
    }

    public static void formatRanges(@NotNull PsiFile file2, @NotNull FormatTextRanges ranges2, @Nullable Runnable formatAction) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(23);
        }
        if (ranges2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(24);
        }
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance(file2.getProject());
        ArrayList<RangeFormatInfo> infos = new ArrayList<RangeFormatInfo>();
        for (TextRange range2 : ranges2.getTextRanges()) {
            PsiElement start2 = CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file2, range2.getStartOffset());
            PsiElement end = CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file2, range2.getEndOffset());
            if (start2 != null && !start2.isValid()) {
                LOG.error("start=" + start2 + "; file=" + file2);
            }
            if (end != null && !end.isValid()) {
                LOG.error("end=" + start2 + "; end=" + file2);
            }
            boolean formatFromStart = range2.getStartOffset() == 0;
            boolean formatToEnd = range2.getEndOffset() == file2.getTextLength();
            infos.add(new RangeFormatInfo(start2 == null ? null : smartPointerManager.createSmartPsiElementPointer(start2), end == null ? null : smartPointerManager.createSmartPsiElementPointer(end), formatFromStart, formatToEnd));
        }
        if (formatAction != null) {
            formatAction.run();
        }
        for (RangeFormatInfo info : infos) {
            PsiElement endElement;
            PsiElement startElement = info.startPointer == null ? null : (PsiElement)info.startPointer.getElement();
            PsiElement psiElement = endElement = info.endPointer == null ? null : (PsiElement)info.endPointer.getElement();
            if ((startElement != null || info.fromStart) && (endElement != null || info.toEnd)) {
                CodeStyleManagerImpl.postProcessText(file2, new TextRange(info.fromStart ? 0 : startElement.getTextRange().getStartOffset(), info.toEnd ? file2.getTextLength() : endElement.getTextRange().getEndOffset()));
            }
            if (info.startPointer != null) {
                smartPointerManager.removePointer(info.startPointer);
            }
            if (info.endPointer == null) continue;
            smartPointerManager.removePointer(info.endPointer);
        }
    }

    private static void removeEndingWhiteSpaceFromEachRange(@NotNull PsiFile file2, @NotNull FormatTextRanges ranges2) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(25);
        }
        if (ranges2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(26);
        }
        for (FormatTextRange formatRange : ranges2.getRanges()) {
            PsiElement prev;
            TextRange range2 = formatRange.getTextRange();
            int rangeStart = range2.getStartOffset();
            int rangeEnd = range2.getEndOffset();
            PsiElement lastElementInRange = CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file2, rangeEnd);
            if (!(lastElementInRange instanceof PsiWhiteSpace) || rangeStart >= lastElementInRange.getTextRange().getStartOffset() || (prev = lastElementInRange.getPrevSibling()) == null) continue;
            int newEnd = prev.getTextRange().getEndOffset();
            formatRange.setTextRange(new TextRange(rangeStart, newEnd));
        }
    }

    private static PsiElement reformatRangeImpl(@NotNull PsiElement element2, int startOffset, int endOffset, boolean canChangeWhiteSpacesOnly) throws IncorrectOperationException {
        if (element2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(27);
        }
        LOG.assertTrue(element2.isValid());
        CheckUtil.checkWritable(element2);
        if (!SourceTreeToPsiMap.hasTreeElement(element2)) {
            return element2;
        }
        ASTNode treeElement = element2.getNode();
        PsiFile file2 = element2.getContainingFile();
        if (ExternalFormatProcessor.useExternalFormatter(file2)) {
            return ExternalFormatProcessor.formatElement(element2, TextRange.create(startOffset, endOffset), canChangeWhiteSpacesOnly);
        }
        CodeFormatterFacade codeFormatter = new CodeFormatterFacade(CodeStyleManagerImpl.getSettings(file2), element2.getLanguage());
        PsiElement formatted = codeFormatter.processRange(treeElement, startOffset, endOffset).getPsi();
        return canChangeWhiteSpacesOnly ? formatted : CodeStyleManagerImpl.postProcessElement(file2, formatted);
    }

    @Override
    public void reformatNewlyAddedElement(@NotNull ASTNode parent, @NotNull ASTNode addedElement) throws IncorrectOperationException {
        FormattingModelBuilder builder2;
        if (parent == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(28);
        }
        if (addedElement == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(29);
        }
        LOG.assertTrue(addedElement.getTreeParent() == parent, "addedElement must be added to parent");
        PsiElement psiElement = parent.getPsi();
        PsiFile containingFile = psiElement.getContainingFile();
        FileViewProvider fileViewProvider = containingFile.getViewProvider();
        if (fileViewProvider instanceof MultiplePsiFilesPerDocumentFileViewProvider) {
            containingFile = fileViewProvider.getPsi(fileViewProvider.getBaseLanguage());
        }
        assert (containingFile != null);
        TextRange textRange = addedElement.getTextRange();
        Document document = fileViewProvider.getDocument();
        if (document instanceof DocumentWindow) {
            containingFile = InjectedLanguageManager.getInstance(containingFile.getProject()).getTopLevelFile(containingFile);
            textRange = ((DocumentWindow)document).injectedToHost(textRange);
        }
        if ((builder2 = LanguageFormatting.INSTANCE.forContext(containingFile)) != null) {
            FormattingModel model = CoreFormatterUtil.buildModel(builder2, containingFile, CodeStyleManagerImpl.getSettings(containingFile), FormattingMode.REFORMAT);
            FormatterEx.getInstanceEx().formatAroundRange(model, CodeStyleManagerImpl.getSettings(containingFile), containingFile, textRange);
        }
        this.adjustLineIndent(containingFile, textRange);
    }

    @Override
    public int adjustLineIndent(@NotNull PsiFile file2, int offset) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(30);
        }
        return PostprocessReformattingAspect.getInstance(file2.getProject()).disablePostprocessFormattingInside(() -> this.doAdjustLineIndentByOffset(file2, offset, FormattingMode.ADJUST_INDENT));
    }

    @Nullable
    static PsiElement findElementInTreeWithFormatterEnabled(PsiFile file2, int offset) {
        PsiElement bottomost = file2.findElementAt(offset);
        if (bottomost != null && LanguageFormatting.INSTANCE.forContext(bottomost) != null) {
            return bottomost;
        }
        Language fileLang = file2.getLanguage();
        if (fileLang instanceof CompositeLanguage) {
            return file2.getViewProvider().findElementAt(offset, fileLang);
        }
        return bottomost;
    }

    @Override
    public int adjustLineIndent(@NotNull Document document, int offset, FormattingMode mode) {
        if (document == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(31);
        }
        return PostprocessReformattingAspect.getInstance(this.getProject()).disablePostprocessFormattingInside(() -> {
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance(this.myProject);
            documentManager.commitDocument(document);
            PsiFile file2 = documentManager.getPsiFile(document);
            if (file2 == null) {
                return offset;
            }
            return this.doAdjustLineIndentByOffset(file2, offset, mode);
        });
    }

    @Override
    public int adjustLineIndent(@NotNull Document document, int offset) {
        if (document == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(32);
        }
        return this.adjustLineIndent(document, offset, FormattingMode.ADJUST_INDENT);
    }

    private int doAdjustLineIndentByOffset(@NotNull PsiFile file2, int offset, FormattingMode mode) {
        Integer result2;
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(33);
        }
        return (result2 = (Integer)new CodeStyleManagerRunnable<Integer>(this, mode){

            @Override
            protected Integer doPerform(int offset, TextRange range2) {
                return FormatterEx.getInstanceEx().adjustLineIndent(this.myModel, this.mySettings, this.myIndentOptions, offset, this.mySignificantRange);
            }

            @Override
            protected Integer computeValueInsidePlainComment(PsiFile file2, int offset, Integer defaultValue) {
                return CharArrayUtil.shiftForward(file2.getViewProvider().getContents(), offset, " \t");
            }

            @Override
            protected Integer adjustResultForInjected(Integer result2, DocumentWindow documentWindow) {
                return result2 != null ? Integer.valueOf(documentWindow.hostToInjected(result2)) : null;
            }
        }.perform(file2, offset, null, null)) != null ? result2 : offset;
    }

    @Override
    public void adjustLineIndent(@NotNull PsiFile file2, TextRange rangeToAdjust) throws IncorrectOperationException {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(34);
        }
        new CodeStyleManagerRunnable<Object>(this, FormattingMode.ADJUST_INDENT){

            @Override
            protected Object doPerform(int offset, TextRange range2) {
                FormatterEx.getInstanceEx().adjustLineIndentsForRange(this.myModel, this.mySettings, this.myIndentOptions, range2);
                return null;
            }
        }.perform(file2, -1, rangeToAdjust, null);
    }

    @Override
    @Nullable
    public String getLineIndent(@NotNull PsiFile file2, int offset) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(35);
        }
        return this.getLineIndent(file2, offset, FormattingMode.ADJUST_INDENT);
    }

    @Override
    @Nullable
    public String getLineIndent(@NotNull PsiFile file2, int offset, FormattingMode mode) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(36);
        }
        return new CodeStyleManagerRunnable<String>(this, mode){

            @Override
            protected boolean useDocumentBaseFormattingModel() {
                return false;
            }

            @Override
            protected String doPerform(int offset, TextRange range2) {
                return FormatterEx.getInstanceEx().getLineIndent(this.myModel, this.mySettings, this.myIndentOptions, offset, this.mySignificantRange);
            }
        }.perform(file2, offset, null, null);
    }

    @Override
    @Nullable
    public String getLineIndent(@NotNull Document document, int offset) {
        PsiFile file2;
        if (document == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(37);
        }
        if ((file2 = PsiDocumentManager.getInstance(this.myProject).getPsiFile(document)) == null) {
            return "";
        }
        return this.getLineIndent(file2, offset);
    }

    @Override
    @Deprecated
    public boolean isLineToBeIndented(@NotNull PsiFile file2, int offset) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(38);
        }
        if (!SourceTreeToPsiMap.hasTreeElement(file2)) {
            return false;
        }
        CharSequence chars = file2.getViewProvider().getContents();
        int start2 = CharArrayUtil.shiftBackward(chars, offset - 1, " \t");
        if (start2 > 0 && chars.charAt(start2) != '\n' && chars.charAt(start2) != '\r') {
            return false;
        }
        int end = CharArrayUtil.shiftForward(chars, offset, " \t");
        if (end >= chars.length()) {
            return false;
        }
        ASTNode element2 = SourceTreeToPsiMap.psiElementToTree(CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file2, end));
        if (element2 == null) {
            return false;
        }
        if (element2.getElementType() == TokenType.WHITE_SPACE) {
            return false;
        }
        if (element2.getElementType() == PlainTextTokenTypes.PLAIN_TEXT) {
            return false;
        }
        return !CodeStyleManagerImpl.getSettings((PsiFile)file2).getCommonSettings((Language)file2.getLanguage()).KEEP_FIRST_COLUMN_COMMENT || !CodeStyleManagerImpl.isCommentToken(element2) || IndentHelper.getInstance().getIndent(this.myProject, file2.getFileType(), element2, true) != 0;
    }

    private static boolean isCommentToken(ASTNode element2) {
        Language language2 = element2.getElementType().getLanguage();
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language2);
        if (commenter instanceof CodeDocumentationAwareCommenter) {
            CodeDocumentationAwareCommenter documentationAwareCommenter = (CodeDocumentationAwareCommenter)commenter;
            return element2.getElementType() == documentationAwareCommenter.getBlockCommentTokenType() || element2.getElementType() == documentationAwareCommenter.getLineCommentTokenType();
        }
        return false;
    }

    private static boolean isWhiteSpaceSymbol(char c) {
        return c == ' ' || c == '\t' || c == '\n';
    }

    @Nullable
    public static TextRange insertNewLineIndentMarker(@NotNull PsiFile file2, @NotNull Document document, int offset) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(39);
        }
        if (document == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(40);
        }
        CharSequence text2 = document.getImmutableCharSequence();
        if (offset <= 0 || offset >= text2.length() || !CodeStyleManagerImpl.isWhiteSpaceSymbol(text2.charAt(offset))) {
            return null;
        }
        if (!CodeStyleManagerImpl.isWhiteSpaceSymbol(text2.charAt(offset - 1))) {
            return null;
        }
        for (int end = offset; end < text2.length() && text2.charAt(end) != '\n'; ++end) {
            if (CodeStyleManagerImpl.isWhiteSpaceSymbol(text2.charAt(end))) continue;
            return null;
        }
        CodeStyleManagerImpl.setSequentialProcessingAllowed(false);
        String dummy = CodeStyleManagerImpl.createDummy(file2);
        document.insertString(offset, dummy);
        return new TextRange(offset, offset + dummy.length());
    }

    @NotNull
    private static String createDummy(@NotNull PsiFile file2) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(41);
        }
        Language language2 = file2.getLanguage();
        PsiElement comment = null;
        try {
            comment = PsiParserFacade.SERVICE.getInstance(file2.getProject()).createLineOrBlockCommentFromText(language2, "");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String text2 = comment != null ? comment.getText() : null;
        return text2 != null ? text2 : DUMMY_IDENTIFIER;
    }

    @Nullable
    public static PsiElement findWhiteSpaceNode(@NotNull PsiFile file2, int offset) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(42);
        }
        return (PsiElement)CodeStyleManagerImpl.doFindWhiteSpaceNode((PsiFile)file2, (int)offset).first;
    }

    @NotNull
    private static Pair<PsiElement, CharTable> doFindWhiteSpaceNode(@NotNull PsiFile file2, int offset) {
        ASTNode astNode;
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(43);
        }
        if (!((astNode = SourceTreeToPsiMap.psiElementToTree(file2)) instanceof FileElement)) {
            return new Pair<Object, Object>(null, null);
        }
        PsiElement elementAt = InjectedLanguageManager.getInstance(file2.getProject()).findInjectedElementAt(file2, offset);
        CharTable charTable = ((FileElement)astNode).getCharTable();
        if (elementAt == null) {
            elementAt = CodeStyleManagerImpl.findElementInTreeWithFormatterEnabled(file2, offset);
        }
        if (elementAt == null) {
            return new Pair<Object, CharTable>(null, charTable);
        }
        ASTNode node = elementAt.getNode();
        if (node == null || node.getElementType() != TokenType.WHITE_SPACE) {
            return new Pair<Object, CharTable>(null, charTable);
        }
        Pair<PsiElement, CharTable> pair = Pair.create(elementAt, charTable);
        if (pair == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(44);
        }
        return pair;
    }

    @Override
    public Indent getIndent(String text2, FileType fileType) {
        int indent = IndentHelperImpl.getIndent(CodeStyle.getSettings(this.myProject).getIndentOptions(fileType), text2, true);
        int indentLevel = indent / 10000;
        int spaceCount = indent - indentLevel * 10000;
        return new IndentImpl(CodeStyle.getSettings(this.myProject), indentLevel, spaceCount, fileType);
    }

    @Override
    public String fillIndent(Indent indent, FileType fileType) {
        IndentImpl indent1 = (IndentImpl)indent;
        int indentLevel = indent1.getIndentLevel();
        int spaceCount = indent1.getSpaceCount();
        CodeStyleSettings settings = CodeStyle.getSettings(this.myProject);
        if (indentLevel < 0) {
            spaceCount += indentLevel * settings.getIndentSize(fileType);
            indentLevel = 0;
            if (spaceCount < 0) {
                spaceCount = 0;
            }
        } else if (spaceCount < 0) {
            int v = (-spaceCount + settings.getIndentSize(fileType) - 1) / settings.getIndentSize(fileType);
            spaceCount += v * settings.getIndentSize(fileType);
            if ((indentLevel -= v) < 0) {
                indentLevel = 0;
            }
        }
        return IndentHelperImpl.fillIndent(this.myProject, fileType, indentLevel * 10000 + spaceCount);
    }

    @Override
    public Indent zeroIndent() {
        return new IndentImpl(CodeStyle.getSettings(this.myProject), 0, 0, null);
    }

    @NotNull
    private static CodeStyleSettings getSettings(@NotNull PsiFile file2) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(45);
        }
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings(file2);
        if (codeStyleSettings == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(46);
        }
        return codeStyleSettings;
    }

    @Override
    public boolean isSequentialProcessingAllowed() {
        return SEQUENTIAL_PROCESSING_ALLOWED.get().isAllowed();
    }

    public static void setSequentialProcessingAllowed(boolean allowed) {
        ProcessingUnderProgressInfo info = SEQUENTIAL_PROCESSING_ALLOWED.get();
        if (allowed) {
            info.decrement();
        } else {
            info.increment();
        }
    }

    @Override
    public void performActionWithFormatterDisabled(Runnable r) {
        this.performActionWithFormatterDisabled(() -> {
            r.run();
            return null;
        });
    }

    @Override
    public <T extends Throwable> void performActionWithFormatterDisabled(ThrowableRunnable<T> r) throws T {
        Throwable[] throwable = new Throwable[1];
        this.performActionWithFormatterDisabled(() -> {
            try {
                r.run();
            }
            catch (Throwable t) {
                throwable[0] = t;
            }
            return null;
        });
        if (throwable[0] != null) {
            throw throwable[0];
        }
    }

    @Override
    public <T> T performActionWithFormatterDisabled(Computable<T> r) {
        return (T)((FormatterImpl)FormatterEx.getInstance()).runWithFormattingDisabled(() -> {
            PostprocessReformattingAspect component2 = PostprocessReformattingAspect.getInstance(this.getProject());
            return component2.disablePostprocessFormattingInside(r);
        });
    }

    private static void postProcessEnabledRanges(@NotNull PsiFile file2, @NotNull TextRange range2, CodeStyleSettings settings) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(47);
        }
        if (range2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(48);
        }
        List<TextRange> enabledRanges = new FormatterTagHandler(CodeStyleManagerImpl.getSettings(file2)).getEnabledRanges(file2.getNode(), range2);
        int delta = 0;
        for (TextRange enabledRange : enabledRanges) {
            enabledRange = enabledRange.shiftRight(delta);
            for (PostFormatProcessor processor2 : PostFormatProcessor.EP_NAME.getExtensionList()) {
                TextRange processedRange = processor2.processText(file2, enabledRange, settings);
                delta += processedRange.getLength() - enabledRange.getLength();
            }
        }
    }

    @Override
    public FormattingMode getCurrentFormattingMode() {
        return this.myCurrentFormattingMode.get();
    }

    void setCurrentFormattingMode(@NotNull FormattingMode mode) {
        if (mode == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(49);
        }
        this.myCurrentFormattingMode.set(mode);
    }

    @Override
    public int getSpacing(@NotNull PsiFile file2, int offset) {
        FormattingModel model;
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(50);
        }
        return (model = CodeStyleManagerImpl.createFormattingModel(file2)) == null ? -1 : FormatterEx.getInstance().getSpacingForBlockAtOffset(model, offset);
    }

    @Override
    public int getMinLineFeeds(@NotNull PsiFile file2, int offset) {
        FormattingModel model;
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(51);
        }
        return (model = CodeStyleManagerImpl.createFormattingModel(file2)) == null ? -1 : FormatterEx.getInstance().getMinLineFeedsBeforeBlockAtOffset(model, offset);
    }

    @Nullable
    private static FormattingModel createFormattingModel(@NotNull PsiFile file2) {
        FormattingModelBuilder builder2;
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(52);
        }
        if ((builder2 = LanguageFormatting.INSTANCE.forContext(file2)) == null) {
            return null;
        }
        CodeStyleSettings settings = CodeStyle.getSettings(file2);
        return builder2.createModel(file2, settings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runWithDocCommentFormattingDisabled(@NotNull PsiFile file2, @NotNull Runnable runnable2) {
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(53);
        }
        if (runnable2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(54);
        }
        DocCommentSettings docSettings = this.getDocCommentSettings(file2);
        boolean currDocFormattingEnabled = docSettings.isDocFormattingEnabled();
        docSettings.setDocFormattingEnabled(false);
        try {
            runnable2.run();
        }
        finally {
            docSettings.setDocFormattingEnabled(currDocFormattingEnabled);
        }
    }

    @Override
    @NotNull
    public DocCommentSettings getDocCommentSettings(@NotNull PsiFile file2) {
        Language language2;
        LanguageCodeStyleSettingsProvider settingsProvider;
        if (file2 == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(55);
        }
        if ((settingsProvider = LanguageCodeStyleSettingsProvider.forLanguage(language2 = file2.getLanguage())) != null) {
            DocCommentSettings docCommentSettings = settingsProvider.getDocCommentSettings(CodeStyle.getSettings(file2));
            if (docCommentSettings == null) {
                CodeStyleManagerImpl.$$$reportNull$$$0(56);
            }
            return docCommentSettings;
        }
        DocCommentSettings docCommentSettings = DocCommentSettings.DEFAULTS;
        if (docCommentSettings == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(57);
        }
        return docCommentSettings;
    }

    @Override
    public void scheduleIndentAdjustment(@NotNull Document document, int offset) {
        if (document == null) {
            CodeStyleManagerImpl.$$$reportNull$$$0(58);
        }
        FormatterBasedIndentAdjuster.scheduleIndentAdjustment(this.myProject, document, offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 58: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 58: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl";
                break;
            }
            case 1: 
            case 3: 
            case 12: 
            case 13: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 10: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatted";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 16: 
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedElement";
                break;
            }
            case 31: 
            case 32: 
            case 37: 
            case 40: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "reformat";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "doFindWhiteSpaceNode";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocCommentSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reformat";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "postProcessElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "postProcessText";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "reformatRange";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "reformatText";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "reformatTextWithContext";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "formatRanges";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "removeEndingWhiteSpaceFromEachRange";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "reformatRangeImpl";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "reformatNewlyAddedElement";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "adjustLineIndent";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "doAdjustLineIndentByOffset";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndent";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isLineToBeIndented";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "insertNewLineIndentMarker";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createDummy";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "findWhiteSpaceNode";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "doFindWhiteSpaceNode";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getSettings";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "postProcessEnabledRanges";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentFormattingMode";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getMinLineFeeds";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createFormattingModel";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "runWithDocCommentFormattingDisabled";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getDocCommentSettings";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "scheduleIndentAdjustment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 58: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CaretPositionKeeper {
        Editor myEditor;
        Document myDocument;
        CaretModel myCaretModel;
        RangeMarker myBeforeCaretRangeMarker;
        String myCaretIndentToRestore;
        int myVisualColumnToRestore;
        boolean myBlankLineIndentPreserved;

        CaretPositionKeeper(@NotNull Editor editor, @NotNull CodeStyleSettings settings, @NotNull Language language2) {
            if (editor == null) {
                CaretPositionKeeper.$$$reportNull$$$0(0);
            }
            if (settings == null) {
                CaretPositionKeeper.$$$reportNull$$$0(1);
            }
            if (language2 == null) {
                CaretPositionKeeper.$$$reportNull$$$0(2);
            }
            this.myVisualColumnToRestore = -1;
            this.myEditor = editor;
            this.myCaretModel = editor.getCaretModel();
            this.myDocument = editor.getDocument();
            this.myBlankLineIndentPreserved = CaretPositionKeeper.isBlankLineIndentPreserved(settings, language2);
            int caretOffset = this.getCaretOffset();
            int lineStartOffset = this.getLineStartOffsetByTotalOffset(caretOffset);
            int lineEndOffset = this.getLineEndOffsetByTotalOffset(caretOffset);
            boolean shouldFixCaretPosition = CharArrayUtil.isEmptyOrSpaces(this.myDocument.getCharsSequence(), lineStartOffset, lineEndOffset);
            if (shouldFixCaretPosition) {
                this.initRestoreInfo(caretOffset);
            }
        }

        private static boolean isBlankLineIndentPreserved(@NotNull CodeStyleSettings settings, @NotNull Language language2) {
            CommonCodeStyleSettings langSettings;
            CommonCodeStyleSettings.IndentOptions indentOptions;
            if (settings == null) {
                CaretPositionKeeper.$$$reportNull$$$0(3);
            }
            if (language2 == null) {
                CaretPositionKeeper.$$$reportNull$$$0(4);
            }
            return (indentOptions = (langSettings = settings.getCommonSettings(language2)).getIndentOptions()) != null && indentOptions.KEEP_INDENTS_ON_EMPTY_LINES;
        }

        private void initRestoreInfo(int caretOffset) {
            int lineStartOffset = this.getLineStartOffsetByTotalOffset(caretOffset);
            this.myVisualColumnToRestore = this.myCaretModel.getVisualPosition().column;
            this.myCaretIndentToRestore = this.myDocument.getText(TextRange.create(lineStartOffset, caretOffset));
            this.myBeforeCaretRangeMarker = this.myDocument.createRangeMarker(0, lineStartOffset);
        }

        public void restoreCaretPosition() {
            if (this.isVirtualSpaceEnabled()) {
                this.restoreVisualPosition();
            } else {
                this.restorePositionByIndentInsertion();
            }
        }

        private void restorePositionByIndentInsertion() {
            if (this.myBeforeCaretRangeMarker == null || !this.myBeforeCaretRangeMarker.isValid() || this.myCaretIndentToRestore == null || this.myBlankLineIndentPreserved) {
                return;
            }
            int newCaretLineStartOffset = this.myBeforeCaretRangeMarker.getEndOffset();
            this.myBeforeCaretRangeMarker.dispose();
            if (this.myCaretModel.getVisualPosition().column == this.myVisualColumnToRestore) {
                return;
            }
            Project project2 = this.myEditor.getProject();
            if (project2 == null || PsiDocumentManager.getInstance(project2).isDocumentBlockedByPsi(this.myDocument)) {
                return;
            }
            this.insertWhiteSpaceIndentIfNeeded(newCaretLineStartOffset);
        }

        private void restoreVisualPosition() {
            if (this.myVisualColumnToRestore < 0) {
                EditorUtil.runWithAnimationDisabled(this.myEditor, () -> this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE));
                return;
            }
            VisualPosition position = this.myCaretModel.getVisualPosition();
            if (this.myVisualColumnToRestore != position.column) {
                this.myCaretModel.moveToVisualPosition(new VisualPosition(position.line, this.myVisualColumnToRestore));
            }
        }

        private void insertWhiteSpaceIndentIfNeeded(int caretLineOffset) {
            int lineToInsertIndent = this.myDocument.getLineNumber(caretLineOffset);
            if (!this.lineContainsWhiteSpaceSymbolsOnly(lineToInsertIndent)) {
                return;
            }
            int lineToInsertStartOffset = this.myDocument.getLineStartOffset(lineToInsertIndent);
            if (lineToInsertIndent != this.getCurrentCaretLine()) {
                this.myCaretModel.moveToOffset(lineToInsertStartOffset);
            }
            this.myDocument.replaceString(lineToInsertStartOffset, caretLineOffset, this.myCaretIndentToRestore);
        }

        private boolean isVirtualSpaceEnabled() {
            return this.myEditor.getSettings().isVirtualSpace();
        }

        private int getLineStartOffsetByTotalOffset(int offset) {
            int line = this.myDocument.getLineNumber(offset);
            return this.myDocument.getLineStartOffset(line);
        }

        private int getLineEndOffsetByTotalOffset(int offset) {
            int line = this.myDocument.getLineNumber(offset);
            return this.myDocument.getLineEndOffset(line);
        }

        private int getCaretOffset() {
            int caretOffset = this.myCaretModel.getOffset();
            caretOffset = Math.max(Math.min(caretOffset, this.myDocument.getTextLength() - 1), 0);
            return caretOffset;
        }

        private boolean lineContainsWhiteSpaceSymbolsOnly(int lineNumber) {
            int startOffset = this.myDocument.getLineStartOffset(lineNumber);
            int endOffset = this.myDocument.getLineEndOffset(lineNumber);
            return CharArrayUtil.isEmptyOrSpaces(this.myDocument.getCharsSequence(), startOffset, endOffset);
        }

        private int getCurrentCaretLine() {
            return this.myDocument.getLineNumber(this.myCaretModel.getOffset());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/CodeStyleManagerImpl$CaretPositionKeeper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isBlankLineIndentPreserved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class RangeFormatInfo {
        private final SmartPsiElementPointer<?> startPointer;
        private final SmartPsiElementPointer<?> endPointer;
        private final boolean fromStart;
        private final boolean toEnd;

        RangeFormatInfo(@Nullable SmartPsiElementPointer<?> startPointer, @Nullable SmartPsiElementPointer<?> endPointer, boolean fromStart, boolean toEnd) {
            this.startPointer = startPointer;
            this.endPointer = endPointer;
            this.fromStart = fromStart;
            this.toEnd = toEnd;
        }
    }

    private static class ProcessingUnderProgressInfo {
        private static final long DURATION_TIME = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS);
        private int myCount;
        private long myEndTime;

        private ProcessingUnderProgressInfo() {
        }

        public void increment() {
            if (this.myCount > 0 && System.currentTimeMillis() > this.myEndTime) {
                this.myCount = 0;
            }
            ++this.myCount;
            this.myEndTime = System.currentTimeMillis() + DURATION_TIME;
        }

        public void decrement() {
            if (this.myCount <= 0) {
                return;
            }
            --this.myCount;
        }

        public boolean isAllowed() {
            return this.myCount <= 0 || System.currentTimeMillis() >= this.myEndTime;
        }
    }
}

