/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.lineIndent;

import com.intellij.formatting.FormattingMode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.text.BlockSupport;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FormatterBasedIndentAdjuster {
    private static final int MAX_SYNCHRONOUS_ADJUSTMENT_DOC_SIZE = 100000;

    private FormatterBasedIndentAdjuster() {
    }

    public static void scheduleIndentAdjustment(@NotNull Project project2, @NotNull Document document, int offset) {
        PsiFile file2;
        if (project2 == null) {
            FormatterBasedIndentAdjuster.$$$reportNull$$$0(0);
        }
        if (document == null) {
            FormatterBasedIndentAdjuster.$$$reportNull$$$0(1);
        }
        if ((file2 = PsiDocumentManager.getInstance(project2).getPsiFile(document)) != null) {
            IndentAdjusterRunnable fixer = new IndentAdjusterRunnable(project2, document, file2, offset);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project2);
            if (FormatterBasedIndentAdjuster.isSynchronousAdjustment(document, file2)) {
                documentManager.commitDocument(document);
            }
            fixer.run();
        }
    }

    private static boolean isSynchronousAdjustment(@NotNull Document document, @NotNull PsiFile file2) {
        if (document == null) {
            FormatterBasedIndentAdjuster.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            FormatterBasedIndentAdjuster.$$$reportNull$$$0(3);
        }
        return ApplicationManager.getApplication().isUnitTestMode() || document.getTextLength() <= 100000 && !BlockSupport.isTooDeep(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/lineIndent/FormatterBasedIndentAdjuster";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleIndentAdjustment";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isSynchronousAdjustment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class IndentAdjusterRunnable
    implements Runnable {
        private final Project myProject;
        private final int myLine;
        private final Document myDocument;
        private final PsiFile myFile;

        public IndentAdjusterRunnable(@NotNull Project project2, @NotNull Document document, @NotNull PsiFile file2, int offset) {
            if (project2 == null) {
                IndentAdjusterRunnable.$$$reportNull$$$0(0);
            }
            if (document == null) {
                IndentAdjusterRunnable.$$$reportNull$$$0(1);
            }
            if (file2 == null) {
                IndentAdjusterRunnable.$$$reportNull$$$0(2);
            }
            this.myProject = project2;
            this.myDocument = document;
            this.myLine = this.myDocument.getLineNumber(offset);
            this.myFile = file2;
        }

        @Override
        public void run() {
            int lineStart = this.myDocument.getLineStartOffset(this.myLine);
            int indentEnd = CharArrayUtil.shiftForward(this.myDocument.getCharsSequence(), lineStart, " \t");
            RangeMarker indentMarker = this.myDocument.createRangeMarker(lineStart, indentEnd);
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(this.myProject);
            if (FormatterBasedIndentAdjuster.isSynchronousAdjustment(this.myDocument, this.myFile)) {
                this.updateIndent(indentMarker, codeStyleManager.getLineIndent(this.myFile, lineStart, FormattingMode.ADJUST_INDENT_ON_ENTER));
            } else {
                ReadAction.nonBlocking(() -> codeStyleManager.getLineIndent(this.myFile, lineStart, FormattingMode.ADJUST_INDENT_ON_ENTER)).withDocumentsCommitted(this.myProject).finishOnUiThread(ModalityState.NON_MODAL, indentString -> this.updateIndent(indentMarker, (String)indentString)).submit(AppExecutorUtil.getAppExecutorService());
            }
        }

        private void updateIndent(@NotNull RangeMarker indentMarker, @Nullable String newIndent) {
            if (indentMarker == null) {
                IndentAdjusterRunnable.$$$reportNull$$$0(3);
            }
            if (newIndent != null) {
                CommandProcessor.getInstance().runUndoTransparentAction(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                    this.myDocument.replaceString(indentMarker.getStartOffset(), indentMarker.getEndOffset(), newIndent);
                    indentMarker.dispose();
                }));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indentMarker";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/lineIndent/FormatterBasedIndentAdjuster$IndentAdjusterRunnable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateIndent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

