/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditReadOnlyListener;
import com.intellij.openapi.editor.ex.LineIterator;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.impl.source.tree.injected.RangeMarkerWindow;
import com.intellij.psi.impl.source.tree.injected.ShredImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.ImmutableCharSequence;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DocumentWindowImpl
extends UserDataHolderBase
implements Disposable,
DocumentWindow,
DocumentEx {
    private static final Logger LOG = Logger.getInstance(DocumentWindowImpl.class);
    private final DocumentEx myDelegate;
    private final boolean myOneLine;
    private Place myShreds;
    private final int myPrefixLineCount;
    private final int mySuffixLineCount;
    private final Object myLock;
    private CachedText myCachedText;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DocumentWindowImpl(@NotNull DocumentEx delegate, @NotNull Place shreds) {
        if (delegate == null) {
            DocumentWindowImpl.$$$reportNull$$$0(0);
        }
        if (shreds == null) {
            DocumentWindowImpl.$$$reportNull$$$0(1);
        }
        this.myLock = new Object();
        this.myDelegate = delegate;
        this.myOneLine = ContainerUtil.and(shreds, s -> ((ShredImpl)s).isOneLine());
        Object object = this.myLock;
        synchronized (object) {
            this.myShreds = shreds;
        }
        this.myPrefixLineCount = Math.max(1, 1 + StringUtil.countNewLines(((PsiLanguageInjectionHost.Shred)shreds.get(0)).getPrefix()));
        this.mySuffixLineCount = Math.max(1, 1 + StringUtil.countNewLines(((PsiLanguageInjectionHost.Shred)shreds.get(shreds.size() - 1)).getSuffix()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable(value="null means we were unable to calculate")
    @Nullable(value="null means we were unable to calculate") LogicalPosition hostToInjectedInVirtualSpace(@NotNull LogicalPosition hPos) {
        if (hPos == null) {
            DocumentWindowImpl.$$$reportNull$$$0(2);
        }
        int hLineStartOffset = hPos.line >= this.myDelegate.getLineCount() ? this.myDelegate.getTextLength() : this.myDelegate.getLineStartOffset(hPos.line);
        int iLineStartOffset = this.hostToInjected(hLineStartOffset);
        int iLine = this.getLineNumber(iLineStartOffset);
        Object object = this.myLock;
        synchronized (object) {
            for (int i = this.myShreds.size() - 1; i >= 0; --i) {
                Segment hostRangeMarker;
                PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)this.myShreds.get(i);
                if (!shred.isValid() || (hostRangeMarker = shred.getHostRangeMarker()) == null) continue;
                int hShredEndOffset = hostRangeMarker.getEndOffset();
                int hShredStartOffset = hostRangeMarker.getStartOffset();
                int hShredStartLine = this.myDelegate.getLineNumber(hShredStartOffset);
                int hShredEndLine = this.myDelegate.getLineNumber(hShredEndOffset);
                if (hShredStartLine > hPos.line || hPos.line > hShredEndLine) continue;
                int hColumnOfShredEnd = hShredEndOffset - hLineStartOffset;
                int iColumnOfShredEnd = this.hostToInjected(hShredEndOffset) - iLineStartOffset;
                int iColumn = iColumnOfShredEnd + hPos.column - hColumnOfShredEnd;
                return new LogicalPosition(iLine, iColumn);
            }
        }
        return null;
    }

    @Override
    public int getLineCount() {
        return 1 + StringUtil.countNewLines(this.getText());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLineStartOffset(int line) {
        LOG.assertTrue(line >= 0, line);
        if (line == 0) {
            return 0;
        }
        String hostText = this.myDelegate.getText();
        int[] pos = new int[2];
        Object object = this.myLock;
        synchronized (object) {
            for (PsiLanguageInjectionHost.Shred shred : this.myShreds) {
                Segment hostRange = shred.getHostRangeMarker();
                if (hostRange == null) continue;
                int found2 = DocumentWindowImpl.countNewLinesIn(shred.getPrefix(), pos, line);
                if (found2 != -1) {
                    return found2;
                }
                CharSequence text2 = hostText.subSequence(hostRange.getStartOffset(), hostRange.getEndOffset());
                found2 = DocumentWindowImpl.countNewLinesIn(text2, pos, line);
                if (found2 != -1) {
                    return found2;
                }
                found2 = DocumentWindowImpl.countNewLinesIn(shred.getSuffix(), pos, line);
                if (found2 == -1) continue;
                return found2;
            }
        }
        return pos[1];
    }

    private static int countNewLinesIn(CharSequence text2, int[] pos, int line) {
        int offsetInside = 0;
        int i = StringUtil.indexOf(text2, '\n');
        while (i != -1) {
            int curLine = pos[0] = pos[0] + 1;
            int lineLength = i + 1 - offsetInside;
            int offset = pos[1] = pos[1] + lineLength;
            offsetInside += lineLength;
            if (curLine == line) {
                return offset;
            }
            i = StringUtil.indexOf(text2, '\n', offsetInside);
        }
        pos[1] = pos[1] + (text2.length() - offsetInside);
        return -1;
    }

    @Override
    public int getLineEndOffset(int line) {
        LOG.assertTrue(line >= 0, line);
        if (line == this.getLineCount() - 1) {
            return this.getTextLength();
        }
        int startOffsetOfNextLine = this.getLineStartOffset(line + 1);
        return startOffsetOfNextLine == 0 || this.getText().charAt(startOffsetOfNextLine - 1) != '\n' ? startOffsetOfNextLine : startOffsetOfNextLine - 1;
    }

    @Override
    @NotNull
    public String getText() {
        CachedText cachedText = this.myCachedText;
        if (cachedText == null || cachedText.getModificationStamp() != this.getModificationStamp()) {
            this.myCachedText = cachedText = new CachedText(this.calcText(), this.getModificationStamp());
        }
        String string = cachedText.getText();
        if (string == null) {
            DocumentWindowImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private String calcText() {
        StringBuilder text2 = new StringBuilder();
        CharSequence hostText = this.myDelegate.getCharsSequence();
        Object object = this.myLock;
        synchronized (object) {
            for (PsiLanguageInjectionHost.Shred shred : this.myShreds) {
                Segment hostRange = shred.getHostRangeMarker();
                if (hostRange == null) continue;
                text2.append(shred.getPrefix());
                text2.append(hostText, hostRange.getStartOffset(), hostRange.getEndOffset());
                text2.append(shred.getSuffix());
            }
        }
        String string = text2.toString();
        if (string == null) {
            DocumentWindowImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public CharSequence getImmutableCharSequence() {
        CharSequence charSequence = ImmutableCharSequence.asImmutable(this.getText());
        if (charSequence == null) {
            DocumentWindowImpl.$$$reportNull$$$0(5);
        }
        return charSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTextLength() {
        int length = 0;
        Object object = this.myLock;
        synchronized (object) {
            for (PsiLanguageInjectionHost.Shred shred : this.myShreds) {
                Segment hostRange = shred.getHostRangeMarker();
                if (hostRange == null) continue;
                length += shred.getPrefix().length();
                length += hostRange.getEndOffset() - hostRange.getStartOffset();
                length += shred.getSuffix().length();
            }
        }
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLineNumber(int offset) {
        int lineNumber = 0;
        String hostText = this.myDelegate.getText();
        Object object = this.myLock;
        synchronized (object) {
            for (PsiLanguageInjectionHost.Shred shred : this.myShreds) {
                String prefix = shred.getPrefix();
                String suffix = shred.getSuffix();
                lineNumber += StringUtil.getLineBreakCount(prefix.substring(0, Math.min(offset, prefix.length())));
                if (offset < prefix.length()) {
                    return lineNumber;
                }
                offset -= prefix.length();
                Segment currentRange = shred.getHostRangeMarker();
                if (currentRange == null) continue;
                int rangeLength = currentRange.getEndOffset() - currentRange.getStartOffset();
                CharSequence rangeText = hostText.subSequence(currentRange.getStartOffset(), currentRange.getEndOffset());
                lineNumber += StringUtil.getLineBreakCount(rangeText.subSequence(0, Math.min(offset, rangeLength)));
                if (offset < rangeLength) {
                    return lineNumber;
                }
                lineNumber += StringUtil.getLineBreakCount(suffix.substring(0, Math.min(offset -= rangeLength, suffix.length())));
                if (offset < suffix.length()) {
                    return lineNumber;
                }
                offset -= suffix.length();
            }
        }
        lineNumber = this.getLineCount() - 1;
        return lineNumber < 0 ? 0 : lineNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TextRange getHostRange(int hostOffset) {
        Object object = this.myLock;
        synchronized (object) {
            for (PsiLanguageInjectionHost.Shred shred : this.myShreds) {
                ProperTextRange textRange;
                Segment currentRange = shred.getHostRangeMarker();
                if (currentRange == null || !((TextRange)(textRange = ProperTextRange.create(currentRange))).grown(1).contains(hostOffset)) continue;
                return textRange;
            }
        }
        return null;
    }

    @Override
    public void insertString(int offset, @NotNull CharSequence s) {
        if (s == null) {
            DocumentWindowImpl.$$$reportNull$$$0(6);
        }
        assert (this.intersectWithEditable(new TextRange(offset, offset)) != null);
        if (this.isOneLine()) {
            s = StringUtil.replace(s.toString(), "\n", "");
        }
        this.myDelegate.insertString(this.injectedToHost(offset), s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteString(int startOffset, int endOffset) {
        ArrayList<TextRange> hostRangesToDelete;
        assert (this.intersectWithEditable(new TextRange(startOffset, startOffset)) != null);
        assert (this.intersectWithEditable(new TextRange(endOffset, endOffset)) != null);
        Object object = this.myLock;
        synchronized (object) {
            hostRangesToDelete = new ArrayList<TextRange>(this.myShreds.size());
            int offset = startOffset;
            int curRangeStart = 0;
            for (PsiLanguageInjectionHost.Shred shred : this.myShreds) {
                if (offset < (curRangeStart += shred.getPrefix().length())) {
                    offset = curRangeStart;
                }
                if (offset >= endOffset) break;
                Segment hostRange = shred.getHostRangeMarker();
                if (hostRange == null) continue;
                int hostRangeLength = hostRange.getEndOffset() - hostRange.getStartOffset();
                TextRange range2 = TextRange.from(curRangeStart, hostRangeLength);
                if (range2.contains(offset)) {
                    TextRange rangeToDelete = new TextRange(offset, Math.min(range2.getEndOffset(), endOffset));
                    hostRangesToDelete.add(rangeToDelete.shiftRight(hostRange.getStartOffset() - curRangeStart));
                    offset = rangeToDelete.getEndOffset();
                }
                curRangeStart += hostRangeLength;
                curRangeStart += shred.getSuffix().length();
            }
        }
        int delta = 0;
        for (TextRange hostRangeToDelete : hostRangesToDelete) {
            this.myDelegate.deleteString(hostRangeToDelete.getStartOffset() + delta, hostRangeToDelete.getEndOffset() + delta);
            delta -= hostRangeToDelete.getLength();
        }
    }

    @Override
    public void replaceString(int startOffset, int endOffset, @NotNull CharSequence s) {
        if (s == null) {
            DocumentWindowImpl.$$$reportNull$$$0(7);
        }
        if (this.isOneLine()) {
            s = StringUtil.replace(s.toString(), "\n", "");
        }
        CharSequence chars = this.getCharsSequence();
        CharSequence toDelete = chars.subSequence(startOffset, endOffset);
        int prefixLength = StringUtil.commonPrefixLength(s, toDelete);
        int suffixLength = StringUtil.commonSuffixLength(toDelete.subSequence(prefixLength, toDelete.length()), s.subSequence(prefixLength, s.length()));
        s = s.subSequence(prefixLength, s.length() - suffixLength);
        this.doReplaceString(startOffset += prefixLength, endOffset -= suffixLength, s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void doReplaceString(int startOffset, int endOffset, CharSequence s) {
        ArrayList<Pair<TextRange, CharSequence>> hostRangesToModify;
        assert (this.intersectWithEditable(new TextRange(startOffset, startOffset)) != null);
        assert (this.intersectWithEditable(new TextRange(endOffset, endOffset)) != null);
        Object object = this.myLock;
        synchronized (object) {
            hostRangesToModify = new ArrayList<Pair<TextRange, CharSequence>>(this.myShreds.size());
            int offset = startOffset;
            boolean bl = false;
            for (int i = 0; i < this.myShreds.size(); ++i) {
                Segment hostRange;
                void var7_10;
                PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)this.myShreds.get(i);
                if (offset < (var7_10 += shred.getPrefix().length())) {
                    offset = var7_10;
                }
                if ((hostRange = shred.getHostRangeMarker()) == null) continue;
                int hostRangeLength = hostRange.getEndOffset() - hostRange.getStartOffset();
                TextRange range2 = TextRange.from((int)var7_10, hostRangeLength);
                if (range2.contains(offset) || range2.getEndOffset() == offset) {
                    TextRange rangeToModify = new TextRange(offset, Math.min(range2.getEndOffset(), endOffset));
                    TextRange hostRangeToModify = rangeToModify.shiftRight(hostRange.getStartOffset() - var7_10);
                    CharSequence toReplace = i == this.myShreds.size() - 1 || range2.getEndOffset() + shred.getSuffix().length() >= endOffset ? s : s.subSequence(0, Math.min(hostRangeToModify.getLength(), s.length()));
                    s = toReplace == s ? "" : s.subSequence(toReplace.length(), s.length());
                    hostRangesToModify.add(Pair.create(hostRangeToModify, toReplace));
                    offset = rangeToModify.getEndOffset();
                }
                var7_10 += hostRangeLength;
                if ((var7_10 += shred.getSuffix().length()) > endOffset) break;
            }
        }
        int delta = 0;
        for (Pair pair : hostRangesToModify) {
            TextRange hostRange = (TextRange)pair.getFirst();
            CharSequence replace = (CharSequence)pair.getSecond();
            this.myDelegate.replaceString(hostRange.getStartOffset() + delta, hostRange.getEndOffset() + delta, replace);
            delta -= hostRange.getLength() - replace.length();
        }
    }

    @Override
    public boolean isWritable() {
        return this.myDelegate.isWritable();
    }

    @Override
    public long getModificationStamp() {
        return this.isValid() ? this.myDelegate.getModificationStamp() : -1L;
    }

    @Override
    public int getModificationSequence() {
        return this.myDelegate.getModificationSequence();
    }

    @Override
    public void fireReadOnlyModificationAttempt() {
        this.myDelegate.fireReadOnlyModificationAttempt();
    }

    @Override
    public void addDocumentListener(@NotNull DocumentListener listener2) {
        if (listener2 == null) {
            DocumentWindowImpl.$$$reportNull$$$0(8);
        }
        this.myDelegate.addDocumentListener(listener2);
    }

    @Override
    public void addDocumentListener(@NotNull DocumentListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            DocumentWindowImpl.$$$reportNull$$$0(9);
        }
        if (parentDisposable == null) {
            DocumentWindowImpl.$$$reportNull$$$0(10);
        }
        this.myDelegate.addDocumentListener(listener2, parentDisposable);
    }

    @Override
    public void removeDocumentListener(@NotNull DocumentListener listener2) {
        if (listener2 == null) {
            DocumentWindowImpl.$$$reportNull$$$0(11);
        }
        this.myDelegate.removeDocumentListener(listener2);
    }

    @Override
    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset) {
        ProperTextRange hostRange = this.injectedToHost(new ProperTextRange(startOffset, endOffset));
        RangeMarker hostMarker = this.myDelegate.createRangeMarker(hostRange);
        int startShift = Math.max(0, this.hostToInjected(hostRange.getStartOffset()) - startOffset);
        int endShift = Math.max(0, endOffset - this.hostToInjected(hostRange.getEndOffset()) - startShift);
        return new RangeMarkerWindow(this, (RangeMarkerEx)hostMarker, startShift, endShift);
    }

    @Override
    @NotNull
    public RangeMarker createRangeMarker(int startOffset, int endOffset, boolean surviveOnExternalChange) {
        if (!surviveOnExternalChange) {
            RangeMarker rangeMarker = this.createRangeMarker(startOffset, endOffset);
            if (rangeMarker == null) {
                DocumentWindowImpl.$$$reportNull$$$0(12);
            }
            return rangeMarker;
        }
        ProperTextRange hostRange = this.injectedToHost(new ProperTextRange(startOffset, endOffset));
        RangeMarker hostMarker = this.myDelegate.createRangeMarker(hostRange.getStartOffset(), hostRange.getEndOffset(), true);
        int startShift = Math.max(0, this.hostToInjected(hostRange.getStartOffset()) - startOffset);
        int endShift = Math.max(0, endOffset - this.hostToInjected(hostRange.getEndOffset()) - startShift);
        return new RangeMarkerWindow(this, (RangeMarkerEx)hostMarker, startShift, endShift);
    }

    @Override
    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            DocumentWindowImpl.$$$reportNull$$$0(13);
        }
        this.myDelegate.addPropertyChangeListener(listener2);
    }

    @Override
    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            DocumentWindowImpl.$$$reportNull$$$0(14);
        }
        this.myDelegate.removePropertyChangeListener(listener2);
    }

    @Override
    public void setReadOnly(boolean isReadOnly) {
        this.myDelegate.setReadOnly(isReadOnly);
    }

    @Override
    @NotNull
    public RangeMarker createGuardedBlock(int startOffset, int endOffset) {
        ProperTextRange hostRange = this.injectedToHost(new ProperTextRange(startOffset, endOffset));
        RangeMarker rangeMarker = this.myDelegate.createGuardedBlock(hostRange.getStartOffset(), hostRange.getEndOffset());
        if (rangeMarker == null) {
            DocumentWindowImpl.$$$reportNull$$$0(15);
        }
        return rangeMarker;
    }

    @Override
    public void removeGuardedBlock(@NotNull RangeMarker block) {
        if (block == null) {
            DocumentWindowImpl.$$$reportNull$$$0(16);
        }
        this.myDelegate.removeGuardedBlock(block);
    }

    @Override
    public RangeMarker getRangeGuard(int startOffset, int endOffset) {
        ProperTextRange injRange = new ProperTextRange(startOffset, endOffset);
        TextRange editable = ObjectUtils.notNull(this.intersectWithEditable(injRange), TextRange.EMPTY_RANGE);
        if (!injRange.equals(editable)) {
            ProperTextRange guarded = injRange.cutOut(editable.shiftLeft(editable.getStartOffset() - injRange.getStartOffset()));
            return this.createRangeMarker(guarded);
        }
        ProperTextRange hostRange = this.injectedToHost(injRange);
        return this.myDelegate.getRangeGuard(hostRange.getStartOffset(), hostRange.getEndOffset());
    }

    @Override
    public void startGuardedBlockChecking() {
        this.myDelegate.startGuardedBlockChecking();
    }

    @Override
    public void stopGuardedBlockChecking() {
        this.myDelegate.stopGuardedBlockChecking();
    }

    @Override
    public void setCyclicBufferSize(int bufferSize) {
        this.myDelegate.setCyclicBufferSize(bufferSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setText(@NotNull CharSequence text2) {
        if (text2 == null) {
            DocumentWindowImpl.$$$reportNull$$$0(17);
        }
        Object object = this.myLock;
        synchronized (object) {
            LOG.assertTrue(text2.toString().startsWith(((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getPrefix()));
            LOG.assertTrue(text2.toString().endsWith(((PsiLanguageInjectionHost.Shred)this.myShreds.get(this.myShreds.size() - 1)).getSuffix()));
            if (this.isOneLine()) {
                text2 = StringUtil.replace(text2.toString(), "\n", "");
            }
            String[] changes = this.calculateMinEditSequence(text2.toString());
            assert (changes.length == this.myShreds.size());
            for (int i = 0; i < changes.length; ++i) {
                Segment hostRange;
                String change = changes[i];
                if (change == null || (hostRange = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getHostRangeMarker()) == null) continue;
                this.myDelegate.replaceString(hostRange.getStartOffset(), hostRange.getEndOffset(), change);
            }
        }
    }

    @Override
    public boolean isLineModified(int line) {
        return this.myDelegate.isLineModified(this.injectedToHostLine(line));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Segment @NotNull [] getHostRanges() {
        Object object = this.myLock;
        // MONITORENTER : object
        ArrayList<Segment> markers = new ArrayList<Segment>(this.myShreds.size());
        for (PsiLanguageInjectionHost.Shred shred : this.myShreds) {
            Segment hostMarker = shred.getHostRangeMarker();
            if (hostMarker == null) continue;
            markers.add(hostMarker);
        }
        Segment[] segmentArray = markers.isEmpty() ? Segment.EMPTY_ARRAY : markers.toArray(Segment.EMPTY_ARRAY);
        // MONITOREXIT : object
        if (segmentArray != null) return segmentArray;
        DocumentWindowImpl.$$$reportNull$$$0(18);
        return segmentArray;
    }

    @Override
    @NotNull
    public RangeMarker createRangeMarker(@NotNull TextRange textRange) {
        if (textRange == null) {
            DocumentWindowImpl.$$$reportNull$$$0(19);
        }
        ProperTextRange properTextRange = new ProperTextRange(textRange);
        RangeMarker rangeMarker = this.createRangeMarker(properTextRange.getStartOffset(), properTextRange.getEndOffset());
        if (rangeMarker == null) {
            DocumentWindowImpl.$$$reportNull$$$0(20);
        }
        return rangeMarker;
    }

    @Override
    public void setStripTrailingSpacesEnabled(boolean isEnabled) {
        this.myDelegate.setStripTrailingSpacesEnabled(isEnabled);
    }

    @Override
    public int getLineSeparatorLength(int line) {
        return this.myDelegate.getLineSeparatorLength(this.injectedToHostLine(line));
    }

    @Override
    @NotNull
    public LineIterator createLineIterator() {
        LineIterator lineIterator = this.myDelegate.createLineIterator();
        if (lineIterator == null) {
            DocumentWindowImpl.$$$reportNull$$$0(21);
        }
        return lineIterator;
    }

    @Override
    public void setModificationStamp(long modificationStamp) {
        this.myDelegate.setModificationStamp(modificationStamp);
    }

    @Override
    public void addEditReadOnlyListener(@NotNull EditReadOnlyListener listener2) {
        if (listener2 == null) {
            DocumentWindowImpl.$$$reportNull$$$0(22);
        }
        this.myDelegate.addEditReadOnlyListener(listener2);
    }

    @Override
    public void removeEditReadOnlyListener(@NotNull EditReadOnlyListener listener2) {
        if (listener2 == null) {
            DocumentWindowImpl.$$$reportNull$$$0(23);
        }
        this.myDelegate.removeEditReadOnlyListener(listener2);
    }

    @Override
    public void replaceText(@NotNull CharSequence chars, long newModificationStamp) {
        if (chars == null) {
            DocumentWindowImpl.$$$reportNull$$$0(24);
        }
        this.setText(chars);
        this.myDelegate.setModificationStamp(newModificationStamp);
    }

    @Override
    public void suppressGuardedExceptions() {
        this.myDelegate.suppressGuardedExceptions();
    }

    @Override
    public void unSuppressGuardedExceptions() {
        this.myDelegate.unSuppressGuardedExceptions();
    }

    @Override
    public boolean isInEventsHandling() {
        return this.myDelegate.isInEventsHandling();
    }

    @Override
    public boolean removeRangeMarker(@NotNull RangeMarkerEx rangeMarker) {
        if (rangeMarker == null) {
            DocumentWindowImpl.$$$reportNull$$$0(25);
        }
        return this.myDelegate.removeRangeMarker(((RangeMarkerWindow)rangeMarker).getDelegate());
    }

    @Override
    public void registerRangeMarker(@NotNull RangeMarkerEx rangeMarker, int start2, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (rangeMarker == null) {
            DocumentWindowImpl.$$$reportNull$$$0(26);
        }
        throw new IllegalStateException();
    }

    @Override
    @NotNull
    public DocumentEx getDelegate() {
        DocumentEx documentEx = this.myDelegate;
        if (documentEx == null) {
            DocumentWindowImpl.$$$reportNull$$$0(27);
        }
        return documentEx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hostToInjected(int hostOffset) {
        Object object = this.myLock;
        synchronized (object) {
            Segment hostRangeMarker = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getHostRangeMarker();
            if (hostRangeMarker == null || hostOffset < hostRangeMarker.getStartOffset()) {
                return ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getPrefix().length();
            }
            int offset = 0;
            for (int i = 0; i < this.myShreds.size(); ++i) {
                Segment nextRange;
                offset += ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getPrefix().length();
                Segment currentRange = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getHostRangeMarker();
                if (currentRange == null) continue;
                Segment segment = nextRange = i == this.myShreds.size() - 1 ? null : ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i + 1)).getHostRangeMarker();
                if (nextRange == null || hostOffset < nextRange.getStartOffset()) {
                    if (hostOffset >= currentRange.getEndOffset()) {
                        hostOffset = currentRange.getEndOffset();
                    }
                    return offset + hostOffset - currentRange.getStartOffset();
                }
                offset += currentRange.getEndOffset() - currentRange.getStartOffset();
                offset += ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getSuffix().length();
            }
            return this.getTextLength() - ((PsiLanguageInjectionHost.Shred)this.myShreds.get(this.myShreds.size() - 1)).getSuffix().length();
        }
    }

    @Override
    public int injectedToHost(int offset) {
        Editor editor;
        int offsetInRightFragment;
        int offsetInLeftFragment = this.injectedToHost(offset, true, false);
        if (offsetInLeftFragment == (offsetInRightFragment = this.injectedToHost(offset, false, false))) {
            return offsetInLeftFragment;
        }
        Editor[] editors = EditorFactory.getInstance().getEditors(this.getDelegate());
        Editor editor2 = editor = editors.length == 0 ? null : editors[0];
        if (editor != null) {
            int caret;
            if (editor instanceof EditorWindow) {
                editor = ((EditorWindow)editor).getDelegate();
            }
            return Math.abs((caret = editor.getCaretModel().getOffset()) - offsetInLeftFragment) < Math.abs(caret - offsetInRightFragment) ? offsetInLeftFragment : offsetInRightFragment;
        }
        return offsetInLeftFragment;
    }

    @Override
    public int injectedToHost(int injectedOffset, boolean minHostOffset) {
        return this.injectedToHost(injectedOffset, minHostOffset, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int injectedToHost(int offset, boolean preferLeftFragment, boolean skipEmptyShreds) {
        Object object = this.myLock;
        synchronized (object) {
            if (offset < ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getPrefix().length()) {
                Segment hostRangeMarker = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getHostRangeMarker();
                int n = hostRangeMarker == null ? 0 : hostRangeMarker.getStartOffset();
                return n;
            }
            int prevEnd = 0;
            for (int i = 0; i < this.myShreds.size(); ++i) {
                PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)this.myShreds.get(i);
                Segment currentRange = shred.getHostRangeMarker();
                if (currentRange == null) continue;
                int currentStart = currentRange.getStartOffset();
                int currentEnd = currentRange.getEndOffset();
                if (skipEmptyShreds && !preferLeftFragment && currentStart == currentEnd && shred.getPrefix().isEmpty() && shred.getSuffix().isEmpty()) continue;
                if ((offset -= shred.getPrefix().length()) < 0) {
                    return preferLeftFragment ? prevEnd : currentStart - 1;
                }
                if (offset == 0) {
                    return preferLeftFragment && i != 0 ? prevEnd : currentStart;
                }
                int length = currentEnd - currentStart;
                if (offset < length || offset == length && preferLeftFragment) {
                    return currentStart + offset;
                }
                offset -= length;
                offset -= shred.getSuffix().length();
                prevEnd = currentEnd;
            }
            Segment hostRangeMarker = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(this.myShreds.size() - 1)).getHostRangeMarker();
            int n = hostRangeMarker == null ? 0 : hostRangeMarker.getEndOffset();
            return n;
        }
    }

    @Override
    @NotNull
    public ProperTextRange injectedToHost(@NotNull TextRange injected) {
        if (injected == null) {
            DocumentWindowImpl.$$$reportNull$$$0(28);
        }
        int start2 = this.injectedToHost(injected.getStartOffset(), false, true);
        int end = this.injectedToHost(injected.getEndOffset(), true, true);
        if (end < start2) {
            end = this.injectedToHost(injected.getEndOffset(), false, true);
        }
        return new ProperTextRange(start2, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int injectedToHostLine(int line) {
        if (line < this.myPrefixLineCount) {
            Object object = this.myLock;
            synchronized (object) {
                Segment hostRangeMarker = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getHostRangeMarker();
                return hostRangeMarker == null ? 0 : this.myDelegate.getLineNumber(hostRangeMarker.getStartOffset());
            }
        }
        int lineCount = this.getLineCount();
        if (line > lineCount - this.mySuffixLineCount) {
            return lineCount;
        }
        int offset = this.getLineStartOffset(line);
        int hostOffset = this.injectedToHost(offset);
        return this.myDelegate.getLineNumber(hostOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsRange(int hostStart, int hostEnd) {
        Object object = this.myLock;
        synchronized (object) {
            ProperTextRange query = new ProperTextRange(hostStart, hostEnd);
            for (PsiLanguageInjectionHost.Shred shred : this.myShreds) {
                ProperTextRange textRange;
                Segment hostRange = shred.getHostRangeMarker();
                if (hostRange == null || !(textRange = ProperTextRange.create(hostRange)).contains(query)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Nullable
    private TextRange intersectWithEditable(@NotNull TextRange rangeToEdit) {
        if (rangeToEdit == null) {
            DocumentWindowImpl.$$$reportNull$$$0(29);
        }
        int startOffset = -1;
        int endOffset = -1;
        Object object = this.myLock;
        synchronized (object) {
            int offset = 0;
            for (PsiLanguageInjectionHost.Shred shred : this.myShreds) {
                int length;
                ProperTextRange intersection;
                Segment hostRange = shred.getHostRangeMarker();
                if (hostRange == null) continue;
                if ((intersection = new ProperTextRange(offset += shred.getPrefix().length(), offset + (length = hostRange.getEndOffset() - hostRange.getStartOffset())).intersection(rangeToEdit)) != null) {
                    if (startOffset == -1) {
                        startOffset = intersection.getStartOffset();
                    }
                    endOffset = intersection.getEndOffset();
                }
                offset += length;
                offset += shred.getSuffix().length();
            }
        }
        if (startOffset == -1) {
            return null;
        }
        return new ProperTextRange(startOffset, endOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    String @NotNull [] calculateMinEditSequence(String newText) {
        Object object = this.myLock;
        // MONITORENTER : object
        String[] result2 = new String[this.myShreds.size()];
        String hostText = this.myDelegate.getText();
        this.calculateMinEditSequence(hostText, newText, result2, 0, result2.length - 1);
        int i = 0;
        while (true) {
            if (i >= result2.length) {
                // MONITOREXIT : object
                if (result2 != null) return result2;
                DocumentWindowImpl.$$$reportNull$$$0(30);
                return result2;
            }
            String change = result2[i];
            if (change != null) {
                String prefix = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getPrefix();
                String suffix = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getSuffix();
                assert (change.startsWith(prefix)) : change + "/" + prefix;
                assert (change.endsWith(suffix)) : change + "/" + suffix;
                result2[i] = StringUtil.trimEnd(StringUtil.trimStart(change, prefix), suffix);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRangeText(@NotNull String hostText, int hostNum) {
        if (hostText == null) {
            DocumentWindowImpl.$$$reportNull$$$0(31);
        }
        Object object = this.myLock;
        synchronized (object) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)this.myShreds.get(hostNum);
            Segment hostRangeMarker = shred.getHostRangeMarker();
            return shred.getPrefix() + (hostRangeMarker == null ? "" : hostText.substring(hostRangeMarker.getStartOffset(), hostRangeMarker.getEndOffset())) + shred.getSuffix();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateMinEditSequence(String hostText, String newText, String[] result2, int i, int j) {
        Object object = this.myLock;
        synchronized (object) {
            String rangeText1 = this.getRangeText(hostText, i);
            if (i == j) {
                result2[i] = rangeText1.equals(newText) ? null : newText;
                return;
            }
            if (StringUtil.startsWith(newText, rangeText1)) {
                result2[i] = null;
                this.calculateMinEditSequence(hostText, newText.substring(rangeText1.length()), result2, i + 1, j);
                return;
            }
            String rangeText2 = this.getRangeText(hostText, j);
            if (StringUtil.endsWith(newText, rangeText2)) {
                result2[j] = null;
                this.calculateMinEditSequence(hostText, newText.substring(0, newText.length() - rangeText2.length()), result2, i, j - 1);
                return;
            }
            if (i + 1 == j) {
                String commonPrefix;
                String suffix = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(i)).getSuffix();
                String prefix = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(j)).getPrefix();
                String separator = suffix + prefix;
                if (!separator.isEmpty()) {
                    int sep = newText.indexOf(separator);
                    assert (sep != -1);
                    result2[i] = newText.substring(0, sep + suffix.length());
                    result2[j] = newText.substring(sep + suffix.length() + prefix.length());
                    return;
                }
                result2[i] = commonPrefix = StringUtil.commonPrefix(rangeText1, newText);
                result2[j] = newText.substring(commonPrefix.length());
                return;
            }
            String middleText = this.getRangeText(hostText, i + 1);
            int m = newText.indexOf(middleText);
            if (m != -1) {
                result2[i] = newText.substring(0, m);
                result2[i + 1] = null;
                this.calculateMinEditSequence(hostText, newText.substring(m + middleText.length()), result2, i + 2, j);
                return;
            }
            middleText = this.getRangeText(hostText, j - 1);
            m = newText.lastIndexOf(middleText);
            if (m != -1) {
                result2[j] = newText.substring(m + middleText.length());
                result2[j - 1] = null;
                this.calculateMinEditSequence(hostText, newText.substring(0, m), result2, i, j - 2);
                return;
            }
            result2[i] = "";
            result2[j] = "";
            this.calculateMinEditSequence(hostText, newText, result2, i + 1, j - 1);
        }
    }

    @Override
    public boolean areRangesEqual(@NotNull DocumentWindow other) {
        if (other == null) {
            DocumentWindowImpl.$$$reportNull$$$0(32);
        }
        DocumentWindowImpl window = (DocumentWindowImpl)other;
        Place shreds = this.getShreds();
        Place otherShreds = window.getShreds();
        if (shreds.size() != otherShreds.size()) {
            return false;
        }
        for (int i = 0; i < shreds.size(); ++i) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)shreds.get(i);
            PsiLanguageInjectionHost.Shred otherShred = (PsiLanguageInjectionHost.Shred)otherShreds.get(i);
            if (!shred.getPrefix().equals(otherShred.getPrefix())) {
                return false;
            }
            if (!shred.getSuffix().equals(otherShred.getSuffix())) {
                return false;
            }
            Segment hostRange = shred.getHostRangeMarker();
            Segment otherRange = otherShred.getHostRangeMarker();
            if (hostRange != null && otherRange != null && TextRange.areSegmentsEqual(hostRange, otherRange)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid() {
        Place shreds;
        Object object = this.myLock;
        synchronized (object) {
            shreds = this.myShreds;
        }
        for (int i = 1; i < shreds.size(); ++i) {
            PsiLanguageInjectionHost.Shred shred = (PsiLanguageInjectionHost.Shred)shreds.get(i);
            if (shred.isValid()) continue;
            return false;
        }
        PsiLanguageInjectionHost.Shred firstShred = (PsiLanguageInjectionHost.Shred)shreds.get(0);
        PsiLanguageInjectionHost host = firstShred.getHost();
        if (host == null || firstShred.getHostRangeMarker() == null) {
            return false;
        }
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(this);
        return virtualFile2 != null && ((PsiManagerEx)host.getManager()).getFileManager().findCachedViewProvider(virtualFile2) != null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DocumentWindowImpl)) {
            return false;
        }
        DocumentWindowImpl window = (DocumentWindowImpl)o;
        return this.myDelegate.equals(window.getDelegate()) && this.areRangesEqual(window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.myLock;
        synchronized (object) {
            Segment hostRangeMarker = ((PsiLanguageInjectionHost.Shred)this.myShreds.get(0)).getHostRangeMarker();
            return hostRangeMarker == null ? -1 : hostRangeMarker.getStartOffset();
        }
    }

    @Override
    public boolean isOneLine() {
        return this.myOneLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = this.myLock;
        synchronized (object) {
            this.myShreds.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setShreds(@NotNull Place shreds) {
        if (shreds == null) {
            DocumentWindowImpl.$$$reportNull$$$0(33);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myShreds.dispose();
            this.myShreds = shreds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    Place getShreds() {
        Object object = this.myLock;
        // MONITORENTER : object
        Place place = this.myShreds;
        // MONITOREXIT : object
        if (place != null) return place;
        DocumentWindowImpl.$$$reportNull$$$0(34);
        return place;
    }

    @Override
    public boolean processRangeMarkers(@NotNull Processor<? super RangeMarker> processor2) {
        if (processor2 == null) {
            DocumentWindowImpl.$$$reportNull$$$0(35);
        }
        return this.myDelegate.processRangeMarkers(processor2);
    }

    @Override
    public boolean processRangeMarkersOverlappingWith(int start2, int end, @NotNull Processor<? super RangeMarker> processor2) {
        if (processor2 == null) {
            DocumentWindowImpl.$$$reportNull$$$0(36);
        }
        return this.myDelegate.processRangeMarkersOverlappingWith(start2, end, processor2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 21: 
            case 27: 
            case 30: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 21: 
            case 27: 
            case 30: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shreds";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hPos";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 21: 
            case 27: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/DocumentWindowImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeMarker";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injected";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToEdit";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostText";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/DocumentWindowImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calcText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmutableCharSequence";
                break;
            }
            case 12: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createRangeMarker";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createGuardedBlock";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getHostRanges";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineIterator";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateMinEditSequence";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getShreds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hostToInjectedInVirtualSpace";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 21: 
            case 27: 
            case 30: 
            case 34: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "insertString";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceString";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addDocumentListener";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeDocumentListener";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeGuardedBlock";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createRangeMarker";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addEditReadOnlyListener";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "removeEditReadOnlyListener";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "replaceText";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "removeRangeMarker";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "registerRangeMarker";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "injectedToHost";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "intersectWithEditable";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getRangeText";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "areRangesEqual";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setShreds";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "processRangeMarkers";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processRangeMarkersOverlappingWith";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 21: 
            case 27: 
            case 30: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CachedText {
        private final String text;
        private final long modificationStamp;

        private CachedText(@NotNull String text2, long modificationStamp) {
            if (text2 == null) {
                CachedText.$$$reportNull$$$0(0);
            }
            this.text = text2;
            this.modificationStamp = modificationStamp;
        }

        @NotNull
        private String getText() {
            String string = this.text;
            if (string == null) {
                CachedText.$$$reportNull$$$0(1);
            }
            return string;
        }

        private long getModificationStamp() {
            return this.modificationStamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/DocumentWindowImpl$CachedText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/DocumentWindowImpl$CachedText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

