/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SelectionModelWindow
implements SelectionModel {
    private final SelectionModel myHostModel;
    private final DocumentWindow myDocument;
    private final EditorWindow myInjectedEditor;

    SelectionModelWindow(EditorEx delegate, DocumentWindow document, EditorWindow injectedEditor) {
        this.myDocument = document;
        this.myInjectedEditor = injectedEditor;
        this.myHostModel = delegate.getSelectionModel();
    }

    @Override
    @NotNull
    public Editor getEditor() {
        EditorWindow editorWindow = this.myInjectedEditor;
        if (editorWindow == null) {
            SelectionModelWindow.$$$reportNull$$$0(0);
        }
        return editorWindow;
    }

    @Override
    @Nullable
    public VisualPosition getSelectionStartPosition() {
        return this.myInjectedEditor.offsetToVisualPosition(this.getSelectionStart());
    }

    @Override
    @Nullable
    public VisualPosition getSelectionEndPosition() {
        return this.myInjectedEditor.offsetToVisualPosition(this.getSelectionEnd());
    }

    @Override
    public boolean hasSelection(boolean anyCaret) {
        return this.myHostModel.hasSelection(anyCaret);
    }

    @Override
    public void addSelectionListener(@NotNull SelectionListener listener2) {
        if (listener2 == null) {
            SelectionModelWindow.$$$reportNull$$$0(1);
        }
        this.myHostModel.addSelectionListener(listener2);
    }

    @Override
    public void removeSelectionListener(@NotNull SelectionListener listener2) {
        if (listener2 == null) {
            SelectionModelWindow.$$$reportNull$$$0(2);
        }
        this.myHostModel.removeSelectionListener(listener2);
    }

    @Override
    public void copySelectionToClipboard() {
        this.myHostModel.copySelectionToClipboard();
    }

    @Override
    public void setBlockSelection(@NotNull LogicalPosition blockStart, @NotNull LogicalPosition blockEnd) {
        if (blockStart == null) {
            SelectionModelWindow.$$$reportNull$$$0(3);
        }
        if (blockEnd == null) {
            SelectionModelWindow.$$$reportNull$$$0(4);
        }
        this.myHostModel.setBlockSelection(this.myInjectedEditor.injectedToHost(blockStart), this.myInjectedEditor.injectedToHost(blockEnd));
    }

    @Override
    public int @NotNull [] getBlockSelectionStarts() {
        int[] result2 = this.myHostModel.getBlockSelectionStarts();
        for (int i = 0; i < result2.length; ++i) {
            result2[i] = this.myDocument.hostToInjected(result2[i]);
        }
        if (result2 == null) {
            SelectionModelWindow.$$$reportNull$$$0(5);
        }
        return result2;
    }

    @Override
    public int @NotNull [] getBlockSelectionEnds() {
        int[] result2 = this.myHostModel.getBlockSelectionEnds();
        for (int i = 0; i < result2.length; ++i) {
            result2[i] = this.myDocument.hostToInjected(result2[i]);
        }
        if (result2 == null) {
            SelectionModelWindow.$$$reportNull$$$0(6);
        }
        return result2;
    }

    @Override
    public TextAttributes getTextAttributes() {
        return this.myHostModel.getTextAttributes();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/SelectionModelWindow";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockStart";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockEnd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/SelectionModelWindow";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockSelectionStarts";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockSelectionEnds";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addSelectionListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeSelectionListener";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setBlockSelection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

