/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected.changesHandler;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.InjectedFileChangesHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import org.jetbrains.annotations.NotNull;

public abstract class BaseInjectedFileChangesHandler
implements InjectedFileChangesHandler {
    protected final Editor myHostEditor;
    protected final Document myHostDocument;
    protected final Document myFragmentDocument;
    protected final Project myProject;
    protected PsiFile myInjectedFile;

    public BaseInjectedFileChangesHandler(Editor hostEditor, Document fragmentDocument, PsiFile injectedFile) {
        this.myProject = hostEditor.getProject();
        this.myHostEditor = hostEditor;
        this.myHostDocument = hostEditor.getDocument();
        this.myFragmentDocument = fragmentDocument;
        this.myInjectedFile = injectedFile;
    }

    @Override
    public boolean tryReuse(@NotNull PsiFile newInjectedFile, @NotNull TextRange newHostRange) {
        DocumentWindow documentWindow;
        if (newInjectedFile == null) {
            BaseInjectedFileChangesHandler.$$$reportNull$$$0(0);
        }
        if (newHostRange == null) {
            BaseInjectedFileChangesHandler.$$$reportNull$$$0(1);
        }
        if (this.myInjectedFile == newInjectedFile) {
            return this.handlesRange(newHostRange);
        }
        if ((this.myInjectedFile == null || !this.myInjectedFile.isValid()) && (documentWindow = InjectedLanguageUtil.getDocumentWindow(newInjectedFile)) != null && this.handlesRange(newHostRange)) {
            this.myInjectedFile = newInjectedFile;
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "newInjectedFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "newHostRange";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/impl/source/tree/injected/changesHandler/BaseInjectedFileChangesHandler";
        objectArray[2] = "tryReuse";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

