/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.core.CoreBundle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CompactVirtualFileSet;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.ProjectAwareFileFilter;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GlobalSearchScope
extends SearchScope
implements ProjectAwareFileFilter {
    public static final GlobalSearchScope[] EMPTY_ARRAY = new GlobalSearchScope[0];
    @Nullable
    private final Project myProject;
    public static final GlobalSearchScope EMPTY_SCOPE = new EmptyScope();

    protected GlobalSearchScope(@Nullable Project project2) {
        this.myProject = project2;
    }

    protected GlobalSearchScope() {
        this(null);
    }

    @Override
    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            GlobalSearchScope.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(1);
        }
        return 0;
    }

    public abstract boolean isSearchInModuleContent(@NotNull Module var1);

    public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
        if (aModule == null) {
            GlobalSearchScope.$$$reportNull$$$0(2);
        }
        return this.isSearchInModuleContent(aModule);
    }

    @Override
    public final boolean accept(VirtualFile file2) {
        return this.contains(file2);
    }

    public abstract boolean isSearchInLibraries();

    public boolean isForceSearchingInLibrarySources() {
        return false;
    }

    @NotNull
    public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        Set<UnloadedModuleDescription> set = Collections.emptySet();
        if (set == null) {
            GlobalSearchScope.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            GlobalSearchScope.$$$reportNull$$$0(4);
        }
        if (scope == this) {
            GlobalSearchScope globalSearchScope = this;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(5);
            }
            return globalSearchScope;
        }
        if (scope instanceof IntersectionScope && ((IntersectionScope)scope).containsScope(this)) {
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(6);
            }
            return globalSearchScope;
        }
        return new IntersectionScope(this, scope, null);
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public SearchScope intersectWith(@NotNull SearchScope scope2) {
        if (scope2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(7);
        }
        if (scope2 instanceof LocalSearchScope) {
            LocalSearchScope localScope2 = (LocalSearchScope)scope2;
            SearchScope searchScope = this.intersectWith(localScope2);
            if (searchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(8);
            }
            return searchScope;
        }
        GlobalSearchScope globalSearchScope = this.intersectWith((GlobalSearchScope)scope2);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(9);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public SearchScope intersectWith(@NotNull LocalSearchScope localScope2) {
        if (localScope2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(10);
        }
        PsiElement[] elements2 = localScope2.getScope();
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>(elements2.length);
        for (PsiElement element2 : elements2) {
            if (!PsiSearchScopeUtil.isInScope(this, element2)) continue;
            result2.add(element2);
        }
        return result2.isEmpty() ? EMPTY_SCOPE : new LocalSearchScope(result2.toArray(PsiElement.EMPTY_ARRAY), null, localScope2.isIgnoreInjectedPsi());
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public GlobalSearchScope union(@NotNull SearchScope scope) {
        if (scope == null) {
            GlobalSearchScope.$$$reportNull$$$0(11);
        }
        if (scope instanceof GlobalSearchScope) {
            GlobalSearchScope globalSearchScope = this.uniteWith((GlobalSearchScope)scope);
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(12);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = this.union((LocalSearchScope)scope);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(13);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public GlobalSearchScope union(final @NotNull LocalSearchScope scope) {
        PsiElement[] localScopeElements;
        if (scope == null) {
            GlobalSearchScope.$$$reportNull$$$0(14);
        }
        if ((localScopeElements = scope.getScope()).length == 0) {
            GlobalSearchScope globalSearchScope = this;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(15);
            }
            return globalSearchScope;
        }
        return new GlobalSearchScope(localScopeElements[0].getProject()){

            @Override
            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return GlobalSearchScope.this.contains(file2) || scope.isInScope(file2);
            }

            @Override
            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (file2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return GlobalSearchScope.this.contains(file1) && GlobalSearchScope.this.contains(file2) ? GlobalSearchScope.this.compare(file1, file2) : 0;
            }

            @Override
            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    1.$$$reportNull$$$0(3);
                }
                return GlobalSearchScope.this.isSearchInModuleContent(aModule);
            }

            @Override
            public boolean isSearchInLibraries() {
                return GlobalSearchScope.this.isSearchInLibraries();
            }

            @Override
            @NotNull
            public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
                Collection<UnloadedModuleDescription> collection = GlobalSearchScope.this.getUnloadedModulesBelongingToScope();
                if (collection == null) {
                    1.$$$reportNull$$$0(4);
                }
                return collection;
            }

            @NonNls
            public String toString() {
                return "UnionToLocal: (" + GlobalSearchScope.this + ", " + scope + ")";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file2";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aModule";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/search/GlobalSearchScope$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/search/GlobalSearchScope$1";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getUnloadedModulesBelongingToScope";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "contains";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "compare";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "isSearchInModuleContent";
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            GlobalSearchScope.$$$reportNull$$$0(16);
        }
        GlobalSearchScope globalSearchScope = UnionScope.create(new GlobalSearchScope[]{this, scope});
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(17);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope union(@NotNull Collection<? extends GlobalSearchScope> scopes) {
        if (scopes == null) {
            GlobalSearchScope.$$$reportNull$$$0(18);
        }
        if (scopes.isEmpty()) {
            throw new IllegalArgumentException("Empty scope collection");
        }
        if (scopes.size() == 1) {
            GlobalSearchScope globalSearchScope = scopes.iterator().next();
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(19);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = UnionScope.create(scopes.toArray(EMPTY_ARRAY));
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(20);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope union(GlobalSearchScope @NotNull [] scopes) {
        if (scopes == null) {
            GlobalSearchScope.$$$reportNull$$$0(21);
        }
        if (scopes.length == 0) {
            throw new IllegalArgumentException("Empty scope array");
        }
        if (scopes.length == 1) {
            GlobalSearchScope globalSearchScope = scopes[0];
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(22);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = UnionScope.create(scopes);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(23);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope allScope(@NotNull Project project2) {
        if (project2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(24);
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getAllScope(project2);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(25);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope projectScope(@NotNull Project project2) {
        if (project2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(26);
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getProjectScope(project2);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(27);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope everythingScope(@NotNull Project project2) {
        if (project2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(28);
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getEverythingScope(project2);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(29);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope notScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            GlobalSearchScope.$$$reportNull$$$0(30);
        }
        return new NotScope(scope);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleScope(@NotNull Module module2) {
        if (module2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(31);
        }
        GlobalSearchScope globalSearchScope = module2.getModuleScope();
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(32);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleWithLibrariesScope(@NotNull Module module2) {
        if (module2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(33);
        }
        GlobalSearchScope globalSearchScope = module2.getModuleWithLibrariesScope();
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(34);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleWithDependenciesScope(@NotNull Module module2) {
        if (module2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(35);
        }
        GlobalSearchScope globalSearchScope = module2.getModuleWithDependenciesScope();
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(36);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleRuntimeScope(@NotNull Module module2, boolean includeTests) {
        if (module2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(37);
        }
        GlobalSearchScope globalSearchScope = module2.getModuleRuntimeScope(includeTests);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(38);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleWithDependenciesAndLibrariesScope(@NotNull Module module2) {
        if (module2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(39);
        }
        return GlobalSearchScope.moduleWithDependenciesAndLibrariesScope(module2, true);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleWithDependenciesAndLibrariesScope(@NotNull Module module2, boolean includeTests) {
        if (module2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(40);
        }
        GlobalSearchScope globalSearchScope = module2.getModuleWithDependenciesAndLibrariesScope(includeTests);
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(41);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleWithDependentsScope(@NotNull Module module2) {
        if (module2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(42);
        }
        GlobalSearchScope globalSearchScope = module2.getModuleWithDependentsScope();
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(43);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope moduleTestsWithDependentsScope(@NotNull Module module2) {
        if (module2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(44);
        }
        GlobalSearchScope globalSearchScope = module2.getModuleTestsWithDependentsScope();
        if (globalSearchScope == null) {
            GlobalSearchScope.$$$reportNull$$$0(45);
        }
        return globalSearchScope;
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope fileScope(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            GlobalSearchScope.$$$reportNull$$$0(46);
        }
        return new FileScope(psiFile.getProject(), psiFile.getVirtualFile(), null);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope fileScope(@NotNull Project project2, VirtualFile virtualFile2) {
        if (project2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(47);
        }
        return GlobalSearchScope.fileScope(project2, virtualFile2, null);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope fileScope(@NotNull Project project2, @Nullable VirtualFile virtualFile2, @Nullable String displayName) {
        if (project2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(48);
        }
        return new FileScope(project2, virtualFile2, displayName);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope filesScope(@NotNull Project project2, @NotNull Collection<? extends VirtualFile> files2) {
        if (project2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(49);
        }
        if (files2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(50);
        }
        return GlobalSearchScope.filesScope(project2, files2, null);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope filesWithoutLibrariesScope(@NotNull Project project2, @NotNull Collection<? extends VirtualFile> files2) {
        if (project2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(51);
        }
        if (files2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(52);
        }
        if (files2.isEmpty()) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(53);
            }
            return globalSearchScope;
        }
        return new FilesScope(project2, files2, false);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope filesWithLibrariesScope(@NotNull Project project2, @NotNull Collection<? extends VirtualFile> files2) {
        if (project2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(54);
        }
        if (files2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(55);
        }
        if (files2.isEmpty()) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(56);
            }
            return globalSearchScope;
        }
        return new FilesScope(project2, files2, true);
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope filesScope(@NotNull Project project2, @NotNull Collection<? extends VirtualFile> files2, final @Nullable String displayName) {
        if (project2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(57);
        }
        if (files2 == null) {
            GlobalSearchScope.$$$reportNull$$$0(58);
        }
        if (files2.isEmpty()) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(59);
            }
            return globalSearchScope;
        }
        return files2.size() == 1 ? GlobalSearchScope.fileScope(project2, files2.iterator().next(), displayName) : new FilesScope(project2, files2){

            @Override
            @NotNull
            public String getDisplayName() {
                String string = displayName == null ? super.getDisplayName() : displayName;
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/GlobalSearchScope$2", "getDisplayName"));
            }
        };
    }

    @NotNull
    @Contract(pure=true)
    public static GlobalSearchScope getScopeRestrictedByFileTypes(@NotNull GlobalSearchScope scope, FileType ... fileTypes) {
        if (scope == null) {
            GlobalSearchScope.$$$reportNull$$$0(60);
        }
        if (fileTypes == null) {
            GlobalSearchScope.$$$reportNull$$$0(61);
        }
        if (scope == EMPTY_SCOPE) {
            GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
            if (globalSearchScope == null) {
                GlobalSearchScope.$$$reportNull$$$0(62);
            }
            return globalSearchScope;
        }
        if (fileTypes.length == 0) {
            throw new IllegalArgumentException("empty fileTypes");
        }
        return new FileTypeRestrictionScope(scope, fileTypes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 45: 
            case 53: 
            case 56: 
            case 59: 
            case 62: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 45: 
            case 53: 
            case 56: 
            case 59: 
            case 62: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 45: 
            case 53: 
            case 56: 
            case 59: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/GlobalSearchScope";
                break;
            }
            case 4: 
            case 11: 
            case 14: 
            case 16: 
            case 30: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope2";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localScope2";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopes";
                break;
            }
            case 24: 
            case 26: 
            case 28: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 54: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 50: 
            case 52: 
            case 55: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/GlobalSearchScope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnloadedModulesBelongingToScope";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectWith";
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "uniteWith";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "allScope";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "projectScope";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "everythingScope";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleScope";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleWithLibrariesScope";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleWithDependenciesScope";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleRuntimeScope";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleWithDependenciesAndLibrariesScope";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleWithDependentsScope";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleTestsWithDependentsScope";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "filesWithoutLibrariesScope";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "filesWithLibrariesScope";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "filesScope";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeRestrictedByFileTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 45: 
            case 53: 
            case 56: 
            case 59: 
            case 62: {
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "intersectWith";
                break;
            }
            case 11: 
            case 14: 
            case 18: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "uniteWith";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "allScope";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "projectScope";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "everythingScope";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "notScope";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "moduleScope";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "moduleWithLibrariesScope";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "moduleWithDependenciesScope";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "moduleRuntimeScope";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "moduleWithDependenciesAndLibrariesScope";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "moduleWithDependentsScope";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "moduleTestsWithDependentsScope";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "fileScope";
                break;
            }
            case 49: 
            case 50: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "filesScope";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "filesWithoutLibrariesScope";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "filesWithLibrariesScope";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getScopeRestrictedByFileTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 41: 
            case 43: 
            case 45: 
            case 53: 
            case 56: 
            case 59: 
            case 62: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FilesScope
    extends GlobalSearchScope
    implements Iterable<VirtualFile> {
        private final Set<? extends VirtualFile> myFiles;
        private volatile Boolean myHasFilesOutOfProjectRoots;

        private FilesScope(@Nullable Project project2, @NotNull Collection<? extends VirtualFile> files2) {
            if (files2 == null) {
                FilesScope.$$$reportNull$$$0(0);
            }
            this(project2, files2, null);
        }

        private FilesScope(@Nullable Project project2, @NotNull Collection<? extends VirtualFile> files2, @Nullable Boolean hasFilesOutOfProjectRoots) {
            if (files2 == null) {
                FilesScope.$$$reportNull$$$0(1);
            }
            super(project2);
            this.myFiles = new CompactVirtualFileSet(files2);
            ((CompactVirtualFileSet)this.myFiles).freeze();
            this.myHasFilesOutOfProjectRoots = hasFilesOutOfProjectRoots;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                FilesScope.$$$reportNull$$$0(2);
            }
            return this.myFiles.contains(file2);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                FilesScope.$$$reportNull$$$0(3);
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.hasFilesOutOfProjectRoots();
        }

        public boolean equals(Object o) {
            return this == o || o instanceof FilesScope && this.myFiles.equals(((FilesScope)o).myFiles);
        }

        @Override
        public int calcHashCode() {
            return this.myFiles.hashCode();
        }

        private boolean hasFilesOutOfProjectRoots() {
            Boolean result2 = this.myHasFilesOutOfProjectRoots;
            if (result2 == null) {
                Project project2 = this.getProject();
                this.myHasFilesOutOfProjectRoots = result2 = Boolean.valueOf(project2 != null && !project2.isDefault() && ContainerUtil.find(this.myFiles, file2 -> FileIndexFacade.getInstance(project2).getModuleForFile((VirtualFile)file2) != null) == null);
            }
            return result2;
        }

        public String toString() {
            List<? extends VirtualFile> files2 = ContainerUtil.getFirstItems(new ArrayList<VirtualFile>(this.myFiles), 20);
            return "Files: (" + files2 + "); search in libraries: " + (this.myHasFilesOutOfProjectRoots != null ? this.myHasFilesOutOfProjectRoots : "unknown");
        }

        @Override
        @NotNull
        public Iterator<VirtualFile> iterator() {
            Iterator<VirtualFile> iterator2 = this.myFiles.iterator();
            if (iterator2 == null) {
                FilesScope.$$$reportNull$$$0(4);
            }
            return iterator2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScope$FilesScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScope$FilesScope";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class FileScope
    extends GlobalSearchScope
    implements Iterable<VirtualFile> {
        private final VirtualFile myVirtualFile;
        @Nullable
        private final String myDisplayName;
        private final Module myModule;

        private FileScope(@NotNull Project project2, @Nullable VirtualFile virtualFile2, @Nullable String displayName) {
            if (project2 == null) {
                FileScope.$$$reportNull$$$0(0);
            }
            super(project2);
            this.myVirtualFile = virtualFile2;
            this.myDisplayName = displayName;
            FileIndexFacade facade = project2.isDefault() ? null : FileIndexFacade.getInstance(project2);
            this.myModule = virtualFile2 == null || facade == null ? null : facade.getModuleForFile(virtualFile2);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                FileScope.$$$reportNull$$$0(1);
            }
            return Comparing.equal(this.myVirtualFile, file2);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                FileScope.$$$reportNull$$$0(2);
            }
            return aModule == this.myModule;
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.myModule == null;
        }

        public String toString() {
            return "File :" + this.myVirtualFile;
        }

        @Override
        @NotNull
        public Iterator<VirtualFile> iterator() {
            Iterator<VirtualFile> iterator2 = Collections.singletonList(this.myVirtualFile).iterator();
            if (iterator2 == null) {
                FileScope.$$$reportNull$$$0(3);
            }
            return iterator2;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = this.myDisplayName != null ? this.myDisplayName : super.getDisplayName();
            if (string == null) {
                FileScope.$$$reportNull$$$0(4);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            FileScope files2 = (FileScope)o;
            return Objects.equals(this.myVirtualFile, files2.myVirtualFile) && Objects.equals(this.myDisplayName, files2.myDisplayName) && Objects.equals(this.myModule, files2.myModule);
        }

        @Override
        protected int calcHashCode() {
            return Objects.hash(this.myVirtualFile, this.myModule, this.myDisplayName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScope$FileScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScope$FileScope";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "iterator";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class EmptyScope
    extends GlobalSearchScope {
        private EmptyScope() {
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                EmptyScope.$$$reportNull$$$0(0);
            }
            return false;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                EmptyScope.$$$reportNull$$$0(1);
            }
            return false;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                EmptyScope.$$$reportNull$$$0(2);
            }
            EmptyScope emptyScope = this;
            if (emptyScope == null) {
                EmptyScope.$$$reportNull$$$0(3);
            }
            return emptyScope;
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                EmptyScope.$$$reportNull$$$0(4);
            }
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                EmptyScope.$$$reportNull$$$0(5);
            }
            return globalSearchScope;
        }

        public String toString() {
            return "EMPTY";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScope$EmptyScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScope$EmptyScope";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "intersectWith";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uniteWith";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "intersectWith";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteWith";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class FileTypeRestrictionScope
    extends DelegatingGlobalSearchScope {
        private final FileType[] myFileTypes;

        private FileTypeRestrictionScope(@NotNull GlobalSearchScope scope, FileType @NotNull [] fileTypes) {
            if (scope == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(0);
            }
            if (fileTypes == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(1);
            }
            super(scope);
            this.myFileTypes = fileTypes;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(2);
            }
            if (!super.contains(file2)) {
                return false;
            }
            for (FileType otherFileType : this.myFileTypes) {
                if (!FileTypeRegistry.getInstance().isFileOfType(file2, otherFileType)) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(3);
            }
            if (scope instanceof FileTypeRestrictionScope) {
                FileTypeRestrictionScope restrict = (FileTypeRestrictionScope)scope;
                if (restrict.myBaseScope == this.myBaseScope) {
                    ArrayList<FileType> intersection = new ArrayList<FileType>(Arrays.asList(restrict.myFileTypes));
                    intersection.retainAll(Arrays.asList(this.myFileTypes));
                    return new FileTypeRestrictionScope(this.myBaseScope, intersection.toArray(FileType.EMPTY_ARRAY));
                }
            }
            GlobalSearchScope globalSearchScope = super.intersectWith(scope);
            if (globalSearchScope == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(4);
            }
            return globalSearchScope;
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(5);
            }
            if (scope instanceof FileTypeRestrictionScope) {
                FileTypeRestrictionScope restrict = (FileTypeRestrictionScope)scope;
                if (restrict.myBaseScope == this.myBaseScope) {
                    return new FileTypeRestrictionScope(this.myBaseScope, ArrayUtil.mergeArrays(this.myFileTypes, restrict.myFileTypes));
                }
            }
            GlobalSearchScope globalSearchScope = super.uniteWith(scope);
            if (globalSearchScope == null) {
                FileTypeRestrictionScope.$$$reportNull$$$0(6);
            }
            return globalSearchScope;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FileTypeRestrictionScope)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FileTypeRestrictionScope that = (FileTypeRestrictionScope)o;
            return Arrays.equals(this.myFileTypes, that.myFileTypes);
        }

        @Override
        public int calcHashCode() {
            int result2 = super.calcHashCode();
            result2 = 31 * result2 + Arrays.hashCode(this.myFileTypes);
            return result2;
        }

        @Override
        public String toString() {
            return "(restricted by file types: " + Arrays.asList(this.myFileTypes) + " in " + this.myBaseScope + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileTypes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScope$FileTypeRestrictionScope";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "intersectWith";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uniteWith";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "intersectWith";
                    break;
                }
                case 4: 
                case 6: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteWith";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class UnionScope
    extends GlobalSearchScope {
        private final GlobalSearchScope[] myScopes;

        @NotNull
        static GlobalSearchScope create(GlobalSearchScope @NotNull [] scopes) {
            if (scopes == null) {
                UnionScope.$$$reportNull$$$0(0);
            }
            THashSet<GlobalSearchScope> result2 = new THashSet<GlobalSearchScope>(scopes.length);
            Project project2 = null;
            for (GlobalSearchScope scope : scopes) {
                if (scope == EMPTY_SCOPE) continue;
                Project scopeProject = scope.getProject();
                if (scopeProject != null) {
                    project2 = scopeProject;
                }
                if (scope instanceof UnionScope) {
                    ContainerUtil.addAll(result2, ((UnionScope)scope).myScopes);
                    continue;
                }
                result2.add(scope);
            }
            if (result2.isEmpty()) {
                GlobalSearchScope globalSearchScope = EMPTY_SCOPE;
                if (globalSearchScope == null) {
                    UnionScope.$$$reportNull$$$0(1);
                }
                return globalSearchScope;
            }
            if (result2.size() == 1) {
                GlobalSearchScope globalSearchScope = (GlobalSearchScope)result2.iterator().next();
                if (globalSearchScope == null) {
                    UnionScope.$$$reportNull$$$0(2);
                }
                return globalSearchScope;
            }
            return new UnionScope(project2, result2.toArray(EMPTY_ARRAY));
        }

        private UnionScope(Project project2, GlobalSearchScope @NotNull [] scopes) {
            if (scopes == null) {
                UnionScope.$$$reportNull$$$0(3);
            }
            super(project2);
            this.myScopes = scopes;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = CoreBundle.message("psi.search.scope.union", this.myScopes[0].getDisplayName(), this.myScopes[1].getDisplayName());
            if (string == null) {
                UnionScope.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                UnionScope.$$$reportNull$$$0(5);
            }
            return ContainerUtil.find(this.myScopes, scope -> scope.contains(file2)) != null;
        }

        @Override
        @NotNull
        public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
            LinkedHashSet<UnloadedModuleDescription> result2 = new LinkedHashSet<UnloadedModuleDescription>();
            for (GlobalSearchScope scope : this.myScopes) {
                result2.addAll(scope.getUnloadedModulesBelongingToScope());
            }
            LinkedHashSet<UnloadedModuleDescription> linkedHashSet = result2;
            if (linkedHashSet == null) {
                UnionScope.$$$reportNull$$$0(6);
            }
            return linkedHashSet;
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                UnionScope.$$$reportNull$$$0(7);
            }
            if (file2 == null) {
                UnionScope.$$$reportNull$$$0(8);
            }
            int[] result2 = new int[]{0};
            ContainerUtil.process(this.myScopes, scope -> {
                if (!scope.contains(file1) || !scope.contains(file2)) {
                    return true;
                }
                int cmp = scope.compare(file1, file2);
                if (result2[0] == 0) {
                    result2[0] = cmp;
                    return true;
                }
                if (cmp == 0) {
                    return true;
                }
                if (result2[0] > 0 == cmp > 0) {
                    return true;
                }
                result2[0] = 0;
                return false;
            });
            return result2[0];
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module module2) {
            if (module2 == null) {
                UnionScope.$$$reportNull$$$0(9);
            }
            return ContainerUtil.find(this.myScopes, scope -> scope.isSearchInModuleContent(module2)) != null;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module module2, boolean testSources) {
            if (module2 == null) {
                UnionScope.$$$reportNull$$$0(10);
            }
            return ContainerUtil.find(this.myScopes, scope -> scope.isSearchInModuleContent(module2, testSources)) != null;
        }

        @Override
        public boolean isSearchInLibraries() {
            return ContainerUtil.find(this.myScopes, GlobalSearchScope::isSearchInLibraries) != null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnionScope)) {
                return false;
            }
            UnionScope that = (UnionScope)o;
            return ContainerUtil.set(this.myScopes).equals(ContainerUtil.set(that.myScopes));
        }

        @Override
        public int calcHashCode() {
            return Arrays.hashCode(this.myScopes);
        }

        @NonNls
        public String toString() {
            return "Union: (" + StringUtil.join(Arrays.asList(this.myScopes), ",") + ")";
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                UnionScope.$$$reportNull$$$0(11);
            }
            if (scope instanceof UnionScope) {
                GlobalSearchScope[] newScopes = ArrayUtil.mergeArrays(this.myScopes, ((UnionScope)scope).myScopes);
                return UnionScope.create(newScopes);
            }
            GlobalSearchScope globalSearchScope = super.uniteWith(scope);
            if (globalSearchScope == null) {
                UnionScope.$$$reportNull$$$0(12);
            }
            return globalSearchScope;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scopes";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScope$UnionScope";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file1";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file2";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScope$UnionScope";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "create";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnloadedModulesBelongingToScope";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uniteWith";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "create";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 12: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "compare";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteWith";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 6: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class IntersectionScope
    extends GlobalSearchScope {
        private final GlobalSearchScope myScope1;
        private final GlobalSearchScope myScope2;
        private final String myDisplayName;

        private IntersectionScope(@NotNull GlobalSearchScope scope1, @NotNull GlobalSearchScope scope2, String displayName) {
            if (scope1 == null) {
                IntersectionScope.$$$reportNull$$$0(0);
            }
            if (scope2 == null) {
                IntersectionScope.$$$reportNull$$$0(1);
            }
            super(scope1.getProject() == null ? scope2.getProject() : scope1.getProject());
            this.myScope1 = scope1;
            this.myScope2 = scope2;
            this.myDisplayName = displayName;
        }

        @Override
        @NotNull
        public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                IntersectionScope.$$$reportNull$$$0(2);
            }
            return this.containsScope(scope) ? this : new IntersectionScope(this, scope, null);
        }

        private boolean containsScope(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                IntersectionScope.$$$reportNull$$$0(3);
            }
            if (this.myScope1.equals(scope) || this.myScope2.equals(scope) || this.equals(scope)) {
                return true;
            }
            if (this.myScope1 instanceof IntersectionScope && ((IntersectionScope)this.myScope1).containsScope(scope)) {
                return true;
            }
            return this.myScope2 instanceof IntersectionScope && ((IntersectionScope)this.myScope2).containsScope(scope);
        }

        @Override
        @NotNull
        public String getDisplayName() {
            if (this.myDisplayName == null) {
                String string = CoreBundle.message("psi.search.scope.intersection", this.myScope1.getDisplayName(), this.myScope2.getDisplayName());
                if (string == null) {
                    IntersectionScope.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = this.myDisplayName;
            if (string == null) {
                IntersectionScope.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                IntersectionScope.$$$reportNull$$$0(6);
            }
            return this.myScope1.contains(file2) && this.myScope2.contains(file2);
        }

        @Override
        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                IntersectionScope.$$$reportNull$$$0(7);
            }
            if (file2 == null) {
                IntersectionScope.$$$reportNull$$$0(8);
            }
            int res1 = this.myScope1.compare(file1, file2);
            int res2 = this.myScope2.compare(file1, file2);
            if (res1 == 0) {
                return res2;
            }
            if (res2 == 0) {
                return res1;
            }
            if (res1 > 0 == res2 > 0) {
                return res1;
            }
            return 0;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                IntersectionScope.$$$reportNull$$$0(9);
            }
            return this.myScope1.isSearchInModuleContent(aModule) && this.myScope2.isSearchInModuleContent(aModule);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                IntersectionScope.$$$reportNull$$$0(10);
            }
            return this.myScope1.isSearchInModuleContent(aModule, testSources) && this.myScope2.isSearchInModuleContent(aModule, testSources);
        }

        @Override
        public boolean isSearchInLibraries() {
            return this.myScope1.isSearchInLibraries() && this.myScope2.isSearchInLibraries();
        }

        @Override
        @NotNull
        public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
            Collection<UnloadedModuleDescription> collection = ContainerUtil.intersection(this.myScope1.getUnloadedModulesBelongingToScope(), this.myScope2.getUnloadedModulesBelongingToScope());
            if (collection == null) {
                IntersectionScope.$$$reportNull$$$0(11);
            }
            return collection;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IntersectionScope)) {
                return false;
            }
            IntersectionScope that = (IntersectionScope)o;
            return this.myScope1.equals(that.myScope1) && this.myScope2.equals(that.myScope2);
        }

        @Override
        public int calcHashCode() {
            return 31 * this.myScope1.hashCode() + this.myScope2.hashCode();
        }

        @NonNls
        public String toString() {
            return "Intersection: (" + this.myScope1 + ", " + this.myScope2 + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope2";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 4: 
                case 5: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScope$IntersectionScope";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file1";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file2";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScope$IntersectionScope";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnloadedModulesBelongingToScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "intersectWith";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "containsScope";
                    break;
                }
                case 4: 
                case 5: 
                case 11: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "compare";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class NotScope
    extends DelegatingGlobalSearchScope {
        private NotScope(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                NotScope.$$$reportNull$$$0(0);
            }
            super(scope);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                NotScope.$$$reportNull$$$0(1);
            }
            return !this.myBaseScope.contains(file2);
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                NotScope.$$$reportNull$$$0(2);
            }
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                NotScope.$$$reportNull$$$0(3);
            }
            return true;
        }

        @Override
        public String toString() {
            return "NOT: " + this.myBaseScope;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/search/GlobalSearchScope$NotScope";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSearchInModuleContent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

