/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GlobalSearchScopesCore {
    @NotNull
    public static GlobalSearchScope projectProductionScope(@NotNull Project project2) {
        if (project2 == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(0);
        }
        return new ProductionScopeFilter(project2);
    }

    @NotNull
    public static GlobalSearchScope projectTestScope(@NotNull Project project2) {
        if (project2 == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(1);
        }
        return new TestScopeFilter(project2);
    }

    @NotNull
    public static GlobalSearchScope directoryScope(@NotNull PsiDirectory directory, boolean withSubdirectories) {
        if (directory == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(2);
        }
        return new DirectoryScope(directory, withSubdirectories);
    }

    @NotNull
    public static GlobalSearchScope directoryScope(@NotNull Project project2, @NotNull VirtualFile directory, boolean withSubdirectories) {
        if (project2 == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(3);
        }
        if (directory == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(4);
        }
        return new DirectoryScope(project2, directory, withSubdirectories);
    }

    @NotNull
    public static GlobalSearchScope directoriesScope(@NotNull Project project2, boolean withSubdirectories, VirtualFile ... directories) {
        HashSet<VirtualFile> dirSet;
        if (project2 == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(5);
        }
        if (directories == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(6);
        }
        if ((dirSet = ContainerUtil.newHashSet(directories)).isEmpty()) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                GlobalSearchScopesCore.$$$reportNull$$$0(7);
            }
            return globalSearchScope;
        }
        if (dirSet.size() == 1) {
            return GlobalSearchScopesCore.directoryScope(project2, (VirtualFile)dirSet.iterator().next(), withSubdirectories);
        }
        return new DirectoriesScope(project2, withSubdirectories ? Collections.emptySet() : dirSet, withSubdirectories ? dirSet : Collections.emptySet());
    }

    public static GlobalSearchScope filterScope(@NotNull Project project2, @NotNull NamedScope set) {
        if (project2 == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(8);
        }
        if (set == null) {
            GlobalSearchScopesCore.$$$reportNull$$$0(9);
        }
        return new FilterScopeAdapter(project2, set);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directories";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopesCore";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopesCore";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "directoriesScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "projectProductionScope";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "projectTestScope";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "directoryScope";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "directoriesScope";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filterScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class DirectoriesScope
    extends GlobalSearchScope {
        private final Set<VirtualFile> myDirectories;
        private final Set<VirtualFile> myDirectoriesWithSubdirectories;

        private DirectoriesScope(@NotNull Project project2, @NotNull Set<VirtualFile> directories, @NotNull Set<VirtualFile> directoriesWithSubdirectories) {
            if (project2 == null) {
                DirectoriesScope.$$$reportNull$$$0(0);
            }
            if (directories == null) {
                DirectoriesScope.$$$reportNull$$$0(1);
            }
            if (directoriesWithSubdirectories == null) {
                DirectoriesScope.$$$reportNull$$$0(2);
            }
            super(project2);
            this.myDirectories = directories;
            this.myDirectoriesWithSubdirectories = directoriesWithSubdirectories;
            if (directories.size() + directoriesWithSubdirectories.size() < 2) {
                throw new IllegalArgumentException("Expected >1 directories, but got: directories " + directories + ", directories with subdirectories " + directoriesWithSubdirectories);
            }
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            VirtualFile parent;
            if (file2 == null) {
                DirectoriesScope.$$$reportNull$$$0(3);
            }
            return (parent = file2.getParent()) != null && this.in(parent);
        }

        private boolean in(@NotNull VirtualFile parent) {
            if (parent == null) {
                DirectoriesScope.$$$reportNull$$$0(4);
            }
            if (this.myDirectories.contains(parent)) {
                return true;
            }
            return VfsUtilCore.isUnder(parent, this.myDirectoriesWithSubdirectories);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                DirectoriesScope.$$$reportNull$$$0(5);
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        public String toString() {
            return "Directories scope: directories " + this.myDirectories + ", directories with subdirectories " + this.myDirectoriesWithSubdirectories;
        }

        @Override
        public int calcHashCode() {
            int result2 = this.myDirectories.hashCode();
            result2 = result2 * 31 + this.myDirectoriesWithSubdirectories.hashCode();
            return result2;
        }

        public boolean equals(Object obj) {
            return obj instanceof DirectoriesScope && this.myDirectories.equals(((DirectoriesScope)obj).myDirectories) && this.myDirectoriesWithSubdirectories.equals(((DirectoriesScope)obj).myDirectoriesWithSubdirectories);
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                DirectoriesScope.$$$reportNull$$$0(6);
            }
            if (this.equals(scope)) {
                DirectoriesScope directoriesScope = this;
                if (directoriesScope == null) {
                    DirectoriesScope.$$$reportNull$$$0(7);
                }
                return directoriesScope;
            }
            if (scope instanceof DirectoryScope) {
                DirectoryScope other = (DirectoryScope)scope;
                if (this.in(other.myDirectory)) {
                    DirectoriesScope directoriesScope = this;
                    if (directoriesScope == null) {
                        DirectoriesScope.$$$reportNull$$$0(8);
                    }
                    return directoriesScope;
                }
                Set<VirtualFile> directories = this.myDirectories;
                Set<VirtualFile> directoriesWithSubdirectories = this.myDirectoriesWithSubdirectories;
                if (other.myWithSubdirectories) {
                    directoriesWithSubdirectories = new HashSet<VirtualFile>(directoriesWithSubdirectories);
                    directoriesWithSubdirectories.add(other.myDirectory);
                } else {
                    directories = new HashSet<VirtualFile>(directories);
                    directories.add(other.myDirectory);
                }
                return new DirectoriesScope(this.getProject(), directories, directoriesWithSubdirectories);
            }
            if (scope instanceof DirectoriesScope) {
                DirectoriesScope other = (DirectoriesScope)scope;
                Set<VirtualFile> directories = this.myDirectories;
                Set<VirtualFile> directoriesWithSubdirectories = this.myDirectoriesWithSubdirectories;
                if (!other.myDirectories.isEmpty()) {
                    directories = new HashSet<VirtualFile>(directories);
                    directories.addAll(other.myDirectories);
                }
                if (!other.myDirectoriesWithSubdirectories.isEmpty()) {
                    directoriesWithSubdirectories = new HashSet<VirtualFile>(directoriesWithSubdirectories);
                    directoriesWithSubdirectories.addAll(other.myDirectoriesWithSubdirectories);
                }
                return new DirectoriesScope(this.getProject(), directories, directoriesWithSubdirectories);
            }
            GlobalSearchScope globalSearchScope = super.uniteWith(scope);
            if (globalSearchScope == null) {
                DirectoriesScope.$$$reportNull$$$0(9);
            }
            return globalSearchScope;
        }

        @Override
        @NotNull
        public Project getProject() {
            Project project2 = super.getProject();
            if (project2 == null) {
                DirectoriesScope.$$$reportNull$$$0(10);
            }
            return project2;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            if (this.myDirectories.size() + this.myDirectoriesWithSubdirectories.size() == 1) {
                Set<VirtualFile> dirs = this.myDirectories.size() == 1 ? this.myDirectories : this.myDirectoriesWithSubdirectories;
                VirtualFile root = Objects.requireNonNull(ContainerUtil.getFirstItem(dirs));
                String string = AnalysisBundle.message("display.name.directory.0", root.getName());
                if (string == null) {
                    DirectoriesScope.$$$reportNull$$$0(11);
                }
                return string;
            }
            Iterable<VirtualFile> allDirs = ContainerUtil.concat(this.myDirectories, this.myDirectoriesWithSubdirectories);
            String string = AnalysisBundle.message("display.name.directories.0", StringUtil.join(allDirs, file2 -> "'" + file2.getName() + "'", ", "));
            if (string == null) {
                DirectoriesScope.$$$reportNull$$$0(12);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directories";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directoriesWithSubdirectories";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopesCore$DirectoriesScope";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uniteWith";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "in";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteWith";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DirectoryScope
    extends GlobalSearchScope {
        private final VirtualFile myDirectory;
        private final boolean myWithSubdirectories;

        private DirectoryScope(@NotNull PsiDirectory psiDirectory, boolean withSubdirectories) {
            if (psiDirectory == null) {
                DirectoryScope.$$$reportNull$$$0(0);
            }
            super(psiDirectory.getProject());
            this.myWithSubdirectories = withSubdirectories;
            this.myDirectory = psiDirectory.getVirtualFile();
        }

        public DirectoryScope(@NotNull Project project2, @NotNull VirtualFile directory, boolean withSubdirectories) {
            if (project2 == null) {
                DirectoryScope.$$$reportNull$$$0(1);
            }
            if (directory == null) {
                DirectoryScope.$$$reportNull$$$0(2);
            }
            super(project2);
            this.myWithSubdirectories = withSubdirectories;
            this.myDirectory = directory;
        }

        @NotNull
        public VirtualFile getDirectory() {
            VirtualFile virtualFile2 = this.myDirectory;
            if (virtualFile2 == null) {
                DirectoryScope.$$$reportNull$$$0(3);
            }
            return virtualFile2;
        }

        public boolean isWithSubdirectories() {
            return this.myWithSubdirectories;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            VirtualFile parent;
            if (file2 == null) {
                DirectoryScope.$$$reportNull$$$0(4);
            }
            return (parent = file2.getParent()) != null && this.in(parent);
        }

        private boolean in(@NotNull VirtualFile parent) {
            if (parent == null) {
                DirectoryScope.$$$reportNull$$$0(5);
            }
            return this.myWithSubdirectories ? VfsUtilCore.isAncestor(this.myDirectory, parent, false) : this.myDirectory.equals(parent);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                DirectoryScope.$$$reportNull$$$0(6);
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        public String toString() {
            return "directory scope: " + this.myDirectory + "; withSubdirs:" + this.myWithSubdirectories;
        }

        @Override
        public int calcHashCode() {
            return this.myDirectory.hashCode() * 31 + (this.myWithSubdirectories ? 1 : 0);
        }

        public boolean equals(Object obj) {
            return obj instanceof DirectoryScope && this.myDirectory.equals(((DirectoryScope)obj).myDirectory) && this.myWithSubdirectories == ((DirectoryScope)obj).myWithSubdirectories;
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (scope == null) {
                DirectoryScope.$$$reportNull$$$0(7);
            }
            if (this.equals(scope)) {
                DirectoryScope directoryScope = this;
                if (directoryScope == null) {
                    DirectoryScope.$$$reportNull$$$0(8);
                }
                return directoryScope;
            }
            if (scope instanceof DirectoryScope) {
                DirectoryScope other = (DirectoryScope)scope;
                if (this.in(other.myDirectory)) {
                    DirectoryScope directoryScope = this;
                    if (directoryScope == null) {
                        DirectoryScope.$$$reportNull$$$0(9);
                    }
                    return directoryScope;
                }
                if (other.in(this.myDirectory)) {
                    DirectoryScope directoryScope = other;
                    if (directoryScope == null) {
                        DirectoryScope.$$$reportNull$$$0(10);
                    }
                    return directoryScope;
                }
                return new DirectoriesScope(this.getProject(), DirectoryScope.union(!this.myWithSubdirectories, this.myDirectory, !other.myWithSubdirectories, other.myDirectory), DirectoryScope.union(this.myWithSubdirectories, this.myDirectory, other.myWithSubdirectories, other.myDirectory));
            }
            GlobalSearchScope globalSearchScope = super.uniteWith(scope);
            if (globalSearchScope == null) {
                DirectoryScope.$$$reportNull$$$0(11);
            }
            return globalSearchScope;
        }

        @NotNull
        private static Set<VirtualFile> union(boolean addDir1, @NotNull VirtualFile dir1, boolean addDir2, @NotNull VirtualFile dir2) {
            if (dir1 == null) {
                DirectoryScope.$$$reportNull$$$0(12);
            }
            if (dir2 == null) {
                DirectoryScope.$$$reportNull$$$0(13);
            }
            if (addDir1 && addDir2) {
                HashSet<VirtualFile> hashSet = ContainerUtil.newHashSet(dir1, dir2);
                if (hashSet == null) {
                    DirectoryScope.$$$reportNull$$$0(14);
                }
                return hashSet;
            }
            if (addDir1) {
                Set<VirtualFile> set = Collections.singleton(dir1);
                if (set == null) {
                    DirectoryScope.$$$reportNull$$$0(15);
                }
                return set;
            }
            if (addDir2) {
                Set<VirtualFile> set = Collections.singleton(dir2);
                if (set == null) {
                    DirectoryScope.$$$reportNull$$$0(16);
                }
                return set;
            }
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                DirectoryScope.$$$reportNull$$$0(17);
            }
            return set;
        }

        @Override
        @NotNull
        public Project getProject() {
            Project project2 = super.getProject();
            if (project2 == null) {
                DirectoryScope.$$$reportNull$$$0(18);
            }
            return project2;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = AnalysisBundle.message("display.name.directory.0", this.myDirectory.getName());
            if (string == null) {
                DirectoryScope.$$$reportNull$$$0(19);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiDirectory";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directory";
                    break;
                }
                case 3: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir1";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dir2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopesCore$DirectoryScope";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDirectory";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "uniteWith";
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "union";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "in";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "uniteWith";
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "union";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TestScopeFilter
    extends GlobalSearchScope {
        private TestScopeFilter(@NotNull Project project2) {
            if (project2 == null) {
                TestScopeFilter.$$$reportNull$$$0(0);
            }
            super(project2);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                TestScopeFilter.$$$reportNull$$$0(1);
            }
            return TestSourcesFilter.isTestSources(file2, Objects.requireNonNull(this.getProject()));
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                TestScopeFilter.$$$reportNull$$$0(2);
            }
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                TestScopeFilter.$$$reportNull$$$0(3);
            }
            return testSources;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = AnalysisBundle.message("psi.search.scope.test.files", new Object[0]);
            if (string == null) {
                TestScopeFilter.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopesCore$TestScopeFilter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ProductionScopeFilter
    extends GlobalSearchScope {
        private final ProjectFileIndex myFileIndex;

        private ProductionScopeFilter(@NotNull Project project2) {
            if (project2 == null) {
                ProductionScopeFilter.$$$reportNull$$$0(0);
            }
            super(project2);
            this.myFileIndex = ProjectRootManager.getInstance(project2).getFileIndex();
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                ProductionScopeFilter.$$$reportNull$$$0(1);
            }
            return this.myFileIndex.isInSourceContent(file2) && !TestSourcesFilter.isTestSources(file2, Objects.requireNonNull(this.getProject()));
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                ProductionScopeFilter.$$$reportNull$$$0(2);
            }
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            if (aModule == null) {
                ProductionScopeFilter.$$$reportNull$$$0(3);
            }
            return !testSources;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        @NotNull
        public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
            Collection<UnloadedModuleDescription> collection = ModuleManager.getInstance(Objects.requireNonNull(this.getProject())).getUnloadedModuleDescriptions();
            if (collection == null) {
                ProductionScopeFilter.$$$reportNull$$$0(4);
            }
            return collection;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = AnalysisBundle.message("psi.search.scope.production.files", new Object[0]);
            if (string == null) {
                ProductionScopeFilter.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopesCore$ProductionScopeFilter";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnloadedModulesBelongingToScope";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class FilterScopeAdapter
    extends GlobalSearchScope {
        private final NamedScope mySet;
        private final PsiManager myManager;

        private FilterScopeAdapter(@NotNull Project project2, @NotNull NamedScope set) {
            if (project2 == null) {
                FilterScopeAdapter.$$$reportNull$$$0(0);
            }
            if (set == null) {
                FilterScopeAdapter.$$$reportNull$$$0(1);
            }
            super(project2);
            this.mySet = set;
            this.myManager = PsiManager.getInstance(project2);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                FilterScopeAdapter.$$$reportNull$$$0(2);
            }
            Project project2 = this.getProject();
            NamedScopeManager holder = NamedScopeManager.getInstance(project2);
            PackageSet packageSet = this.mySet.getValue();
            if (packageSet != null) {
                if (packageSet instanceof PackageSetBase) {
                    return ((PackageSetBase)packageSet).contains(file2, project2, holder);
                }
                PsiFile psiFile = this.myManager.findFile(file2);
                return psiFile != null && packageSet.contains(psiFile, holder);
            }
            return false;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            String string = this.mySet.getName();
            if (string == null) {
                FilterScopeAdapter.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon2 = this.mySet.getIcon();
            if (icon2 == null) {
                FilterScopeAdapter.$$$reportNull$$$0(4);
            }
            return icon2;
        }

        @Override
        @NotNull
        public Project getProject() {
            Project project2 = super.getProject();
            if (project2 == null) {
                FilterScopeAdapter.$$$reportNull$$$0(5);
            }
            return project2;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                FilterScopeAdapter.$$$reportNull$$$0(6);
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterScopeAdapter adapter = (FilterScopeAdapter)o;
            if (!this.mySet.equals(adapter.mySet)) {
                return false;
            }
            return this.myManager.equals(adapter.myManager);
        }

        @Override
        public int calcHashCode() {
            int result2 = super.calcHashCode();
            result2 = 31 * result2 + this.mySet.hashCode();
            result2 = 31 * result2 + this.myManager.hashCode();
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "set";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/GlobalSearchScopesCore$FilterScopeAdapter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

