/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyBrowserBase;
import com.intellij.ide.scratch.ScratchesSearchScope;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbUnawareHider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopes;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchScopeProvider;
import com.intellij.psi.search.scope.EditorSelectionLocalSearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PredefinedSearchScopeProviderImpl
extends PredefinedSearchScopeProvider {
    @Override
    @NotNull
    public List<SearchScope> getPredefinedScopes(@NotNull Project project2, @Nullable DataContext dataContext, boolean suggestSearchInLibs, boolean prevSearchFiles, boolean currentSelection, boolean usageView, boolean showEmptyScopes) {
        SelectionModel selectionModel;
        PsiFile psiFile;
        if (project2 == null) {
            PredefinedSearchScopeProviderImpl.$$$reportNull$$$0(0);
        }
        LinkedHashSet<SearchScope> result2 = new LinkedHashSet<SearchScope>();
        result2.add(GlobalSearchScope.everythingScope(project2));
        result2.add(GlobalSearchScope.projectScope(project2));
        if (suggestSearchInLibs) {
            result2.add(GlobalSearchScope.allScope(project2));
        }
        DataContext adjustedContext = dataContext != null ? dataContext : SimpleDataContext.getProjectContext(project2);
        for (SearchScopeProvider each : SearchScopeProvider.EP_NAME.getExtensions()) {
            result2.addAll(each.getGeneralSearchScopes(project2, adjustedContext));
        }
        if (ModuleUtil.hasTestSourceRoots(project2)) {
            result2.add(GlobalSearchScopesCore.projectProductionScope(project2));
            result2.add(GlobalSearchScopesCore.projectTestScope(project2));
        }
        result2.add(ScratchesSearchScope.getScratchesScope(project2));
        GlobalSearchScope recentFilesScope = PredefinedSearchScopeProviderImpl.recentFilesScope(project2, false);
        ContainerUtil.addIfNotNull(result2, recentFilesScope != GlobalSearchScope.EMPTY_SCOPE ? recentFilesScope : (showEmptyScopes ? new LocalSearchScope(PsiElement.EMPTY_ARRAY, IdeBundle.message("scope.recent.files", new Object[0])) : null));
        GlobalSearchScope recentModFilesScope = PredefinedSearchScopeProviderImpl.recentFilesScope(project2, true);
        ContainerUtil.addIfNotNull(result2, recentModFilesScope != GlobalSearchScope.EMPTY_SCOPE ? recentModFilesScope : (showEmptyScopes ? new LocalSearchScope(PsiElement.EMPTY_ARRAY, IdeBundle.message("scope.recent.modified.files", new Object[0])) : null));
        GlobalSearchScope openFilesScope = GlobalSearchScopes.openFilesScope(project2);
        ContainerUtil.addIfNotNull(result2, openFilesScope != GlobalSearchScope.EMPTY_SCOPE ? openFilesScope : (showEmptyScopes ? new LocalSearchScope(PsiElement.EMPTY_ARRAY, IdeBundle.message("scope.open.files", new Object[0])) : null));
        Editor selectedTextEditor = ApplicationManager.getApplication().isDispatchThread() ? FileEditorManager.getInstance(project2).getSelectedTextEditor() : null;
        PsiFile currentFile = psiFile = selectedTextEditor == null ? null : PsiDocumentManager.getInstance(project2).getPsiFile(selectedTextEditor.getDocument());
        if (dataContext != null) {
            PsiElement dataContextElement = CommonDataKeys.PSI_FILE.getData(dataContext);
            if (dataContextElement == null) {
                dataContextElement = CommonDataKeys.PSI_ELEMENT.getData(dataContext);
            }
            if (dataContextElement == null && psiFile != null) {
                dataContextElement = psiFile;
            }
            if (dataContextElement != null) {
                if (!PlatformUtils.isCidr() && !PlatformUtils.isRider()) {
                    Module module2 = ModuleUtilCore.findModuleForPsiElement(dataContextElement);
                    if (module2 == null) {
                        module2 = LangDataKeys.MODULE.getData(dataContext);
                    }
                    if (module2 != null && !ModuleType.isInternal(module2)) {
                        result2.add(module2.getModuleScope());
                    }
                }
                if (currentFile == null) {
                    currentFile = dataContextElement.getContainingFile();
                }
            }
        }
        if (currentFile != null || showEmptyScopes) {
            PsiElement[] psiElementArray;
            if (currentFile != null) {
                PsiElement[] psiElementArray2 = new PsiElement[1];
                psiElementArray = psiElementArray2;
                psiElementArray2[0] = currentFile;
            } else {
                psiElementArray = PsiElement.EMPTY_ARRAY;
            }
            PsiElement[] scope = psiElementArray;
            result2.add(new LocalSearchScope(scope, IdeBundle.message("scope.current.file", new Object[0])));
        }
        if (currentSelection && selectedTextEditor != null && psiFile != null && (selectionModel = selectedTextEditor.getSelectionModel()).hasSelection()) {
            result2.add(new EditorSelectionLocalSearchScope(selectedTextEditor, project2, IdeBundle.message("scope.selection", new Object[0])));
        }
        if (usageView) {
            PredefinedSearchScopeProviderImpl.addHierarchyScope(project2, result2);
            UsageView selectedUsageView = UsageViewManager.getInstance(project2).getSelectedUsageView();
            if (selectedUsageView != null && !selectedUsageView.isSearchInProgress()) {
                final THashSet<Usage> usages = new THashSet<Usage>(selectedUsageView.getUsages());
                usages.removeAll(selectedUsageView.getExcludedUsages());
                if (prevSearchFiles) {
                    Set<VirtualFile> files2 = PredefinedSearchScopeProviderImpl.collectFiles(usages, true);
                    if (!files2.isEmpty()) {
                        GlobalSearchScope prev = new GlobalSearchScope(project2){
                            private Set<VirtualFile> myFiles;

                            @Override
                            @NotNull
                            public String getDisplayName() {
                                String string = IdeBundle.message("scope.files.in.previous.search.result", new Object[0]);
                                if (string == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                return string;
                            }

                            @Override
                            public synchronized boolean contains(@NotNull VirtualFile file2) {
                                if (file2 == null) {
                                    1.$$$reportNull$$$0(1);
                                }
                                if (this.myFiles == null) {
                                    this.myFiles = PredefinedSearchScopeProviderImpl.collectFiles(usages, false);
                                }
                                return this.myFiles.contains(file2);
                            }

                            @Override
                            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                                if (aModule == null) {
                                    1.$$$reportNull$$$0(2);
                                }
                                return true;
                            }

                            @Override
                            public boolean isSearchInLibraries() {
                                return true;
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                RuntimeException runtimeException;
                                Object[] objectArray;
                                Object[] objectArray2;
                                int n2;
                                String string;
                                switch (n) {
                                    default: {
                                        string = "@NotNull method %s.%s must not return null";
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        n2 = 2;
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        n2 = 3;
                                        break;
                                    }
                                }
                                Object[] objectArray3 = new Object[n2];
                                switch (n) {
                                    default: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "com/intellij/psi/search/PredefinedSearchScopeProviderImpl$1";
                                        break;
                                    }
                                    case 1: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "file";
                                        break;
                                    }
                                    case 2: {
                                        objectArray2 = objectArray3;
                                        objectArray3[0] = "aModule";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "getDisplayName";
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        objectArray = objectArray2;
                                        objectArray2[1] = "com/intellij/psi/search/PredefinedSearchScopeProviderImpl$1";
                                        break;
                                    }
                                }
                                switch (n) {
                                    default: {
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray;
                                        objectArray[2] = "contains";
                                        break;
                                    }
                                    case 2: {
                                        objectArray = objectArray;
                                        objectArray[2] = "isSearchInModuleContent";
                                        break;
                                    }
                                }
                                String string2 = String.format(string, objectArray);
                                switch (n) {
                                    default: {
                                        runtimeException = new IllegalStateException(string2);
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        runtimeException = new IllegalArgumentException(string2);
                                        break;
                                    }
                                }
                                throw runtimeException;
                            }
                        };
                        result2.add(prev);
                    }
                } else {
                    ArrayList<PsiElement> results = new ArrayList<PsiElement>(usages.size());
                    for (Usage usage : usages) {
                        PsiElement element2;
                        if (!(usage instanceof PsiElementUsage) || (element2 = ((PsiElementUsage)usage).getElement()) == null || !element2.isValid() || element2.getContainingFile() == null) continue;
                        results.add(element2);
                    }
                    if (!results.isEmpty()) {
                        result2.add(new LocalSearchScope(PsiUtilCore.toPsiElementArray(results), IdeBundle.message("scope.previous.search.results", new Object[0])));
                    }
                }
            }
        }
        ContainerUtil.addIfNotNull(result2, PredefinedSearchScopeProviderImpl.getSelectedFilesScope(project2, dataContext, currentFile));
        return new ArrayList<SearchScope>(result2);
    }

    private static void addHierarchyScope(@NotNull Project project2, Collection<? super SearchScope> result2) {
        HierarchyBrowserBase hierarchyBrowserBase;
        PsiElement[] elements2;
        ToolWindow toolWindow;
        if (project2 == null) {
            PredefinedSearchScopeProviderImpl.$$$reportNull$$$0(1);
        }
        if ((toolWindow = ToolWindowManager.getInstance(project2).getToolWindow("Hierarchy")) == null) {
            return;
        }
        ContentManager contentManager2 = toolWindow.getContentManager();
        Content content2 = contentManager2.getSelectedContent();
        if (content2 == null) {
            return;
        }
        String name = content2.getDisplayName();
        JComponent component2 = content2.getComponent();
        if (component2 instanceof DumbUnawareHider) {
            component2 = ((DumbUnawareHider)component2).getContent();
        }
        if ((elements2 = (hierarchyBrowserBase = (HierarchyBrowserBase)component2).getAvailableElements()).length > 0) {
            result2.add(new LocalSearchScope(elements2, "Hierarchy '" + name + "' (visible nodes only)"));
        }
    }

    @NotNull
    public static GlobalSearchScope recentFilesScope(@NotNull Project project2, boolean changedOnly) {
        if (project2 == null) {
            PredefinedSearchScopeProviderImpl.$$$reportNull$$$0(2);
        }
        String name = changedOnly ? IdeBundle.message("scope.recent.modified.files", new Object[0]) : IdeBundle.message("scope.recent.files", new Object[0]);
        List<VirtualFile> files2 = changedOnly ? Arrays.asList(IdeDocumentHistory.getInstance(project2).getChangedFiles()) : JBIterable.from(EditorHistoryManager.getInstance(project2).getFileList()).append((VirtualFile)FileEditorManager.getInstance(project2).getOpenFiles()).unique().toList();
        GlobalSearchScope globalSearchScope = files2.isEmpty() ? GlobalSearchScope.EMPTY_SCOPE : GlobalSearchScope.filesScope(project2, files2, name);
        if (globalSearchScope == null) {
            PredefinedSearchScopeProviderImpl.$$$reportNull$$$0(3);
        }
        return globalSearchScope;
    }

    @Nullable
    private static SearchScope getSelectedFilesScope(@NotNull Project project2, @Nullable DataContext dataContext, @Nullable PsiFile currentFile) {
        VirtualFile[] filesOrDirs;
        if (project2 == null) {
            PredefinedSearchScopeProviderImpl.$$$reportNull$$$0(4);
        }
        VirtualFile[] virtualFileArray = filesOrDirs = dataContext == null ? null : CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (filesOrDirs == null || filesOrDirs.length == 0 || filesOrDirs.length == 1 && currentFile != null && filesOrDirs[0].equals(currentFile.getVirtualFile())) {
            return null;
        }
        return new SelectedFilesScope(project2, filesOrDirs);
    }

    @NotNull
    protected static Set<VirtualFile> collectFiles(Set<? extends Usage> usages, boolean findFirst) {
        HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
        for (Usage usage : usages) {
            VirtualFile file2;
            PsiFile psiFile;
            PsiElement psiElement;
            if (!(usage instanceof PsiElementUsage) || (psiElement = ((PsiElementUsage)usage).getElement()) == null || !psiElement.isValid() || (psiFile = psiElement.getContainingFile()) == null || (file2 = psiFile.getVirtualFile()) == null) continue;
            files2.add(file2);
            if (!findFirst) continue;
            HashSet<VirtualFile> hashSet = files2;
            if (hashSet == null) {
                PredefinedSearchScopeProviderImpl.$$$reportNull$$$0(5);
            }
            return hashSet;
        }
        HashSet<VirtualFile> hashSet = files2;
        if (hashSet == null) {
            PredefinedSearchScopeProviderImpl.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/PredefinedSearchScopeProviderImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/PredefinedSearchScopeProviderImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "recentFilesScope";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedScopes";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addHierarchyScope";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "recentFilesScope";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedFilesScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class SelectedFilesScope
    extends GlobalSearchScope {
        private final Set<VirtualFile> myFiles = new THashSet<VirtualFile>();
        private final Set<VirtualFile> myDirectories = new THashSet<VirtualFile>();

        SelectedFilesScope(Project project2, VirtualFile ... filesOrDirs) {
            super(project2);
            if (filesOrDirs.length == 0) {
                throw new IllegalArgumentException("array is empty");
            }
            for (VirtualFile fileOrDir : filesOrDirs) {
                if (fileOrDir.isDirectory()) {
                    this.myDirectories.add(fileOrDir);
                    continue;
                }
                this.myFiles.add(fileOrDir);
            }
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                SelectedFilesScope.$$$reportNull$$$0(0);
            }
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                SelectedFilesScope.$$$reportNull$$$0(1);
            }
            for (VirtualFile virtualFile2 : this.myFiles) {
                if (!virtualFile2.equals(file2)) continue;
                return true;
            }
            return VfsUtilCore.isUnder(file2, this.myDirectories);
        }

        @Override
        @NotNull
        public String getDisplayName() {
            if (this.myFiles.isEmpty()) {
                String string = IdeBundle.message("scope.selected.directories", this.myDirectories.size());
                if (string == null) {
                    SelectedFilesScope.$$$reportNull$$$0(2);
                }
                return string;
            }
            if (this.myDirectories.isEmpty()) {
                String string = IdeBundle.message("scope.selected.files", this.myFiles.size());
                if (string == null) {
                    SelectedFilesScope.$$$reportNull$$$0(3);
                }
                return string;
            }
            String string = IdeBundle.message("scope.selected.files.and.directories", this.myFiles.size(), this.myDirectories.size());
            if (string == null) {
                SelectedFilesScope.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/PredefinedSearchScopeProviderImpl$SelectedFilesScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/PredefinedSearchScopeProviderImpl$SelectedFilesScope";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

