/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.codeInsight.ContainerProvider;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchRequest;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.ScopeOptimizer;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.psi.search.SingleTargetRequestResultProcessor;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SearchRequestCollector {
    private static final ExtensionPointName<ScopeOptimizer> CODE_USAGE_SCOPE_OPTIMIZER_EP_NAME = ExtensionPointName.create("com.intellij.codeUsageScopeOptimizer");
    private final Object lock;
    private final List<PsiSearchRequest> myWordRequests;
    private final List<QuerySearchRequest> myQueryRequests;
    private final List<Processor<Processor<? super PsiReference>>> myCustomSearchActions;
    private final SearchSession mySession;

    public SearchRequestCollector(@NotNull SearchSession session2) {
        if (session2 == null) {
            SearchRequestCollector.$$$reportNull$$$0(0);
        }
        this.lock = new Object();
        this.myWordRequests = new ArrayList<PsiSearchRequest>();
        this.myQueryRequests = new ArrayList<QuerySearchRequest>();
        this.myCustomSearchActions = new ArrayList<Processor<Processor<? super PsiReference>>>();
        this.mySession = session2;
    }

    @NotNull
    public SearchSession getSearchSession() {
        SearchSession searchSession = this.mySession;
        if (searchSession == null) {
            SearchRequestCollector.$$$reportNull$$$0(1);
        }
        return searchSession;
    }

    public void searchWord(@NotNull String word, @NotNull SearchScope searchScope, boolean caseSensitive, @NotNull PsiElement searchTarget) {
        if (word == null) {
            SearchRequestCollector.$$$reportNull$$$0(2);
        }
        if (searchScope == null) {
            SearchRequestCollector.$$$reportNull$$$0(3);
        }
        if (searchTarget == null) {
            SearchRequestCollector.$$$reportNull$$$0(4);
        }
        short searchContext = (short)(0xB | (searchTarget instanceof PsiFileSystemItem ? 4 : 0));
        this.searchWord(word, searchScope, searchContext, caseSensitive, searchTarget);
    }

    public void searchWord(@NotNull String word, @NotNull SearchScope searchScope, short searchContext, boolean caseSensitive, @NotNull PsiElement searchTarget) {
        if (word == null) {
            SearchRequestCollector.$$$reportNull$$$0(5);
        }
        if (searchScope == null) {
            SearchRequestCollector.$$$reportNull$$$0(6);
        }
        if (searchTarget == null) {
            SearchRequestCollector.$$$reportNull$$$0(7);
        }
        this.searchWord(word, searchScope, searchContext, caseSensitive, SearchRequestCollector.getContainerName(searchTarget), searchTarget, new SingleTargetRequestResultProcessor(searchTarget));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchWord(@NotNull String word, @NotNull SearchScope searchScope, short searchContext, boolean caseSensitive, String containerName, PsiElement searchTarget, @NotNull RequestResultProcessor processor2) {
        SearchScope restrictedCodeUsageSearchScope;
        if (word == null) {
            SearchRequestCollector.$$$reportNull$$$0(8);
        }
        if (searchScope == null) {
            SearchRequestCollector.$$$reportNull$$$0(9);
        }
        if (processor2 == null) {
            SearchRequestCollector.$$$reportNull$$$0(10);
        }
        if (!SearchRequestCollector.makesSenseToSearch(word, searchScope)) {
            return;
        }
        Collection<PsiSearchRequest> requests = null;
        if (searchTarget != null && searchScope instanceof GlobalSearchScope && ((searchContext & 1) != 0 || searchContext == 255) && (restrictedCodeUsageSearchScope = ReadAction.compute(() -> ScopeOptimizer.calculateOverallRestrictedUseScope(CODE_USAGE_SCOPE_OPTIMIZER_EP_NAME.getExtensions(), searchTarget))) != null) {
            short exceptCodeSearchContext = searchContext == 255 ? (short)30 : (short)(searchContext ^ 1);
            SearchScope searchCodeUsageEffectiveScope = searchScope.intersectWith(restrictedCodeUsageSearchScope);
            requests = Arrays.asList(new PsiSearchRequest(searchCodeUsageEffectiveScope, word, 1, caseSensitive, containerName, processor2), new PsiSearchRequest(searchScope, word, exceptCodeSearchContext, caseSensitive, containerName, processor2));
        }
        if (requests == null) {
            requests = Collections.singleton(new PsiSearchRequest(searchScope, word, searchContext, caseSensitive, containerName, processor2));
        }
        Object object = this.lock;
        synchronized (object) {
            this.myWordRequests.addAll(requests);
        }
    }

    public void searchWord(@NotNull String word, @NotNull SearchScope searchScope, short searchContext, boolean caseSensitive, @NotNull PsiElement searchTarget, @NotNull RequestResultProcessor processor2) {
        if (word == null) {
            SearchRequestCollector.$$$reportNull$$$0(11);
        }
        if (searchScope == null) {
            SearchRequestCollector.$$$reportNull$$$0(12);
        }
        if (searchTarget == null) {
            SearchRequestCollector.$$$reportNull$$$0(13);
        }
        if (processor2 == null) {
            SearchRequestCollector.$$$reportNull$$$0(14);
        }
        this.searchWord(word, searchScope, searchContext, caseSensitive, SearchRequestCollector.getContainerName(searchTarget), searchTarget, processor2);
    }

    private static String getContainerName(@NotNull PsiElement target2) {
        if (target2 == null) {
            SearchRequestCollector.$$$reportNull$$$0(15);
        }
        return ReadAction.compute(() -> {
            PsiElement container2 = SearchRequestCollector.getContainer(target2);
            return container2 instanceof PsiNamedElement ? ((PsiNamedElement)container2).getName() : null;
        });
    }

    private static PsiElement getContainer(@NotNull PsiElement refElement) {
        if (refElement == null) {
            SearchRequestCollector.$$$reportNull$$$0(16);
        }
        for (ContainerProvider provider : ContainerProvider.EP_NAME.getExtensions()) {
            PsiElement container2 = provider.getContainer(refElement);
            if (container2 == null) continue;
            return container2;
        }
        return null;
    }

    @Deprecated
    public void searchWord(@NotNull String word, @NotNull SearchScope searchScope, short searchContext, boolean caseSensitive, @NotNull RequestResultProcessor processor2) {
        if (word == null) {
            SearchRequestCollector.$$$reportNull$$$0(17);
        }
        if (searchScope == null) {
            SearchRequestCollector.$$$reportNull$$$0(18);
        }
        if (processor2 == null) {
            SearchRequestCollector.$$$reportNull$$$0(19);
        }
        this.searchWord(word, searchScope, searchContext, caseSensitive, null, null, processor2);
    }

    private static boolean makesSenseToSearch(@NotNull String word, @NotNull SearchScope searchScope) {
        if (word == null) {
            SearchRequestCollector.$$$reportNull$$$0(20);
        }
        if (searchScope == null) {
            SearchRequestCollector.$$$reportNull$$$0(21);
        }
        if (searchScope instanceof LocalSearchScope && ((LocalSearchScope)searchScope).getScope().length == 0) {
            return false;
        }
        return searchScope != GlobalSearchScope.EMPTY_SCOPE && !StringUtil.isEmpty(word);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchQuery(@NotNull QuerySearchRequest request2) {
        if (request2 == null) {
            SearchRequestCollector.$$$reportNull$$$0(22);
        }
        assert (request2.collector != this);
        assert (request2.collector.getSearchSession() == this.mySession);
        Object object = this.lock;
        synchronized (object) {
            this.myQueryRequests.add(request2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchCustom(@NotNull Processor<Processor<? super PsiReference>> searchAction) {
        if (searchAction == null) {
            SearchRequestCollector.$$$reportNull$$$0(23);
        }
        Object object = this.lock;
        synchronized (object) {
            this.myCustomSearchActions.add(searchAction);
        }
    }

    @NotNull
    public List<QuerySearchRequest> takeQueryRequests() {
        return this.takeRequests(this.myQueryRequests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private <T> List<T> takeRequests(@NotNull List<? extends T> list2) {
        if (list2 == null) {
            SearchRequestCollector.$$$reportNull$$$0(24);
        }
        Object object = this.lock;
        // MONITORENTER : object
        ArrayList<T> requests = new ArrayList<T>(list2);
        list2.clear();
        ArrayList<T> arrayList = requests;
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        SearchRequestCollector.$$$reportNull$$$0(25);
        return arrayList;
    }

    @NotNull
    public List<PsiSearchRequest> takeSearchRequests() {
        return this.takeRequests(this.myWordRequests);
    }

    @NotNull
    public List<Processor<Processor<? super PsiReference>>> takeCustomSearchActions() {
        return this.takeRequests(this.myCustomSearchActions);
    }

    public String toString() {
        return this.myWordRequests.toString().replace(',', '\n') + ";" + this.myQueryRequests;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/SearchRequestCollector";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 12: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 4: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchTarget";
                break;
            }
            case 10: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchAction";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/SearchRequestCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchSession";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "takeRequests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 25: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "searchWord";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getContainerName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getContainer";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "makesSenseToSearch";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "searchQuery";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "searchCustom";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "takeRequests";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

