/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SingleTargetRequestResultProcessor
extends RequestResultProcessor {
    private static final PsiReferenceService ourReferenceService = PsiReferenceService.getService();
    private final PsiElement myTarget;

    public SingleTargetRequestResultProcessor(@NotNull PsiElement target2) {
        if (target2 == null) {
            SingleTargetRequestResultProcessor.$$$reportNull$$$0(0);
        }
        super(target2);
        this.myTarget = target2;
    }

    @Override
    public boolean processTextOccurrence(@NotNull PsiElement element2, int offsetInElement, @NotNull Processor<? super PsiReference> consumer) {
        if (element2 == null) {
            SingleTargetRequestResultProcessor.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            SingleTargetRequestResultProcessor.$$$reportNull$$$0(2);
        }
        if (!this.myTarget.isValid()) {
            return false;
        }
        List<PsiReference> references2 = ourReferenceService.getReferences(element2, new PsiReferenceService.Hints(this.myTarget, offsetInElement));
        for (int i = 0; i < references2.size(); ++i) {
            PsiReference ref = references2.get(i);
            ProgressManager.checkCanceled();
            if (!ReferenceRange.containsOffsetInElement(ref, offsetInElement) || !ref.isReferenceTo(this.myTarget) || consumer.process(ref)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "SingleTarget: " + this.myTarget;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/search/SingleTargetRequestResultProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processTextOccurrence";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

