/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.util.ObjectUtils;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TodoAttributes
implements Cloneable {
    private Icon myIcon;
    private TextAttributes myTextAttributes;
    private boolean myShouldUseCustomColors;
    @NonNls
    private static final String ATTRIBUTE_ICON = "icon";
    @NonNls
    private static final String ICON_DEFAULT = "default";
    @NonNls
    private static final String ICON_QUESTION = "question";
    @NonNls
    private static final String ICON_IMPORTANT = "important";
    @NonNls
    private static final String ELEMENT_OPTION = "option";
    @NonNls
    private static final String USE_CUSTOM_COLORS_ATT = "useCustomColors";

    public TodoAttributes(@NotNull Element element2, @NotNull TextAttributes defaultTodoAttributes) {
        if (element2 == null) {
            TodoAttributes.$$$reportNull$$$0(0);
        }
        if (defaultTodoAttributes == null) {
            TodoAttributes.$$$reportNull$$$0(1);
        }
        String icon2 = element2.getAttributeValue(ATTRIBUTE_ICON, ICON_DEFAULT);
        if (ICON_DEFAULT.equals(icon2)) {
            this.myIcon = AllIcons.General.TodoDefault;
        } else if (ICON_QUESTION.equals(icon2)) {
            this.myIcon = AllIcons.General.TodoQuestion;
        } else if (ICON_IMPORTANT.equals(icon2)) {
            this.myIcon = AllIcons.General.TodoImportant;
        } else {
            throw new InvalidDataException(icon2);
        }
        this.myShouldUseCustomColors = Boolean.parseBoolean(element2.getAttributeValue(USE_CUSTOM_COLORS_ATT));
        this.myTextAttributes = this.myShouldUseCustomColors && element2.getChild(ELEMENT_OPTION) != null ? new TextAttributes(element2) : defaultTodoAttributes;
    }

    public TodoAttributes(@NotNull Icon icon2, @NotNull TextAttributes textAttributes) {
        if (icon2 == null) {
            TodoAttributes.$$$reportNull$$$0(2);
        }
        if (textAttributes == null) {
            TodoAttributes.$$$reportNull$$$0(3);
        }
        this.myIcon = icon2;
        this.myTextAttributes = textAttributes;
    }

    public TodoAttributes(@NotNull TextAttributes textAttributes) {
        if (textAttributes == null) {
            TodoAttributes.$$$reportNull$$$0(4);
        }
        this.myTextAttributes = textAttributes;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon2 = ObjectUtils.chooseNotNull(this.myIcon, AllIcons.General.TodoDefault);
        if (icon2 == null) {
            TodoAttributes.$$$reportNull$$$0(5);
        }
        return icon2;
    }

    @NotNull
    public TextAttributes getTextAttributes() {
        TextAttributes textAttributes = this.getCustomizedTextAttributes();
        if (textAttributes == null) {
            TodoAttributes.$$$reportNull$$$0(6);
        }
        return textAttributes;
    }

    @NotNull
    public TextAttributes getCustomizedTextAttributes() {
        TextAttributes textAttributes = this.myTextAttributes;
        if (textAttributes == null) {
            TodoAttributes.$$$reportNull$$$0(7);
        }
        return textAttributes;
    }

    public void setIcon(Icon icon2) {
        this.myIcon = icon2;
    }

    public void writeExternal(@NotNull Element element2) {
        if (element2 == null) {
            TodoAttributes.$$$reportNull$$$0(8);
        }
        String icon2 = ICON_DEFAULT;
        if (this.myIcon == AllIcons.General.TodoQuestion) {
            icon2 = ICON_QUESTION;
        } else if (this.myIcon == AllIcons.General.TodoImportant) {
            icon2 = ICON_IMPORTANT;
        }
        if (!icon2.equals(ICON_DEFAULT)) {
            element2.setAttribute(ATTRIBUTE_ICON, icon2);
        }
        if (this.shouldUseCustomTodoColor()) {
            this.myTextAttributes.writeExternal(element2);
            element2.setAttribute(USE_CUSTOM_COLORS_ATT, "true");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TodoAttributes)) {
            return false;
        }
        TodoAttributes attributes = (TodoAttributes)o;
        return this.myIcon == attributes.myIcon && !(this.myTextAttributes == null ? attributes.myTextAttributes != null : !this.myTextAttributes.equals(attributes.myTextAttributes)) && this.myShouldUseCustomColors == attributes.myShouldUseCustomColors;
    }

    public int hashCode() {
        int result2 = this.myIcon != null ? this.myIcon.hashCode() : 0;
        result2 = 29 * result2 + (this.myTextAttributes != null ? this.myTextAttributes.hashCode() : 0);
        result2 = 29 * result2 + Boolean.valueOf(this.myShouldUseCustomColors).hashCode();
        return result2;
    }

    public boolean shouldUseCustomTodoColor() {
        return this.myShouldUseCustomColors;
    }

    public void setUseCustomTodoColor(boolean useCustomColors, @NotNull TextAttributes defaultTodoAttributes) {
        if (defaultTodoAttributes == null) {
            TodoAttributes.$$$reportNull$$$0(9);
        }
        this.myShouldUseCustomColors = useCustomColors;
        if (!useCustomColors) {
            this.myTextAttributes = defaultTodoAttributes;
        }
    }

    public TodoAttributes clone() {
        try {
            TextAttributes textAttributes = this.myTextAttributes.clone();
            TodoAttributes attributes = (TodoAttributes)super.clone();
            attributes.myTextAttributes = textAttributes;
            attributes.myShouldUseCustomColors = this.myShouldUseCustomColors;
            return attributes;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultTodoAttributes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_ICON;
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/TodoAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/TodoAttributes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextAttributes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomizedTextAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setUseCustomTodoColor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

