/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.DumbAwareSearchParameters;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchRequestQuery;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.psi.search.searches.ReferenceDescriptor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.MergeQuery;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.UniqueResultsQuery;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodReferencesSearch
extends ExtensibleQueryFactory<PsiReference, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor<PsiReference, SearchParameters>> EP_NAME = ExtensionPointName.create("com.intellij.methodReferencesSearch");
    public static final MethodReferencesSearch INSTANCE = new MethodReferencesSearch();

    private MethodReferencesSearch() {
        super(EP_NAME);
    }

    public static Query<PsiReference> search(@NotNull PsiMethod method2, SearchScope scope, boolean strictSignatureSearch) {
        if (method2 == null) {
            MethodReferencesSearch.$$$reportNull$$$0(0);
        }
        return MethodReferencesSearch.search(new SearchParameters(method2, scope, strictSignatureSearch));
    }

    public static void searchOptimized(PsiMethod method2, SearchScope scope, boolean strictSignatureSearch, @NotNull SearchRequestCollector collector, Processor<? super PsiReference> processor2) {
        if (collector == null) {
            MethodReferencesSearch.$$$reportNull$$$0(1);
        }
        MethodReferencesSearch.searchOptimized(method2, scope, strictSignatureSearch, collector, false, (psiReference, collector1) -> processor2.process((PsiReference)psiReference));
    }

    public static void searchOptimized(PsiMethod method2, SearchScope scope, boolean strictSignatureSearch, SearchRequestCollector collector, boolean inReadAction, PairProcessor<? super PsiReference, ? super SearchRequestCollector> processor2) {
        SearchRequestCollector nested = new SearchRequestCollector(collector.getSearchSession());
        collector.searchQuery(new QuerySearchRequest(MethodReferencesSearch.search(new SearchParameters(method2, scope, strictSignatureSearch, nested)), nested, inReadAction, processor2));
    }

    public static Query<PsiReference> search(SearchParameters parameters) {
        Query result2 = INSTANCE.createQuery(parameters);
        if (parameters.isSharedOptimizer) {
            return MethodReferencesSearch.uniqueResults(result2);
        }
        SearchRequestCollector requests = parameters.getOptimizer();
        Project project2 = PsiUtilCore.getProjectInReadAction(parameters.getMethod());
        return MethodReferencesSearch.uniqueResults((Query<? extends PsiReference>)new MergeQuery(result2, (Query)new SearchRequestQuery(project2, requests)));
    }

    public static Query<PsiReference> search(PsiMethod method2, boolean strictSignatureSearch) {
        return MethodReferencesSearch.search(method2, GlobalSearchScope.allScope(PsiUtilCore.getProjectInReadAction(method2)), strictSignatureSearch);
    }

    public static Query<PsiReference> search(PsiMethod method2) {
        return MethodReferencesSearch.search(method2, true);
    }

    private static UniqueResultsQuery<PsiReference, ReferenceDescriptor> uniqueResults(@NotNull Query<? extends PsiReference> composite) {
        if (composite == null) {
            MethodReferencesSearch.$$$reportNull$$$0(2);
        }
        return new UniqueResultsQuery<PsiReference, ReferenceDescriptor>(composite, ContainerUtil.canonicalStrategy(), ReferenceDescriptor.MAPPER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composite";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/search/searches/MethodReferencesSearch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "search";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "searchOptimized";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "uniqueResults";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class SearchParameters
    implements DumbAwareSearchParameters {
        private final PsiMethod myMethod;
        private final Project myProject;
        private final SearchScope myScope;
        private volatile SearchScope myEffectiveScope;
        private final boolean myStrictSignatureSearch;
        private final SearchRequestCollector myOptimizer;
        private final boolean isSharedOptimizer;

        public SearchParameters(@NotNull PsiMethod method2, @NotNull SearchScope scope, boolean strictSignatureSearch, @Nullable SearchRequestCollector optimizer) {
            if (method2 == null) {
                SearchParameters.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                SearchParameters.$$$reportNull$$$0(1);
            }
            this.myMethod = method2;
            this.myScope = scope;
            this.myStrictSignatureSearch = strictSignatureSearch;
            this.isSharedOptimizer = optimizer != null;
            this.myOptimizer = optimizer != null ? optimizer : new SearchRequestCollector(new SearchSession());
            this.myProject = PsiUtilCore.getProjectInReadAction(method2);
        }

        public SearchParameters(@NotNull PsiMethod method2, @NotNull SearchScope scope, boolean strict) {
            if (method2 == null) {
                SearchParameters.$$$reportNull$$$0(2);
            }
            if (scope == null) {
                SearchParameters.$$$reportNull$$$0(3);
            }
            this(method2, scope, strict, null);
        }

        @Override
        public boolean isQueryValid() {
            return this.myMethod.isValid();
        }

        @Override
        @NotNull
        public Project getProject() {
            Project project2 = this.myProject;
            if (project2 == null) {
                SearchParameters.$$$reportNull$$$0(4);
            }
            return project2;
        }

        @NotNull
        public PsiMethod getMethod() {
            PsiMethod psiMethod = this.myMethod;
            if (psiMethod == null) {
                SearchParameters.$$$reportNull$$$0(5);
            }
            return psiMethod;
        }

        public boolean isStrictSignatureSearch() {
            return this.myStrictSignatureSearch;
        }

        public SearchRequestCollector getOptimizer() {
            return this.myOptimizer;
        }

        public SearchScope getScopeDeterminedByUser() {
            return this.myScope;
        }

        @Deprecated
        @NotNull
        public SearchScope getScope() {
            SearchScope searchScope = this.getScopeDeterminedByUser();
            if (searchScope == null) {
                SearchParameters.$$$reportNull$$$0(6);
            }
            return searchScope;
        }

        @NotNull
        public SearchScope getEffectiveSearchScope() {
            SearchScope scope = this.myEffectiveScope;
            if (scope == null) {
                if (!this.myMethod.isValid()) {
                    GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
                    if (globalSearchScope == null) {
                        SearchParameters.$$$reportNull$$$0(7);
                    }
                    return globalSearchScope;
                }
                this.myEffectiveScope = scope = this.myScope.intersectWith(PsiSearchHelper.getInstance(this.myMethod.getProject()).getUseScope(this.myMethod));
            }
            SearchScope searchScope = scope;
            if (searchScope == null) {
                SearchParameters.$$$reportNull$$$0(8);
            }
            return searchScope;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/searches/MethodReferencesSearch$SearchParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/searches/MethodReferencesSearch$SearchParameters";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethod";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScope";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEffectiveSearchScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

