/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
class ByteArrayInterner {
    private static final TObjectHashingStrategy<byte[]> BYTE_ARRAY_STRATEGY = new TObjectHashingStrategy<byte[]>(){

        @Override
        public int computeHashCode(byte[] object) {
            return Arrays.hashCode(object);
        }

        @Override
        public boolean equals(byte[] o1, byte[] o2) {
            return Arrays.equals(o1, o2);
        }
    };
    private final TObjectIntHashMap<byte[]> arrayToStart = new TObjectIntHashMap<byte[]>(BYTE_ARRAY_STRATEGY);
    final BufferExposingByteArrayOutputStream joinedBuffer = new BufferExposingByteArrayOutputStream();

    ByteArrayInterner() {
    }

    int internBytes(byte @NotNull [] bytes) {
        if (bytes == null) {
            ByteArrayInterner.$$$reportNull$$$0(0);
        }
        if (bytes.length == 0) {
            return 0;
        }
        int start2 = this.arrayToStart.get(bytes);
        if (start2 == 0) {
            start2 = this.joinedBuffer.size() + 1;
            this.arrayToStart.put(bytes, start2);
            this.joinedBuffer.write(bytes, 0, bytes.length);
        }
        return start2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/psi/stubs/ByteArrayInterner", "internBytes"));
    }
}

