/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class IndexingStampInfo {
    final long indexingFileStamp;
    final long indexingByteLength;
    final int indexingCharLength;

    IndexingStampInfo(long indexingFileStamp, long indexingByteLength, int indexingCharLength) {
        this.indexingFileStamp = indexingFileStamp;
        this.indexingByteLength = indexingByteLength;
        this.indexingCharLength = indexingCharLength;
    }

    public String toString() {
        return "indexed at " + this.indexingFileStamp + " with document " + IndexingStampInfo.dumpSize(this.indexingByteLength, this.indexingCharLength);
    }

    @NotNull
    static String dumpSize(long byteLength, int charLength) {
        String string = " byte size = " + byteLength + ", char size = " + charLength;
        if (string == null) {
            IndexingStampInfo.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isUpToDate(@Nullable Document document, @NotNull VirtualFile file2, @NotNull PsiFile psi) {
        if (file2 == null) {
            IndexingStampInfo.$$$reportNull$$$0(1);
        }
        if (psi == null) {
            IndexingStampInfo.$$$reportNull$$$0(2);
        }
        if (document == null || FileDocumentManager.getInstance().isDocumentUnsaved(document) || !PsiDocumentManager.getInstance(psi.getProject()).isCommitted(document)) {
            return false;
        }
        return this.indexingFileStamp == file2.getTimeStamp() && this.contentLengthMatches(file2.getLength(), document.getTextLength());
    }

    public boolean contentLengthMatches(long byteContentLength, int charContentLength) {
        if (this.indexingCharLength >= 0 && charContentLength >= 0) {
            return this.indexingCharLength == charContentLength;
        }
        return this.indexingByteLength == byteContentLength;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/IndexingStampInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpSize";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/IndexingStampInfo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

