/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntIntHashMap;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.function.IntUnaryOperator;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
class IntEnumerator {
    private final TIntIntHashMap myEnumerates;
    private final TIntArrayList myIds;
    private int myNext;

    IntEnumerator() {
        this(true);
    }

    private IntEnumerator(boolean forSavingStub) {
        this.myEnumerates = forSavingStub ? new TIntIntHashMap(1) : null;
        this.myIds = new TIntArrayList();
    }

    int enumerate(int number) {
        assert (this.myEnumerates != null);
        int i = this.myEnumerates.get(number);
        if (i == 0) {
            i = this.myNext;
            this.myEnumerates.put(number, this.myNext++);
            this.myIds.add(number);
        }
        return i;
    }

    int valueOf(int id2) {
        return this.myIds.get(id2);
    }

    void dump(DataOutputStream stream) throws IOException {
        this.dump(stream, IntUnaryOperator.identity());
    }

    void dump(DataOutputStream stream, IntUnaryOperator idRemapping) throws IOException {
        DataInputOutputUtil.writeINT(stream, this.myIds.size());
        IOException[] exception = new IOException[1];
        this.myIds.forEach(id2 -> {
            try {
                int remapped = idRemapping.applyAsInt(id2);
                if (remapped == 0) {
                    exception[0] = new IOException("remapping is not found for " + id2);
                    return false;
                }
                DataInputOutputUtil.writeINT(stream, remapped);
            }
            catch (IOException e) {
                exception[0] = e;
                return false;
            }
            return true;
        });
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    static IntEnumerator read(DataInputStream stream) throws IOException {
        int size = DataInputOutputUtil.readINT(stream);
        IntEnumerator enumerator = new IntEnumerator(false);
        for (int i = 1; i < size + 1; ++i) {
            enumerator.myIds.add(DataInputOutputUtil.readINT(stream));
        }
        return enumerator;
    }
}

